/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign.multijoin;

import de.unijena.bioinf.treealign.Tree;
import de.unijena.bioinf.treealign.map.IntFloatArrayMap;
import de.unijena.bioinf.treealign.map.IntFloatHashMap;
import de.unijena.bioinf.treealign.map.IntFloatIterator;
import de.unijena.bioinf.treealign.map.IntFloatMap;
import de.unijena.bioinf.treealign.map.IntPairFloatArrayMap;
import de.unijena.bioinf.treealign.map.IntPairFloatHashMap;
import de.unijena.bioinf.treealign.map.IntPairFloatIterator;
import de.unijena.bioinf.treealign.map.IntPairFloatMap;
import java.util.List;

class HashTable<T> {
    public static final float INITIAL_FILL_SIZE_FOR_SMALL = 0.2f;
    public static final float INITIAL_FILL_SIZE_FOR_HUGE = 0.05f;
    static final int MAX_INITIAL_ENTRY_SLOTS = 1024;
    private static final Mode MODE = Mode.USE_HASH_FOR_HUGE_DEGREE;
    private final IntPairFloatMap data;
    private final IntFloatMap maxLeft;
    private final IntFloatMap maxRight;
    private final JoinTable[][] join;
    private float score;

    HashTable() {
        this.data = null;
        this.join = null;
        this.maxLeft = null;
        this.maxRight = null;
        this.score = 0.0f;
    }

    HashTable(List<Tree<T>> basicSetA, List<Tree<T>> basicSetB, short L, short R) {
        int leftSize = 1 << basicSetA.size();
        int rightSize = 1 << basicSetB.size();
        this.data = HashTable.allocateIntPairFloatMap(leftSize, rightSize);
        this.join = new JoinTable[L + 1][R + 1];
        for (int l = 0; l <= L; ++l) {
            for (int r = 0; r <= R; ++r) {
                if (l == 0 && r == 0) continue;
                this.join[l][r] = new JoinTable(leftSize, rightSize, l, r);
            }
        }
        this.maxLeft = HashTable.allocateIntFloatMap(rightSize);
        this.maxRight = HashTable.allocateIntFloatMap(leftSize);
        this.score = 0.0f;
    }

    private static IntFloatMap allocateIntFloatMap(int size) {
        switch (MODE) {
            case USE_ARRAY: {
                return new IntFloatArrayMap(size);
            }
            case USE_HASH: {
                return new IntFloatHashMap(HashTable.trimSizeForHashMap(size));
            }
            case USE_HASH_FOR_HUGE_DEGREE: {
                return HashTable.isHuge(size) ? new IntFloatHashMap(HashTable.trimSizeForHashMap(size)) : new IntFloatArrayMap(size);
            }
        }
        throw new RuntimeException("Illegal value for MODE: " + String.valueOf((Object)MODE));
    }

    private static boolean isHuge(long size) {
        return size >= 262144L;
    }

    private static int trimSizeForHashMap(long size) {
        long l = 0L;
        l = HashTable.isHuge(size) ? (long)((float)size * 0.05f) : (long)((float)size * 0.2f) + 2L;
        l = Math.min(size, Math.min(l, 1024L));
        assert (l < Integer.MAX_VALUE);
        return (int)l;
    }

    private static IntPairFloatMap allocateIntPairFloatMap(int leftSize, int rightSize) {
        long size = (long)leftSize * (long)rightSize;
        switch (MODE) {
            case USE_ARRAY: {
                return new IntPairFloatArrayMap(leftSize, rightSize);
            }
            case USE_HASH: {
                return new IntPairFloatHashMap(HashTable.trimSizeForHashMap(size));
            }
            case USE_HASH_FOR_HUGE_DEGREE: {
                return HashTable.isHuge(size) ? new IntPairFloatHashMap(HashTable.trimSizeForHashMap(size)) : new IntPairFloatArrayMap(leftSize, rightSize);
            }
        }
        throw new RuntimeException("Illegal value for MODE: " + String.valueOf((Object)MODE));
    }

    float getScore() {
        return this.score;
    }

    void setScore(float score) {
        this.score = score;
    }

    void setScoreIfGreater(float score) {
        this.score = Math.max(score, this.score);
    }

    float get(int A, int B) {
        if (this.data == null) {
            return 0.0f;
        }
        return this.data.get(A, B);
    }

    void set(int A, int B, float value) {
        this.data.put(A, B, value);
        assert (this.data.get(A, B) > 0.0f);
    }

    IntPairFloatMap.ReturnType putIfGreater(int A, int B, float value) {
        return this.data.putIfGreater(A, B, value);
    }

    float getJoin(short l, short r, int A, int B) {
        if (this.join == null) {
            return 0.0f;
        }
        return this.join[l][r].data.get(A, B);
    }

    void setJoin(short l, short r, int A, int B, float value) {
        this.join[l][r].data.put(A, B, value);
    }

    IntPairFloatMap.ReturnType putJoinIfGreater(short l, short r, int A, int B, float value) {
        return this.join[l][r].data.putIfGreater(A, B, value);
    }

    float getMaxLeft(int B) {
        if (this.maxLeft == null) {
            return 0.0f;
        }
        return this.maxLeft.get(B);
    }

    float getMaxRight(int A) {
        if (this.maxRight == null) {
            return 0.0f;
        }
        return this.maxRight.get(A);
    }

    float getMaxJoinLeft(short l, short r, int B) {
        if (this.join == null) {
            return 0.0f;
        }
        return this.join[l][r].maxLeft.get(B);
    }

    float getMaxJoinRight(short l, short r, int A) {
        if (this.join == null) {
            return 0.0f;
        }
        return this.join[l][r].maxRight.get(A);
    }

    IntFloatIterator eachInMaxLeft() {
        if (this.maxLeft == null) {
            return IntFloatIterator.Empty;
        }
        return this.maxLeft.entries();
    }

    IntFloatIterator eachInMaxRight() {
        if (this.maxRight == null) {
            return IntFloatIterator.Empty;
        }
        return this.maxRight.entries();
    }

    IntFloatIterator eachInMaxJoinLeft(short l, short r) {
        if (this.join == null) {
            return IntFloatIterator.Empty;
        }
        return this.join[l][r].maxLeft.entries();
    }

    IntFloatIterator eachInMaxJoinRight(short l, short r) {
        if (this.join == null) {
            return IntFloatIterator.Empty;
        }
        return this.join[l][r].maxRight.entries();
    }

    IntPairFloatIterator each() {
        if (this.data == null) {
            return IntPairFloatIterator.Empty;
        }
        return this.data.entries();
    }

    IntPairFloatIterator eachInJoin(short l, short r) {
        if (this.join == null) {
            return IntPairFloatIterator.Empty;
        }
        return this.join[l][r].data.entries();
    }

    void putMaxLeftIfGreater(int B, float value) {
        this.maxLeft.putIfGreater(B, value);
    }

    void putMaxRightIfGreater(int A, float value) {
        this.maxRight.putIfGreater(A, value);
    }

    void putMaxJoinLeftIfGreater(short l, short r, int B, float value) {
        this.join[l][r].maxLeft.putIfGreater(B, value);
    }

    void putMaxJoinRightIfGreater(short l, short r, int A, float value) {
        this.join[l][r].maxRight.putIfGreater(A, value);
    }

    private static final class JoinTable {
        private final IntFloatMap maxLeft;
        private final IntFloatMap maxRight;
        private final IntPairFloatMap data;

        private JoinTable(int leftSize, int rightSize, int l, int r) {
            this.data = HashTable.allocateIntPairFloatMap(leftSize, rightSize);
            this.maxLeft = l == 0 ? null : HashTable.allocateIntFloatMap(rightSize);
            this.maxRight = r == 0 ? null : HashTable.allocateIntFloatMap(leftSize);
        }
    }

    static enum Mode {
        USE_ARRAY,
        USE_HASH,
        USE_HASH_FOR_HUGE_DEGREE;

    }
}

