/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign.scoring;

import de.unijena.bioinf.treealign.scoring.Scoring;
import java.util.Iterator;

public abstract class AbstractScoring<T>
implements Scoring<T> {
    protected abstract float joinOperation(T var1, T var2, T var3);

    protected abstract float matchOperation(T var1, T var2);

    protected abstract float gapScore();

    @Override
    public float joinLeft(T left, T join, T right) {
        return this.joinOperation(left, join, right);
    }

    @Override
    public float joinRight(T right, T join, T left) {
        return this.joinOperation(right, join, left);
    }

    @Override
    public float match(T left, T right) {
        return this.matchOperation(left, right);
    }

    @Override
    public float deleteLeft(T left) {
        return this.gapScore();
    }

    @Override
    public float deleteRight(T right) {
        return this.gapScore();
    }

    @Override
    public float join(Iterator<T> leftNodes, Iterator<T> rightNodes, int leftSize, int rightSize) {
        throw new UnsupportedOperationException("This scoring doesn't support multijoin scoring");
    }

    @Override
    public float scoreVertices(T left, T right) {
        return 0.0f;
    }
}

