/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign.sparse;

import de.unijena.bioinf.graphUtils.tree.PostOrderTraversal;
import de.unijena.bioinf.graphUtils.tree.TreeAdapter;
import de.unijena.bioinf.graphUtils.tree.TreeCursor;
import de.unijena.bioinf.treealign.Backtrace;
import de.unijena.bioinf.treealign.Set;
import de.unijena.bioinf.treealign.TraceItem;
import de.unijena.bioinf.treealign.Tree;
import de.unijena.bioinf.treealign.TreeAlignmentAlgorithm;
import de.unijena.bioinf.treealign.TreeDecorator;
import de.unijena.bioinf.treealign.map.IntFloatIterator;
import de.unijena.bioinf.treealign.map.IntPairFloatIterator;
import de.unijena.bioinf.treealign.map.IntPairFloatMap;
import de.unijena.bioinf.treealign.scoring.Scoring;
import de.unijena.bioinf.treealign.sparse.HashTable;
import de.unijena.bioinf.treealign.sparse.QueueItem;
import de.unijena.bioinf.treealign.sparse.TreeHashMap;
import de.unijena.bioinf.util.Iterators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DPSparseTreeAlign<T>
implements TreeAlignmentAlgorithm<T> {
    private final TreeAdapter<T> adapter;
    private final Scoring<T> scoring;
    private final Tree<T> left;
    private final Tree<T> right;
    private final ArrayList<Tree<T>> leftVertices;
    private final ArrayList<Tree<T>> rightVertices;
    private final ArrayList<Tree<T>> leftLeafs;
    private final ArrayList<Tree<T>> rightLeafs;
    private final int maxDegree;
    private final TreeHashMap<T> tables;
    private final ArrayDeque<QueueItem>[] queues;
    private final ArrayDeque<TraceItem<T>> traceQueue;
    private final boolean useJoins;
    private float optScore;
    private Tree<T> optLeft;
    private Tree<T> optRight;
    private Backtrace<T> tracer;
    private boolean scoreRoot;

    public DPSparseTreeAlign(Scoring<T> scoring, boolean useJoins, T left, T right, TreeAdapter<T> adapter) {
        this.adapter = adapter;
        this.scoring = scoring;
        int leftSize = TreeCursor.getCursor(left, adapter).numberOfVertices();
        int rightSize = TreeCursor.getCursor(right, adapter).numberOfVertices();
        this.leftVertices = new ArrayList(leftSize);
        this.rightVertices = new ArrayList(rightSize);
        this.leftLeafs = new ArrayList(leftSize);
        this.rightLeafs = new ArrayList(rightSize);
        TreeDecorator<T> leftDeco = new TreeDecorator<T>(this.leftVertices, this.leftLeafs);
        this.left = (Tree)new PostOrderTraversal(left, adapter).call(leftDeco);
        TreeDecorator<T> rightDeco = new TreeDecorator<T>(this.rightVertices, this.rightLeafs);
        this.right = (Tree)new PostOrderTraversal(right, adapter).call(rightDeco);
        this.maxDegree = Math.max(leftDeco.maxDegree, rightDeco.maxDegree);
        this.tables = new TreeHashMap(this.leftVertices.size(), this.rightVertices.size());
        this.queues = new ArrayDeque[leftDeco.maxDegree + rightDeco.maxDegree];
        for (int i = 0; i < this.queues.length; ++i) {
            this.queues[i] = new ArrayDeque();
        }
        this.optScore = -1.0f;
        this.optLeft = null;
        this.optRight = null;
        this.traceQueue = new ArrayDeque();
        this.tracer = null;
        this.scoreRoot = false;
        this.useJoins = useJoins;
    }

    protected float scoreSubtreeRoots() {
        if (this.scoreRoot) {
            return this.optScore;
        }
        assert (this.left.isRoot());
        assert (this.right.isRoot());
        Iterator iter = PostOrderTraversal.create(this.left).iterator();
        float opt = 0.0f;
        while (iter.hasNext()) {
            Tree a = (Tree)iter.next();
            for (Tree b : PostOrderTraversal.create(this.right)) {
                HashTable<T> table = this.tables.get(a.index, b.index);
                float newScore = table.getScore() + this.scoring.scoreVertices(a.label, b.label);
                if (!(newScore > opt)) continue;
                this.optLeft = a;
                this.optRight = b;
                opt = newScore;
            }
        }
        this.optScore = opt;
        this.scoreRoot = true;
        return this.optScore;
    }

    @Override
    public float compute() {
        float opt = 0.0f;
        for (int i = 0; i < this.leftVertices.size(); ++i) {
            Tree<T> u = this.leftVertices.get(i);
            for (int j = 0; j < this.rightVertices.size(); ++j) {
                List<Tree<T>> Bs;
                List<Tree<T>> As;
                QueueItem item;
                ArrayDeque<QueueItem> queue;
                int q;
                Tree<T> v = this.rightVertices.get(j);
                HashTable<T> D = new HashTable<T>(u.children(), v.children(), this.useJoins);
                this.tables.set(u.index, v.index, D);
                if (this.useJoins) {
                    this.clearQueues();
                    if (!u.isRoot()) {
                        this.pushPairwisePreJoinsLeft(u, v, D);
                        for (q = 0; q < this.queues.length; ++q) {
                            queue = this.queues[q];
                            while (!queue.isEmpty()) {
                                item = queue.poll();
                                As = Set.subList(u.children(), (1 << u.degree()) - 1 & ~item.A);
                                Bs = Set.subList(v.children(), (1 << v.degree()) - 1 & ~item.B);
                                this.pushPreJoinLeft(u, v, D, item.A, item.B, As, Bs);
                            }
                        }
                    }
                    this.clearQueues();
                    if (!v.isRoot()) {
                        this.pushPairwisePreJoinsRight(u, v, D);
                        for (q = 0; q < this.queues.length; ++q) {
                            queue = this.queues[q];
                            while (!queue.isEmpty()) {
                                item = queue.poll();
                                As = Set.subList(u.children(), (1 << u.degree()) - 1 & ~item.A);
                                Bs = Set.subList(v.children(), (1 << v.degree()) - 1 & ~item.B);
                                this.pushPreJoinRight(u, v, D, item.A, item.B, As, Bs);
                            }
                        }
                    }
                }
                this.clearQueues();
                this.pushPairwiseMatches(u, v, D);
                this.pushDeleteLeft(u, v, D, 0, 0, u.children(), v.children(), 0.0f);
                this.pushDeleteRight(u, v, D, 0, 0, u.children(), v.children(), 0.0f);
                if (this.useJoins) {
                    this.pushJoinLeft(u, v, D, 0, 0, u.children(), v.children(), 0.0f);
                    this.pushJoinRight(u, v, D, 0, 0, u.children(), v.children(), 0.0f);
                }
                for (q = 0; q < this.queues.length; ++q) {
                    queue = this.queues[q];
                    while (!queue.isEmpty()) {
                        item = queue.poll();
                        As = Set.subList(u.children(), (1 << u.degree()) - 1 & ~item.A);
                        Bs = Set.subList(v.children(), (1 << v.degree()) - 1 & ~item.B);
                        float value = D.get(item.A, item.B);
                        assert (value > 0.0f);
                        this.pushDeleteLeft(u, v, D, item.A, item.B, As, Bs, value);
                        this.pushDeleteRight(u, v, D, item.A, item.B, As, Bs, value);
                        if (q <= 0) continue;
                        this.pushMatch(u, v, D, item.A, item.B, As, Bs, value);
                        if (!this.useJoins) continue;
                        this.pushJoinLeft(u, v, D, item.A, item.B, As, Bs, value);
                        this.pushJoinRight(u, v, D, item.A, item.B, As, Bs, value);
                    }
                }
                float newScore = this.vertexScore(D, u, v);
                if (!(newScore > opt)) continue;
                opt = newScore;
                this.optLeft = u;
                this.optRight = v;
            }
        }
        this.optScore = opt;
        if (this.scoring.isScoringVertices()) {
            return this.scoreSubtreeRoots();
        }
        return opt;
    }

    private float vertexScore(HashTable<T> D, Tree<T> u, Tree<T> v) {
        return D.getScore();
    }

    private void pushJoinLeft(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs, float value) {
        for (Tree<T> a : As) {
            HashTable<T> T = this.tables.get(a.index, v.index);
            IntFloatIterator iter = T.eachInMaxJoinLeft();
            while (iter.hasNext()) {
                float score;
                iter.next();
                int B_ = iter.getKey();
                if ((B_ & B) != 0 || !((score = value + iter.getValue()) > value)) continue;
                this.update(u, v, D, A | a.key, B | B_, score);
            }
        }
    }

    private void pushJoinRight(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs, float value) {
        for (Tree<T> b : Bs) {
            HashTable<T> T = this.tables.get(u.index, b.index);
            IntFloatIterator iter = T.eachInMaxJoinRight();
            while (iter.hasNext()) {
                float score;
                iter.next();
                int A_ = iter.getKey();
                if ((A_ & A) != 0 || !((score = value + iter.getValue()) > value)) continue;
                this.update(u, v, D, A | A_, B | b.key, score);
            }
        }
    }

    private void pushPreJoinLeft(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        float value = D.getJoinLeft(A, B);
        int cardA = Integer.bitCount(A);
        int cardB = Integer.bitCount(B);
        for (Tree<T> a : As) {
            for (Tree<T> b : Bs) {
                int B_;
                int A_;
                IntPairFloatMap.ReturnType inserted;
                float score = D.getJoinLeft(a.key, b.key) + value;
                if (!(score > value) || (inserted = D.putJoinLeftIfGreater(A_ = A | a.key, B_ = B | b.key, score)) == IntPairFloatMap.ReturnType.LOWER) continue;
                if (inserted == IntPairFloatMap.ReturnType.NOT_EXIST) {
                    this.queues[cardA + cardB + 1].offer(new QueueItem(A_, B_));
                }
                D.putMaxJoinLeftIfGreater(B_, score);
            }
        }
    }

    private void pushPreJoinRight(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        float value = D.getJoinRight(A, B);
        int cardA = Integer.bitCount(A);
        int cardB = Integer.bitCount(B);
        for (Tree<T> a : As) {
            for (Tree<T> b : Bs) {
                int B_;
                int A_;
                IntPairFloatMap.ReturnType inserted;
                float score = D.getJoinRight(a.key, b.key) + value;
                if (!(score > value) || (inserted = D.putJoinRightIfGreater(A_ = A | a.key, B_ = B | b.key, score)) == IntPairFloatMap.ReturnType.LOWER) continue;
                if (inserted == IntPairFloatMap.ReturnType.NOT_EXIST) {
                    this.queues[cardA + cardB + 1].offer(new QueueItem(A_, B_));
                }
                D.putMaxJoinRightIfGreater(A_, score);
            }
        }
    }

    private void pushPairwisePreJoinsLeft(Tree<T> u, Tree<T> v, HashTable<T> D) {
        assert (!u.isRoot());
        for (Tree<T> a : u.children()) {
            for (Tree<T> b : v.children()) {
                float score = this.scoring.joinLeft(u.label, a.label, b.label) + this.tables.get(a.index, b.index).getScore();
                if (!(score > 0.0f)) continue;
                D.setJoinLeft(a.key, b.key, score);
                D.putMaxJoinLeftIfGreater(b.key, score);
                this.queues[1].offer(new QueueItem(a.key, b.key));
            }
        }
    }

    private void pushPairwisePreJoinsRight(Tree<T> u, Tree<T> v, HashTable<T> D) {
        assert (!v.isRoot());
        for (Tree<T> a : u.children()) {
            for (Tree<T> b : v.children()) {
                float score = this.scoring.joinRight(v.label, b.label, a.label) + this.tables.get(a.index, b.index).getScore();
                if (!(score > 0.0f)) continue;
                D.setJoinRight(a.key, b.key, score);
                D.putMaxJoinRightIfGreater(a.key, score);
                this.queues[1].offer(new QueueItem(a.key, b.key));
            }
        }
    }

    private void pushPairwiseMatches(Tree<T> u, Tree<T> v, HashTable<T> D) {
        for (int i = 0; i < u.degree(); ++i) {
            Tree<T> a = u.children().get(i);
            for (int j = 0; j < v.degree(); ++j) {
                Tree<T> b = v.children().get(j);
                float score = this.scoring.match(a.label, b.label) + this.tables.get(a.index, b.index).getScore();
                if (!(score > 0.0f)) continue;
                D.set(a.key, b.key, score);
                D.putMaxLeftIfGreater(b.key, score);
                D.putMaxRightIfGreater(a.key, score);
                D.setScoreIfGreater(score);
                assert (D.get(a.key, b.key) > 0.0f);
                this.queues[1].offer(new QueueItem(a.key, b.key));
            }
        }
    }

    private void update(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, float score) {
        assert (score > 0.0f);
        int cardA = Integer.bitCount(A);
        int cardB = Integer.bitCount(B);
        IntPairFloatMap.ReturnType inserted = D.putIfGreater(A, B, score);
        if (inserted != IntPairFloatMap.ReturnType.LOWER) {
            if (inserted == IntPairFloatMap.ReturnType.NOT_EXIST) {
                this.queues[cardA + cardB - 1].offer(new QueueItem(A, B));
                assert (D.get(A, B) > 0.0f);
            }
            D.putMaxLeftIfGreater(B, score);
            D.putMaxRightIfGreater(A, score);
            D.setScoreIfGreater(score);
        }
    }

    private void pushMatch(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs, float value) {
        for (Tree<T> a : As) {
            for (Tree<T> b : Bs) {
                float score = D.get(a.key, b.key) + value;
                if (!(score > value)) continue;
                this.update(u, v, D, A | a.key, B | b.key, score);
            }
        }
    }

    private void pushDeleteLeft(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs, float value) {
        for (Tree<T> a : As) {
            float gapScore = value + this.scoring.deleteLeft(a.label);
            HashTable<T> T = this.tables.get(a.index, v.index);
            IntFloatIterator iter = T.eachInMaxLeft();
            while (iter.hasNext()) {
                float newValue;
                iter.next();
                int B_ = iter.getKey();
                if ((B & B_) != 0 || !((newValue = gapScore + iter.getValue()) > value)) continue;
                this.update(u, v, D, A | a.key, B | B_, newValue);
            }
        }
    }

    private void pushDeleteRight(Tree<T> u, Tree<T> v, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs, float value) {
        for (Tree<T> b : Bs) {
            float gapScore = value + this.scoring.deleteRight(b.label);
            HashTable<T> T = this.tables.get(u.index, b.index);
            IntFloatIterator iter = T.eachInMaxRight();
            while (iter.hasNext()) {
                float newValue;
                iter.next();
                int A_ = iter.getKey();
                if ((A & A_) != 0 || !((newValue = gapScore + iter.getValue()) > value)) continue;
                this.update(u, v, D, A | A_, B | b.key, newValue);
            }
        }
    }

    private void clearQueues() {
        for (ArrayDeque<QueueItem> queue : this.queues) {
            queue.clear();
        }
    }

    @Override
    public void backtrace(Backtrace<T> tracer) {
        float score;
        if (this.optScore <= 0.0f) {
            return;
        }
        this.traceQueue.clear();
        this.tracer = tracer;
        if (this.scoreRoot) {
            tracer.matchVertices(this.optScore - this.tables.get(this.optLeft.index, this.optRight.index).getScore(), this.optLeft.label, this.optRight.label);
            score = this.tables.get(this.optLeft.index, this.optRight.index).getScore();
        } else {
            score = this.optScore;
        }
        if (score <= 0.0f) {
            return;
        }
        this.addTraceItemFor(this.optLeft, this.optRight, score);
        while (!this.traceQueue.isEmpty()) {
            boolean found;
            TraceItem<T> item = this.traceQueue.poll();
            List As = Set.subList(item.u.children(), item.A);
            List Bs = Set.subList(item.v.children(), item.B);
            HashTable<T> D = this.tables.get(item.u.index, item.v.index);
            float opt = D.get(item.A, item.B);
            if (opt == 0.0f) continue;
            boolean bl = found = this.traceMatch(item.u, item.v, opt, D, item.A, item.B, As, Bs) || this.traceDeleteLeft(item.u, item.v, opt, D, item.A, item.B, As, Bs) || this.traceDeleteRight(item.u, item.v, opt, D, item.A, item.B, As, Bs) || this.useJoins && (this.traceJoinLeft(item.u, item.v, opt, D, item.A, item.B, As, Bs) || this.traceJoinRight(item.u, item.v, opt, D, item.A, item.B, As, Bs));
            assert (found);
        }
    }

    private boolean addTraceItemFor(Tree<T> u, Tree<T> v, float opt) {
        return this.addTraceItemFor(u, v, Set.of(u.children()), Set.of(v.children()), opt);
    }

    private boolean addTraceItemFor(Tree<T> u, Tree<T> v, int A, int B, float opt) {
        HashTable<T> D = this.tables.get(u.index, v.index);
        assert (D.getScore() >= opt);
        IntPairFloatIterator iter = D.each();
        while (iter.hasNext()) {
            iter.next();
            if (!(iter.getValue() >= opt) || (iter.getLeft() & A) != iter.getLeft() || (iter.getRight() & B) != iter.getRight()) continue;
            this.traceQueue.offer(new TraceItem<T>(u, v, iter.getLeft(), iter.getRight()));
            return true;
        }
        assert (false);
        return false;
    }

    private boolean traceMatch(Tree<T> u, Tree<T> v, float opt, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        for (Tree<T> a : As) {
            int A_ = A & ~a.key;
            for (Tree<T> b : Bs) {
                int B_ = B & ~b.key;
                float pre = D.get(A_, B_);
                float matchScore = this.scoring.match(a.label, b.label);
                float subtreeScore = this.tables.get(a.index, b.index).getScore();
                float score = subtreeScore + pre + matchScore;
                if (!(score >= opt)) continue;
                assert (score == opt);
                this.tracer.match(matchScore, a.label, b.label);
                if (a.degree() > 0 && b.degree() > 0 && subtreeScore > 0.0f) {
                    this.addTraceItemFor(a, b, subtreeScore);
                }
                if (pre > 0.0f) {
                    this.traceQueue.offer(new TraceItem<T>(u, v, A_, B_));
                }
                return true;
            }
        }
        return false;
    }

    private boolean traceDeleteLeft(Tree<T> u, Tree<T> v, float opt, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        for (Tree<T> a : As) {
            int A_ = A & ~a.key;
            IntFloatIterator iter = this.tables.get(a.index, v.index).eachInMaxLeft();
            while (iter.hasNext()) {
                iter.next();
                int B_ = iter.getKey();
                if ((B & B_) != B_) continue;
                int BB = B & ~B_;
                float deleteScore = this.scoring.deleteLeft(a.label);
                float pre = D.get(A_, BB);
                float score = iter.getValue() + deleteScore + pre;
                if (!(score >= opt)) continue;
                assert (iter.getValue() > 0.0f);
                assert (score == opt);
                this.tracer.deleteLeft(deleteScore, a.label);
                if (a.degree() > 0) {
                    this.addTraceItemFor(a, v, Set.of(a.children()), B_, iter.getValue());
                }
                if (pre > 0.0f) {
                    this.addTraceItemFor(u, v, A_, BB, pre);
                }
                return true;
            }
        }
        return false;
    }

    private boolean traceDeleteRight(Tree<T> u, Tree<T> v, float opt, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        for (Tree<T> b : Bs) {
            int B_ = B & ~b.key;
            IntFloatIterator iter = this.tables.get(u.index, b.index).eachInMaxRight();
            while (iter.hasNext()) {
                iter.next();
                int A_ = iter.getKey();
                if ((A & A_) != A_) continue;
                int AA = A & ~A_;
                float deleteScore = this.scoring.deleteRight(b.label);
                float pre = D.get(AA, B_);
                float score = iter.getValue() + deleteScore + pre;
                if (!(score >= opt)) continue;
                assert (iter.getValue() > 0.0f);
                assert (score == opt);
                this.tracer.deleteRight(deleteScore, b.label);
                if (b.degree() > 0) {
                    this.addTraceItemFor(u, b, A_, Set.of(b.children()), iter.getValue());
                }
                if (pre > 0.0f) {
                    this.addTraceItemFor(u, v, AA, B_, pre);
                }
                return true;
            }
        }
        return false;
    }

    private boolean traceJoinLeft(Tree<T> u, Tree<T> v, float opt, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        for (Tree<T> a : As) {
            int A__ = A & ~a.key;
            HashTable<T> T = this.tables.get(a.index, v.index);
            IntFloatIterator iter = T.eachInMaxJoinLeft();
            while (iter.hasNext()) {
                iter.next();
                int B_ = iter.getKey();
                if ((B_ & B) != B_) continue;
                int B__ = B & ~B_;
                float pre = D.get(A__, B__);
                float value = iter.getValue();
                float score = value + pre;
                if (!(score >= opt)) continue;
                assert (score == opt);
                IntPairFloatIterator pairIter = T.eachInJoinLeft();
                while (pairIter.hasNext()) {
                    pairIter.next();
                    int X = pairIter.getLeft();
                    int Y = pairIter.getRight();
                    if (Y != B_ || !(pairIter.getValue() >= value)) continue;
                    assert (pairIter.getValue() == value);
                    List<Tree<T>> Ys = Set.subList(v.children(), Y);
                    for (Tree<T> x : Set.subList(a.children(), X)) {
                        for (Tree<T> y : Ys) {
                            float preScore = T.getJoinLeft(X & ~x.key, Y & ~y.key);
                            if (!(T.getJoinLeft(x.key, y.key) + preScore >= value)) continue;
                            assert (T.getJoinLeft(x.key, y.key) + preScore == value);
                            float joinScore = this.scoring.joinLeft(a.label, x.label, y.label);
                            this.tracer.innerJoinLeft(a.label);
                            this.tracer.join(joinScore, x.eachAncestors(1), Iterators.singleton(y.label), 2, 1);
                            float subtreeScore = value - joinScore - preScore;
                            if (!(subtreeScore > 0.0f)) continue;
                            this.addTraceItemFor(x, y, subtreeScore);
                        }
                    }
                    if (pre > 0.0f) {
                        this.addTraceItemFor(u, v, A__, B__, pre);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean traceJoinRight(Tree<T> u, Tree<T> v, float opt, HashTable<T> D, int A, int B, List<Tree<T>> As, List<Tree<T>> Bs) {
        for (Tree<T> b : Bs) {
            int B_ = B & ~b.key;
            HashTable<T> T = this.tables.get(u.index, b.index);
            IntFloatIterator iter = T.eachInMaxJoinRight();
            while (iter.hasNext()) {
                iter.next();
                int A_ = iter.getKey();
                if ((A_ & A) != A_) continue;
                int AA = A & ~A_;
                float pre = D.get(AA, B_);
                float value = iter.getValue();
                float jvalue = value;
                float score = jvalue + pre;
                if (!(score >= opt)) continue;
                assert (score == opt);
                IntPairFloatIterator pairIter = T.eachInJoinRight();
                while (pairIter.hasNext()) {
                    pairIter.next();
                    int X = pairIter.getLeft();
                    int Y = pairIter.getRight();
                    if (X != A_ || !(pairIter.getValue() >= value)) continue;
                    assert (pairIter.getValue() == value);
                    List<Tree<T>> Xs = Set.subList(u.children(), X);
                    for (Tree<T> y : Set.subList(b.children(), Y)) {
                        for (Tree<T> x : Xs) {
                            float preScore = T.getJoinRight(X & ~x.key, Y & ~y.key);
                            if (!(T.getJoinRight(x.key, y.key) + preScore >= value)) continue;
                            assert (T.getJoinRight(x.key, y.key) + preScore == value);
                            this.tracer.innerJoinRight(b.label);
                            float joinScore = this.scoring.joinRight(b.label, y.label, x.label);
                            this.tracer.join(joinScore, Iterators.singleton(x.label), y.eachAncestors(1), 1, 2);
                            float subtreeScore = jvalue - joinScore - preScore;
                            if (!(subtreeScore > 0.0f)) continue;
                            this.addTraceItemFor(x, y, subtreeScore);
                        }
                    }
                    if (pre > 0.0f) {
                        this.addTraceItemFor(u, v, AA, B_, pre);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

