/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.treealign.sparse;

import de.unijena.bioinf.treealign.Tree;
import de.unijena.bioinf.treealign.map.IntFloatArrayMap;
import de.unijena.bioinf.treealign.map.IntFloatHashMap;
import de.unijena.bioinf.treealign.map.IntFloatIterator;
import de.unijena.bioinf.treealign.map.IntFloatMap;
import de.unijena.bioinf.treealign.map.IntPairFloatArrayMap;
import de.unijena.bioinf.treealign.map.IntPairFloatHashMap;
import de.unijena.bioinf.treealign.map.IntPairFloatIterator;
import de.unijena.bioinf.treealign.map.IntPairFloatMap;
import java.util.List;

class HashTable<T> {
    public static final double INITIAL_FILL_SIZE_FOR_SMALL = (double)0.2f;
    public static final double INITIAL_FILL_SIZE_FOR_HUGE = (double)0.05f;
    public static final int MAX_INITIAL_ENTRY_SLOTS = 1024;
    public static final Mode MODE = Mode.USE_HASH_FOR_HUGE_DEGREE;
    private final IntPairFloatMap data;
    private final IntPairFloatMap joinDataLeft;
    private final IntPairFloatMap joinDataRight;
    private final IntFloatMap maxLeft;
    private final IntFloatMap maxRight;
    private final IntFloatMap maxJoinLeft;
    private final IntFloatMap maxJoinRight;
    private float score;

    public HashTable(List<Tree<T>> basicSetA, List<Tree<T>> basicSetB, boolean useJoins) {
        int leftSize = 1 << basicSetA.size();
        int rightSize = 1 << basicSetB.size();
        this.data = this.allocateIntPairFloatMap(leftSize, rightSize);
        if (useJoins) {
            this.joinDataLeft = this.allocateIntPairFloatMap(leftSize, rightSize);
            this.joinDataRight = this.allocateIntPairFloatMap(leftSize, rightSize);
            this.maxJoinLeft = this.allocateIntFloatMap(rightSize);
            this.maxJoinRight = this.allocateIntFloatMap(leftSize);
        } else {
            this.joinDataLeft = null;
            this.joinDataRight = null;
            this.maxJoinLeft = null;
            this.maxJoinRight = null;
        }
        this.maxLeft = this.allocateIntFloatMap(rightSize);
        this.maxRight = this.allocateIntFloatMap(leftSize);
        this.score = 0.0f;
    }

    private IntFloatMap allocateIntFloatMap(int size) {
        switch (MODE) {
            case USE_ARRAY: {
                return new IntFloatArrayMap(size);
            }
            case USE_HASH: {
                return new IntFloatHashMap(this.trimSizeForHashMap(size));
            }
            case USE_HASH_FOR_HUGE_DEGREE: {
                return this.isHuge(size) ? new IntFloatHashMap(this.trimSizeForHashMap(size)) : new IntFloatArrayMap(size);
            }
        }
        throw new RuntimeException("Illegal value for MODE: " + String.valueOf((Object)MODE));
    }

    public boolean isHuge(long size) {
        return size >= 262144L;
    }

    private int trimSizeForHashMap(long size) {
        long l = 0L;
        l = this.isHuge(size) ? (long)((double)size * (double)0.05f) : (long)((double)size * (double)0.2f) + 2L;
        if (l > 1024L) {
            return 1024;
        }
        assert (l < Integer.MAX_VALUE);
        return (int)l;
    }

    private IntPairFloatMap allocateIntPairFloatMap(int leftSize, int rightSize) {
        long size = (long)leftSize * (long)rightSize;
        switch (MODE) {
            case USE_ARRAY: {
                return new IntPairFloatArrayMap(leftSize, rightSize);
            }
            case USE_HASH: {
                return new IntPairFloatHashMap(this.trimSizeForHashMap(size));
            }
            case USE_HASH_FOR_HUGE_DEGREE: {
                return this.isHuge(size) ? new IntPairFloatHashMap(this.trimSizeForHashMap(size)) : new IntPairFloatArrayMap(leftSize, rightSize);
            }
        }
        throw new RuntimeException("Illegal value for MODE: " + String.valueOf((Object)MODE));
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setScoreIfGreater(float score) {
        this.score = Math.max(score, this.score);
    }

    public float get(int A, int B) {
        return this.data.get(A, B);
    }

    public void set(int A, int B, float value) {
        this.data.put(A, B, value);
        assert (this.data.get(A, B) > 0.0f);
    }

    public IntPairFloatMap.ReturnType putIfGreater(int A, int B, float value) {
        return this.data.putIfGreater(A, B, value);
    }

    public float getJoinLeft(int A, int B) {
        return this.joinDataLeft.get(A, B);
    }

    public void setJoinLeft(int A, int B, float value) {
        this.joinDataLeft.put(A, B, value);
    }

    public IntPairFloatMap.ReturnType putJoinLeftIfGreater(int A, int B, float value) {
        return this.joinDataLeft.putIfGreater(A, B, value);
    }

    public float getJoinRight(int A, int B) {
        return this.joinDataRight.get(A, B);
    }

    public void setJoinRight(int A, int B, float value) {
        this.joinDataRight.put(A, B, value);
    }

    public IntPairFloatMap.ReturnType putJoinRightIfGreater(int A, int B, float value) {
        return this.joinDataRight.putIfGreater(A, B, value);
    }

    public float getMaxLeft(int B) {
        return this.maxLeft.get(B);
    }

    public float getMaxRight(int A) {
        return this.maxRight.get(A);
    }

    public float getMaxJoinLeft(int B) {
        return this.maxJoinLeft.get(B);
    }

    public float getMaxJoinRight(int A) {
        return this.maxJoinRight.get(A);
    }

    public IntFloatIterator eachInMaxLeft() {
        return this.maxLeft.entries();
    }

    public IntFloatIterator eachInMaxRight() {
        return this.maxRight.entries();
    }

    public IntFloatIterator eachInMaxJoinLeft() {
        return this.maxJoinLeft.entries();
    }

    public IntFloatIterator eachInMaxJoinRight() {
        return this.maxJoinRight.entries();
    }

    public IntPairFloatIterator each() {
        return this.data.entries();
    }

    public IntPairFloatIterator eachInJoinLeft() {
        return this.joinDataLeft.entries();
    }

    public IntPairFloatIterator eachInJoinRight() {
        return this.joinDataRight.entries();
    }

    public void putMaxLeftIfGreater(int B, float value) {
        this.maxLeft.putIfGreater(B, value);
    }

    public void putMaxRightIfGreater(int A, float value) {
        this.maxRight.putIfGreater(A, value);
    }

    public void putMaxJoinLeftIfGreater(int B, float value) {
        this.maxJoinLeft.putIfGreater(B, value);
    }

    public void putMaxJoinRightIfGreater(int A, float value) {
        this.maxJoinRight.putIfGreater(A, value);
    }

    public static enum Mode {
        USE_ARRAY,
        USE_HASH,
        USE_HASH_FOR_HUGE_DEGREE;

    }
}

