/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class Iterators {
    public static <T> ListIterator<T> singleton(T instance) {
        return new SingletonIterator(instance);
    }

    public static <T> ListIterator<T> empty() {
        return new EmptyIterator();
    }

    public static <T> ListIterator<T> pair(T left, T right) {
        return new Iterator2(left, right);
    }

    public static <T> ListIterator<T> array(T ... array) {
        switch (array.length) {
            case 0: {
                return new EmptyIterator();
            }
            case 1: {
                return new SingletonIterator(array[0]);
            }
            case 2: {
                return new Iterator2(array[0], array[1]);
            }
        }
        return Arrays.asList(array).listIterator();
    }

    public static <T> Iterable<T> capture(final Iterator<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterable;
            }
        };
    }

    public static <T> void rewind(ListIterator<T> iter) {
        while (iter.hasPrevious()) {
            iter.previous();
        }
    }

    public static <T> void forward(Iterator<T> iter) {
        while (iter.hasNext()) {
            iter.next();
        }
    }

    private static final class Iterator2<T>
    extends BidirectionalIterator<T> {
        private final T e1;
        private final T e2;
        private byte i;

        private Iterator2(T e1, T e2) {
            this.e1 = e1;
            this.e2 = e2;
            this.i = 0;
        }

        @Override
        public boolean hasPrevious() {
            return this.i > 0;
        }

        @Override
        public T previous() {
            if (this.i <= 0) {
                throw new NoSuchElementException();
            }
            this.i = (byte)(this.i - 1);
            return this.i == 1 ? this.e1 : this.e2;
        }

        @Override
        public int nextIndex() {
            return this.i;
        }

        @Override
        public int previousIndex() {
            return this.i - 1;
        }

        @Override
        public boolean hasNext() {
            return this.i < 2;
        }

        @Override
        public T next() {
            if (this.i >= 2) {
                throw new NoSuchElementException();
            }
            this.i = (byte)(this.i + 1);
            return this.i == 1 ? this.e1 : this.e2;
        }
    }

    private static final class SingletonIterator<T>
    extends BidirectionalIterator<T> {
        private final T instance;
        private boolean hasNext;

        private SingletonIterator(T instance) {
            this.instance = instance;
            this.hasNext = true;
        }

        @Override
        public boolean hasPrevious() {
            return !this.hasNext;
        }

        @Override
        public T previous() {
            if (this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = true;
            return this.instance;
        }

        @Override
        public int nextIndex() {
            return this.hasNext ? 0 : 1;
        }

        @Override
        public int previousIndex() {
            return this.hasNext ? -1 : 0;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.instance;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class EmptyIterator<T>
    extends BidirectionalIterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public T previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class BidirectionalIterator<T>
    implements ListIterator<T> {
        private BidirectionalIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException();
        }
    }
}

