/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.recal;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.MathUtils;

public class ChebychevPolynomialFunction
implements UnivariateFunction {
    private static final long serialVersionUID = -3649121243067210554L;
    protected static final PolynomialFunction[] firstOrderCoefficients = new PolynomialFunction[10];
    protected double[] coefficients;
    protected double xmin;
    protected double scale;

    public ChebychevPolynomialFunction(double[] c, double xmin, double xmax) throws NullArgumentException, NoDataException {
        if (c.length > 10) {
            throw new IllegalArgumentException("too many coefficients");
        }
        this.coefficients = c;
        this.xmin = xmin;
        this.scale = 2.0 / (xmax - xmin);
    }

    public static int getN() {
        return 9;
    }

    protected static PolynomialFunction[] getChebychevCoefficients() {
        return firstOrderCoefficients;
    }

    protected static double evaluate(double[] coefficients, double argument) {
        MathUtils.checkNotNull((Object)coefficients);
        int n = coefficients.length;
        if (n == 0) {
            throw new NoDataException((Localizable)LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        PolynomialFunction[] chebychevCoefficients = ChebychevPolynomialFunction.getChebychevCoefficients();
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            result += coefficients[i] * chebychevCoefficients[i].value(argument);
        }
        return result - 0.5 * coefficients[0];
    }

    public double value(double x) {
        return ChebychevPolynomialFunction.evaluate(this.coefficients, (x - this.xmin) * this.scale - 1.0);
    }

    public String toString() {
        return ChebychevPolynomialFunction.toString(this.coefficients);
    }

    private static String toString(double[] coefficients) {
        StringBuilder s = new StringBuilder();
        if (coefficients[0] == 0.0) {
            if (coefficients.length == 1) {
                return "0";
            }
        } else {
            s.append(ChebychevPolynomialFunction.toString(coefficients[0]));
        }
        for (int i = 1; i < coefficients.length; ++i) {
            if (coefficients[i] == 0.0) continue;
            if (coefficients[i] < 0.0) {
                s.append(" - ");
            } else {
                s.append(" + ");
            }
            s.append(ChebychevPolynomialFunction.toString(Math.abs(coefficients[i])) + " ");
            s.append("(" + ChebychevPolynomialFunction.getChebychevCoefficients()[i].toString() + ")");
        }
        if (coefficients[0] != 0.0) {
            if (coefficients[0] > 0.0) {
                s.append(" - ");
            } else {
                s.append(" + ");
            }
            s.append(" 0.5 " + ChebychevPolynomialFunction.toString(Math.abs(coefficients[0])));
        }
        return s.toString();
    }

    private static String toString(double coeff) {
        String c = Double.toString(coeff);
        if (c.endsWith(".0")) {
            return c.substring(0, c.length() - 2);
        }
        return c;
    }

    static {
        ChebychevPolynomialFunction.firstOrderCoefficients[0] = new PolynomialFunction(new double[]{1.0});
        ChebychevPolynomialFunction.firstOrderCoefficients[1] = new PolynomialFunction(new double[]{0.0, 1.0});
        ChebychevPolynomialFunction.firstOrderCoefficients[2] = new PolynomialFunction(new double[]{-1.0, 0.0, 2.0});
        ChebychevPolynomialFunction.firstOrderCoefficients[3] = new PolynomialFunction(new double[]{0.0, -3.0, 0.0, 4.0});
        ChebychevPolynomialFunction.firstOrderCoefficients[4] = new PolynomialFunction(new double[]{1.0, 0.0, -8.0, 0.0, 8.0});
        ChebychevPolynomialFunction.firstOrderCoefficients[5] = new PolynomialFunction(new double[]{0.0, 5.0, 0.0, -20.0, 0.0, 16.0});
        ChebychevPolynomialFunction.firstOrderCoefficients[6] = new PolynomialFunction(new double[]{-1.0, 0.0, 18.0, 0.0, -48.0, 0.0, 36.0});
        ChebychevPolynomialFunction.firstOrderCoefficients[7] = new PolynomialFunction(new double[]{0.0, -7.0, 0.0, 56.0, 0.0, -112.0, 0.0, 64.0});
        ChebychevPolynomialFunction.firstOrderCoefficients[8] = new PolynomialFunction(new double[]{1.0, 0.0, -32.0, 0.0, 160.0, 0.0, -256.0, 0.0, 128.0});
        ChebychevPolynomialFunction.firstOrderCoefficients[9] = new PolynomialFunction(new double[]{0.0, 9.0, 0.0, -120.0, 0.0, 432.0, 0.0, -576.0, 0.0, 256.0});
    }
}

