/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.recal;

import de.unijena.bioinf.ChemistryBase.ms.MutableSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.Peak;
import de.unijena.bioinf.ChemistryBase.ms.Spectrum;
import de.unijena.bioinf.recal.ChebychevPolynomialFunction;
import de.unijena.bioinf.recal.OrdinaryLeastSquares;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.optimization.DifferentiableMultivariateVectorOptimizer;
import org.apache.commons.math3.optimization.fitting.PolynomialFitter;
import org.apache.commons.math3.optimization.general.LevenbergMarquardtOptimizer;
import utils.math.MathUtils;

public class MzRecalibration {
    private static final int SIGN_POS = 1;
    private static final int SIGN_NEG = -1;
    public static final double DEFAULT_POLY_COEFF_THRESHOLD = 1.0E-10;
    private static Comparator<Tuple> COMPARATOR = new Comparator<Tuple>(){

        @Override
        public int compare(Tuple tuple, Tuple tuple2) {
            return Double.compare(tuple.key, tuple2.key);
        }
    };

    @Deprecated
    public static <P extends Peak, Q extends Peak> double[][] maxIntervalStabbing(Spectrum<P> observed, Spectrum<Q> reference, UnivariateFunction epsilon) {
        return MzRecalibration.maxIntervalStabbing(observed, reference, epsilon, Double.POSITIVE_INFINITY);
    }

    public static <P extends Peak, Q extends Peak> double[][] maxIntervalStabbing(Spectrum<P> observed, Spectrum<Q> reference, UnivariateFunction epsilon, double threshold) {
        double[] e = new double[observed.size()];
        for (int i = 0; i < observed.size(); ++i) {
            e[i] = epsilon.value(observed.getMzAt(i));
        }
        return MzRecalibration.maxIntervalStabbing(observed, reference, e, threshold);
    }

    @Deprecated
    public static <P extends Peak, Q extends Peak> double[][] maxIntervalStabbing(Spectrum<P> observed, Spectrum<Q> reference, BivariateFunction epsilon) {
        return MzRecalibration.maxIntervalStabbing(observed, reference, epsilon, Double.POSITIVE_INFINITY);
    }

    public static <P extends Peak, Q extends Peak> double[][] maxIntervalStabbing(Spectrum<P> observed, Spectrum<Q> reference, BivariateFunction epsilon, double threshold) {
        double[] e = new double[observed.size()];
        for (int i = 0; i < observed.size(); ++i) {
            e[i] = epsilon.value(observed.getMzAt(i), observed.getIntensityAt(i));
        }
        return MzRecalibration.maxIntervalStabbing(observed, reference, e, threshold);
    }

    @Deprecated
    public static <P extends Peak, Q extends Peak> double[][] maxIntervalStabbing(Spectrum<P> observed, Spectrum<Q> reference, double[] epsilon) {
        return MzRecalibration.maxIntervalStabbing(observed, reference, epsilon, Double.POSITIVE_INFINITY);
    }

    public static <P extends Peak, Q extends Peak> double[][] maxIntervalStabbing(Spectrum<P> observed, Spectrum<Q> reference, double[] epsilon, double threshold) {
        if (epsilon.length != observed.size()) {
            throw new IllegalArgumentException("length of epsilon != size of observed spectrum");
        }
        TDoubleArrayList x = new TDoubleArrayList();
        TDoubleArrayList y = new TDoubleArrayList();
        TDoubleArrayList e = new TDoubleArrayList();
        for (int i = 0; i < observed.size(); ++i) {
            for (int j = 0; j < reference.size(); ++j) {
                if (!(Math.abs(observed.getMzAt(i) - reference.getMzAt(j)) < threshold)) continue;
                x.add(observed.getMzAt(i));
                y.add(reference.getMzAt(j));
                e.add(epsilon[i]);
            }
        }
        int maxScore = 0;
        double aStar = 0.0;
        double bStar = 0.0;
        for (int i = 0; i < x.size(); ++i) {
            PriorityQueue<Tuple> Q = new PriorityQueue<Tuple>(2 * x.size(), COMPARATOR);
            for (int j = 0; j < x.size(); ++j) {
                double delta;
                if (i == j || (delta = x.get(i) - x.get(j)) == 0.0) continue;
                int sign = delta < 0.0 ? -1 : 1;
                Q.add(new Tuple((y.get(i) - y.get(j)) / delta, sign));
                Q.add(new Tuple((y.get(i) - y.get(j) + e.get(j)) / delta, -sign));
            }
            int score = 0;
            while (!Q.isEmpty()) {
                Tuple min = Q.poll();
                if ((score += min.value) <= maxScore) continue;
                maxScore = score;
                aStar = min.key;
                bStar = min.key * x.get(i) - y.get(i);
            }
        }
        TDoubleArrayList subsetX = new TDoubleArrayList();
        TDoubleArrayList subsetY = new TDoubleArrayList();
        for (int i = 0; i < x.size(); ++i) {
            if (!(Math.abs(aStar * x.get(i) - bStar - y.get(i)) <= e.get(i))) continue;
            subsetX.add(x.get(i));
            subsetY.add(y.get(i));
        }
        return new double[][]{subsetX.toArray(), subsetY.toArray()};
    }

    @Deprecated
    public static <P extends Peak, Q extends Peak> double[][] maxLinePairStabbing(Spectrum<P> observed, Spectrum<Q> reference, double epsilon) {
        return MzRecalibration.maxLinePairStabbing(observed, reference, epsilon, Double.POSITIVE_INFINITY);
    }

    public static <P extends Peak, Q extends Peak> double[][] maxLinePairStabbing(Spectrum<P> observed, Spectrum<Q> reference, double epsilon, double threshold) {
        double[] e = new double[observed.size()];
        Arrays.fill(e, epsilon);
        return MzRecalibration.maxIntervalStabbing(observed, reference, e, threshold);
    }

    public static <T extends Peak> MutableSpectrum<T> recalibrate(MutableSpectrum<T> spectrum, UnivariateFunction function) {
        for (int i = 0; i < spectrum.size(); ++i) {
            spectrum.setMzAt(i, function.value(spectrum.getMzAt(i)));
        }
        return spectrum;
    }

    public static <P extends Peak, Q extends Peak> PolynomialFunction getMedianLinearRecalibration(double[] x, double[] y) {
        MzRecalibration.checkArgs(x, y);
        TDoubleArrayList slopes = new TDoubleArrayList();
        for (int i = 0; i < x.length - 1; ++i) {
            for (int j = i + 1; j < x.length; ++j) {
                slopes.add((y[j] - y[i]) / (x[j] - x[i]));
            }
        }
        double slope = MathUtils.median((double[])slopes.toArray());
        TDoubleArrayList intersects = new TDoubleArrayList();
        for (int i = 0; i < y.length; ++i) {
            intersects.add(y[i] - slope * x[i]);
        }
        double intersect = MathUtils.median((double[])intersects.toArray());
        return new PolynomialFunction(new double[]{intersect, slope});
    }

    public static PolynomialFunction getLinearRecalibration(double[] x, double[] y) {
        MzRecalibration.checkArgs(x, y);
        double[] coefficients = new OrdinaryLeastSquares().solve(x, y);
        return new PolynomialFunction(coefficients);
    }

    public static PolynomialFunction getPolynomialRecalibration(double[] x, double[] y) {
        return MzRecalibration.getPolynomialRecalibration(x, y, 1.0E-10);
    }

    public static PolynomialFunction getPolynomialRecalibration(double[] x, double[] y, double threshold) {
        MzRecalibration.checkArgs(x, y);
        int degree = 1;
        while (true) {
            PolynomialFitter fit = new PolynomialFitter(degree, (DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
            for (int i = 0; i < x.length; ++i) {
                fit.addObservedPoint(x[i], y[i]);
            }
            double[] coefficients = fit.fit();
            if (Math.abs(coefficients[coefficients.length - 1]) < threshold) {
                return new PolynomialFunction(coefficients);
            }
            ++degree;
        }
    }

    public static PolynomialFunction getPolynomialRecalibrationWithDegree(double[] x, double[] y, int degree) {
        MzRecalibration.checkArgs(x, y);
        PolynomialFitter fit = new PolynomialFitter(degree, (DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
        for (int i = 0; i < x.length; ++i) {
            fit.addObservedPoint(x[i], y[i]);
        }
        return new PolynomialFunction(fit.fit());
    }

    private static PolynomialSplineFunction getPolynomialSplineRecalibration(double[] x, double[] y) {
        SplineInterpolator interpolator = new SplineInterpolator();
        return interpolator.interpolate(x, y);
    }

    public static ChebychevPolynomialFunction getFirstOrderChebyshevRecalibration(double[] x, double[] y) {
        MzRecalibration.checkArgs(x, y);
        double[] xR = new double[x.length];
        System.arraycopy(x, 0, xR, 0, x.length);
        double xmin = xR[0];
        double xmax = xR[xR.length - 1];
        double scale = 2.0 / (xmax - xmin);
        for (int i = 0; i < xR.length; ++i) {
            xR[i] = (xR[i] - xmin) * scale - 1.0;
        }
        PolynomialSplineFunction function = MzRecalibration.getPolynomialSplineRecalibration(xR, y);
        double N = ChebychevPolynomialFunction.getN() + 1;
        double[] coefficients = new double[(int)N];
        double twoDivN = 2.0 / N;
        double piDivN = Math.PI / N;
        int j = 0;
        while ((double)j < N) {
            int k = 1;
            while ((double)k <= N) {
                double kTimesPiDivN = ((double)k - 0.5) * piDivN;
                int n = j;
                coefficients[n] = coefficients[n] + Math.cos((double)j * kTimesPiDivN) * function.value(Math.cos(kTimesPiDivN));
                ++k;
            }
            int n = j++;
            coefficients[n] = coefficients[n] * twoDivN;
        }
        return new ChebychevPolynomialFunction(coefficients, xmin, xmax);
    }

    private static void checkArgs(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x != y");
        }
        if (x.length == 0) {
            throw new IllegalArgumentException("no points");
        }
    }

    private static class Tuple {
        double key;
        int value;

        public Tuple(double key, int value) {
            this.key = key;
            this.value = value;
        }
    }
}

