/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.recal;

public class OrdinaryLeastSquares {
    private int n = 0;
    private double xbar = 0.0;
    private double ybar = 0.0;
    private double sumXX = 0.0;
    private double sumXY = 0.0;
    private double sumX = 0.0;
    private double sumY = 0.0;

    public void reset() {
        this.n = 0;
        this.xbar = 0.0;
        this.ybar = 0.0;
        this.sumXX = 0.0;
        this.sumXY = 0.0;
        this.sumX = 0.0;
        this.sumY = 0.0;
    }

    public void addPoint(double x, double y) {
        if (this.n == 0) {
            this.xbar = x;
            this.ybar = y;
        } else {
            double dx = x - this.xbar;
            double dy = y - this.ybar;
            this.sumXX += dx * dx * (double)this.n / ((double)this.n + 1.0);
            this.sumXY += dx * dy * (double)this.n / ((double)this.n + 1.0);
            this.xbar += dx / ((double)this.n + 1.0);
            this.ybar += dy / ((double)this.n + 1.0);
        }
        this.sumX += x;
        this.sumY += y;
        ++this.n;
    }

    public double[] getSolution() {
        if (this.n == 0) {
            throw new IllegalArgumentException("no points added");
        }
        double[] solution = new double[2];
        solution[1] = this.sumXY / this.sumXX;
        solution[0] = (this.sumY - solution[1] * this.sumX) / (double)this.n;
        return solution;
    }

    public double[] solve(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x != y");
        }
        if (x.length < 2) {
            throw new IllegalArgumentException("not enough points");
        }
        this.reset();
        for (int i = 0; i < x.length; ++i) {
            this.addPoint(x[i], y[i]);
        }
        return this.getSolution();
    }
}

