/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLRXNFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MDLRXNReader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLReader.class);

    public MDLRXNReader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLRXNReader(Reader in, IChemObjectReader.Mode mode) {
        this.input = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        this.mode = mode;
    }

    public MDLRXNReader(InputStream input) {
        this(input, IChemObjectReader.Mode.RELAXED);
    }

    public MDLRXNReader(InputStream input, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(input), mode);
    }

    public MDLRXNReader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return MDLRXNFormat.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        if (IReaction.class.equals(classObject)) {
            return true;
        }
        if (IReactionSet.class.equals(classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IChemModel.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemFile.class.equals(interfaces[i])) {
                return true;
            }
            if (IReaction.class.equals(interfaces[i])) {
                return true;
            }
            if (!IReactionSet.class.equals(interfaces[i])) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        if (object instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)object);
        }
        if (object instanceof IReactionSet) {
            return (T)this.readReactionSet((IReactionSet)object);
        }
        if (object instanceof IReaction) {
            return (T)this.readReaction(object.getBuilder());
        }
        throw new CDKException("Only supported are Reaction, ReactionSet, ChemModel and ChemFile, and not " + object.getClass().getName() + ".");
    }

    public boolean accepts(IChemObject object) {
        if (object instanceof IReaction) {
            return true;
        }
        if (object instanceof IChemModel) {
            return true;
        }
        if (object instanceof IChemFile) {
            return true;
        }
        return object instanceof IReactionSet;
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException {
        IChemSequence chemSequence = (IChemSequence)chemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel chemModel = (IChemModel)chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        chemSequence.addChemModel(this.readChemModel(chemModel));
        chemFile.addChemSequence(chemSequence);
        return chemFile;
    }

    private IChemModel readChemModel(IChemModel chemModel) throws CDKException {
        IReactionSet setOfReactions = chemModel.getReactionSet();
        if (setOfReactions == null) {
            setOfReactions = (IReactionSet)chemModel.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        }
        chemModel.setReactionSet(this.readReactionSet(setOfReactions));
        return chemModel;
    }

    private IReactionSet readReactionSet(IReactionSet setOfReactions) throws CDKException {
        IReaction r = this.readReaction(setOfReactions.getBuilder());
        if (r != null) {
            setOfReactions.addReaction(r);
        }
        try {
            String line;
            while ((line = this.input.readLine()) != null) {
                logger.debug((Object)"line: ", new Object[]{line});
                if (line.equals("$$$$")) {
                    r = this.readReaction(setOfReactions.getBuilder());
                    if (r == null) continue;
                    setOfReactions.addReaction(r);
                    continue;
                }
                if (r == null) continue;
                String fieldName = null;
                if (line.startsWith("> ")) {
                    int index2;
                    int index = line.indexOf(60);
                    if (index != -1 && (index2 = line.substring(index).indexOf(62)) != -1) {
                        fieldName = line.substring(index + 1, index + index2);
                    }
                    while ((line = this.input.readLine()) != null && line.startsWith(">")) {
                        logger.debug((Object)"data header line: ", new Object[]{line});
                    }
                }
                if (line == null) {
                    throw new CDKException("Expecting data line here, but found null!");
                }
                String data = line;
                while ((line = this.input.readLine()) != null && line.trim().length() > 0) {
                    if (line.equals("$$$$")) {
                        logger.error((Object)"Expecting data line here, but found end of molecule: ", new Object[]{line});
                        break;
                    }
                    logger.debug((Object)"data line: ", new Object[]{line});
                    data = data + line;
                    if (line.length() >= 80) continue;
                    data = data + System.getProperty("line.separator");
                }
                if (fieldName == null) continue;
                logger.info((Object)"fieldName, data: ", new Object[]{fieldName, ", ", data});
                r.setProperty((Object)fieldName, (Object)data);
            }
        }
        catch (CDKException cdkexc) {
            throw cdkexc;
        }
        catch (IOException exception) {
            String error = "Error while parsing SDF";
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
        return setOfReactions;
    }

    private IReaction readReaction(IChemObjectBuilder builder) throws CDKException {
        MDLReader reader;
        String molFileLine;
        StringBuffer molFile;
        int i;
        logger.debug((Object)"Reading new reaction");
        int linecount = 0;
        IReaction reaction = (IReaction)builder.newInstance(IReaction.class, new Object[0]);
        try {
            this.input.readLine();
            this.input.readLine();
            this.input.readLine();
            this.input.readLine();
        }
        catch (IOException exception) {
            logger.debug((Object)exception);
            throw new CDKException("Error while reading header of RXN file", (Throwable)exception);
        }
        int reactantCount = 0;
        int productCount = 0;
        try {
            String countsLine = this.input.readLine();
            ++linecount;
            if (countsLine == null) {
                return null;
            }
            logger.debug((Object)("Line " + linecount + ": " + countsLine));
            if (countsLine.startsWith("$$$$")) {
                logger.debug((Object)"File is empty, returning empty reaction");
                return reaction;
            }
            StringTokenizer tokenizer = new StringTokenizer(countsLine);
            reactantCount = Integer.valueOf(tokenizer.nextToken());
            logger.info((Object)("Expecting " + reactantCount + " reactants in file"));
            productCount = Integer.valueOf(tokenizer.nextToken());
            logger.info((Object)("Expecting " + productCount + " products in file"));
        }
        catch (IOException | NumberFormatException exception) {
            logger.debug((Object)exception);
            throw new CDKException("Error while counts line of RXN file", (Throwable)exception);
        }
        try {
            for (i = 1; i <= reactantCount; ++i) {
                molFile = new StringBuffer();
                this.input.readLine();
                molFileLine = "";
                do {
                    molFileLine = this.input.readLine();
                    molFile.append(molFileLine);
                    molFile.append(System.getProperty("line.separator"));
                } while (!molFileLine.equals("M  END"));
                reader = new MDLReader(new StringReader(molFile.toString()));
                IAtomContainer reactant = (IAtomContainer)reader.read((IChemObject)builder.newInstance(IAtomContainer.class, new Object[0]));
                reader.close();
                reaction.addReactant(reactant);
            }
        }
        catch (CDKException exception) {
            throw exception;
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.debug((Object)exception);
            throw new CDKException("Error while reading reactant", (Throwable)exception);
        }
        try {
            for (i = 1; i <= productCount; ++i) {
                molFile = new StringBuffer();
                this.input.readLine();
                molFileLine = "";
                do {
                    molFileLine = this.input.readLine();
                    molFile.append(molFileLine);
                    molFile.append(System.getProperty("line.separator"));
                } while (!molFileLine.equals("M  END"));
                reader = new MDLReader(new StringReader(molFile.toString()), this.mode);
                IAtomContainer product = (IAtomContainer)reader.read((IChemObject)builder.newInstance(IAtomContainer.class, new Object[0]));
                reader.close();
                reaction.addProduct(product);
            }
        }
        catch (CDKException exception) {
            throw exception;
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.debug((Object)exception);
            throw new CDKException("Error while reading products", (Throwable)exception);
        }
        logger.info((Object)"Reading atom-atom mapping from file");
        IAtomContainer reactingSide = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        Iterator molecules = reaction.getReactants().atomContainers().iterator();
        while (molecules.hasNext()) {
            reactingSide.add((IAtomContainer)molecules.next());
        }
        IAtomContainer producedSide = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        molecules = reaction.getProducts().atomContainers().iterator();
        while (molecules.hasNext()) {
            producedSide.add((IAtomContainer)molecules.next());
        }
        int mappingCount = 0;
        block16: for (int i2 = 0; i2 < reactingSide.getAtomCount(); ++i2) {
            for (int j = 0; j < producedSide.getAtomCount(); ++j) {
                IAtom eductAtom = reactingSide.getAtom(i2);
                IAtom productAtom = producedSide.getAtom(j);
                if (eductAtom.getProperty((Object)"cdk:AtomAtomMapping") == null || !eductAtom.getProperty((Object)"cdk:AtomAtomMapping").equals(productAtom.getProperty((Object)"cdk:AtomAtomMapping"))) continue;
                reaction.addMapping((IMapping)builder.newInstance(IMapping.class, new Object[]{eductAtom, productAtom}));
                ++mappingCount;
                continue block16;
            }
        }
        logger.info((Object)("Mapped atom pairs: " + mappingCount));
        return reaction;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

