/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.qsar.AtomValenceTool;

class ChiIndexUtils {
    ChiIndexUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static List<List<Integer>> getFragments(IAtomContainer atomContainer, QueryAtomContainer[] queries) {
        void var6_8;
        UniversalIsomorphismTester universalIsomorphismTester = new UniversalIsomorphismTester();
        ArrayList<List<Integer>> uniqueSubgraphs = new ArrayList<List<Integer>>();
        QueryAtomContainer[] queryAtomContainerArray = queries;
        int n = queryAtomContainerArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            QueryAtomContainer query = queryAtomContainerArray[var6_8];
            List subgraphMaps = null;
            try {
                subgraphMaps = universalIsomorphismTester.getSubgraphMaps(atomContainer, (IAtomContainer)query);
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
            if (subgraphMaps != null && subgraphMaps.size() != 0) {
                uniqueSubgraphs.addAll(ChiIndexUtils.getUniqueBondSubgraphs(subgraphMaps, atomContainer));
            }
            ++var6_8;
        }
        ArrayList<List<Integer>> retValue = new ArrayList<List<Integer>>();
        block3: for (List list : uniqueSubgraphs) {
            for (QueryAtomContainer query : queries) {
                if (list.size() != query.getAtomCount()) continue;
                retValue.add(list);
                continue block3;
            }
        }
        return retValue;
    }

    public static double evalSimpleIndex(IAtomContainer atomContainer, List<List<Integer>> fragLists) {
        double sum = 0.0;
        for (List<Integer> fragList : fragLists) {
            double prod = 1.0;
            for (Integer atomSerial : fragList) {
                IAtom atom = atomContainer.getAtom(atomSerial.intValue());
                int nconnected = atomContainer.getConnectedBondsCount(atom);
                prod *= (double)nconnected;
            }
            if (prod == 0.0) continue;
            sum += 1.0 / Math.sqrt(prod);
        }
        return sum;
    }

    public static double evalValenceIndex(IAtomContainer atomContainer, List<List<Integer>> fragList) throws CDKException {
        try {
            Isotopes ifac = Isotopes.getInstance();
            ifac.configureAtoms(atomContainer);
        }
        catch (IOException e) {
            throw new CDKException("IO problem occurred when using the CDK atom config\n" + e.getMessage(), (Throwable)e);
        }
        double sum = 0.0;
        Iterator<List<Integer>> iterator = fragList.iterator();
        while (iterator.hasNext()) {
            List<Integer> aFragList;
            List<Integer> frag = aFragList = iterator.next();
            double prod = 1.0;
            for (Integer aFrag : frag) {
                double tmp;
                int atomSerial = aFrag;
                IAtom atom = atomContainer.getAtom(atomSerial);
                String sym = atom.getSymbol();
                if (sym.equals("S") && (tmp = ChiIndexUtils.deltavSulphur(atom, atomContainer)) != -1.0) {
                    prod *= tmp;
                    continue;
                }
                if (sym.equals("P") && (tmp = ChiIndexUtils.deltavPhosphorous(atom, atomContainer)) != -1.0) {
                    prod *= tmp;
                    continue;
                }
                int z = atom.getAtomicNumber();
                int zv = ChiIndexUtils.getValenceElectronCount(atom);
                int hsupp = atom.getImplicitHydrogenCount();
                double deltav = (double)(zv - hsupp) / (double)(z - zv - 1);
                prod *= deltav;
            }
            if (prod == 0.0) continue;
            sum += 1.0 / Math.sqrt(prod);
        }
        return sum;
    }

    private static int getValenceElectronCount(IAtom atom) {
        int valency = AtomValenceTool.getValence((IAtom)atom);
        return valency - atom.getFormalCharge();
    }

    protected static double deltavSulphur(IAtom atom, IAtomContainer atomContainer) {
        if (!atom.getSymbol().equals("S")) {
            return -1.0;
        }
        List connected = atomContainer.getConnectedAtomsList(atom);
        for (IAtom connectedAtom : connected) {
            if (!connectedAtom.getSymbol().equals("S") || atomContainer.getBond(atom, connectedAtom).getOrder() != IBond.Order.SINGLE) continue;
            return 0.89;
        }
        int count = 0;
        for (IAtom connectedAtom : connected) {
            if (!connectedAtom.getSymbol().equals("O") || atomContainer.getBond(atom, connectedAtom).getOrder() != IBond.Order.DOUBLE) continue;
            ++count;
        }
        if (count == 1) {
            return 1.33;
        }
        if (count == 2) {
            return 2.67;
        }
        return -1.0;
    }

    private static double deltavPhosphorous(IAtom atom, IAtomContainer atomContainer) {
        if (!atom.getSymbol().equals("P")) {
            return -1.0;
        }
        List connected = atomContainer.getConnectedAtomsList(atom);
        int conditions = 0;
        if (connected.size() == 4) {
            ++conditions;
        }
        for (IAtom connectedAtom : connected) {
            if (connectedAtom.getSymbol().equals("O") && atomContainer.getBond(atom, connectedAtom).getOrder() == IBond.Order.DOUBLE) {
                ++conditions;
            }
            if (atomContainer.getBond(atom, connectedAtom).getOrder() != IBond.Order.SINGLE) continue;
            ++conditions;
        }
        if (conditions == 5) {
            return 2.22;
        }
        return -1.0;
    }

    private static List<List<Integer>> getUniqueBondSubgraphs(List<List<RMap>> subgraphs, IAtomContainer ac) {
        ArrayList bondList = new ArrayList();
        Iterator<List<RMap>> iterator = subgraphs.iterator();
        while (iterator.hasNext()) {
            List<RMap> subgraph;
            List<RMap> current = subgraph = iterator.next();
            ArrayList<Integer> ids = new ArrayList<Integer>();
            Iterator<RMap> iterator2 = current.iterator();
            while (iterator2.hasNext()) {
                RMap aCurrent;
                RMap rmap = aCurrent = iterator2.next();
                ids.add(rmap.getId1());
            }
            Collections.sort(ids);
            bondList.add(ids);
        }
        HashSet hs = new HashSet(bondList);
        bondList = new ArrayList(hs);
        ArrayList<List<Integer>> paths = new ArrayList<List<Integer>>();
        Iterator iterator3 = bondList.iterator();
        while (iterator3.hasNext()) {
            List aBondList1;
            List aBondList = aBondList1 = (List)iterator3.next();
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            for (Object anABondList : aBondList) {
                int bondNumber = (Integer)anABondList;
                for (IAtom atom : ac.getBond(bondNumber).atoms()) {
                    Integer atomInt = ac.indexOf(atom);
                    if (tmp.contains(atomInt)) continue;
                    tmp.add(atomInt);
                }
            }
            paths.add(tmp);
        }
        return paths;
    }
}

