/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class WeightDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private String elementName = "*";

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#weight", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("weight only expects one parameter");
        }
        if (!(params[0] instanceof String)) {
            throw new CDKException("The parameter must be of type String");
        }
        this.elementName = (String)params[0];
    }

    public Object[] getParameters() {
        Object[] params = new Object[]{this.elementName};
        return params;
    }

    public String[] getDescriptorNames() {
        String name = "w";
        name = this.elementName.equals("*") ? "MW" : name + this.elementName;
        return new String[]{name};
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
    }

    public DescriptorValue calculate(IAtomContainer container) {
        double weight = 0.0;
        if (this.elementName.equals("*")) {
            try {
                for (int i = 0; i < container.getAtomCount(); ++i) {
                    weight += Isotopes.getInstance().getMajorIsotope(container.getAtom(i).getSymbol()).getExactMass().doubleValue();
                    Integer hcount = container.getAtom(i).getImplicitHydrogenCount();
                    if (hcount == CDKConstants.UNSET) {
                        hcount = 0;
                    }
                    weight += (double)hcount.intValue() * 1.00782504;
                }
            }
            catch (Exception e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        if (this.elementName.equals("H")) {
            try {
                IIsotope h = Isotopes.getInstance().getMajorIsotope("H");
                for (int i = 0; i < container.getAtomCount(); ++i) {
                    if (container.getAtom(i).getSymbol().equals(this.elementName)) {
                        weight += Isotopes.getInstance().getMajorIsotope(container.getAtom(i).getSymbol()).getExactMass().doubleValue();
                        continue;
                    }
                    weight += (double)container.getAtom(i).getImplicitHydrogenCount().intValue() * h.getExactMass();
                }
            }
            catch (Exception e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        try {
            for (int i = 0; i < container.getAtomCount(); ++i) {
                if (!container.getAtom(i).getSymbol().equals(this.elementName)) continue;
                weight += Isotopes.getInstance().getMajorIsotope(container.getAtom(i).getSymbol()).getExactMass().doubleValue();
            }
        }
        catch (Exception e) {
            return this.getDummyDescriptorValue(e);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(weight), this.getDescriptorNames());
    }

    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResult(0.0);
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"elementSymbol"};
        return params;
    }

    public Object getParameterType(String name) {
        return "";
    }
}

