/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.chemdb;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.unijena.bioinf.ChemistryBase.chem.InChI;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.fp.CdkFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.FingerprintVersion;
import de.unijena.bioinf.ChemistryBase.ms.Deviation;
import de.unijena.bioinf.babelms.CloseableIterator;
import de.unijena.bioinf.chemdb.AbstractChemicalDatabase;
import de.unijena.bioinf.chemdb.BioFilter;
import de.unijena.bioinf.chemdb.CompoundCandidate;
import de.unijena.bioinf.chemdb.DatabaseException;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.chemdb.FormulaCandidate;
import de.unijena.bioinf.chemdb.JSONReader;
import de.unijena.bioinf.fingerid.utils.FingerIDProperties;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.json.JsonException;
import javax.json.stream.JsonParsingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTDatabase
extends AbstractChemicalDatabase {
    private static final boolean IS_USING_ECFP = false;
    private final CloseableHttpClient client;
    private static Logger logger = LoggerFactory.getLogger(RESTDatabase.class);
    protected BioFilter bioFilter;
    protected File cacheDir;
    protected URI uri;

    public static void SHUT_UP_STUPID_LOGGING() {
        java.util.logging.Logger.getLogger("org.apache.http.wire").setLevel(Level.FINEST);
        java.util.logging.Logger.getLogger("org.apache.http.headers").setLevel(Level.FINEST);
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "ERROR");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "ERROR");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.headers", "ERROR");
    }

    protected URIBuilder getFingerIdURI(String path) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(this.uri);
        if (path != null && !path.isEmpty()) {
            builder.setPath(this.uri.getPath() + path);
        } else {
            builder.setPath(this.uri.getPath());
        }
        return builder;
    }

    private static URI getDefaultHost() {
        String host = FingerIDProperties.fingeridWebHost();
        String port = FingerIDProperties.fingeridWebPort();
        if (port == null) {
            return URI.create(host + "/csi-fingerid-" + FingerIDProperties.fingeridVersion());
        }
        return URI.create(host + ":" + port + "/csi-fingerid-" + FingerIDProperties.fingeridVersion());
    }

    public static File defaultCacheDir() {
        String val = System.getenv("CSI_FINGERID_STORAGE");
        if (val != null) {
            return new File(val);
        }
        return new File(System.getProperty("user.home"), "csi_fingerid_cache");
    }

    public boolean testConnection() {
        try {
            URIBuilder builder = this.getFingerIdURI("");
            HttpURLConnection urlConn = (HttpURLConnection)builder.build().toURL().openConnection();
            urlConn.connect();
            return 200 == urlConn.getResponseCode();
        }
        catch (IOException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public RESTDatabase(File cacheDir, BioFilter bioFilter, URI host, CloseableHttpClient client) {
        this.bioFilter = bioFilter;
        this.cacheDir = cacheDir;
        this.uri = host == null ? RESTDatabase.getDefaultHost() : host;
        this.client = client;
    }

    public RESTDatabase(File cacheDir, BioFilter bioFilter, String host, CloseableHttpClient client) {
        this(cacheDir, bioFilter, URI.create(host), client);
    }

    public RESTDatabase(File cacheDir, BioFilter bioFilter, String host) {
        this(cacheDir, bioFilter, host, HttpClients.createDefault());
    }

    public RESTDatabase(File cacheDir, BioFilter bioFilter, URI host) {
        this(cacheDir, bioFilter, host, HttpClients.createDefault());
    }

    public RESTDatabase(File cacheDir, BioFilter bioFilter) {
        this(cacheDir, bioFilter, (URI)null);
    }

    public RESTDatabase(BioFilter bioFilter) {
        this(RESTDatabase.defaultCacheDir(), bioFilter, (URI)null);
    }

    public BioFilter getBioFilter() {
        return this.bioFilter;
    }

    public void setBioFilter(BioFilter bioFilter) {
        this.bioFilter = bioFilter;
    }

    public List<FormulaCandidate> lookupMolecularFormulas(double mass, Deviation deviation, PrecursorIonType ionType) throws DatabaseException {
        HttpGet get;
        try {
            URIBuilder builder = this.getFingerIdURI("/webapi/formulasdb.json/");
            builder.setParameter("mass", String.valueOf(mass));
            builder.setParameter("ppm", String.valueOf(deviation.getPpm()));
            builder.setParameter("ion", ionType.toString());
            if (this.bioFilter == BioFilter.ONLY_BIO) {
                builder.setParameter("bio", "true");
            }
            get = new HttpGet(builder.build());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ArrayList<FormulaCandidate> candidates = new ArrayList<FormulaCandidate>();
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);){
            JsonParser parser = new JsonParser();
            JsonElement elem = parser.parse((Reader)new InputStreamReader(response.getEntity().getContent(), Charset.forName("UTF-8")));
            for (Map.Entry pair : elem.getAsJsonObject().entrySet()) {
                for (Map.Entry e : ((JsonElement)pair.getValue()).getAsJsonObject().entrySet()) {
                    candidates.add(new FormulaCandidate(MolecularFormula.parse((String)((String)e.getKey())), ionType, (long)((JsonElement)e.getValue()).getAsInt()));
                }
            }
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
        return candidates;
    }

    protected FingerprintCandidate wrap(FingerprintCandidate c) {
        return c;
    }

    public List<CompoundCandidate> lookupStructuresByFormula(MolecularFormula formula) throws DatabaseException {
        ArrayList<CompoundCandidate> candidates = new ArrayList<CompoundCandidate>();
        for (CompoundCandidate c : this.lookupStructuresAndFingerprintsByFormula(formula)) {
            candidates.add(new CompoundCandidate(c));
        }
        return candidates;
    }

    private synchronized List<FingerprintCandidate> requestFormula(File output, MolecularFormula formula, BioFilter bioFilter) throws IOException {
        HttpGet get;
        try {
            String biof;
            String string = bioFilter == BioFilter.ONLY_BIO ? "bio/" : (biof = bioFilter == BioFilter.ONLY_NONBIO ? "not-bio/" : null);
            if (biof == null) {
                throw new IllegalArgumentException();
            }
            get = new HttpGet(this.getFingerIdURI("/webapi/compounds/" + biof + formula.toString() + ".json").build());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        output.getParentFile().mkdirs();
        ArrayList<FingerprintCandidate> compounds = new ArrayList<FingerprintCandidate>(100);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);
             MultiplexerFileAndIO io = new MultiplexerFileAndIO(response.getEntity().getContent(), new GZIPOutputStream(new FileOutputStream(output)));
             CloseableIterator fciter = new JSONReader().readFingerprints((FingerprintVersion)CdkFingerprintVersion.getDefault(), (Reader)new InputStreamReader(io));){
            while (fciter.hasNext()) {
                compounds.add((FingerprintCandidate)fciter.next());
            }
        }
        return compounds;
    }

    public <T extends Collection<FingerprintCandidate>> T lookupStructuresAndFingerprintsByFormula(MolecularFormula formula, T fingerprintCandidates) throws DatabaseException {
        if (this.bioFilter != BioFilter.ALL) {
            return this.lookupStructuresAndFingerprintsByFormula(formula, fingerprintCandidates, this.bioFilter);
        }
        this.lookupStructuresAndFingerprintsByFormula(formula, fingerprintCandidates, BioFilter.ONLY_BIO);
        return this.lookupStructuresAndFingerprintsByFormula(formula, fingerprintCandidates, BioFilter.ONLY_NONBIO);
    }

    protected <T extends Collection<FingerprintCandidate>> T lookupStructuresAndFingerprintsByFormula(MolecularFormula formula, T fingerprintCandidates, BioFilter bioFilter) throws DatabaseException {
        block19: {
            File stfile = new File(this.cacheDir, (bioFilter == BioFilter.ONLY_BIO ? "bio/" : (bioFilter == BioFilter.ONLY_NONBIO ? "not-bio/" : "")) + formula.toString() + ".json.gz");
            if (stfile.exists()) {
                try {
                    GZIPInputStream zin = new GZIPInputStream(new BufferedInputStream(new FileInputStream(stfile)));
                    try (CloseableIterator fciter = new JSONReader().readFingerprints((FingerprintVersion)CdkFingerprintVersion.getDefault(), (Reader)new InputStreamReader(zin));){
                        while (fciter.hasNext()) {
                            fingerprintCandidates.add((FingerprintCandidate)this.wrap((FingerprintCandidate)fciter.next()));
                        }
                        break block19;
                    }
                }
                catch (IOException | JsonException e) {
                    LoggerFactory.getLogger(RESTDatabase.class).error("Error when searching for " + formula.toString() + " in " + bioFilter.name() + "file database.");
                    throw new DatabaseException(e);
                }
            }
            try {
                for (FingerprintCandidate fc : this.requestFormula(stfile, formula, bioFilter)) {
                    fingerprintCandidates.add((FingerprintCandidate)this.wrap(fc));
                }
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        return fingerprintCandidates;
    }

    public List<FingerprintCandidate> lookupFingerprintsByInchis(Iterable<String> inchi_keys) throws DatabaseException {
        int n = Iterables.size(inchi_keys);
        ArrayList<FingerprintCandidate> compounds = new ArrayList<FingerprintCandidate>(Iterables.size(inchi_keys));
        Iterator<String> keyIter = inchi_keys.iterator();
        for (int i = 0; i < n; i += 1000) {
            try {
                HttpPost post = new HttpPost(this.getFingerIdURI("/webapi/compounds.json").build());
                StringBuilder buffer = new StringBuilder(Math.min(n - i, 1000) * 15);
                for (int k = 0; keyIter.hasNext() && k < 1000; ++k) {
                    buffer.append(keyIter.next()).append('\n');
                }
                post.setEntity((HttpEntity)new StringEntity(buffer.toString(), Charset.forName("UTF-8")));
                try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)post);){
                    try (CloseableIterator fciter = new JSONReader().readFingerprints(this.getFingerprintVersion(), (Reader)new InputStreamReader(response.getEntity().getContent()));){
                        while (fciter.hasNext()) {
                            compounds.add((FingerprintCandidate)fciter.next());
                        }
                    }
                    catch (JsonParsingException e) {
                        String line;
                        BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                        StringBuilder buf = new StringBuilder();
                        while ((line = br.readLine()) != null) {
                            buf.append(line).append('\n');
                        }
                        logger.debug(buf.toString());
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return compounds;
    }

    private FingerprintVersion getFingerprintVersion() {
        return CdkFingerprintVersion.getDefault();
    }

    public List<InChI> lookupManyInchisByInchiKeys(Iterable<String> inchi_keys) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public List<FingerprintCandidate> lookupManyFingerprintsByInchis(Iterable<String> inchi_keys) throws DatabaseException {
        return this.lookupFingerprintsByInchis(inchi_keys);
    }

    public List<FingerprintCandidate> lookupFingerprintsByInchi(Iterable<CompoundCandidate> compounds) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public void annotateCompounds(List<? extends CompoundCandidate> sublist) throws DatabaseException {
    }

    public List<InChI> findInchiByNames(List<String> names) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
    }

    public static void main(String[] args) {
        RESTDatabase rest = new RESTDatabase(BioFilter.ALL);
        System.out.println(rest.uri.getHost());
        System.out.println(rest.uri.getPath());
        rest.testConnection();
    }

    static {
        FingerIDProperties.fingeridVersion();
        RESTDatabase.SHUT_UP_STUPID_LOGGING();
    }

    private static class MultiplexerFileAndIO
    extends InputStream
    implements Closeable {
        private final byte[] buffer = new byte[524288];
        private final InputStream stream;
        private final OutputStream writer;
        private int offset;
        private int limit;
        private boolean closed = false;

        private MultiplexerFileAndIO(InputStream stream, OutputStream writer) throws IOException {
            this.stream = stream;
            this.writer = writer;
            this.offset = 0;
            this.limit = 0;
            this.fillCache();
        }

        private boolean fillCache() throws IOException {
            this.limit = this.stream.read(this.buffer, 0, this.buffer.length);
            this.offset = 0;
            if (this.limit <= 0) {
                return false;
            }
            this.writer.write(this.buffer, this.offset, this.limit);
            return true;
        }

        @Override
        public int read() throws IOException {
            if (this.offset >= this.limit && !this.fillCache()) {
                return -1;
            }
            return this.buffer[this.offset++];
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int written = 0;
            int bytesAvailable;
            while ((bytesAvailable = this.limit - this.offset) > 0 || this.fillCache()) {
                int bytesToRead = len - off;
                if (bytesToRead == 0) {
                    return written;
                }
                int bytesToWrite = Math.min(bytesAvailable, bytesToRead);
                System.arraycopy(this.buffer, this.offset, b, off, bytesToWrite);
                written += bytesToWrite;
                off += bytesToWrite;
                this.offset += bytesToWrite;
            }
            return written;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public void close() throws IOException {
            boolean finished;
            if (this.closed) {
                return;
            }
            while (finished = this.fillCache()) {
            }
            this.stream.close();
            this.writer.close();
            this.closed = true;
        }
    }
}

