/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.chemdb;

import de.unijena.bioinf.ChemistryBase.chem.InChI;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.fp.ArrayFingerprint;
import de.unijena.bioinf.ChemistryBase.fp.CdkFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.Fingerprint;
import de.unijena.bioinf.ChemistryBase.fp.FingerprintVersion;
import de.unijena.bioinf.ChemistryBase.ms.Deviation;
import de.unijena.bioinf.ChemistryBase.properties.PropertyManager;
import de.unijena.bioinf.ChemistryBase.utils.ConnectionPool;
import de.unijena.bioinf.ChemistryBase.utils.PooledConnection;
import de.unijena.bioinf.chemdb.AbstractChemicalDatabase;
import de.unijena.bioinf.chemdb.BioFilter;
import de.unijena.bioinf.chemdb.CompoundCandidate;
import de.unijena.bioinf.chemdb.DBLink;
import de.unijena.bioinf.chemdb.DatabaseException;
import de.unijena.bioinf.chemdb.DatasourceService;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.chemdb.FormulaCandidate;
import de.unijena.bioinf.fingerid.utils.FingerIDProperties;
import gnu.trove.list.array.TShortArrayList;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChemicalDatabase
extends AbstractChemicalDatabase
implements Cloneable {
    private static final int DEFAULT_SQL_CAPACITY = 5;
    protected static final Logger log = LoggerFactory.getLogger(ChemicalDatabase.class);
    protected ConnectionPool<Connection> connection;
    protected String host;
    protected String username;
    protected String password;
    protected BioFilter bioFilter = BioFilter.ALL;

    public ChemicalDatabase() throws DatabaseException {
        this.setup();
        this.connection = new ConnectionPool((ConnectionPool.Connection)new SqlConnector(this.host, this.username, this.password), 5);
    }

    protected ChemicalDatabase(ChemicalDatabase db) {
        this.connection = db.connection.newSharedConnectionPool();
        this.host = db.host;
        this.username = db.username;
        this.password = db.password;
    }

    public ChemicalDatabase clone() {
        return new ChemicalDatabase(this);
    }

    private void setup() {
        if (this.host == null) {
            this.host = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.fingerid.chemical_db.host");
        }
        if (this.username == null) {
            this.username = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.fingerid.chemical_db.username");
        }
        if (this.password == null) {
            this.password = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.fingerid.chemical_db.password");
        }
    }

    public ChemicalDatabase(String host, String username, String password) throws DatabaseException {
        this.host = host;
        this.username = username;
        this.password = password;
        this.setup();
        this.connection = new ConnectionPool((ConnectionPool.Connection)new SqlConnector(this.host, this.username, this.password), 5);
    }

    public BioFilter getBioFilter() {
        return this.bioFilter;
    }

    public void setBioFilter(BioFilter bioFilter) {
        this.bioFilter = bioFilter;
    }

    public List<FormulaCandidate> lookupMolecularFormulas(double mass, Deviation deviation, PrecursorIonType ionType) throws DatabaseException {
        ArrayList<FormulaCandidate> xs = new ArrayList<FormulaCandidate>();
        try (PooledConnection c = this.connection.orderConnection();
             PreparedStatement statement = ((Connection)c.connection).prepareStatement("SELECT formula, flags FROM formulas WHERE exactmass >= ? AND exactmass <= ?");){
            xs.addAll(this.lookupFormulaWithIon(statement, mass, deviation, ionType));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new ArrayList<FormulaCandidate>();
        }
        catch (IOException | SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        return xs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getFlagsByFormula(MolecularFormula formula) throws DatabaseException {
        try (PooledConnection c = this.connection.orderConnection();
             PreparedStatement statement = ((Connection)c.connection).prepareStatement("SELECT flags FROM formulas WHERE formula = ?");){
            statement.setString(1, formula.toString());
            try (ResultSet set = statement.executeQuery();){
                if (!set.next()) return 0L;
                long l = set.getLong(1);
                return l;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return 0L;
        }
        catch (IOException | SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public List<List<FormulaCandidate>> lookupMolecularFormulas(double mass, Deviation deviation, PrecursorIonType[] ionTypes) throws DatabaseException {
        ArrayList<List<FormulaCandidate>> xs = new ArrayList<List<FormulaCandidate>>();
        try (PooledConnection c = this.connection.orderConnection();){
            PreparedStatement statement = ((Connection)c.connection).prepareStatement("SELECT formula, flags FROM formulas WHERE exactmass >= ? AND exactmass <= ?");
            for (PrecursorIonType ionType : ionTypes) {
                try {
                    xs.add(this.lookupFormulaWithIon(statement, mass, deviation, ionType));
                }
                catch (DatabaseException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new ArrayList<List<FormulaCandidate>>();
        }
        catch (IOException | SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        return xs;
    }

    private List<FormulaCandidate> lookupFormulaWithIon(PreparedStatement statement, double mass, Deviation deviation, PrecursorIonType ionType) throws DatabaseException, SQLException {
        if (ionType.isIntrinsicalCharged()) {
            List<FormulaCandidate> protonated = this.lookupFormulaWithIonIntrinsicalChargedAreConsidered(statement, mass, deviation, ionType.getCharge() > 0 ? PrecursorIonType.getPrecursorIonType((String)"[M+H]+") : PrecursorIonType.getPrecursorIonType((String)"[M-H]-"));
            List<FormulaCandidate> intrinsical = this.lookupFormulaWithIonIntrinsicalChargedAreConsidered(statement, mass, deviation, ionType);
            HashMap<MolecularFormula, FormulaCandidate> map = new HashMap<MolecularFormula, FormulaCandidate>();
            for (FormulaCandidate fc : intrinsical) {
                map.put(fc.formula, fc);
            }
            MolecularFormula hydrogen = MolecularFormula.parse((String)"H");
            for (FormulaCandidate fc : protonated) {
                MolecularFormula intrinsic = ionType.getCharge() > 0 ? fc.formula.subtract(hydrogen) : fc.formula.add(hydrogen);
                map.put(intrinsic, new FormulaCandidate(intrinsic, ionType, fc.bitset));
            }
            return new ArrayList<FormulaCandidate>(map.values());
        }
        return this.lookupFormulaWithIonIntrinsicalChargedAreConsidered(statement, mass, deviation, ionType);
    }

    private List<FormulaCandidate> lookupFormulaWithIonIntrinsicalChargedAreConsidered(PreparedStatement statement, double mass, Deviation deviation, PrecursorIonType ionType) throws DatabaseException, SQLException {
        double delta = deviation.absoluteFor(mass);
        double neutralMass = ionType.precursorMassToNeutralMass(mass);
        double minmz = neutralMass - delta;
        double maxmz = neutralMass + delta;
        ArrayList<FormulaCandidate> list = new ArrayList<FormulaCandidate>();
        statement.setDouble(1, minmz);
        statement.setDouble(2, maxmz);
        try (ResultSet set = statement.executeQuery();){
            while (set.next()) {
                boolean isPubchemOnly;
                long flag = set.getLong(2);
                boolean bl = isPubchemOnly = !DatasourceService.isBio((long)flag);
                if (this.bioFilter == BioFilter.ONLY_BIO && isPubchemOnly || this.bioFilter == BioFilter.ONLY_NONBIO && !isPubchemOnly) continue;
                FormulaCandidate fc = new FormulaCandidate(MolecularFormula.parse((String)set.getString(1)), ionType, set.getLong(2));
                list.add(fc);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<CompoundCandidate> lookupStructuresByFormula(MolecularFormula formula) throws DatabaseException {
        try (PooledConnection c = this.connection.orderConnection();){
            List<CompoundCandidate> list = this.lookupStructuresByFormula(formula, (PooledConnection<Connection>)c);
            return list;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new ArrayList<CompoundCandidate>();
        }
        catch (IOException | SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    private List<CompoundCandidate> lookupStructuresByFormula(MolecularFormula formula, PooledConnection<Connection> c) throws SQLException {
        PreparedStatement statement;
        boolean enforceBio;
        boolean bl = enforceBio = this.bioFilter == BioFilter.ONLY_BIO;
        if (enforceBio) {
            long bioflag = DatasourceService.BIOFLAG;
            statement = ((Connection)c.connection).prepareStatement("SELECT inchi_key_1, inchi, name, smiles, flags, p_layer, q_layer, xlogp FROM structures WHERE formula = ? AND (flags & " + bioflag + " ) != 0");
        } else {
            statement = ((Connection)c.connection).prepareStatement("SELECT inchi_key_1, inchi, name, smiles, flags, p_layer, q_layer, xlogp FROM structures WHERE formula = ?");
        }
        statement.setString(1, formula.toString());
        ArrayList<CompoundCandidate> candidates = new ArrayList<CompoundCandidate>();
        try (ResultSet set = statement.executeQuery();){
            while (set.next()) {
                CompoundCandidate candidate = new CompoundCandidate(new InChI(set.getString(1), set.getString(2)));
                candidate.setName(set.getString(3));
                candidate.setSmiles(set.getString(4));
                candidate.setBitset(set.getLong(5));
                candidate.setpLayer(set.getInt(6));
                candidate.setqLayer(set.getInt(7));
                candidate.setXlogp(set.getDouble(8));
                candidates.add(candidate);
            }
        }
        return candidates;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Collection<FingerprintCandidate>> T lookupStructuresAndFingerprintsByFormula(MolecularFormula formula, T fingerprintCandidates) throws DatabaseException {
        try (PooledConnection c = this.connection.orderConnection();){
            List<CompoundCandidate> candidates = this.lookupStructuresByFormula(formula, (PooledConnection<Connection>)c);
            HashMap<String, CompoundCandidate> hashMap = new HashMap<String, CompoundCandidate>(candidates.size());
            for (CompoundCandidate candidate : candidates) {
                hashMap.put(candidate.getInchiKey2D(), candidate);
            }
            try (PreparedStatement statement = ((Connection)c.connection).prepareStatement("SELECT inchi_key_1, fingerprint FROM fingerprints WHERE fp_id = 1 AND formula = ?");){
                statement.setString(1, formula.toString());
                try (ResultSet r = statement.executeQuery();){
                    while (r.next()) {
                        String inchikey = r.getString(1);
                        CompoundCandidate compoundCandidate = (CompoundCandidate)hashMap.get(inchikey);
                        if (compoundCandidate == null) continue;
                        Fingerprint fingerprint = this.parseFingerprint(r, 2);
                        fingerprintCandidates.add((FingerprintCandidate)new FingerprintCandidate(compoundCandidate, fingerprint));
                    }
                }
            }
            Iterator<Object> iterator = fingerprintCandidates;
            return (T)iterator;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return fingerprintCandidates;
        }
        catch (IOException | SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<FingerprintCandidate> lookupFingerprintsByInchis(Iterable<String> inchi_keys) throws DatabaseException {
        ArrayList<FingerprintCandidate> candidates = new ArrayList<FingerprintCandidate>();
        try (PooledConnection c = this.connection.orderConnection();){
            try (PreparedStatement statement = ((Connection)c.connection).prepareStatement("SELECT s.inchi_key_1, s.inchi, s.name, s.smiles, s.flags, s.p_layer, s.q_layer, s.xlogp, f.fingerprint FROM structures as s, fingerprints as f WHERE f.fp_id = 1 AND s.inchi_key_1 = ? AND f.inchi_key_1 = s.inchi_key_1");){
                for (String inchikey : inchi_keys) {
                    statement.setString(1, inchikey);
                    ResultSet set = statement.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        if (!set.next()) continue;
                        FingerprintCandidate candidate = new FingerprintCandidate(new InChI(set.getString(1), set.getString(2)), this.parseFingerprint(set, 9));
                        candidate.setName(set.getString(3));
                        candidate.setSmiles(set.getString(4));
                        candidate.setBitset(set.getLong(5));
                        candidate.setpLayer(set.getInt(6));
                        candidate.setqLayer(set.getInt(7));
                        candidate.setXlogp(set.getDouble(8));
                        candidates.add(candidate);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (set == null) continue;
                        if (throwable2 != null) {
                            try {
                                set.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        set.close();
                    }
                }
            }
            ArrayList<FingerprintCandidate> arrayList = candidates;
            return arrayList;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return candidates;
        }
        catch (IOException | SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<InChI> lookupManyInchisByInchiKeys(Iterable<String> inchi_keys) throws DatabaseException {
        ArrayList<InChI> candidates = new ArrayList<InChI>();
        try (PooledConnection c = this.connection.orderConnection();){
            try (PreparedStatement statement = ((Connection)c.connection).prepareStatement("SELECT inchi_key_1, inchi FROM structures WHERE s.inchi_key_1 = ?");){
                for (String inchikey : inchi_keys) {
                    statement.setString(1, inchikey);
                    ResultSet set = statement.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        if (!set.next()) continue;
                        candidates.add(new InChI(set.getString(1), set.getString(2)));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (set == null) continue;
                        if (throwable2 != null) {
                            try {
                                set.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        set.close();
                    }
                }
            }
            ArrayList<InChI> arrayList = candidates;
            return arrayList;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return candidates;
        }
        catch (IOException | SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public List<FingerprintCandidate> lookupManyFingerprintsByInchis(Iterable<String> inchi_keys) throws DatabaseException {
        return this.lookupFingerprintsByInchis(inchi_keys);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<FingerprintCandidate> lookupFingerprintsByInchi(Iterable<CompoundCandidate> compounds) throws DatabaseException {
        ArrayList<FingerprintCandidate> candidates = new ArrayList<FingerprintCandidate>();
        try (PooledConnection c = this.connection.orderConnection();){
            try (PreparedStatement statement = ((Connection)c.connection).prepareStatement("SELECT fingerprint FROM fingerprints WHERE fp_id = 1 AND inchi_key_1 = ?");){
                for (CompoundCandidate candidate : compounds) {
                    statement.setString(1, candidate.getInchiKey2D());
                    ResultSet set = statement.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        if (!set.next()) continue;
                        candidates.add(new FingerprintCandidate(candidate, this.parseFingerprint(set, 1)));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (set == null) continue;
                        if (throwable2 != null) {
                            try {
                                set.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        set.close();
                    }
                }
            }
            ArrayList<FingerprintCandidate> arrayList = candidates;
            return arrayList;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return candidates;
        }
        catch (IOException | SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void annotateCompounds(List<? extends CompoundCandidate> sublist) throws DatabaseException {
        try (PooledConnection c = this.connection.orderConnection();){
            void var9_15;
            DatasourceService.Sources[] sources = DatasourceService.Sources.values();
            PreparedStatement[] statements = new PreparedStatement[sources.length];
            int k = 0;
            DatasourceService.Sources[] sourcesArray = sources;
            int n = sourcesArray.length;
            boolean bl = false;
            while (var9_15 < n) {
                DatasourceService.Sources source = sourcesArray[var9_15];
                statements[k++] = source.sqlQuery == null ? null : ((Connection)c.connection).prepareStatement(source.sqlQuery);
                ++var9_15;
            }
            ArrayList<DBLink> buffer = new ArrayList<DBLink>();
            for (CompoundCandidate compoundCandidate : sublist) {
                for (int i = 0; i < sources.length; ++i) {
                    PreparedStatement statement;
                    DatasourceService.Sources source = sources[i];
                    if (source != DatasourceService.Sources.PUBCHEM && (compoundCandidate.getBitset() & source.flag) == 0L || (statement = statements[i]) == null) continue;
                    statement.setString(1, compoundCandidate.getInchiKey2D());
                    try (ResultSet set = statement.executeQuery();){
                        while (set.next()) {
                            buffer.add(new DBLink(source.name, set.getString(1)));
                        }
                        continue;
                    }
                }
                compoundCandidate.setLinks(buffer.toArray(new DBLink[buffer.size()]));
                buffer.clear();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException | SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public List<InChI> findInchiByNames(List<String> names) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void close() throws IOException {
        this.connection.close();
    }

    public void refresh() throws DatabaseException {
        try {
            this.connection.closeAllIdlingConnections();
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public PooledConnection<Connection> getConnection() throws IOException, InterruptedException {
        return this.connection.orderConnection();
    }

    private Fingerprint parseFingerprint(ResultSet result, int index) throws SQLException {
        try (ResultSet fp = result.getArray(index).getResultSet();){
            Fingerprint fingerprint = this.parseFingerprint(fp);
            return fingerprint;
        }
    }

    private Fingerprint parseFingerprint(ResultSet fp) throws SQLException {
        TShortArrayList shorts = new TShortArrayList();
        while (fp.next()) {
            short s = fp.getShort(2);
            shorts.add(s);
        }
        return new ArrayFingerprint((FingerprintVersion)CdkFingerprintVersion.getComplete(), shorts.toArray());
    }

    static {
        FingerIDProperties.fingeridVersion();
    }

    protected static class SqlConnector
    implements ConnectionPool.Connection<Connection> {
        private String host;
        private String username;
        private String password;

        public SqlConnector(String host, String username, String password) {
            this.host = host;
            this.username = username;
            this.password = password;
        }

        public Connection open() throws IOException {
            try {
                return DriverManager.getConnection("jdbc:postgresql://" + this.host + "/pubchem", this.username, this.password);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        public void close(Connection connection) throws IOException {
            try {
                connection.close();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }
}

