/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.chemdb;

import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.ms.Deviation;
import de.unijena.bioinf.chemdb.ChemicalDatabase;
import de.unijena.bioinf.chemdb.DatabaseException;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.chemdb.FormulaCandidate;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Main {
    public static void main(String ... args) throws DatabaseException, IOException {
        ChemicalDatabase chemicalDatabase = new ChemicalDatabase();
        int i = 0;
        Deviation dev = new Deviation(10.0);
        PrecursorIonType ionType = PrecursorIonType.getPrecursorIonType((String)"[M+H]+");
        while (++i <= 10) {
            double mass = Math.random() * 500.0 + 100.0;
            List<FormulaCandidate> formulas = chemicalDatabase.lookupMolecularFormulas(mass, dev, ionType);
            if (formulas.size() <= 0) continue;
            System.out.println(formulas.get((int)0).formula);
            List list = chemicalDatabase.lookupStructuresAndFingerprintsByFormula(formulas.get((int)0).formula);
        }
        List<FingerprintCandidate> fp = chemicalDatabase.lookupFingerprintsByInchis(Collections.singleton("UKQHHPFOVDGOPK"));
        System.out.println(Arrays.toString(fp.get((int)0).fingerprint.toIndizesArray()));
        chemicalDatabase.close();
    }
}

