/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixIterator;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrix;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.data.SingularMatrixException;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.MatrixFeatures_FDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.NormOps_FDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.dense.row.SpecializedOps_FDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_FDRM;
import org.ejml.equation.Equation;
import org.ejml.ops.MatrixIO;
import org.ejml.simple.SimpleEVD;
import org.ejml.simple.SimpleMatrix;
import org.ejml.simple.SimpleSVD;

public abstract class SimpleBase<T extends SimpleBase>
implements Serializable {
    static final long serialVersionUID = 2342556642L;
    protected Matrix mat;

    public SimpleBase(int numRows, int numCols) {
        this.mat = new DMatrixRMaj(numRows, numCols);
    }

    protected SimpleBase() {
    }

    protected abstract T createMatrix(int var1, int var2);

    public <T extends Matrix> T getMatrix() {
        return (T)this.mat;
    }

    public DMatrixRMaj matrix_F64() {
        return (DMatrixRMaj)this.mat;
    }

    public FMatrixRMaj matrix_F32() {
        return (FMatrixRMaj)this.mat;
    }

    public T transpose() {
        T ret = this.createMatrix(this.mat.getNumCols(), this.mat.getNumRows());
        if (this.bits() == 64) {
            CommonOps_DDRM.transpose((DMatrixRMaj)((DMatrixRMaj)this.mat), (DMatrixRMaj)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            CommonOps_FDRM.transpose((FMatrixRMaj)((FMatrixRMaj)this.mat), (FMatrixRMaj)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T mult(T b) {
        T ret = this.createMatrix(this.mat.getNumRows(), ((SimpleBase)b).getMatrix().getNumCols());
        if (this.bits() == 64) {
            CommonOps_DDRM.mult((DMatrix1Row)((DMatrixRMaj)this.mat), (DMatrix1Row)((DMatrixRMaj)((SimpleBase)b).getMatrix()), (DMatrix1Row)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            CommonOps_FDRM.mult((FMatrix1Row)((FMatrixRMaj)this.mat), (FMatrix1Row)((FMatrixRMaj)((SimpleBase)b).getMatrix()), (FMatrix1Row)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T kron(T B) {
        T ret = this.createMatrix(this.mat.getNumRows() * ((SimpleBase)B).numRows(), this.mat.getNumCols() * ((SimpleBase)B).numCols());
        if (this.bits() == 64) {
            CommonOps_DDRM.kron((DMatrixRMaj)((DMatrixRMaj)this.mat), (DMatrixRMaj)((DMatrixRMaj)((SimpleBase)B).getMatrix()), (DMatrixRMaj)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            CommonOps_FDRM.kron((FMatrixRMaj)((FMatrixRMaj)this.mat), (FMatrixRMaj)((FMatrixRMaj)((SimpleBase)B).getMatrix()), (FMatrixRMaj)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T plus(T b) {
        T ret = this.copy();
        if (this.bits() == 64) {
            CommonOps_DDRM.addEquals((DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()), (DMatrixD1)((DMatrixRMaj)((SimpleBase)b).getMatrix()));
        } else {
            CommonOps_FDRM.addEquals((FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()), (FMatrixD1)((FMatrixRMaj)((SimpleBase)b).getMatrix()));
        }
        return ret;
    }

    public T minus(T b) {
        T ret = this.copy();
        if (this.bits() == 64) {
            CommonOps_DDRM.subtract((DMatrixD1)((DMatrixRMaj)this.getMatrix()), (DMatrixD1)((DMatrixRMaj)((SimpleBase)b).getMatrix()), (DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            CommonOps_FDRM.subtract((FMatrixD1)((FMatrixRMaj)this.getMatrix()), (FMatrixD1)((FMatrixRMaj)((SimpleBase)b).getMatrix()), (FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T minus(double b) {
        T ret = this.copy();
        if (this.bits() == 64) {
            CommonOps_DDRM.subtract((DMatrixD1)((DMatrixRMaj)this.getMatrix()), (double)b, (DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            CommonOps_FDRM.subtract((FMatrixD1)((FMatrixRMaj)this.getMatrix()), (float)((float)b), (FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T plus(double b) {
        T ret = this.createMatrix(this.numRows(), this.numCols());
        if (this.bits() == 64) {
            CommonOps_DDRM.add((DMatrixD1)((DMatrixRMaj)this.getMatrix()), (double)b, (DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            CommonOps_FDRM.add((FMatrixD1)((FMatrixRMaj)this.getMatrix()), (float)((float)b), (FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T plus(double beta, T b) {
        T ret = this.copy();
        if (this.bits() == 64) {
            CommonOps_DDRM.addEquals((DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()), (double)beta, (DMatrixD1)((DMatrixRMaj)((SimpleBase)b).getMatrix()));
        } else {
            CommonOps_FDRM.addEquals((FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()), (float)((float)beta), (FMatrixD1)((FMatrixRMaj)((SimpleBase)b).getMatrix()));
        }
        return ret;
    }

    public double dot(T v) {
        if (!this.isVector()) {
            throw new IllegalArgumentException("'this' matrix is not a vector.");
        }
        if (!((SimpleBase)v).isVector()) {
            throw new IllegalArgumentException("'v' matrix is not a vector.");
        }
        if (this.bits() == 64) {
            return VectorVectorMult_DDRM.innerProd((DMatrixD1)((DMatrixRMaj)this.mat), (DMatrixD1)((DMatrixRMaj)((SimpleBase)v).getMatrix()));
        }
        return VectorVectorMult_FDRM.innerProd((FMatrixD1)((FMatrixRMaj)this.mat), (FMatrixD1)((FMatrixRMaj)((SimpleBase)v).getMatrix()));
    }

    public boolean isVector() {
        return this.mat.getNumRows() == 1 || this.mat.getNumCols() == 1;
    }

    public T scale(double val) {
        T ret = this.copy();
        if (this.bits() == 64) {
            CommonOps_DDRM.scale((double)val, (DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            CommonOps_FDRM.scale((float)((float)val), (FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T divide(double val) {
        T ret = this.copy();
        if (this.bits() == 64) {
            CommonOps_DDRM.divide((DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()), (double)val);
        } else {
            CommonOps_FDRM.divide((FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()), (float)((float)val));
        }
        return ret;
    }

    public T invert() {
        T ret = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols());
        if (this.bits() == 64) {
            if (!CommonOps_DDRM.invert((DMatrixRMaj)((DMatrixRMaj)this.mat), (DMatrixRMaj)((DMatrixRMaj)((SimpleBase)ret).getMatrix()))) {
                throw new SingularMatrixException();
            }
            if (MatrixFeatures_DDRM.hasUncountable((DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()))) {
                throw new SingularMatrixException("Solution has uncountable numbers");
            }
        } else {
            if (!CommonOps_FDRM.invert((FMatrixRMaj)((FMatrixRMaj)this.mat), (FMatrixRMaj)((FMatrixRMaj)((SimpleBase)ret).getMatrix()))) {
                throw new SingularMatrixException();
            }
            if (MatrixFeatures_FDRM.hasUncountable((FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()))) {
                throw new SingularMatrixException("Solution has uncountable numbers");
            }
        }
        return ret;
    }

    public T pseudoInverse() {
        T ret = this.createMatrix(this.mat.getNumCols(), this.mat.getNumRows());
        if (this.bits() == 64) {
            CommonOps_DDRM.pinv((DMatrixRMaj)((DMatrixRMaj)this.mat), (DMatrixRMaj)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            CommonOps_FDRM.pinv((FMatrixRMaj)((FMatrixRMaj)this.mat), (FMatrixRMaj)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T solve(T b) {
        T x = this.createMatrix(this.mat.getNumCols(), ((SimpleBase)b).getMatrix().getNumCols());
        if (this.bits() == 64) {
            if (!CommonOps_DDRM.solve((DMatrixRMaj)((DMatrixRMaj)this.mat), (DMatrixRMaj)((DMatrixRMaj)((SimpleBase)b).getMatrix()), (DMatrixRMaj)((DMatrixRMaj)((SimpleBase)x).getMatrix()))) {
                throw new SingularMatrixException();
            }
            if (MatrixFeatures_DDRM.hasUncountable((DMatrixD1)((DMatrixRMaj)((SimpleBase)x).getMatrix()))) {
                throw new SingularMatrixException("Solution contains uncountable numbers");
            }
        } else {
            if (!CommonOps_FDRM.solve((FMatrixRMaj)((FMatrixRMaj)this.mat), (FMatrixRMaj)((FMatrixRMaj)((SimpleBase)b).getMatrix()), (FMatrixRMaj)((FMatrixRMaj)((SimpleBase)x).getMatrix()))) {
                throw new SingularMatrixException();
            }
            if (MatrixFeatures_FDRM.hasUncountable((FMatrixD1)((FMatrixRMaj)((SimpleBase)x).getMatrix()))) {
                throw new SingularMatrixException("Solution contains uncountable numbers");
            }
        }
        return x;
    }

    public void set(T a) {
        this.mat.set(((SimpleBase)a).getMatrix());
    }

    public void set(double val) {
        if (this.bits() == 64) {
            CommonOps_DDRM.fill((DMatrixD1)((DMatrixRMaj)this.mat), (double)val);
        } else {
            CommonOps_FDRM.fill((FMatrixD1)((FMatrixRMaj)this.mat), (float)((float)val));
        }
    }

    public void zero() {
        if (this.bits() == 64) {
            ((DMatrixRMaj)this.mat).zero();
        } else {
            ((FMatrixRMaj)this.mat).zero();
        }
    }

    public double normF() {
        if (this.bits() == 64) {
            return NormOps_DDRM.normF((DMatrixD1)((DMatrixRMaj)this.mat));
        }
        return NormOps_FDRM.normF((FMatrixD1)((FMatrixRMaj)this.mat));
    }

    public double conditionP2() {
        if (this.bits() == 64) {
            return NormOps_DDRM.conditionP2((DMatrixRMaj)((DMatrixRMaj)this.mat));
        }
        return NormOps_FDRM.conditionP2((FMatrixRMaj)((FMatrixRMaj)this.mat));
    }

    public double determinant() {
        if (this.bits() == 64) {
            double ret = CommonOps_DDRM.det((DMatrixRMaj)((DMatrixRMaj)this.mat));
            if (UtilEjml.isUncountable((double)ret)) {
                return 0.0;
            }
            return ret;
        }
        double ret = CommonOps_FDRM.det((FMatrixRMaj)((FMatrixRMaj)this.mat));
        if (UtilEjml.isUncountable((double)ret)) {
            return 0.0;
        }
        return ret;
    }

    public double trace() {
        if (this.bits() == 64) {
            return CommonOps_DDRM.trace((DMatrix1Row)((DMatrixRMaj)this.mat));
        }
        return CommonOps_FDRM.trace((FMatrix1Row)((FMatrixRMaj)this.mat));
    }

    public void reshape(int numRows, int numCols) {
        if (this.bits() == 64) {
            ((DMatrixRMaj)this.mat).reshape(numRows, numCols, false);
        } else {
            ((FMatrixRMaj)this.mat).reshape(numRows, numCols, false);
        }
    }

    public void set(int row, int col, double value) {
        if (this.bits() == 64) {
            ((DMatrixRMaj)this.mat).set(row, col, value);
        } else {
            ((FMatrixRMaj)this.mat).set(row, col, (float)value);
        }
    }

    public void set(int index, double value) {
        if (this.bits() == 64) {
            ((DMatrixRMaj)this.mat).set(index, value);
        } else {
            ((FMatrixRMaj)this.mat).set(index, (float)value);
        }
    }

    public void setRow(int row, int offset, double ... values) {
        if (this.bits() == 64) {
            DMatrixRMaj m = (DMatrixRMaj)this.mat;
            for (int i = 0; i < values.length; ++i) {
                m.set(row, offset + i, values[i]);
            }
        } else {
            FMatrixRMaj m = (FMatrixRMaj)this.mat;
            for (int i = 0; i < values.length; ++i) {
                m.set(row, offset + i, (float)values[i]);
            }
        }
    }

    public void setColumn(int column, int offset, double ... values) {
        if (this.bits() == 64) {
            DMatrixRMaj m = (DMatrixRMaj)this.mat;
            for (int i = 0; i < values.length; ++i) {
                m.set(offset + i, column, values[i]);
            }
        } else {
            FMatrixRMaj m = (FMatrixRMaj)this.mat;
            for (int i = 0; i < values.length; ++i) {
                m.set(offset + i, column, (float)values[i]);
            }
        }
    }

    public double get(int row, int col) {
        if (this.bits() == 64) {
            return ((DMatrixRMaj)this.mat).get(row, col);
        }
        return ((FMatrixRMaj)this.mat).get(row, col);
    }

    public double get(int index) {
        if (this.bits() == 64) {
            return ((DMatrixRMaj)this.mat).data[index];
        }
        return ((FMatrixRMaj)this.mat).data[index];
    }

    public int getIndex(int row, int col) {
        return row * this.mat.getNumCols() + col;
    }

    public DMatrixIterator iterator(boolean rowMajor, int minRow, int minCol, int maxRow, int maxCol) {
        return new DMatrixIterator((DMatrixD1)((DMatrixRMaj)this.mat), rowMajor, minRow, minCol, maxRow, maxCol);
    }

    public T copy() {
        T ret = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols());
        ((SimpleBase)ret).getMatrix().set(this.getMatrix());
        return ret;
    }

    public int numRows() {
        return this.mat.getNumRows();
    }

    public int numCols() {
        return this.mat.getNumCols();
    }

    public int getNumElements() {
        if (this.bits() == 64) {
            return ((DMatrixRMaj)this.mat).getNumElements();
        }
        return ((FMatrixRMaj)this.mat).getNumElements();
    }

    public void print() {
        if (this.bits() == 64) {
            MatrixIO.print((PrintStream)System.out, (DMatrix)((DMatrixRMaj)this.mat));
        } else {
            MatrixIO.print((PrintStream)System.out, (FMatrix)((FMatrixRMaj)this.mat));
        }
    }

    public void print(int numChar, int precision) {
        if (this.bits() == 64) {
            MatrixIO.print((PrintStream)System.out, (DMatrix)((DMatrixRMaj)this.mat), (int)numChar, (int)precision);
        } else {
            MatrixIO.print((PrintStream)System.out, (FMatrix)((FMatrixRMaj)this.mat), (int)numChar, (int)precision);
        }
    }

    public void print(String format) {
        if (this.bits() == 64) {
            MatrixIO.print((PrintStream)System.out, (DMatrix)((DMatrixRMaj)this.mat), (String)format);
        } else {
            MatrixIO.print((PrintStream)System.out, (FMatrix)((FMatrixRMaj)this.mat), (String)format);
        }
    }

    public String toString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (this.bits() == 64) {
            MatrixIO.print((PrintStream)new PrintStream(stream), (DMatrix)((DMatrixRMaj)this.mat));
        } else {
            MatrixIO.print((PrintStream)new PrintStream(stream), (FMatrix)((FMatrixRMaj)this.mat));
        }
        return stream.toString();
    }

    public T extractMatrix(int y0, int y1, int x0, int x1) {
        if (y0 == Integer.MAX_VALUE) {
            y0 = this.mat.getNumRows();
        }
        if (y1 == Integer.MAX_VALUE) {
            y1 = this.mat.getNumRows();
        }
        if (x0 == Integer.MAX_VALUE) {
            x0 = this.mat.getNumCols();
        }
        if (x1 == Integer.MAX_VALUE) {
            x1 = this.mat.getNumCols();
        }
        T ret = this.createMatrix(y1 - y0, x1 - x0);
        if (this.bits() == 64) {
            CommonOps_DDRM.extract((DMatrix)((DMatrixRMaj)this.mat), (int)y0, (int)y1, (int)x0, (int)x1, (DMatrix)((DMatrixRMaj)((SimpleBase)ret).getMatrix()), (int)0, (int)0);
        } else {
            CommonOps_FDRM.extract((FMatrix)((FMatrixRMaj)this.mat), (int)y0, (int)y1, (int)x0, (int)x1, (FMatrix)((FMatrixRMaj)((SimpleBase)ret).getMatrix()), (int)0, (int)0);
        }
        return ret;
    }

    public T extractVector(boolean extractRow, int element) {
        T ret;
        int length = extractRow ? this.mat.getNumCols() : this.mat.getNumRows();
        T t = ret = extractRow ? this.createMatrix(1, length) : this.createMatrix(length, 1);
        if (this.bits() == 64) {
            if (extractRow) {
                SpecializedOps_DDRM.subvector((DMatrix1Row)((DMatrixRMaj)this.mat), (int)element, (int)0, (int)length, (boolean)true, (int)0, (DMatrix1Row)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
            } else {
                SpecializedOps_DDRM.subvector((DMatrix1Row)((DMatrixRMaj)this.mat), (int)0, (int)element, (int)length, (boolean)false, (int)0, (DMatrix1Row)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
            }
        } else if (extractRow) {
            SpecializedOps_FDRM.subvector((FMatrix1Row)((FMatrixRMaj)this.mat), (int)element, (int)0, (int)length, (boolean)true, (int)0, (FMatrix1Row)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            SpecializedOps_FDRM.subvector((FMatrix1Row)((FMatrixRMaj)this.mat), (int)0, (int)element, (int)length, (boolean)false, (int)0, (FMatrix1Row)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T diag() {
        T diag;
        if (this.bits() == 64) {
            if (MatrixFeatures_DDRM.isVector((Matrix)this.mat)) {
                int N = Math.max(this.mat.getNumCols(), this.mat.getNumRows());
                diag = this.createMatrix(N, N);
                CommonOps_DDRM.diag((DMatrixRMaj)((DMatrixRMaj)((SimpleBase)diag).getMatrix()), (int)N, (double[])((DMatrixRMaj)this.mat).data);
            } else {
                int N = Math.min(this.mat.getNumCols(), this.mat.getNumRows());
                diag = this.createMatrix(N, 1);
                CommonOps_DDRM.extractDiag((DMatrixRMaj)((DMatrixRMaj)this.mat), (DMatrixRMaj)((DMatrixRMaj)((SimpleBase)diag).getMatrix()));
            }
        } else if (MatrixFeatures_FDRM.isVector((Matrix)this.mat)) {
            int N = Math.max(this.mat.getNumCols(), this.mat.getNumRows());
            diag = this.createMatrix(N, N);
            CommonOps_FDRM.diag((FMatrixRMaj)((FMatrixRMaj)((SimpleBase)diag).getMatrix()), (int)N, (float[])((FMatrixRMaj)this.mat).data);
        } else {
            int N = Math.min(this.mat.getNumCols(), this.mat.getNumRows());
            diag = this.createMatrix(N, 1);
            CommonOps_FDRM.extractDiag((FMatrixRMaj)((FMatrixRMaj)this.mat), (FMatrixRMaj)((FMatrixRMaj)((SimpleBase)diag).getMatrix()));
        }
        return diag;
    }

    public boolean isIdentical(T a, double tol) {
        if (this.bits() == 64) {
            return MatrixFeatures_DDRM.isIdentical((DMatrixD1)((DMatrixRMaj)this.mat), (DMatrixD1)((DMatrixRMaj)((SimpleBase)a).getMatrix()), (double)tol);
        }
        return MatrixFeatures_FDRM.isIdentical((FMatrixD1)((FMatrixRMaj)this.mat), (FMatrixD1)((FMatrixRMaj)((SimpleBase)a).getMatrix()), (float)((float)tol));
    }

    public boolean hasUncountable() {
        if (this.bits() == 64) {
            return MatrixFeatures_DDRM.hasUncountable((DMatrixD1)((DMatrixRMaj)this.mat));
        }
        return MatrixFeatures_FDRM.hasUncountable((FMatrixD1)((FMatrixRMaj)this.mat));
    }

    public SimpleSVD<T> svd() {
        return new SimpleSVD(this.mat, false);
    }

    public SimpleSVD<T> svd(boolean compact) {
        return new SimpleSVD(this.mat, compact);
    }

    public SimpleEVD<T> eig() {
        return new SimpleEVD(this.mat);
    }

    public void insertIntoThis(int insertRow, int insertCol, T B) {
        if (this.bits() == 64) {
            CommonOps_DDRM.insert((DMatrix)((DMatrixRMaj)((SimpleBase)B).getMatrix()), (DMatrix)((DMatrixRMaj)this.mat), (int)insertRow, (int)insertCol);
        } else {
            CommonOps_FDRM.insert((FMatrix)((FMatrixRMaj)((SimpleBase)B).getMatrix()), (FMatrix)((FMatrixRMaj)this.mat), (int)insertRow, (int)insertCol);
        }
    }

    public T combine(int insertRow, int insertCol, T B) {
        SimpleBase<T> ret;
        if (insertRow == Integer.MAX_VALUE) {
            insertRow = this.mat.getNumRows();
        }
        if (insertCol == Integer.MAX_VALUE) {
            insertCol = this.mat.getNumCols();
        }
        int maxRow = insertRow + ((SimpleBase)B).numRows();
        int maxCol = insertCol + ((SimpleBase)B).numCols();
        if (maxRow > this.mat.getNumRows() || maxCol > this.mat.getNumCols()) {
            int M = Math.max(maxRow, this.mat.getNumRows());
            int N = Math.max(maxCol, this.mat.getNumCols());
            ret = this.createMatrix(M, N);
            ret.insertIntoThis(0, 0, (SimpleBase)this);
        } else {
            ret = this.copy();
        }
        ret.insertIntoThis(insertRow, insertCol, B);
        return (T)ret;
    }

    public double elementMaxAbs() {
        if (this.bits() == 64) {
            return CommonOps_DDRM.elementMaxAbs((DMatrixD1)((DMatrixRMaj)this.mat));
        }
        return CommonOps_FDRM.elementMaxAbs((FMatrixD1)((FMatrixRMaj)this.mat));
    }

    public double elementSum() {
        if (this.bits() == 64) {
            return CommonOps_DDRM.elementSum((DMatrixD1)((DMatrixRMaj)this.mat));
        }
        return CommonOps_FDRM.elementSum((FMatrixD1)((FMatrixRMaj)this.mat));
    }

    public T elementMult(T b) {
        T c = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols());
        if (this.bits() == 64) {
            CommonOps_DDRM.elementMult((DMatrixD1)((DMatrixRMaj)this.mat), (DMatrixD1)((DMatrixRMaj)((SimpleBase)b).getMatrix()), (DMatrixD1)((DMatrixRMaj)((SimpleBase)c).getMatrix()));
        } else {
            CommonOps_FDRM.elementMult((FMatrixD1)((FMatrixRMaj)this.mat), (FMatrixD1)((FMatrixRMaj)((SimpleBase)b).getMatrix()), (FMatrixD1)((FMatrixRMaj)((SimpleBase)c).getMatrix()));
        }
        return c;
    }

    public T elementDiv(T b) {
        T c = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols());
        if (this.bits() == 64) {
            CommonOps_DDRM.elementDiv((DMatrixD1)((DMatrixRMaj)this.mat), (DMatrixD1)((DMatrixRMaj)((SimpleBase)b).getMatrix()), (DMatrixD1)((DMatrixRMaj)((SimpleBase)c).getMatrix()));
        } else {
            CommonOps_FDRM.elementDiv((FMatrixD1)((FMatrixRMaj)this.mat), (FMatrixD1)((FMatrixRMaj)((SimpleBase)b).getMatrix()), (FMatrixD1)((FMatrixRMaj)((SimpleBase)c).getMatrix()));
        }
        return c;
    }

    public T elementPower(T b) {
        T c = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols());
        if (this.bits() == 64) {
            CommonOps_DDRM.elementPower((DMatrixD1)((DMatrixRMaj)this.mat), (DMatrixD1)((DMatrixRMaj)((SimpleBase)b).getMatrix()), (DMatrixD1)((DMatrixRMaj)((SimpleBase)c).getMatrix()));
        } else {
            CommonOps_FDRM.elementPower((FMatrixD1)((FMatrixRMaj)this.mat), (FMatrixD1)((FMatrixRMaj)((SimpleBase)b).getMatrix()), (FMatrixD1)((FMatrixRMaj)((SimpleBase)c).getMatrix()));
        }
        return c;
    }

    public T elementPower(double b) {
        T c = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols());
        if (this.bits() == 64) {
            CommonOps_DDRM.elementPower((DMatrixD1)((DMatrixRMaj)this.mat), (double)b, (DMatrixD1)((DMatrixRMaj)((SimpleBase)c).getMatrix()));
        } else {
            CommonOps_FDRM.elementPower((FMatrixD1)((FMatrixRMaj)this.mat), (float)((float)b), (FMatrixD1)((FMatrixRMaj)((SimpleBase)c).getMatrix()));
        }
        return c;
    }

    public T elementExp() {
        T c = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols());
        if (this.bits() == 64) {
            CommonOps_DDRM.elementExp((DMatrixD1)((DMatrixRMaj)this.mat), (DMatrixD1)((DMatrixRMaj)((SimpleBase)c).getMatrix()));
        } else {
            CommonOps_FDRM.elementExp((FMatrixD1)((FMatrixRMaj)this.mat), (FMatrixD1)((FMatrixRMaj)((SimpleBase)c).getMatrix()));
        }
        return c;
    }

    public T elementLog() {
        T c = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols());
        if (this.bits() == 64) {
            CommonOps_DDRM.elementLog((DMatrixD1)((DMatrixRMaj)this.mat), (DMatrixD1)((DMatrixRMaj)((SimpleBase)c).getMatrix()));
        } else {
            CommonOps_FDRM.elementLog((FMatrixD1)((FMatrixRMaj)this.mat), (FMatrixD1)((FMatrixRMaj)((SimpleBase)c).getMatrix()));
        }
        return c;
    }

    public T negative() {
        T A = this.copy();
        if (this.bits() == 64) {
            CommonOps_DDRM.changeSign((DMatrixD1)((DMatrixRMaj)((SimpleBase)A).getMatrix()));
        } else {
            CommonOps_FDRM.changeSign((FMatrixD1)((FMatrixRMaj)((SimpleBase)A).getMatrix()));
        }
        return A;
    }

    public void equation(String equation, Object ... variables) {
        if (variables.length >= 25) {
            throw new IllegalArgumentException("Too many variables!  At most 25");
        }
        if (!(this.mat instanceof DMatrixRMaj)) {
            return;
        }
        Equation eq = new Equation();
        String nameThis = "A";
        int offset = 0;
        if (variables.length > 0 && variables[0] instanceof String) {
            nameThis = (String)variables[0];
            offset = 1;
            if (variables.length % 2 != 1) {
                throw new IllegalArgumentException("Expected and odd length for variables");
            }
        } else if (variables.length % 2 != 0) {
            throw new IllegalArgumentException("Expected and even length for variables");
        }
        eq.alias((DMatrixRMaj)this.mat, nameThis);
        for (int i = offset; i < variables.length; i += 2) {
            if (!(variables[i + 1] instanceof String)) {
                throw new IllegalArgumentException("String expected at variables index " + i);
            }
            Object o = variables[i];
            String name = (String)variables[i + 1];
            if (SimpleBase.class.isAssignableFrom(o.getClass())) {
                eq.alias(((SimpleBase)o).matrix_F64(), name);
                continue;
            }
            if (o instanceof DMatrixRMaj) {
                eq.alias((DMatrixRMaj)o, name);
                continue;
            }
            if (o instanceof Double) {
                eq.alias((Double)o, name);
                continue;
            }
            if (o instanceof Integer) {
                eq.alias((Integer)o, name);
                continue;
            }
            String type = o == null ? "null" : o.getClass().getSimpleName();
            throw new IllegalArgumentException("Variable type not supported by Equation! " + type);
        }
        if (!equation.contains("=")) {
            equation = nameThis + " = " + equation;
        }
        eq.process(equation);
    }

    public void saveToFileBinary(String fileName) throws IOException {
        MatrixIO.saveBin((DMatrix)((DMatrixRMaj)this.mat), (String)fileName);
    }

    public static SimpleMatrix loadBinary(String fileName) throws IOException {
        DMatrix mat = MatrixIO.loadBin((String)fileName);
        if (mat instanceof DMatrixRMaj) {
            return SimpleMatrix.wrap((Matrix)((DMatrixRMaj)mat));
        }
        return SimpleMatrix.wrap((Matrix)new DMatrixRMaj(mat));
    }

    public void saveToFileCSV(String fileName) throws IOException {
        MatrixIO.saveCSV((DMatrix)((DMatrixRMaj)this.mat), (String)fileName);
    }

    public T loadCSV(String fileName) throws IOException {
        DMatrixRMaj mat = MatrixIO.loadCSV((String)fileName);
        T ret = this.createMatrix(1, 1);
        ((SimpleBase)ret).mat = mat instanceof DMatrixRMaj ? mat : new DMatrixRMaj((DMatrix)mat);
        return ret;
    }

    public boolean isInBounds(int row, int col) {
        return row >= 0 && col >= 0 && row < this.mat.getNumRows() && col < this.mat.getNumCols();
    }

    public void printDimensions() {
        System.out.println("[rows = " + this.numRows() + " , cols = " + this.numCols() + " ]");
    }

    public int bits() {
        if (this.mat.getClass() == DMatrixRMaj.class) {
            return 64;
        }
        if (this.mat.getClass() == FMatrixRMaj.class) {
            return 32;
        }
        throw new RuntimeException("Unknown matrix type");
    }
}

