/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import de.unijena.bioinf.ChemistryBase.fp.Fingerprint;
import de.unijena.bioinf.fingerid.KernelCentering;
import de.unijena.bioinf.fingerid.KernelToNumpyConverter;
import de.unijena.bioinf.fingerid.MatrixUtils;
import de.unijena.bioinf.fingerid.NormalizationType;
import gurobi.GRB;
import gurobi.GRBEnv;
import gurobi.GRBException;
import gurobi.GRBExpr;
import gurobi.GRBModel;
import gurobi.GRBQuadExpr;
import gurobi.GRBVar;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class ALIGNF {
    private double[][][] kernelMatrices;
    private final double[][] targetMatrix;
    private final Fingerprint[] fingerprints;
    private final boolean matricesAreAlreadyCentered;
    private double[] upperbounds;
    private double[] lowerbounds;
    private int matrixType = 0;
    private double[] weights;

    public ALIGNF(double[][][] kernelMatrices, Fingerprint[] fingerprints) {
        this(kernelMatrices, fingerprints, false);
    }

    public ALIGNF(double[][][] kernelMatrices, Fingerprint[] fingerprints, boolean matricesAreAlreadyCentered) {
        this.kernelMatrices = kernelMatrices;
        this.targetMatrix = new double[kernelMatrices[0].length][kernelMatrices[0].length];
        this.fingerprints = fingerprints;
        this.weights = null;
        this.matricesAreAlreadyCentered = matricesAreAlreadyCentered;
        this.upperbounds = new double[kernelMatrices.length];
        this.lowerbounds = new double[kernelMatrices.length];
        Arrays.fill(this.upperbounds, Double.POSITIVE_INFINITY);
    }

    public double[] getUpperbounds() {
        return this.upperbounds;
    }

    public double[] getLowerbounds() {
        return this.lowerbounds;
    }

    public void setUpperbound(int k, double up) {
        this.upperbounds[k] = up;
    }

    public void setUpperbound(double up) {
        Arrays.fill(this.upperbounds, up);
    }

    public void setLowerbound(int k, double up) {
        this.lowerbounds[k] = up;
    }

    public void setLowerbound(double up) {
        Arrays.fill(this.lowerbounds, up);
    }

    public int getMatrixType() {
        return this.matrixType;
    }

    public void setMatrixType(int matrixType) {
        this.matrixType = matrixType;
    }

    public void run() {
        int i;
        Future[] centerKernels;
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        if (this.matricesAreAlreadyCentered) {
            centerKernels = new Future[]{};
        } else {
            centerKernels = new Future[this.kernelMatrices.length];
            for (int i2 = 0; i2 < this.kernelMatrices.length; ++i2) {
                final int I = i2;
                centerKernels[i2] = executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[][] kernel = ALIGNF.this.kernelMatrices[I];
                        ALIGNF.this.centerMatrix(kernel, I);
                    }
                });
            }
        }
        switch (NormalizationType.ENABLED_NORMALIZATION_TYPE) {
            case CENTER_NORMALIZE: {
                System.out.println("CENTERING -> NORMALIZING");
                break;
            }
            case NORMALIZE_CENTER_NORMALIZE: {
                System.out.println("NORMALIZING -> CENTERING -> NORMALIZING");
                break;
            }
            case NORMALIZE_CENTER: {
                System.out.println("NORMALIZING -> CENTERING");
                break;
            }
            case CENTER_NORMALIZE_CENTER: {
                System.out.println("CENTERING -> NORMALIZING -> CENTERING");
            }
        }
        this.generateTargetMatrix(executor, this.fingerprints);
        try {
            new KernelToNumpyConverter().writeToFile(new File("normFpMatrix.matrix"), this.targetMatrix);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Future f : centerKernels) {
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        for (int k = 0; k < this.kernelMatrices.length; ++k) {
            if (!this.isNaN(this.kernelMatrices[k])) continue;
            throw new RuntimeException(k + "th matrix contains a NaN");
        }
        ArrayList mfutures = new ArrayList();
        int N = this.kernelMatrices[0].length;
        final int K = this.kernelMatrices.length;
        final double[][] M = new double[K][K];
        int i3 = 0;
        while (i3 < this.kernelMatrices.length / 2) {
            final int n = i3++;
            mfutures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    int i2;
                    for (int j = n; j < K; ++j) {
                        M[n][j] = ALIGNF.this.frobeniusProduct(ALIGNF.this.kernelMatrices[n], ALIGNF.this.kernelMatrices[j]);
                    }
                    for (int j = i2 = K - n - 1; j < K; ++j) {
                        M[i2][j] = ALIGNF.this.frobeniusProduct(ALIGNF.this.kernelMatrices[i2], ALIGNF.this.kernelMatrices[j]);
                    }
                }
            }));
        }
        if (this.kernelMatrices.length % 2 != 0) {
            final int I = this.kernelMatrices.length / 2;
            mfutures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    for (int j = I; j < K; ++j) {
                        M[I][j] = ALIGNF.this.frobeniusProduct(ALIGNF.this.kernelMatrices[I], ALIGNF.this.kernelMatrices[j]);
                    }
                }
            }));
        }
        for (Future future : mfutures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        for (int i2 = 0; i2 < K; ++i2) {
            for (int j = i2 + 1; j < K; ++j) {
                M[j][i2] = M[i2][j];
            }
        }
        double[] A = new double[K];
        Future[] futureArray = new Future[K];
        for (i = 0; i < K; ++i) {
            final double[][] kernel = this.kernelMatrices[i];
            futureArray[i] = executor.submit(new Callable<Double>(){

                @Override
                public Double call() throws Exception {
                    return ALIGNF.this.frobeniusProduct(kernel, ALIGNF.this.targetMatrix);
                }
            });
        }
        for (i = 0; i < K; ++i) {
            try {
                A[i] = (Double)futureArray[i].get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        try {
            this.weights = this.formulateQuadraticProgramming(M, A);
            double sum = 0.0;
            for (double w : this.weights) {
                sum += w;
            }
            int k = 0;
            while (k < this.weights.length) {
                int n = k++;
                this.weights[n] = this.weights[n] / sum;
            }
        }
        catch (GRBException e) {
            e.printStackTrace();
        }
        executor.shutdown();
    }

    public double[][] getALIGNFMatrix() {
        if (this.weights == null) {
            throw new IllegalStateException("First call #run to start the ALIGNF computation!");
        }
        int N = this.kernelMatrices[0].length;
        double[][] alignf = new double[N][N];
        for (int k = 0; k < this.kernelMatrices.length; ++k) {
            double weight = this.weights[k];
            double[][] kernel = this.kernelMatrices[k];
            for (int i = 0; i < N; ++i) {
                for (int j = 0; j < N; ++j) {
                    double[] dArray = alignf[i];
                    int n = j;
                    dArray[n] = dArray[n] + kernel[i][j] * weight;
                }
            }
        }
        return alignf;
    }

    public double[] getWeights() {
        if (this.weights == null) {
            throw new IllegalStateException("First call #run to start the ALIGNF computation!");
        }
        return (double[])this.weights.clone();
    }

    private double[] formulateQuadraticProgramming(double[][] M, double[] a) throws GRBException {
        int i;
        GRBModel model = new GRBModel(new GRBEnv());
        assert (this.isSymetric(M));
        int K = M.length;
        GRBVar[] variables = new GRBVar[K];
        for (int i2 = 0; i2 < K; ++i2) {
            variables[i2] = model.addVar(this.lowerbounds[i2], this.upperbounds[i2], 0.0, 'C', null);
        }
        model.update();
        GRBQuadExpr expr = new GRBQuadExpr();
        for (i = 0; i < K; ++i) {
            for (int j = 0; j < K; ++j) {
                expr.addTerm(M[i][j], variables[i], variables[j]);
            }
        }
        for (i = 0; i < K; ++i) {
            expr.addTerm(-2.0 * a[i], variables[i]);
        }
        model.setObjective((GRBExpr)expr, 1);
        model.update();
        model.optimize();
        double[] solution = new double[K];
        for (int i3 = 0; i3 < K; ++i3) {
            solution[i3] = variables[i3].get(GRB.DoubleAttr.X);
        }
        double norm = 0.0;
        for (double w : solution) {
            norm += w * w;
        }
        norm = Math.sqrt(norm);
        int i4 = 0;
        while (i4 < K) {
            int n = i4++;
            solution[n] = solution[n] / norm;
        }
        model.dispose();
        return solution;
    }

    private boolean isNaN(double[][] m) {
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m.length; ++j) {
                if (!Double.isNaN(m[i][j])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSymetric(double[][] m) {
        for (int i = 0; i < m.length; ++i) {
            for (int j = i + 1; j < m.length; ++j) {
                double delta = m[i][j] - m[j][i];
                if (!(Math.abs(delta) > 1.0E-12)) continue;
                return false;
            }
        }
        return true;
    }

    private double frobeniusProduct(double[][] A, double[][] B) {
        int i;
        int N = A.length;
        double sum = 0.0;
        for (i = 0; i < N; ++i) {
            for (int j = i + 1; j < N; ++j) {
                sum += A[i][j] * B[i][j];
            }
        }
        sum *= 2.0;
        for (i = 0; i < N; ++i) {
            sum += A[i][i] * B[i][i];
        }
        return sum;
    }

    private double frobeniusProduct(double[][] A, long[][] B) {
        int i;
        int N = A.length;
        double sum = 0.0;
        for (i = 0; i < N; ++i) {
            for (int j = i + 1; j < N; ++j) {
                sum += A[i][j] * (double)B[i][j];
            }
        }
        sum *= 2.0;
        for (i = 0; i < N; ++i) {
            sum += A[i][i] * (double)B[i][i];
        }
        return sum;
    }

    private void centerMatrix(double[][] kernel, int I) {
        if (NormalizationType.ENABLED_NORMALIZATION_TYPE == NormalizationType.NORMALIZE_CENTER || NormalizationType.ENABLED_NORMALIZATION_TYPE == NormalizationType.NORMALIZE_CENTER_NORMALIZE) {
            MatrixUtils.normalize((double[][])kernel);
            for (int i = 0; i < kernel.length; ++i) {
                for (int j = 0; j < kernel.length; ++j) {
                    if (!(Math.abs(kernel[i][j]) > 1.1)) continue;
                    System.err.println("NOT POSSIBLE!!! " + kernel[i][j] + " at " + i + " and " + j + " for " + I + "th kernel.");
                }
            }
        }
        if (NormalizationType.ENABLED_NORMALIZATION_TYPE == NormalizationType.CENTER_NORMALIZE || NormalizationType.ENABLED_NORMALIZATION_TYPE == NormalizationType.NORMALIZE_CENTER_NORMALIZE || NormalizationType.ENABLED_NORMALIZATION_TYPE == NormalizationType.CENTER_NORMALIZE_CENTER) {
            KernelCentering kc = new KernelCentering(kernel, true);
            kc.applyToTrainMatrix(kernel);
            if (NormalizationType.ENABLED_NORMALIZATION_TYPE == NormalizationType.CENTER_NORMALIZE_CENTER) {
                new KernelCentering(kernel, false).applyToTrainMatrix(kernel);
            }
        } else if (NormalizationType.ENABLED_NORMALIZATION_TYPE == NormalizationType.NORMALIZE_CENTER) {
            KernelCentering kc = new KernelCentering(kernel, false);
            kc.applyToTrainMatrix(kernel);
        }
    }

    private void generateTargetMatrix(ExecutorService service, final Fingerprint[] F) {
        if (this.matrixType == 1) {
            System.out.println("Compute TANIMOTO");
            for (int i = 0; i < F.length; ++i) {
                this.targetMatrix[i][i] = 1.0;
                for (int j = 0; j < i; ++j) {
                    double d;
                    double d2 = d = F[i].tanimoto(F[j]);
                    this.targetMatrix[j][i] = d2;
                    this.targetMatrix[i][j] = d2;
                }
            }
        } else {
            System.out.println("Compute DOT PRODUCT *4");
            ArrayList futures = new ArrayList();
            for (int i = 0; i < F.length; ++i) {
                final int n = i;
                this.targetMatrix[i][i] = F[i].getFingerprintVersion().size();
                futures.add(service.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int j = 0; j < n; ++j) {
                            double dot;
                            double d = dot = F[n].plusMinusdotProduct(F[j]);
                            ((ALIGNF)ALIGNF.this).targetMatrix[j][n] = d;
                            ((ALIGNF)ALIGNF.this).targetMatrix[n][j] = d;
                        }
                    }
                }));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.centerMatrix(this.targetMatrix, 0);
    }

    private void makeFingerprintMatrix(ExecutorService service, final int[][] fingerprintIndizes, final int totalLength) {
        final double[] weights = null;
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < this.targetMatrix.length / 2) {
            final int n = i++;
            futures.add(service.submit(new Runnable(){

                @Override
                public void run() {
                    ALIGNF.this.calcFpTargetRow(n, fingerprintIndizes, totalLength, weights);
                    ALIGNF.this.calcFpTargetRow(fingerprintIndizes.length - n - 1, fingerprintIndizes, totalLength, weights);
                }
            }));
        }
        if (this.targetMatrix.length % 2 != 0) {
            final int MIDDLE = this.targetMatrix.length / 2;
            futures.add(service.submit(new Runnable(){

                @Override
                public void run() {
                    ALIGNF.this.calcFpTargetRow(MIDDLE, fingerprintIndizes, totalLength, weights);
                }
            }));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        for (i = 0; i < this.targetMatrix.length; ++i) {
            this.targetMatrix[i][i] = this.matrixType == 0 ? (double)totalLength : 1.0;
            for (int j = i + 1; j < this.targetMatrix.length; ++j) {
                this.targetMatrix[j][i] = this.targetMatrix[i][j];
            }
        }
    }

    private void calcFpTargetRow(int i, int[][] fingerprintIndizes, int totalLength, double[] weights) {
        if (this.matrixType > 0) {
            this.calcFpTargetRowJaccard(i, fingerprintIndizes, totalLength);
            return;
        }
        int[] as = fingerprintIndizes[i];
        for (int j = i + 1; j < this.targetMatrix.length; ++j) {
            int[] bs = fingerprintIndizes[j];
            int a = 0;
            int b = 0;
            int count = 0;
            while (a < as.length && b < bs.length) {
                if (as[a] == bs[b]) {
                    ++count;
                    ++a;
                    ++b;
                    continue;
                }
                if (as[a] > bs[b]) {
                    ++b;
                    continue;
                }
                ++a;
            }
            double[] dArray = this.targetMatrix[i];
            int n = j;
            dArray[n] = dArray[n] + (double)(2 * count + totalLength - (as.length + bs.length));
            double[] dArray2 = this.targetMatrix[i];
            int n2 = j;
            dArray2[n2] = dArray2[n2] - ((double)totalLength - this.targetMatrix[i][j]);
        }
    }

    private void calcFpTargetRowJaccard(int i, int[][] fingerprintIndizes, int totalLength) {
        int[] as = fingerprintIndizes[i];
        for (int j = i + 1; j < this.targetMatrix.length; ++j) {
            int[] bs = fingerprintIndizes[j];
            int a = 0;
            int b = 0;
            int count = 0;
            while (a < as.length && b < bs.length) {
                if (as[a] == bs[b]) {
                    ++count;
                    ++a;
                    ++b;
                    continue;
                }
                if (as[a] > bs[b]) {
                    ++b;
                    continue;
                }
                ++a;
            }
            double[] dArray = this.targetMatrix[i];
            int n = j;
            dArray[n] = dArray[n] + (double)count / (double)(as.length + bs.length - count);
            if (this.matrixType < 2) continue;
            this.targetMatrix[i][j] = Math.pow(this.targetMatrix[i][j], this.matrixType);
        }
    }

    public void run2(String[] kernelNames, int[] treeSizes) {
        int i;
        Future[] centerKernels;
        System.out.println("RUN2");
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        double[][][] origMatrices = this.kernelMatrices;
        this.kernelMatrices = new double[origMatrices.length * 2][][];
        String[] kernelNames2 = new String[this.kernelMatrices.length];
        for (int k = 0; k < this.kernelMatrices.length; k += 2) {
            this.kernelMatrices[k] = origMatrices[k / 2];
            this.kernelMatrices[k + 1] = this.dividebytreesizes(this.kernelMatrices[k], treeSizes);
            kernelNames2[k] = kernelNames[k / 2];
            kernelNames2[k + 1] = kernelNames[k / 2];
        }
        if (this.matricesAreAlreadyCentered) {
            centerKernels = new Future[]{};
        } else {
            centerKernels = new Future[this.kernelMatrices.length];
            for (int i2 = 0; i2 < this.kernelMatrices.length; ++i2) {
                final int I = i2;
                centerKernels[i2] = executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[][] kernel = ALIGNF.this.kernelMatrices[I];
                        ALIGNF.this.centerMatrix(kernel, I);
                    }
                });
            }
        }
        this.upperbounds = new double[this.kernelMatrices.length];
        Arrays.fill(this.upperbounds, Double.POSITIVE_INFINITY);
        this.generateTargetMatrix(executor, this.fingerprints);
        for (Future f : centerKernels) {
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        ArrayList mfutures = new ArrayList();
        int N = this.kernelMatrices[0].length;
        final int K = this.kernelMatrices.length;
        final double[][] M = new double[K][K];
        int i3 = 0;
        while (i3 < this.kernelMatrices.length / 2) {
            final int n = i3++;
            mfutures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    int i2;
                    for (int j = n; j < K; ++j) {
                        M[n][j] = ALIGNF.this.frobeniusProduct(ALIGNF.this.kernelMatrices[n], ALIGNF.this.kernelMatrices[j]);
                    }
                    for (int j = i2 = K - n - 1; j < K; ++j) {
                        M[i2][j] = ALIGNF.this.frobeniusProduct(ALIGNF.this.kernelMatrices[i2], ALIGNF.this.kernelMatrices[j]);
                    }
                }
            }));
        }
        if (this.kernelMatrices.length % 2 != 0) {
            final int I = this.kernelMatrices.length / 2;
            mfutures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    for (int j = I; j < K; ++j) {
                        M[I][j] = ALIGNF.this.frobeniusProduct(ALIGNF.this.kernelMatrices[I], ALIGNF.this.kernelMatrices[j]);
                    }
                }
            }));
        }
        for (Future future : mfutures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        for (int i2 = 0; i2 < K; ++i2) {
            for (int j = i2 + 1; j < K; ++j) {
                M[j][i2] = M[i2][j];
            }
        }
        double[] A = new double[K];
        Future[] futureArray = new Future[K];
        for (i = 0; i < K; ++i) {
            final double[][] kernel = this.kernelMatrices[i];
            futureArray[i] = executor.submit(new Callable<Double>(){

                @Override
                public Double call() throws Exception {
                    return ALIGNF.this.frobeniusProduct(kernel, ALIGNF.this.targetMatrix);
                }
            });
        }
        for (i = 0; i < K; ++i) {
            try {
                A[i] = (Double)futureArray[i].get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        try {
            this.weights = this.formulateQuadraticProgramming(M, A);
            double sum = 0.0;
            for (double w : this.weights) {
                sum += w;
            }
            int k = 0;
            while (k < this.weights.length) {
                int n = k++;
                this.weights[n] = this.weights[n] / sum;
            }
            for (k = 0; k < this.weights.length; ++k) {
                System.out.println(kernelNames2[k] + (k % 2 == 0 ? "" : " (norm)") + ": " + this.weights[k]);
            }
        }
        catch (GRBException e) {
            e.printStackTrace();
        }
        executor.shutdown();
    }

    private double[][] dividebytreesizes(double[][] kernelMatrice, int[] treeSizes) {
        kernelMatrice = MatrixUtils.clone((double[][])kernelMatrice);
        for (int i = 0; i < kernelMatrice.length; ++i) {
            for (int j = 0; j <= i; ++j) {
                double d = kernelMatrice[i][j] / (double)(treeSizes[i] * treeSizes[j]);
                kernelMatrice[j][i] = d;
                kernelMatrice[i][j] = d;
            }
        }
        return kernelMatrice;
    }
}

