/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import de.unijena.bioinf.ChemistryBase.fp.Fingerprint;
import de.unijena.bioinf.fingerid.KernelCentering;
import gurobi.GRB;
import gurobi.GRBEnv;
import gurobi.GRBException;
import gurobi.GRBExpr;
import gurobi.GRBModel;
import gurobi.GRBQuadExpr;
import gurobi.GRBVar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class ALIGNFTEST {
    private final double[][][] kernelMatrices;
    private final double[][] targetMatrix;
    private final Fingerprint[] fingerprints;
    private final boolean matricesAreAlreadyCentered = false;
    private double[] upperbounds;
    private int matrixType = 0;
    private double[] weights;
    private int trainSize;
    private double[][] norms;

    public ALIGNFTEST(double[][][] kernelMatrices, Fingerprint[] fingerprints, double[][] norms) {
        this.kernelMatrices = kernelMatrices;
        this.targetMatrix = new double[kernelMatrices[0].length][kernelMatrices[0][0].length];
        this.fingerprints = fingerprints;
        this.weights = null;
        this.upperbounds = new double[kernelMatrices.length];
        Arrays.fill(this.upperbounds, Double.POSITIVE_INFINITY);
        this.trainSize = kernelMatrices[0][0].length;
        this.norms = norms;
    }

    public void setUpperbound(int k, double up) {
        this.upperbounds[k] = up;
    }

    public int getMatrixType() {
        return this.matrixType;
    }

    public void setMatrixType(int matrixType) {
        this.matrixType = matrixType;
    }

    public void run() {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        Future[] centerKernels = new Future[this.kernelMatrices.length];
        for (int i2 = 0; i2 < this.kernelMatrices.length; ++i2) {
            final int I = i2;
            centerKernels[i2] = executor.submit(new Runnable(){

                @Override
                public void run() {
                    double[][] kernel = ALIGNFTEST.this.kernelMatrices[I];
                    ALIGNFTEST.this.centerMatrix(kernel, ALIGNFTEST.this.norms[I]);
                }
            });
        }
        this.generateTargetMatrix(executor, this.fingerprints);
        for (Future f : centerKernels) {
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        double[] fpnorm = new double[this.targetMatrix.length];
        Arrays.fill(fpnorm, this.targetMatrix[0][0]);
        this.centerMatrix(this.targetMatrix, fpnorm);
        ArrayList mfutures = new ArrayList();
        int N = this.kernelMatrices[0].length;
        final int K = this.kernelMatrices.length;
        final double[][] M = new double[K][K];
        int i3 = 0;
        while (i3 < this.kernelMatrices.length / 2) {
            final int n = i3++;
            mfutures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    int i2;
                    for (int j = n; j < K; ++j) {
                        M[n][j] = ALIGNFTEST.this.frobeniusProduct(ALIGNFTEST.this.kernelMatrices[n], ALIGNFTEST.this.kernelMatrices[j]);
                    }
                    for (int j = i2 = K - n - 1; j < K; ++j) {
                        M[i2][j] = ALIGNFTEST.this.frobeniusProduct(ALIGNFTEST.this.kernelMatrices[i2], ALIGNFTEST.this.kernelMatrices[j]);
                    }
                }
            }));
        }
        if (this.kernelMatrices.length % 2 != 0) {
            final int I = this.kernelMatrices.length / 2;
            mfutures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    for (int j = I; j < K; ++j) {
                        M[I][j] = ALIGNFTEST.this.frobeniusProduct(ALIGNFTEST.this.kernelMatrices[I], ALIGNFTEST.this.kernelMatrices[j]);
                    }
                }
            }));
        }
        for (Future future : mfutures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        for (int i2 = 0; i2 < K; ++i2) {
            for (int j = i2 + 1; j < K; ++j) {
                M[j][i2] = M[i2][j];
            }
        }
        double[] A = new double[K];
        Future[] futureArray = new Future[K];
        for (i = 0; i < K; ++i) {
            final double[][] kernel = this.kernelMatrices[i];
            futureArray[i] = executor.submit(new Callable<Double>(){

                @Override
                public Double call() throws Exception {
                    return ALIGNFTEST.this.frobeniusProduct(kernel, ALIGNFTEST.this.targetMatrix);
                }
            });
        }
        for (i = 0; i < K; ++i) {
            try {
                A[i] = (Double)futureArray[i].get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        try {
            this.weights = this.formulateQuadraticProgramming(M, A);
            double sum = 0.0;
            for (double w : this.weights) {
                sum += w;
            }
            int k = 0;
            while (k < this.weights.length) {
                int n = k++;
                this.weights[n] = this.weights[n] / sum;
            }
        }
        catch (GRBException e) {
            e.printStackTrace();
        }
        executor.shutdown();
    }

    public double[][] getALIGNFMatrix() {
        if (this.weights == null) {
            throw new IllegalStateException("First call #run to start the ALIGNF computation!");
        }
        int N = this.kernelMatrices[0].length;
        double[][] alignf = new double[N][N];
        for (int k = 0; k < this.kernelMatrices.length; ++k) {
            double weight = this.weights[k];
            double[][] kernel = this.kernelMatrices[k];
            for (int i = 0; i < N; ++i) {
                for (int j = 0; j < N; ++j) {
                    double[] dArray = alignf[i];
                    int n = j;
                    dArray[n] = dArray[n] + kernel[i][j] * weight;
                }
            }
        }
        return alignf;
    }

    public double[] getWeights() {
        if (this.weights == null) {
            throw new IllegalStateException("First call #run to start the ALIGNF computation!");
        }
        return (double[])this.weights.clone();
    }

    private double[] formulateQuadraticProgramming(double[][] M, double[] a) throws GRBException {
        int i;
        GRBModel model = new GRBModel(new GRBEnv());
        int K = M.length;
        GRBVar[] variables = new GRBVar[K];
        for (int i2 = 0; i2 < K; ++i2) {
            variables[i2] = model.addVar(0.0, this.upperbounds[i2], 0.0, 'C', null);
        }
        model.update();
        GRBQuadExpr expr = new GRBQuadExpr();
        for (i = 0; i < K; ++i) {
            for (int j = 0; j < K; ++j) {
                expr.addTerm(M[i][j], variables[i], variables[j]);
            }
        }
        for (i = 0; i < K; ++i) {
            expr.addTerm(-2.0 * a[i], variables[i]);
        }
        model.setObjective((GRBExpr)expr, 1);
        model.update();
        model.optimize();
        double[] solution = new double[K];
        for (int i3 = 0; i3 < K; ++i3) {
            solution[i3] = variables[i3].get(GRB.DoubleAttr.X);
        }
        double norm = 0.0;
        for (double w : solution) {
            norm += w * w;
        }
        norm = Math.sqrt(norm);
        System.out.println(norm);
        int i4 = 0;
        while (i4 < K) {
            int n = i4++;
            solution[n] = solution[n] / norm;
        }
        model.dispose();
        return solution;
    }

    private boolean isSymetric(double[][] m) {
        for (int i = 0; i < m.length; ++i) {
            for (int j = i + 1; j < m.length; ++j) {
                double delta = m[i][j] - m[j][i];
                if (!(Math.abs(delta) > 1.0E-12)) continue;
                return false;
            }
        }
        return true;
    }

    private double frobeniusProduct(double[][] A, double[][] B) {
        double sum = 0.0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                sum += A[i][j] * B[i][j];
            }
        }
        return sum;
    }

    private void centerMatrix(double[][] kernel, double[] norms) {
        int i;
        int testSize = kernel.length - this.trainSize;
        System.out.println("trainSize: " + this.trainSize + "\ntestSize: " + testSize);
        double[][] trainKernel = (double[][])Arrays.copyOf(kernel, this.trainSize);
        KernelCentering kc = new KernelCentering(trainKernel, true);
        double[][] testKernel = new double[testSize][];
        for (int k = 0; k < testSize; ++k) {
            testKernel[k] = kernel[this.trainSize + k];
        }
        System.out.println("trainKernel: " + trainKernel.length + " x " + trainKernel[0].length);
        System.out.println("testKernel: " + testKernel.length + " x " + testKernel[0].length);
        System.out.println("norm: " + norms.length);
        kc.applyToTrainMatrix(trainKernel);
        kc.applyToKernelMatrix((double[][])testKernel, norms);
        for (i = 0; i < this.trainSize; ++i) {
            kernel[i] = trainKernel[i];
        }
        for (i = 0; i < testSize; ++i) {
            kernel[i + this.trainSize] = testKernel[i];
        }
    }

    private void generateTargetMatrix(ExecutorService service, Fingerprint[] F) {
        int j;
        int i;
        for (i = 0; i < this.trainSize; ++i) {
            for (j = 0; j <= i; ++j) {
                double d = F[i].plusMinusdotProduct(F[j]);
                this.targetMatrix[j][i] = d;
                this.targetMatrix[i][j] = d;
            }
        }
        for (i = this.trainSize; i < F.length; ++i) {
            for (j = 0; j < this.trainSize; ++j) {
                this.targetMatrix[i][j] = F[i].plusMinusdotProduct(F[j]);
            }
        }
    }
}

