/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

public class FingerprintCentering {
    private final boolean standardize;
    private final boolean fingerprintsInRows;
    private final double[] fpMeans;

    public FingerprintCentering(double[][] Ky, boolean fingerprintsInRows, boolean standardize) {
        this.standardize = standardize;
        this.fingerprintsInRows = fingerprintsInRows;
        this.fpMeans = fingerprintsInRows ? this.rowMeans(Ky) : this.colMeans(Ky);
    }

    public void apply(double[] row) {
        int i;
        double sum = 0.0;
        for (i = 0; i < row.length; ++i) {
            int n = i;
            row[n] = row[n] - this.fpMeans[i];
            sum += row[i] * row[i];
        }
        if (!this.standardize) {
            return;
        }
        sum = Math.sqrt(sum);
        i = 0;
        while (i < row.length) {
            int n = i++;
            row[n] = row[n] / sum;
        }
    }

    public void apply(double[][] Ky) {
        if (this.fingerprintsInRows) {
            int j;
            int i;
            double[] sampleAverages = new double[Ky[0].length];
            for (i = 0; i < Ky.length; ++i) {
                j = 0;
                while (j < Ky[i].length) {
                    double[] dArray = Ky[i];
                    int n = j;
                    dArray[n] = dArray[n] - this.fpMeans[i];
                    double val = Ky[i][j];
                    int n2 = j++;
                    sampleAverages[n2] = sampleAverages[n2] + val * val;
                }
            }
            if (!this.standardize) {
                return;
            }
            for (i = 0; i < sampleAverages.length; ++i) {
                sampleAverages[i] = Math.sqrt(sampleAverages[i]);
            }
            for (i = 0; i < Ky.length; ++i) {
                for (j = 0; j < Ky[i].length; ++j) {
                    double[] dArray = Ky[i];
                    int n = j;
                    dArray[n] = dArray[n] / sampleAverages[j];
                }
            }
        } else {
            for (double[] row : Ky) {
                this.apply(row);
            }
        }
    }

    private double[] colMeans(double[][] matrix) {
        double[] means = new double[matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                int n = j;
                means[n] = means[n] + matrix[i][j];
            }
        }
        int j = 0;
        while (j < means.length) {
            int n = j++;
            means[n] = means[n] / (double)matrix.length;
        }
        return means;
    }

    private double[] rowMeans(double[][] matrix) {
        double[] means = new double[matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                int n = i;
                means[n] = means[n] + matrix[i][j];
            }
            int n = i;
            means[n] = means[n] / (double)matrix[i].length;
        }
        return means;
    }
}

