/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import de.unijena.bioinf.fingerid.Kernels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FingerprintKernel {
    public double[][] buildKernel(boolean[][] fingerprints) {
        return this.buildKernel(fingerprints, false);
    }

    public double[][] buildKernel(boolean[][] fingerprints, boolean normalize) {
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        double[][] matrix = this.generateTargetMatrix(service, fingerprints, normalize);
        service.shutdown();
        return matrix;
    }

    private double[][] generateTargetMatrix(ExecutorService service, boolean[][] F, boolean normalize) {
        double[][] matrix = new double[F.length][F.length];
        int[][] fingerprintIndizes = new int[F.length][];
        int[] buffer = new int[F[0].length];
        for (int i = 0; i < F.length; ++i) {
            boolean[] row = F[i];
            int k = 0;
            for (int j = 0; j < row.length; ++j) {
                if (!row[j]) continue;
                buffer[k++] = j;
            }
            fingerprintIndizes[i] = Arrays.copyOf(buffer, k);
        }
        this.makeFingerprintMatrix(service, matrix, fingerprintIndizes, F[0].length, F, normalize);
        return matrix;
    }

    private void makeFingerprintMatrix(ExecutorService service, final double[][] targetMatrix, final int[][] fingerprintIndizes, final int totalLength, boolean[][] F, boolean normalize) {
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < targetMatrix.length / 2) {
            final int n = i++;
            futures.add(service.submit(new Runnable(){

                @Override
                public void run() {
                    FingerprintKernel.this.calcFpTargetRow(targetMatrix[n], n, fingerprintIndizes, totalLength);
                    FingerprintKernel.this.calcFpTargetRow(targetMatrix[fingerprintIndizes.length - n - 1], fingerprintIndizes.length - n - 1, fingerprintIndizes, totalLength);
                }
            }));
        }
        if (targetMatrix.length % 2 != 0) {
            final int MIDDLE = targetMatrix.length / 2;
            futures.add(service.submit(new Runnable(){

                @Override
                public void run() {
                    FingerprintKernel.this.calcFpTargetRow(targetMatrix[MIDDLE], MIDDLE, fingerprintIndizes, totalLength);
                }
            }));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        for (i = 0; i < targetMatrix.length; ++i) {
            targetMatrix[i][i] = totalLength;
            for (int j = i + 1; j < targetMatrix.length; ++j) {
                targetMatrix[j][i] = targetMatrix[i][j];
            }
        }
        if (normalize) {
            for (i = 0; i < targetMatrix.length; ++i) {
                for (int j = 0; j < i; ++j) {
                    double d = Kernels.norm((double)targetMatrix[i][j], (double)targetMatrix[i][i], (double)targetMatrix[j][j]);
                    targetMatrix[j][i] = d;
                    targetMatrix[i][j] = d;
                }
            }
            for (i = 0; i < targetMatrix.length; ++i) {
                targetMatrix[i][i] = 1.0;
            }
        }
    }

    private void calcFpTargetRow(double[] targetRow, int i, int[][] fingerprintIndizes, int totalLength) {
        int[] as = fingerprintIndizes[i];
        for (int j = i + 1; j < targetRow.length; ++j) {
            int[] bs = fingerprintIndizes[j];
            int a = 0;
            int b = 0;
            int count = 0;
            while (a < as.length && b < bs.length) {
                if (as[a] == bs[b]) {
                    ++count;
                    ++a;
                    ++b;
                    continue;
                }
                if (as[a] > bs[b]) {
                    ++b;
                    continue;
                }
                ++a;
            }
            targetRow[j] = 2 * count + totalLength - (as.length + bs.length);
            int n = j;
            targetRow[n] = targetRow[n] - ((double)totalLength - targetRow[j]);
        }
    }
}

