/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import de.unijena.bioinf.ChemistryBase.fp.PredictionPerformance;
import java.util.Comparator;

public abstract class OptimizationStrategy {
    public int bestChoice(PredictionPerformance[] predictionPerformances, int defaultValue) {
        int maxi = defaultValue;
        Comparator<PredictionPerformance> comp = this.getComparator();
        for (int k = 0; k < predictionPerformances.length; ++k) {
            if (comp.compare(predictionPerformances[maxi], predictionPerformances[k]) >= 0) continue;
            maxi = k;
        }
        return maxi;
    }

    public abstract Comparator<PredictionPerformance> getComparator();

    public static class WithMinimalSensitivity
    extends OptimizationStrategy {
        private final double minSens;

        public WithMinimalSensitivity(double val) {
            this.minSens = val;
        }

        @Override
        public Comparator<PredictionPerformance> getComparator() {
            return new Comparator<PredictionPerformance>(){

                @Override
                public int compare(PredictionPerformance left, PredictionPerformance right) {
                    double s = Math.min(left.getRecall(), right.getRecall());
                    if (s < minSens) {
                        if (left.getRecall() > right.getRecall()) {
                            return 1;
                        }
                        if (right.getRecall() > left.getRecall()) {
                            return -1;
                        }
                        if (left.getAccuracy() > right.getAccuracy()) {
                            return 1;
                        }
                        if (right.getAccuracy() > left.getAccuracy()) {
                            return -1;
                        }
                        return 0;
                    }
                    if (left.getAccuracy() > right.getAccuracy()) {
                        return 1;
                    }
                    if (right.getAccuracy() > left.getAccuracy()) {
                        return -1;
                    }
                    return 0;
                }
            };
        }
    }

    public static class ByFScore
    extends OptimizationStrategy {
        @Override
        public Comparator<PredictionPerformance> getComparator() {
            return new Comparator<PredictionPerformance>(){

                @Override
                public int compare(PredictionPerformance left, PredictionPerformance right) {
                    double delta = left.getF() - right.getF();
                    if (delta > 1.0E-5) {
                        return 1;
                    }
                    if (delta > -1.0E-5) {
                        return left.getAccuracy() > right.getAccuracy() ? 1 : 0;
                    }
                    return -1;
                }
            };
        }
    }

    public static class ByAccuracy
    extends OptimizationStrategy {
        @Override
        public Comparator<PredictionPerformance> getComparator() {
            return new Comparator<PredictionPerformance>(){

                @Override
                public int compare(PredictionPerformance left, PredictionPerformance right) {
                    double delta = left.getAccuracy() - right.getAccuracy();
                    if (delta > 1.0E-5) {
                        return 1;
                    }
                    if (delta > -1.0E-5) {
                        return left.getAccuracy() > right.getAccuracy() ? 1 : 0;
                    }
                    return -1;
                }
            };
        }
    }
}

