/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

public class ParameterC {
    public double value;
    public GROW bias;

    public static ParameterC[] combinations(double[] weights, GROW ... modes) {
        ParameterC[] POSSIBLE_CVALUES = new ParameterC[weights.length * modes.length];
        int k = 0;
        for (int i = 0; i < weights.length; ++i) {
            for (int j = 0; j < modes.length; ++j) {
                POSSIBLE_CVALUES[k++] = new ParameterC(weights[i], modes[j]);
            }
        }
        return POSSIBLE_CVALUES;
    }

    public static ParameterC fromString(String s) {
        int i = s.indexOf(40);
        int j = s.lastIndexOf(41);
        return new ParameterC(Double.parseDouble(s.substring(0, i).trim()), GROW.valueOf(s.substring(i + 1, j).toUpperCase()));
    }

    public ParameterC(double value, GROW bias) {
        this.value = value;
        this.bias = bias;
    }

    public ParameterC(double value) {
        this(value, GROW.CONSTANT);
    }

    public String toString() {
        return this.value + " (" + this.bias.toString().toLowerCase() + ")";
    }

    public double setWeightsBySample(int positiveExamples, int totalExamples, double[] weights) {
        return this.setWeights(positiveExamples, totalExamples - positiveExamples, weights);
    }

    public double setWeights(int positiveExamples, int negativeExamples, double[] weights) {
        if (this.bias == GROW.CONSTANT) {
            weights[1] = 1.0;
            weights[0] = 1.0;
            return this.value;
        }
        if (this.bias == GROW.DOUBLED) {
            int multiplier = Math.min(4, (int)Math.floor((double)(positiveExamples / negativeExamples) / 2.0));
            if (multiplier > 0) {
                weights[0] = 1.0;
                weights[1] = multiplier;
                return this.value;
            }
            multiplier = Math.min(4, (int)Math.floor((double)(negativeExamples / positiveExamples) / 2.0));
            weights[1] = 1.0;
            weights[0] = multiplier;
            return this.value;
        }
        double total = positiveExamples + negativeExamples + 2;
        weights[1] = (1.0 + (double)positiveExamples) / total;
        weights[0] = (1.0 + (double)negativeExamples) / total;
        if (this.bias == GROW.QUADRATIC) {
            double a = Math.sqrt(weights[0]);
            double b = Math.sqrt(weights[1]);
            weights[1] = b / (a + b);
            weights[0] = a / (a + b);
        }
        return this.value;
    }

    public static enum GROW {
        CONSTANT,
        DOUBLED,
        LINEAR,
        QUADRATIC;

    }
}

