/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import de.unijena.bioinf.ChemistryBase.fp.PredictionPerformance;
import de.unijena.bioinf.fingerid.ParameterC;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class Predictor {
    protected int realIndex;
    protected double rho;
    protected double probB;
    protected double probA;
    protected double[] coefficients;
    protected int[] supportVectors;
    protected double tp;
    protected double fp;
    protected double tn;
    protected double fn;
    protected ParameterC c;

    public static Predictor nullModel(int realIndex) {
        return new Predictor(realIndex, 0.0, 0.0, 0.0, new double[0], new int[0]);
    }

    public static Predictor negativeModel(int realIndex) {
        return new Predictor(realIndex, 1.0, -100.0, 0.0, new double[0], new int[0]);
    }

    public Predictor(int realIndex, double rho, double probA, double probB, double[] coeffs, int[] vectors) {
        if (coeffs.length != vectors.length) {
            throw new IllegalArgumentException("Numbers of support vectors and coefficients differ");
        }
        this.rho = rho;
        this.probA = probA;
        this.probB = probB;
        this.coefficients = coeffs;
        this.supportVectors = vectors;
        this.realIndex = realIndex;
    }

    public double getProbB() {
        return this.probB;
    }

    public void setProbB(double probB) {
        this.probB = probB;
    }

    public double getProbA() {
        return this.probA;
    }

    public void setProbA(double probA) {
        this.probA = probA;
    }

    public boolean predict(double[] kernel) {
        return this.predictValue(kernel) > 0.0;
    }

    public double estimateProbability(double[] kernel) {
        return Predictor.sigmoid_predict(this.predictValue(kernel), this.probA, this.probB);
    }

    public void setStatistics(PredictionPerformance performance) {
        this.tp = performance.getTp();
        this.fp = performance.getFp();
        this.tn = performance.getTn();
        this.fn = performance.getFn();
    }

    public PredictionPerformance getPerformance() {
        return new PredictionPerformance(this.tp, this.fp, this.tn, this.fn);
    }

    public int getRealIndex() {
        return this.realIndex;
    }

    public void setStatistics(double tp, double fp, double tn, double fn) {
        this.tp = tp;
        this.fp = fp;
        this.tn = tn;
        this.fn = fn;
    }

    public void setParameterC(ParameterC c) {
        this.c = c;
    }

    public ParameterC getParameterC() {
        return this.c;
    }

    public void setRealIndex(int realIndex) {
        this.realIndex = realIndex;
    }

    public double getTp() {
        return this.tp;
    }

    public double getFp() {
        return this.fp;
    }

    public double getTn() {
        return this.tn;
    }

    public double getFn() {
        return this.fn;
    }

    public double predictValue(double[] kernel) {
        double sum = 0.0;
        for (int i = 0; i < this.supportVectors.length; ++i) {
            if (this.supportVectors[i] > kernel.length) {
                System.err.println("ALARM!");
            }
            sum += this.coefficients[i] * kernel[this.supportVectors[i] - 1];
        }
        return sum -= this.rho;
    }

    public static Predictor parseModelFile(File f) throws IOException {
        String mname = f.getName();
        int realIndex = Integer.parseInt(mname.substring(0, mname.lastIndexOf(46)));
        return Predictor.parseModelFile(f, realIndex);
    }

    public static Predictor parseModelFile(File f, int realIndex) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(f));){
            Predictor predictor = Predictor.parseModel(reader, realIndex);
            return predictor;
        }
    }

    public static Predictor parseModel(Reader someReader) throws IOException {
        return Predictor.parseModel(someReader, 0);
    }

    public static Predictor parseModel(Reader someReader, int realIndex) throws IOException {
        BufferedReader reader = someReader instanceof BufferedReader ? (BufferedReader)someReader : new BufferedReader(someReader);
        String line = null;
        boolean mode = false;
        double rho = 0.0;
        double probB = 0.0;
        double probA = 0.0;
        double[] coefficients = null;
        int[] supportVectors = null;
        int k = 0;
        while ((line = reader.readLine()) != null) {
            if (!mode) {
                if (line.startsWith("total_sv")) {
                    int num = Integer.parseInt(line.split("\\s+")[1]);
                    coefficients = new double[num];
                    supportVectors = new int[num];
                    continue;
                }
                if (line.startsWith("label")) {
                    if (line.startsWith("label 1 -1")) continue;
                    throw new IOException("strange order of labels");
                }
                if (line.startsWith("probA")) {
                    probA = Double.parseDouble(line.split("\\s+")[1]);
                    continue;
                }
                if (line.startsWith("probB")) {
                    probB = Double.parseDouble(line.split("\\s+")[1]);
                    continue;
                }
                if (line.startsWith("rho")) {
                    rho = Double.parseDouble(line.split("\\s+")[1]);
                    continue;
                }
                if (!line.startsWith("SV")) continue;
                mode = true;
                continue;
            }
            String[] tokens = line.split("\\s+|:");
            if (tokens.length < 3) continue;
            coefficients[k] = Double.parseDouble(tokens[0]);
            supportVectors[k] = Integer.parseInt(tokens[2]);
            ++k;
        }
        return new Predictor(realIndex, rho, probA, probB, coefficients, supportVectors);
    }

    public void writeModel(BufferedWriter someWriter) throws IOException {
        int k;
        someWriter.write("svm_type c_svc");
        someWriter.newLine();
        someWriter.write("kernel_type precomputed");
        someWriter.newLine();
        someWriter.write("nr_class 2");
        someWriter.newLine();
        someWriter.write("total_sv ");
        someWriter.write(String.valueOf(this.supportVectors.length));
        someWriter.newLine();
        someWriter.write("rho ");
        someWriter.write(String.valueOf(this.rho));
        someWriter.newLine();
        someWriter.write("label 1 -1");
        someWriter.newLine();
        someWriter.write("probA ");
        someWriter.write(String.valueOf(this.probA));
        someWriter.newLine();
        someWriter.write("probB ");
        someWriter.write(String.valueOf(this.probB));
        someWriter.newLine();
        int pos = 0;
        int neg = 0;
        for (k = 0; k < this.coefficients.length; ++k) {
            if (this.coefficients[k] > 0.0) {
                ++pos;
                continue;
            }
            ++neg;
        }
        assert (pos + neg == this.supportVectors.length);
        someWriter.write("nr_svg ");
        someWriter.write(String.valueOf(pos));
        someWriter.write(" ");
        someWriter.write(String.valueOf(neg));
        someWriter.newLine();
        someWriter.write("SV");
        someWriter.newLine();
        for (k = 0; k < this.supportVectors.length; ++k) {
            someWriter.write(String.valueOf(this.coefficients[k]));
            someWriter.write(" 0:");
            someWriter.write(String.valueOf(this.supportVectors[k]));
            someWriter.newLine();
        }
    }

    static double sigmoid_predict(double decision_value, double A, double B) {
        double fApB = decision_value * A + B;
        if (fApB >= 0.0) {
            return Math.exp(-fApB) / (1.0 + Math.exp(-fApB));
        }
        return 1.0 / (1.0 + Math.exp(fApB));
    }
}

