/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import com.google.common.primitives.Ints;
import de.unijena.bioinf.ChemistryBase.chem.InChI;
import de.unijena.bioinf.ChemistryBase.fp.ArrayFingerprint;
import de.unijena.bioinf.ChemistryBase.fp.PredictionPerformance;
import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.fingerid.CrossvalidationResult;
import de.unijena.bioinf.fingerid.OptimizationStrategy;
import de.unijena.bioinf.fingerid.ParameterC;
import de.unijena.bioinf.fingerid.Predictor;
import de.unijena.bioinf.fingerid.TrainResult;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_print_interface;
import libsvm.svm_problem;
import org.libsvm.SVM;

public class Train {
    public static final boolean DONT_USE_SAMPLE_WEIGHTS = true;
    public static final boolean USE_QUADRATIC_ONLY_WITH_HIGHER_ACC = true;
    private static final boolean DEBUG_INFO = false;
    private static final boolean VERBOSE = true;
    protected final boolean[][] fingerprints;
    protected int[] fingerprintIndizes;
    protected final InChI[] compounds;
    protected final int[] crossvalidation;
    protected final double[][] kernelMatrix;
    protected int[] foldSizes;
    protected Predictor[] predictors;
    protected ParameterC[] POSSIBLE_CVALUES;
    protected int defaultC;
    protected ParameterC[] cvaluesPerFingerprint;
    protected OptimizationStrategy optimizationStrategy;
    protected double[] sampleWeights;
    protected int[] sampleStatistics;
    protected WeightMode weightMode;
    private int crossvalFolds;

    public Train(InChI[] compounds, ArrayFingerprint[] fingerprints, double[][] kernelMatrix) {
        this(compounds, Train.tooBooleanArray(fingerprints), kernelMatrix);
    }

    private static boolean[][] tooBooleanArray(ArrayFingerprint[] fingerprints) {
        boolean[][] M = new boolean[fingerprints.length][];
        for (int i = 0; i < fingerprints.length; ++i) {
            M[i] = fingerprints[i].toBooleanArray();
        }
        return M;
    }

    /*
     * WARNING - void declaration
     */
    public Train(InChI[] compounds, boolean[][] fingerprints, double[][] kernelMatrix) {
        void var4_7;
        if (compounds.length == 0 || fingerprints.length == 0 || fingerprints[0].length == 0) {
            throw new IllegalArgumentException("no compounds/fingerprints in training set");
        }
        if (compounds.length != fingerprints.length) {
            throw new IllegalArgumentException("row number of fingerprints matrix differs from number of compounds");
        }
        if (kernelMatrix.length != compounds.length || kernelMatrix[0].length != compounds.length) {
            throw new IllegalArgumentException("size of kernel matrix differs from number of compounds");
        }
        for (Object[] r : fingerprints) {
            if (r.length == fingerprints[0].length) continue;
            throw new IllegalArgumentException("number of fingerprints is varying");
        }
        double[][] dArray = kernelMatrix;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] r;
            r = dArray[i];
            if (r.length == compounds.length) continue;
            throw new IllegalArgumentException("invalid kernel matrix");
        }
        this.compounds = compounds;
        this.fingerprints = fingerprints;
        this.kernelMatrix = kernelMatrix;
        this.crossvalidation = new int[compounds.length];
        this.crossvalFolds = 0;
        this.predictors = new Predictor[fingerprints[0].length];
        this.fingerprintIndizes = new int[fingerprints[0].length];
        this.setCSelections(new double[]{0.03125, 0.5, 1.0, 2.0, 4.0, 8.0, 16.0, 32.0}, ParameterC.GROW.CONSTANT, ParameterC.GROW.LINEAR, ParameterC.GROW.QUADRATIC);
        this.optimizationStrategy = new OptimizationStrategy.ByFScore();
        this.cvaluesPerFingerprint = null;
        this.sampleStatistics = this.makeSampleStatistics();
        boolean bl = false;
        while (var4_7 < fingerprints[0].length) {
            this.fingerprintIndizes[var4_7] = var4_7;
            ++var4_7;
        }
    }

    private int[] makeSampleStatistics() {
        int[] stats = new int[this.fingerprints[0].length];
        for (int k = 0; k < this.fingerprints[0].length; ++k) {
            int counter = 0;
            for (int i = 0; i < this.fingerprints.length; ++i) {
                if (!this.fingerprints[i][k]) continue;
                ++counter;
            }
            stats[k] = counter;
        }
        return stats;
    }

    private PredictionPerformance.Modify extend(PredictionPerformance.Modify perf, boolean[] buffer, int[] compounds, int fingerprint) {
        boolean k = false;
        for (int index : compounds) {
            perf.update(this.fingerprints[index][fingerprint], buffer[index], this.sampleWeights != null ? this.sampleWeights[index] : 1.0);
        }
        return perf;
    }

    public int[] getCrossvalidationFolds() {
        return this.crossvalidation;
    }

    public CrossvalidationResult startCrossvalidation() {
        return this.startCrossvalidation(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrossvalidationResult startCrossvalidation(final CrossvalidationResult.IntermediateResult callback) {
        if (this.crossvalFolds == 0) {
            throw new IllegalStateException("No crossvalidation enabled yet");
        }
        int nthreads = Runtime.getRuntime().availableProcessors();
        final int NWORKERS = Math.min(this.fingerprintIndizes.length, nthreads * 12);
        ExecutorService service = Executors.newFixedThreadPool(nthreads);
        if (this.sampleWeights != null) {
            System.out.println("USE SAMPLE WEIGHTING WITH THE FOLLOWING WEIGHTS:");
            System.out.println(Arrays.toString(this.sampleWeights));
            System.out.println("");
        }
        try {
            this.foldSizes = new int[this.crossvalFolds];
            for (int k = 0; k < this.crossvalidation.length; ++k) {
                int n = this.crossvalidation[k];
                this.foldSizes[n] = this.foldSizes[n] + 1;
            }
            final svm_parameter param = this.defaultParameters();
            final svm_problem problem = this.defineProblem();
            svm.svm_set_print_string_function((svm_print_interface)new svm_print_interface(){

                public void print(String s) {
                }
            });
            SVM.svm_set_print_string_function(new svm_print_interface(){

                public void print(String s) {
                }
            });
            final int M = this.kernelMatrix.length;
            final int N = this.fingerprintIndizes.length;
            Future[] futures = new Future[NWORKERS];
            final PredictionPerformance[] totalResults = new PredictionPerformance[N];
            final svm_problem[] shallow_copies = new svm_problem[NWORKERS];
            for (int i = 0; i < NWORKERS; ++i) {
                shallow_copies[i] = new svm_problem();
            }
            for (int k = 0; k < totalResults.length; ++k) {
                totalResults[k] = new PredictionPerformance();
            }
            final boolean[][] buffer = new boolean[NWORKERS][M];
            final PredictionPerformance[][] cSelPerf = new PredictionPerformance[N][this.POSSIBLE_CVALUES.length];
            for (int k = 0; k < this.POSSIBLE_CVALUES.length; ++k) {
                for (int n = 0; n < N; ++n) {
                    cSelPerf[n][k] = new PredictionPerformance();
                }
            }
            final boolean[][] predictedTransposed = new boolean[N][this.compounds.length];
            final double[][] plattTransposed = new double[N][this.compounds.length];
            final double[][] decisionValuesTransposed = new double[N][this.compounds.length];
            for (int K = 0; K < this.crossvalFolds; ++K) {
                int x;
                int f;
                ParameterC[] cvalues;
                int n = K;
                PredictionPerformance[][] predictionPerformanceArray = cSelPerf;
                int n2 = predictionPerformanceArray.length;
                for (int i = 0; i < n2; ++i) {
                    PredictionPerformance[] r;
                    for (PredictionPerformance rr : r = predictionPerformanceArray[i]) {
                        rr.reset();
                    }
                }
                if (this.cvaluesPerFingerprint != null) {
                    System.out.println("WARNING: parameter C is fixed and not learned by crossvalidation. This speeds up the computation but might lead to biased results. Please repeat a true crossvalidation for the final results you want to report.");
                    cvalues = this.cvaluesPerFingerprint;
                } else {
                    cvalues = new ParameterC[N];
                    int evalSize = this.crossvalFolds - 1;
                    for (int I = 1; I <= evalSize; ++I) {
                        int evalId = (K + I) % this.crossvalFolds;
                        final int[] trainCompounds = this.idsNotFor(n, evalId);
                        final int[] evalCompounds = this.idsFor(evalId);
                        this.setupProblem(problem, trainCompounds);
                        param.probability = 0;
                        for (int ci = 0; ci < this.POSSIBLE_CVALUES.length; ++ci) {
                            final int C_SEL = ci;
                            for (int f2 = 0; f2 < NWORKERS; ++f2) {
                                final int B = f2;
                                futures[f2] = service.submit(new Runnable(){

                                    @Override
                                    public void run() {
                                        svm_problem copyProblem = shallow_copies[B];
                                        svm_parameter copyParam = Train.this.deepCopy(param);
                                        Train.this.shallow_copy(copyProblem, problem);
                                        for (int k = B; k < N; k += NWORKERS) {
                                            PredictionPerformance result = cSelPerf[k][C_SEL];
                                            Train.this.setupFingerprint(k, copyProblem, trainCompounds);
                                            copyParam.C = Train.this.POSSIBLE_CVALUES[C_SEL].setWeightsBySample(Train.this.sampleStatistics[Train.this.fingerprintIndizes[k]], Train.this.compounds.length, copyParam.weight);
                                            svm_model model = SVM.svm_train(copyProblem, copyParam, Train.this.sampleWeights);
                                            Train.this.predict(model, trainCompounds, evalCompounds, buffer[B], null, null);
                                            Train.this.extend(result.modify(), buffer[B], evalCompounds, k).done(result);
                                        }
                                    }
                                });
                            }
                            for (int f2 = 0; f2 < futures.length; ++f2) {
                                try {
                                    if (futures[f2] == null) continue;
                                    futures[f2].get();
                                    continue;
                                }
                                catch (InterruptedException | ExecutionException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            System.out.println("finished C: " + this.POSSIBLE_CVALUES[C_SEL]);
                            System.out.flush();
                        }
                    }
                    for (int k = 0; k < N; ++k) {
                        for (PredictionPerformance r : cSelPerf[k]) {
                            r.calc();
                        }
                        cvalues[k] = this.POSSIBLE_CVALUES[this.chooseBestC(this.POSSIBLE_CVALUES, cSelPerf[k])];
                    }
                }
                final double[][] decision_values = new double[N][M];
                int evalSize = this.crossvalFolds - 1;
                for (int I = 1; I <= evalSize; ++I) {
                    int evalId = (K + I) % this.crossvalFolds;
                    final int[] trainCompounds = this.idsNotFor(n, evalId);
                    final int[] evalCompounds = this.idsFor(evalId);
                    this.setupProblem(problem, trainCompounds);
                    param.probability = 0;
                    for (int f3 = 0; f3 < NWORKERS; ++f3) {
                        final int B = f3;
                        futures[f3] = service.submit(new Runnable(){

                            @Override
                            public void run() {
                                svm_problem copyProblem = shallow_copies[B];
                                svm_parameter copyParam = Train.this.deepCopy(param);
                                Train.this.shallow_copy(copyProblem, problem);
                                for (int k = B; k < N; k += NWORKERS) {
                                    for (PredictionPerformance r : cSelPerf[k]) {
                                        r.calc();
                                    }
                                    copyParam.C = cvalues[k].setWeightsBySample(Train.this.sampleStatistics[Train.this.fingerprintIndizes[k]], Train.this.compounds.length, copyParam.weight);
                                    Train.this.setupFingerprint(k, copyProblem, trainCompounds);
                                    svm_model model = SVM.svm_train(copyProblem, copyParam, Train.this.sampleWeights);
                                    Train.this.predictValues(model, trainCompounds, evalCompounds, decision_values[k]);
                                }
                            }
                        });
                    }
                    for (int f4 = 0; f4 < futures.length; ++f4) {
                        try {
                            if (futures[f4] == null) continue;
                            futures[f4].get();
                            continue;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                final int[] fullset = this.idsNotFor(n);
                final int[] independentSet = this.idsFor(n);
                final double[][] decision_values_train = new double[N][fullset.length];
                for (int i = 0; i < N; ++i) {
                    for (int j = 0; j < fullset.length; ++j) {
                        decision_values_train[i][j] = decision_values[i][fullset[j]];
                    }
                }
                this.setupProblem(problem, fullset);
                param.probability = 0;
                PredictionPerformance[][] i = cSelPerf;
                int j = i.length;
                for (int f4 = 0; f4 < j; ++f4) {
                    PredictionPerformance[] rr;
                    for (PredictionPerformance r : rr = i[f4]) {
                        r.calc();
                    }
                }
                for (int f5 = 0; f5 < N; ++f5) {
                    System.out.println("For " + f5 + " choose C=" + cvalues[f5]);
                }
                final Predictor[] trainedModels = new Predictor[N];
                for (f = 0; f < NWORKERS; ++f) {
                    final int B = f;
                    futures[f] = service.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                svm_parameter p = Train.this.deepCopy(param);
                                svm_problem copyProblem = shallow_copies[B];
                                double[] labels = new double[M];
                                Train.this.shallow_copy(copyProblem, problem);
                                for (int k = B; k < N; k += NWORKERS) {
                                    for (PredictionPerformance r : cSelPerf[k]) {
                                        r.calc();
                                    }
                                    p.C = cvalues[k].setWeightsBySample(Train.this.sampleStatistics[Train.this.fingerprintIndizes[k]], Train.this.compounds.length, p.weight);
                                    Train.this.setupFingerprint(k, copyProblem, fullset);
                                    svm_model model = SVM.svm_train(copyProblem, p, Train.this.sampleWeights);
                                    for (int i = 0; i < fullset.length; ++i) {
                                        labels[i] = Train.this.fingerprints[fullset[i]][Train.this.fingerprintIndizes[k]] ? 1.0 : -1.0;
                                    }
                                    double[] AB = new double[2];
                                    Train.sigmoid_train(fullset.length, decision_values_train[k], labels, AB);
                                    model.probA = new double[]{AB[0]};
                                    model.probB = new double[]{AB[1]};
                                    Train.this.predict(model, fullset, independentSet, predictedTransposed[k], plattTransposed[k], decisionValuesTransposed[k]);
                                    Train.this.extend(totalResults[k].modify(), predictedTransposed[k], independentSet, k).done(totalResults[k]);
                                    if (callback == null) continue;
                                    int[] supportVectors = new int[model.sv_indices.length];
                                    for (int j = 0; j < supportVectors.length; ++j) {
                                        supportVectors[j] = fullset[model.sv_indices[j] - 1] + 1;
                                    }
                                    if (model.sv_coef.length == 0) {
                                        System.out.println("WARNING: cannot predict property " + k);
                                        trainedModels[k] = new Predictor(k, 0.0, 1.0, 0.0, new double[0], new int[0]);
                                        continue;
                                    }
                                    trainedModels[k] = new Predictor(Train.this.fingerprintIndizes[k], model.rho[0], model.probA[0], model.probB[0], model.sv_coef[0], model.sv_indices);
                                }
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                                throw e;
                            }
                        }
                    });
                }
                for (f = 0; f < futures.length; ++f) {
                    try {
                        if (futures[f] == null) continue;
                        futures[f].get();
                        continue;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
                PredictionPerformance total = new PredictionPerformance();
                for (PredictionPerformance a : totalResults) {
                    total.merge(a);
                }
                total.calc();
                System.out.println("Total results so far: " + total.toString());
                System.out.println("finished outer fold " + K);
                System.out.flush();
                if (callback == null) continue;
                InChI[] trainInchis = new InChI[fullset.length];
                InChI[] testInchis = new InChI[independentSet.length];
                boolean[][] testFps = new boolean[independentSet.length][];
                double[][] testPredictions = new double[independentSet.length][N];
                for (x = 0; x < trainInchis.length; ++x) {
                    trainInchis[x] = this.compounds[fullset[x]];
                }
                for (x = 0; x < independentSet.length; ++x) {
                    testInchis[x] = this.compounds[independentSet[x]];
                    testFps[x] = this.fingerprints[independentSet[x]];
                    for (int fpI = 0; fpI < N; ++fpI) {
                        testPredictions[x][fpI] = plattTransposed[fpI][independentSet[x]];
                    }
                }
                callback.run(trainInchis, trainedModels, null, testInchis, testFps, testPredictions);
            }
            for (PredictionPerformance r : totalResults) {
                r.calc();
            }
            PredictionPerformance overall = new PredictionPerformance();
            for (PredictionPerformance r : totalResults) {
                overall.merge(r);
            }
            overall.calc();
            CrossvalidationResult crossvalidationResult = new CrossvalidationResult(overall, totalResults, (int[])this.fingerprintIndizes.clone(), (InChI[])this.compounds.clone(), predictedTransposed, plattTransposed, decisionValuesTransposed);
            return crossvalidationResult;
        }
        finally {
            service.shutdown();
        }
    }

    private svm_parameter deepCopy(svm_parameter param) {
        svm_parameter p = (svm_parameter)param.clone();
        p.weight = (double[])param.weight.clone();
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrainResult startTraining() {
        TrainResult result;
        int nthreads = Runtime.getRuntime().availableProcessors();
        final int NWORKERS = nthreads * 12;
        final Predictor[] predictors = new Predictor[this.fingerprintIndizes.length];
        if (this.crossvalFolds == 0) {
            throw new IllegalStateException("No crossvalidation enabled yet. You need crossvalidation for c selection");
        }
        svm.svm_set_print_string_function((svm_print_interface)new svm_print_interface(){

            public void print(String s) {
            }
        });
        SVM.svm_set_print_string_function(new svm_print_interface(){

            public void print(String s) {
            }
        });
        if (this.fingerprintIndizes.length <= nthreads) {
            TrainResult.Builder resultBuilder = new TrainResult.Builder();
            for (int i = 0; i < this.fingerprintIndizes.length; ++i) {
                resultBuilder.addResult(this.trainSingleFingerprint(i));
            }
            return resultBuilder.done();
        }
        ExecutorService service = Executors.newFixedThreadPool(nthreads);
        final PredictionPerformance[] bestPerformances = new PredictionPerformance[this.fingerprintIndizes.length];
        try {
            int f;
            ParameterC[] cvalues;
            int i;
            this.foldSizes = new int[this.crossvalFolds];
            for (int k = 0; k < this.crossvalidation.length; ++k) {
                int n = this.crossvalidation[k];
                this.foldSizes[n] = this.foldSizes[n] + 1;
            }
            final svm_parameter param = this.defaultParameters();
            final svm_problem problem = this.defineProblem();
            final int M = this.kernelMatrix.length;
            final int N = this.fingerprintIndizes.length;
            Future[] futures = new Future[NWORKERS];
            final svm_problem[] shallow_copies = new svm_problem[NWORKERS];
            for (int i2 = 0; i2 < NWORKERS; ++i2) {
                shallow_copies[i2] = new svm_problem();
            }
            final boolean[][] buffer = new boolean[NWORKERS][M];
            final PredictionPerformance[][] rs = new PredictionPerformance[N][this.POSSIBLE_CVALUES.length];
            for (int k = 0; k < this.POSSIBLE_CVALUES.length; ++k) {
                for (i = 0; i < N; ++i) {
                    rs[i][k] = new PredictionPerformance();
                }
            }
            PredictionPerformance[][] k = rs;
            i = k.length;
            for (int j = 0; j < i; ++j) {
                PredictionPerformance[] r;
                for (PredictionPerformance rr : r = k[j]) {
                    rr.reset();
                }
            }
            if (this.cvaluesPerFingerprint != null) {
                cvalues = this.cvaluesPerFingerprint;
            } else {
                cvalues = new ParameterC[N];
                int evalSize = this.crossvalFolds;
                for (int I = 0; I < evalSize; ++I) {
                    int evalId = I % this.crossvalFolds;
                    final int[] trainCompounds = this.idsNotFor(evalId);
                    final int[] evalCompounds = this.idsFor(evalId);
                    this.setupProblem(problem, trainCompounds);
                    param.probability = 0;
                    for (int ci = 0; ci < this.POSSIBLE_CVALUES.length; ++ci) {
                        int f2;
                        final int C_SEL = ci;
                        for (f2 = 0; f2 < NWORKERS; ++f2) {
                            final int B = f2;
                            futures[f2] = service.submit(new Runnable(){

                                @Override
                                public void run() {
                                    svm_problem copyProblem = shallow_copies[B];
                                    svm_parameter copyParam = Train.this.deepCopy(param);
                                    Train.this.shallow_copy(copyProblem, problem);
                                    for (int k = B; k < N; k += NWORKERS) {
                                        PredictionPerformance result = rs[k][C_SEL];
                                        Train.this.setupFingerprint(k, copyProblem, trainCompounds);
                                        copyParam.C = Train.this.POSSIBLE_CVALUES[C_SEL].setWeightsBySample(Train.this.sampleStatistics[Train.this.fingerprintIndizes[k]], Train.this.compounds.length, copyParam.weight);
                                        svm_model model = SVM.svm_train(copyProblem, copyParam, Train.this.sampleWeights);
                                        Train.this.predict(model, trainCompounds, evalCompounds, buffer[B], null, null);
                                        Train.this.extend(result.modify(), buffer[B], evalCompounds, k).done(result);
                                    }
                                }
                            });
                        }
                        for (f2 = 0; f2 < futures.length; ++f2) {
                            try {
                                if (futures[f2] == null) continue;
                                futures[f2].get();
                                continue;
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        System.out.println("fold " + I + " / " + this.crossvalFolds);
                    }
                }
                for (int k2 = 0; k2 < N; ++k2) {
                    for (PredictionPerformance r : rs[k2]) {
                        r.calc();
                    }
                    int bestchoice = this.chooseBestC(this.POSSIBLE_CVALUES, rs[k2]);
                    cvalues[k2] = this.POSSIBLE_CVALUES[bestchoice];
                    System.out.println("for fingerprint " + this.fingerprintIndizes[k2] + " choose " + cvalues[k2] + " with " + rs[k2][bestchoice]);
                    bestPerformances[k2] = rs[k2][bestchoice];
                }
            }
            final double[][] decisionValues = new double[N][M];
            int evalSize = this.crossvalFolds;
            for (int I = 0; I < evalSize; ++I) {
                int f3;
                int evalId = I % this.crossvalFolds;
                final int[] trainCompounds = this.idsNotFor(evalId);
                final int[] evalCompounds = this.idsFor(evalId);
                this.setupProblem(problem, trainCompounds);
                param.probability = 0;
                for (f3 = 0; f3 < NWORKERS; ++f3) {
                    final int B = f3;
                    futures[f3] = service.submit(new Runnable(){

                        @Override
                        public void run() {
                            svm_problem copyProblem = shallow_copies[B];
                            svm_parameter paramCopy = Train.this.deepCopy(param);
                            Train.this.shallow_copy(copyProblem, problem);
                            for (int k = B; k < N; k += NWORKERS) {
                                paramCopy.C = cvalues[k].setWeightsBySample(Train.this.sampleStatistics[Train.this.fingerprintIndizes[k]], Train.this.compounds.length, paramCopy.weight);
                                Train.this.setupFingerprint(k, copyProblem, trainCompounds);
                                svm_model model = SVM.svm_train(copyProblem, paramCopy, Train.this.sampleWeights);
                                Train.this.predictValues(model, trainCompounds, evalCompounds, decisionValues[k]);
                            }
                        }
                    });
                }
                for (f3 = 0; f3 < futures.length; ++f3) {
                    try {
                        if (futures[f3] == null) continue;
                        futures[f3].get();
                        continue;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            param.probability = 0;
            final int[] allIds = new int[this.compounds.length];
            for (int k3 = 0; k3 < allIds.length; ++k3) {
                allIds[k3] = k3;
            }
            this.setupProblem(problem, allIds);
            for (f = 0; f < NWORKERS; ++f) {
                final int B = f;
                futures[f] = service.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] labels = new double[M];
                        svm_problem copyProblem = shallow_copies[B];
                        svm_parameter paramCopy = Train.this.deepCopy(param);
                        Train.this.shallow_copy(copyProblem, problem);
                        for (int k = B; k < N; k += NWORKERS) {
                            Predictor predictor;
                            for (int j = 0; j < labels.length; ++j) {
                                labels[j] = Train.this.fingerprints[j][k] ? 1.0 : -1.0;
                            }
                            Train.this.setupFingerprint(k, copyProblem, allIds);
                            paramCopy.C = cvalues[k].setWeightsBySample(Train.this.sampleStatistics[Train.this.fingerprintIndizes[k]], Train.this.compounds.length, paramCopy.weight);
                            svm_model model = SVM.svm_train(copyProblem, paramCopy, Train.this.sampleWeights);
                            int[] supportVectors = new int[model.sv_indices.length];
                            for (int j = 0; j < supportVectors.length; ++j) {
                                supportVectors[j] = allIds[model.sv_indices[j] - 1] + 1;
                            }
                            double[] AB = new double[2];
                            Train.sigmoid_train(decisionValues[k].length, decisionValues[k], labels, AB);
                            if (model.sv_coef.length == 0) {
                                System.out.println("WARNING: cannot predict property " + k);
                                predictor = new Predictor(k, 0.0, 1.0, 0.0, new double[0], new int[0]);
                            } else {
                                predictor = new Predictor(k, model.rho[0], AB[0], AB[1], model.sv_coef[0], supportVectors);
                            }
                            predictor.setStatistics(bestPerformances[k] == null ? new PredictionPerformance(0.0, 0.0, 0.0, 0.0) : bestPerformances[k]);
                            predictor.setParameterC(cvalues[k]);
                            predictors[k] = predictor;
                        }
                    }
                });
            }
            for (f = 0; f < futures.length; ++f) {
                try {
                    if (futures[f] == null) continue;
                    futures[f].get();
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            result = new TrainResult(predictors, cvalues);
            result.setDecisionValues(decisionValues);
        }
        finally {
            service.shutdown();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterC[] learnC() {
        ParameterC[] cs = new ParameterC[this.fingerprintIndizes.length];
        if (this.crossvalFolds == 0) {
            throw new IllegalStateException("No crossvalidation enabled yet. You need crossvalidation for c selection");
        }
        int nthreads = Runtime.getRuntime().availableProcessors();
        final int NWORKERS = nthreads * 12;
        ExecutorService service = Executors.newFixedThreadPool(nthreads);
        try {
            int i;
            this.foldSizes = new int[this.crossvalFolds];
            for (int k = 0; k < this.crossvalidation.length; ++k) {
                int n = this.crossvalidation[k];
                this.foldSizes[n] = this.foldSizes[n] + 1;
            }
            final svm_parameter param = this.defaultParameters();
            final svm_problem problem = this.defineProblem();
            svm.svm_set_print_string_function((svm_print_interface)new svm_print_interface(){

                public void print(String s) {
                }
            });
            SVM.svm_set_print_string_function(new svm_print_interface(){

                public void print(String s) {
                }
            });
            int M = this.kernelMatrix.length;
            final int N = this.fingerprintIndizes.length;
            Future[] futures = new Future[NWORKERS];
            final svm_problem[] shallow_copies = new svm_problem[NWORKERS];
            for (int i2 = 0; i2 < NWORKERS; ++i2) {
                shallow_copies[i2] = new svm_problem();
            }
            final boolean[][] buffer = new boolean[NWORKERS][M];
            final PredictionPerformance[][] rs = new PredictionPerformance[N][this.POSSIBLE_CVALUES.length];
            for (int k = 0; k < this.POSSIBLE_CVALUES.length; ++k) {
                for (i = 0; i < N; ++i) {
                    rs[i][k] = new PredictionPerformance();
                }
            }
            PredictionPerformance[][] k = rs;
            i = k.length;
            for (int j = 0; j < i; ++j) {
                PredictionPerformance[] r;
                for (PredictionPerformance rr : r = k[j]) {
                    rr.reset();
                }
            }
            int evalSize = this.crossvalFolds;
            for (int I = 0; I < evalSize; ++I) {
                int evalId = I % this.crossvalFolds;
                final int[] trainCompounds = this.idsNotFor(evalId);
                final int[] evalCompounds = this.idsFor(evalId);
                this.setupProblem(problem, trainCompounds);
                param.probability = 0;
                for (int ci = 0; ci < this.POSSIBLE_CVALUES.length; ++ci) {
                    int f;
                    final int C_SEL = ci;
                    for (f = 0; f < NWORKERS; ++f) {
                        final int B = f;
                        futures[f] = service.submit(new Runnable(){

                            @Override
                            public void run() {
                                svm_problem copyProblem = shallow_copies[B];
                                svm_parameter copyParam = Train.this.deepCopy(param);
                                Train.this.shallow_copy(copyProblem, problem);
                                for (int k = B; k < N; k += NWORKERS) {
                                    PredictionPerformance result = rs[k][C_SEL];
                                    copyParam.C = Train.this.POSSIBLE_CVALUES[C_SEL].setWeightsBySample(Train.this.sampleStatistics[Train.this.fingerprintIndizes[k]], Train.this.compounds.length, param.weight);
                                    Train.this.setupFingerprint(k, copyProblem, trainCompounds);
                                    svm_model model = SVM.svm_train(copyProblem, param, Train.this.sampleWeights);
                                    Train.this.predict(model, trainCompounds, evalCompounds, buffer[B], null, null);
                                    Train.this.extend(result.modify(), buffer[B], evalCompounds, k).done(result);
                                }
                            }
                        });
                    }
                    for (f = 0; f < futures.length; ++f) {
                        try {
                            if (futures[f] == null) continue;
                            futures[f].get();
                            continue;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    System.out.println(this.POSSIBLE_CVALUES[C_SEL] + " done");
                    System.out.flush();
                }
                System.out.println(I + "-fold done");
                System.out.flush();
            }
            for (int i3 = 0; i3 < rs.length; ++i3) {
                for (PredictionPerformance p : rs[i3]) {
                    p.calc();
                }
                cs[i3] = this.POSSIBLE_CVALUES[this.chooseBestC(this.POSSIBLE_CVALUES, rs[i3])];
            }
            ParameterC[] parameterCArray = cs;
            return parameterCArray;
        }
        finally {
            service.shutdown();
        }
    }

    public void setCForFingerprints(ParameterC[] cs) {
        if (cs == null) {
            this.cvaluesPerFingerprint = null;
        } else {
            if (cs.length != this.fingerprintIndizes.length) {
                throw new RuntimeException("Need a c value for each fingerprint.");
            }
            if (this.cvaluesPerFingerprint == null || this.cvaluesPerFingerprint.length < this.fingerprints[0].length) {
                this.cvaluesPerFingerprint = new ParameterC[this.fingerprints[0].length];
                for (int i = 0; i < cs.length; ++i) {
                    this.cvaluesPerFingerprint[this.fingerprintIndizes[i]] = cs[i];
                }
            } else {
                this.cvaluesPerFingerprint = (ParameterC[])cs.clone();
            }
        }
    }

    public void setSampleWeightMode(WeightMode mode, FTree[] correspondingTrees) {
        this.weightMode = mode;
        if (mode == WeightMode.UNIT) {
            this.sampleWeights = null;
            return;
        }
        this.sampleWeights = new double[this.compounds.length];
        Arrays.fill(this.sampleWeights, 1.0);
        switch (mode) {
            case DOWNRATE_DUPLICATES: {
                this.downrateDuplicates();
                break;
            }
            case SIZE_DEPENDENT: {
                this.uprateLargeTrees(correspondingTrees);
                break;
            }
            case DOWNRATE_DUPLICATES_SIZE_DEPENDENT: {
                this.uprateLargeTrees(correspondingTrees);
                this.downrateDuplicates();
            }
        }
        System.out.println(Arrays.toString(this.sampleWeights));
    }

    private void uprateLargeTrees(FTree[] correspondingTrees) {
        for (int k = 0; k < this.compounds.length; ++k) {
            FTree tree = correspondingTrees[k];
            this.sampleWeights[k] = Math.log(tree.numberOfVertices());
        }
    }

    private void downrateDuplicates() {
        int k;
        TObjectDoubleHashMap groupSize = new TObjectDoubleHashMap();
        for (k = 0; k < this.compounds.length; ++k) {
            double weight = this.sampleWeights[k];
            String key = this.compounds[k].key2D();
            groupSize.adjustOrPutValue((Object)key, weight, weight);
        }
        k = 0;
        while (k < this.compounds.length) {
            String key = this.compounds[k].key2D();
            double weightsum = groupSize.get((Object)key);
            int n = k++;
            this.sampleWeights[n] = this.sampleWeights[n] / weightsum;
        }
    }

    public void restrictToFingerprints(int[] indizes) {
        this.fingerprintIndizes = (int[])indizes.clone();
    }

    public void setCSelections(ParameterC[] possible, int defaultC) {
        this.setCSelections(possible);
        this.defaultC = defaultC;
    }

    public void setCSelections(ParameterC[] possible) {
        this.POSSIBLE_CVALUES = (ParameterC[])possible.clone();
        this.defaultC = -1;
        int k = 0;
        for (ParameterC c : this.POSSIBLE_CVALUES) {
            if (c.value == 1.0 && (this.defaultC < 0 || c.bias == ParameterC.GROW.CONSTANT)) {
                this.defaultC = k;
            }
            ++k;
        }
        if (this.defaultC < 0) {
            this.defaultC = 0;
        }
    }

    public void setCSelections(double[] weights, ParameterC.GROW ... modes) {
        this.setCSelections(ParameterC.combinations(weights, modes));
    }

    public OptimizationStrategy getOptimizationStrategy() {
        return this.optimizationStrategy;
    }

    public void setOptimizationStrategy(OptimizationStrategy optimizationStrategy) {
        this.optimizationStrategy = optimizationStrategy;
    }

    public void sequentialCrossvalidation(int folds) {
        this.crossvalFolds = folds;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int tagging = 0;
        for (int k = 0; k < this.compounds.length; ++k) {
            String inchi = this.compounds[k].key2D();
            if (map.containsKey(inchi)) {
                this.crossvalidation[k] = (Integer)map.get(inchi);
                continue;
            }
            this.crossvalidation[k] = tagging++;
            map.put(inchi, this.crossvalidation[k]);
            tagging %= this.crossvalFolds;
        }
    }

    public void setCrossvalidationBatches(int[] batchNumbers) {
        this.crossvalFolds = Ints.max((int[])batchNumbers) + 1;
        for (int i = 0; i < this.crossvalidation.length; ++i) {
            int batch;
            this.crossvalidation[i] = batch = batchNumbers[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrainResult trainSingleFingerprint(final int relativeFingerprintIndex) {
        System.out.println("TRAIN SINGLE FINGERPRINT: " + this.fingerprintIndizes[relativeFingerprintIndex] + " with " + this.sampleStatistics[this.fingerprintIndizes[relativeFingerprintIndex]] + " positive samples");
        if (this.crossvalFolds == 0) {
            throw new IllegalStateException("No crossvalidation enabled yet. You need crossvalidation for c selection");
        }
        int nthreads = Runtime.getRuntime().availableProcessors();
        ExecutorService service = Executors.newFixedThreadPool(nthreads);
        PredictionPerformance performance = new PredictionPerformance();
        try {
            Predictor predictor;
            ParameterC cvalue;
            this.foldSizes = new int[this.crossvalFolds];
            for (int k = 0; k < this.crossvalidation.length; ++k) {
                int n = this.crossvalidation[k];
                this.foldSizes[n] = this.foldSizes[n] + 1;
            }
            final svm_parameter param = this.defaultParameters();
            final svm_problem problem = this.defineProblem();
            SVM.svm_set_print_string_function(new svm_print_interface(){

                public void print(String s) {
                }
            });
            final int M = this.kernelMatrix.length;
            int N = this.fingerprintIndizes.length;
            final PredictionPerformance[] rs = new PredictionPerformance[this.POSSIBLE_CVALUES.length];
            Future[] futures = new Future[this.POSSIBLE_CVALUES.length];
            for (int k = 0; k < this.POSSIBLE_CVALUES.length; ++k) {
                rs[k] = new PredictionPerformance();
            }
            if (this.cvaluesPerFingerprint != null) {
                cvalue = this.cvaluesPerFingerprint[this.fingerprintIndizes[relativeFingerprintIndex]];
            } else {
                int evalSize = this.crossvalFolds;
                for (int I = 0; I < evalSize; ++I) {
                    int evalId = I % this.crossvalFolds;
                    final int[] trainCompounds = this.idsNotFor(evalId);
                    final int[] evalCompounds = this.idsFor(evalId);
                    this.setupProblem(problem, trainCompounds);
                    param.probability = 0;
                    for (int ci = 0; ci < this.POSSIBLE_CVALUES.length; ++ci) {
                        final int C_SEL = ci;
                        futures[ci] = service.submit(new Runnable(){

                            @Override
                            public void run() {
                                svm_problem copy_problem = Train.this.shallow_copy(problem);
                                svm_parameter copyParam = Train.this.deepCopy(param);
                                PredictionPerformance result = rs[C_SEL];
                                boolean[] buffer = new boolean[M];
                                Train.this.setupFingerprint(relativeFingerprintIndex, copy_problem, trainCompounds);
                                copyParam.C = Train.this.POSSIBLE_CVALUES[C_SEL].setWeightsBySample(Train.this.sampleStatistics[Train.this.fingerprintIndizes[relativeFingerprintIndex]], Train.this.compounds.length, copyParam.weight);
                                svm_model model = SVM.svm_train(copy_problem, copyParam, Train.this.sampleWeights);
                                Train.this.predict(model, trainCompounds, evalCompounds, buffer, null, null);
                                Train.this.extend(result.modify(), buffer, evalCompounds, relativeFingerprintIndex).done(result);
                            }
                        });
                    }
                    for (int f = 0; f < futures.length; ++f) {
                        try {
                            if (futures[f] == null) continue;
                            futures[f].get();
                            continue;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                for (PredictionPerformance r : rs) {
                    r.calc();
                }
                for (int k = 0; k < rs.length; ++k) {
                    System.out.println(this.fingerprintIndizes[relativeFingerprintIndex] + ": c = " + this.POSSIBLE_CVALUES[k] + " results into \t" + rs[k].toString());
                }
                int bestCIndex = this.chooseBestC(this.POSSIBLE_CVALUES, rs);
                cvalue = this.POSSIBLE_CVALUES[bestCIndex];
                System.out.println("For " + this.fingerprintIndizes[relativeFingerprintIndex] + " choose " + cvalue + " with \t" + rs[bestCIndex].toString());
                performance = rs[bestCIndex];
            }
            double[][] decisionValues = new double[N][M];
            int evalSize = this.crossvalFolds;
            for (int I = 0; I < evalSize; ++I) {
                int evalId = I % this.crossvalFolds;
                int[] trainCompounds = this.idsNotFor(evalId);
                int[] evalCompounds = this.idsFor(evalId);
                this.setupProblem(problem, trainCompounds);
                param.probability = 0;
                param.C = cvalue.setWeightsBySample(this.sampleStatistics[this.fingerprintIndizes[relativeFingerprintIndex]], this.compounds.length, param.weight);
                this.setupFingerprint(relativeFingerprintIndex, problem, trainCompounds);
                svm_model model = SVM.svm_train(problem, param, this.sampleWeights);
                this.predictValues(model, trainCompounds, evalCompounds, decisionValues[relativeFingerprintIndex]);
            }
            param.probability = 0;
            int[] allIds = new int[this.compounds.length];
            for (int k = 0; k < allIds.length; ++k) {
                allIds[k] = k;
            }
            this.setupProblem(problem, allIds);
            double[] labels = new double[M];
            for (int j = 0; j < labels.length; ++j) {
                labels[j] = this.fingerprints[j][relativeFingerprintIndex] ? 1.0 : -1.0;
            }
            this.setupFingerprint(relativeFingerprintIndex, problem, allIds);
            param.C = cvalue.setWeightsBySample(this.sampleStatistics[this.fingerprintIndizes[relativeFingerprintIndex]], this.compounds.length, param.weight);
            svm_model model = SVM.svm_train(problem, param, this.sampleWeights);
            int[] supportVectors = new int[model.sv_indices.length];
            for (int j = 0; j < supportVectors.length; ++j) {
                supportVectors[j] = allIds[model.sv_indices[j] - 1] + 1;
            }
            double[] AB = new double[2];
            Train.sigmoid_train(decisionValues[relativeFingerprintIndex].length, decisionValues[relativeFingerprintIndex], labels, AB);
            if (model.sv_coef.length == 0) {
                System.out.println("WARNING: cannot predict property " + relativeFingerprintIndex);
                predictor = new Predictor(relativeFingerprintIndex, 0.0, 1.0, 0.0, new double[0], new int[0]);
            } else {
                predictor = new Predictor(relativeFingerprintIndex, model.rho[0], AB[0], AB[1], model.sv_coef[0], supportVectors);
            }
            predictor.setStatistics(performance);
            TrainResult trainResult = new TrainResult(new Predictor[]{predictor}, new ParameterC[]{cvalue});
            return trainResult;
        }
        finally {
            service.shutdown();
        }
    }

    public int chooseBestC(ParameterC[] cs, PredictionPerformance[] performances) {
        int bestConstant = this.defaultC;
        int bestWeighted = -1;
        for (int k = 0; k < cs.length; ++k) {
            if (cs[k].bias != ParameterC.GROW.CONSTANT) continue;
            if (bestConstant < 0) {
                bestConstant = k;
                continue;
            }
            if (this.optimizationStrategy.getComparator().compare(performances[bestConstant], performances[k]) >= 0) continue;
            bestConstant = k;
        }
        if (bestConstant < 0) {
            return this.optimizationStrategy.bestChoice(performances, this.defaultC);
        }
        double minaccuracy = performances[bestConstant].getAccuracy();
        for (int k = 0; k < cs.length; ++k) {
            if (cs[k].bias == ParameterC.GROW.CONSTANT || !(performances[k].getAccuracy() >= minaccuracy)) continue;
            if (bestWeighted < 0) {
                bestWeighted = k;
                continue;
            }
            if (this.optimizationStrategy.getComparator().compare(performances[bestWeighted], performances[k]) >= 0) continue;
            bestWeighted = k;
        }
        if (bestWeighted < 0) {
            return bestConstant;
        }
        if (this.optimizationStrategy.getComparator().compare(performances[bestConstant], performances[bestWeighted]) >= 0) {
            return bestConstant;
        }
        return bestWeighted;
    }

    public void randomizedCrossValidation(long seed, int folds) {
        int k;
        this.crossvalFolds = folds;
        Random r = new Random(seed);
        HashMap<String, Integer> tagging = new HashMap<String, Integer>();
        ArrayList keys = new ArrayList(tagging.keySet());
        Integer ZERO = 0;
        for (int k2 = 0; k2 < this.compounds.length; ++k2) {
            if (tagging.put(this.compounds[k2].in2D, ZERO) != null) continue;
            keys.add(this.compounds[k2].in2D);
        }
        ArrayList<Integer> randomTags = new ArrayList<Integer>();
        for (k = 0; k < tagging.size(); ++k) {
            randomTags.add(k % folds);
        }
        Collections.shuffle(randomTags, r);
        for (k = 0; k < tagging.size(); ++k) {
            tagging.put((String)keys.get(k), (Integer)randomTags.get(k));
        }
        for (k = 0; k < this.crossvalidation.length; ++k) {
            this.crossvalidation[k] = (Integer)tagging.get(this.compounds[k].in2D);
        }
    }

    private void setupFingerprint(int f, svm_problem problem, int[] ids) {
        for (int k = 0; k < problem.l; ++k) {
            problem.y[k] = this.fingerprints[ids[k]][this.fingerprintIndizes[f]] ? 1.0 : -1.0;
        }
    }

    private void shallow_copy(svm_problem copy, svm_problem original) {
        copy.x = original.x;
        if (copy.y != null && copy.y.length == original.y.length) {
            System.arraycopy(original.y, 0, copy.y, 0, original.y.length);
        } else {
            copy.y = (double[])original.y.clone();
        }
        copy.l = original.l;
    }

    private svm_problem shallow_copy(svm_problem original) {
        svm_problem problem = new svm_problem();
        this.shallow_copy(problem, original);
        return problem;
    }

    private void predict(svm_model model, int[] trainCompounds, int[] evalCompounds, boolean[] vector, double[] platts, double[] decisionValues) {
        if (model.nSV[0] == 0) {
            for (int k = 0; k < evalCompounds.length; ++k) {
                vector[evalCompounds[k]] = model.label[0] > 0;
            }
            return;
        }
        double[] coefficients = model.sv_coef[0];
        int[] supportVectors = model.sv_indices;
        for (int j = 0; j < evalCompounds.length; ++j) {
            int eval = evalCompounds[j];
            double sum = 0.0;
            for (int i = 0; i < supportVectors.length; ++i) {
                sum += coefficients[i] * this.kernelMatrix[eval][trainCompounds[supportVectors[i] - 1]];
            }
            boolean bl = vector[eval] = (sum -= model.rho[0]) > 0.0;
            if (platts != null) {
                double platt;
                double min_prob = 1.0E-7;
                platts[eval] = platt = Math.max(1.0E-7, Math.min(0.9999999, Predictor.sigmoid_predict(sum, model.probA[0], model.probB[0])));
            }
            if (decisionValues == null) continue;
            decisionValues[eval] = sum;
        }
    }

    private void predictValues(svm_model model, int[] trainCompounds, int[] evalCompounds, double[] decisionValues) {
        if (model.nSV[0] == 0) {
            for (int k = 0; k < evalCompounds.length; ++k) {
                decisionValues[evalCompounds[k]] = model.label[0] > 0 ? 1.0 : -1.0;
            }
            return;
        }
        double[] coefficients = model.sv_coef[0];
        int[] supportVectors = model.sv_indices;
        for (int j = 0; j < evalCompounds.length; ++j) {
            int eval = evalCompounds[j];
            double sum = 0.0;
            for (int i = 0; i < supportVectors.length; ++i) {
                sum += coefficients[i] * this.kernelMatrix[eval][trainCompounds[supportVectors[i] - 1]];
            }
            decisionValues[eval] = sum -= model.rho[0];
        }
    }

    private svm_problem defineProblem() {
        svm_problem p = new svm_problem();
        p.l = this.compounds.length;
        p.x = new svm_node[p.l][p.l + 2];
        p.y = new double[p.l];
        for (int i = 0; i < p.x.length; ++i) {
            for (int j = 0; j < p.x[i].length; ++j) {
                p.x[i][j] = new svm_node();
                p.x[i][j].index = j;
            }
        }
        return p;
    }

    private int[] idsFor(int fold) {
        int[] compoundIds = new int[this.foldSizes[fold]];
        int k = 0;
        for (int i = 0; i < this.crossvalidation.length; ++i) {
            if (this.crossvalidation[i] != fold) continue;
            compoundIds[k++] = i;
        }
        return compoundIds;
    }

    private int[] idsNotFor(int fold) {
        int[] compoundIds = new int[this.compounds.length - this.foldSizes[fold]];
        int k = 0;
        for (int i = 0; i < this.crossvalidation.length; ++i) {
            if (this.crossvalidation[i] == fold) continue;
            compoundIds[k++] = i;
        }
        return compoundIds;
    }

    private int[] idsNotFor(int foldA, int foldB) {
        int[] compoundIds = new int[this.compounds.length - this.foldSizes[foldA] - this.foldSizes[foldB]];
        int k = 0;
        for (int i = 0; i < this.crossvalidation.length; ++i) {
            if (this.crossvalidation[i] == foldA || this.crossvalidation[i] == foldB) continue;
            compoundIds[k++] = i;
        }
        return compoundIds;
    }

    private void setupProblem(svm_problem problem, int[] ids) {
        problem.l = ids.length;
        for (int i = 0; i < ids.length; ++i) {
            problem.x[i][0].value = i + 1;
            for (int j = 0; j < ids.length; ++j) {
                svm_node node = problem.x[i][j + 1];
                node.value = this.kernelMatrix[ids[i]][ids[j]];
                node.index = j + 1;
            }
            problem.x[i][ids.length + 1].index = -1;
        }
    }

    private svm_parameter defaultParameters() {
        svm_parameter param = new svm_parameter();
        param.svm_type = 0;
        param.kernel_type = 4;
        param.degree = 3;
        param.gamma = 0.0;
        param.coef0 = 0.0;
        param.nu = 0.5;
        param.cache_size = 100.0;
        param.C = 1.0;
        param.eps = 0.001;
        param.p = 0.1;
        param.shrinking = 1;
        param.probability = 0;
        param.weight_label = new int[]{1, -1};
        param.weight = new double[]{1.0, 1.0};
        param.nr_weight = param.weight.length;
        return param;
    }

    private static void fingerprintStats(svm_problem copyProblem) {
        int pos = 0;
        int neg = 0;
        for (int k = 0; k < copyProblem.l; ++k) {
            if (copyProblem.y[k] > 0.0) {
                ++pos;
                continue;
            }
            ++neg;
        }
        System.out.println("positive examples: " + pos + "\tnegative examples: " + neg);
    }

    public static void sigmoid_train(int l, double[] dec_values, double[] labels, double[] probAB) {
        double fApB;
        int i;
        double prior1 = 0.0;
        double prior0 = 0.0;
        for (i = 0; i < l; ++i) {
            if (labels[i] > 0.0) {
                prior1 += 1.0;
                continue;
            }
            prior0 += 1.0;
        }
        int max_iter = 100;
        double min_step = 1.0E-10;
        double sigma = 1.0E-12;
        double eps = 1.0E-5;
        double hiTarget = (prior1 + 1.0) / (prior1 + 2.0);
        double loTarget = 1.0 / (prior0 + 2.0);
        double[] t = new double[l];
        double A = 0.0;
        double B = Math.log((prior0 + 1.0) / (prior1 + 1.0));
        double fval = 0.0;
        for (i = 0; i < l; ++i) {
            t[i] = labels[i] > 0.0 ? hiTarget : loTarget;
            fApB = dec_values[i] * A + B;
            if (fApB >= 0.0) {
                fval += t[i] * fApB + Math.log(1.0 + Math.exp(-fApB));
                continue;
            }
            fval += (t[i] - 1.0) * fApB + Math.log(1.0 + Math.exp(fApB));
        }
        for (int iter = 0; iter < max_iter; ++iter) {
            double stepsize;
            double h11 = sigma;
            double h22 = sigma;
            double h21 = 0.0;
            double g1 = 0.0;
            double g2 = 0.0;
            for (i = 0; i < l; ++i) {
                double q;
                double p;
                fApB = dec_values[i] * A + B;
                if (fApB >= 0.0) {
                    p = Math.exp(-fApB) / (1.0 + Math.exp(-fApB));
                    q = 1.0 / (1.0 + Math.exp(-fApB));
                } else {
                    p = 1.0 / (1.0 + Math.exp(fApB));
                    q = Math.exp(fApB) / (1.0 + Math.exp(fApB));
                }
                double d2 = p * q;
                h11 += dec_values[i] * dec_values[i] * d2;
                h22 += d2;
                h21 += dec_values[i] * d2;
                double d1 = t[i] - p;
                g1 += dec_values[i] * d1;
                g2 += d1;
            }
            if (Math.abs(g1) < eps && Math.abs(g2) < eps) break;
            double det = h11 * h22 - h21 * h21;
            double dA = -(h22 * g1 - h21 * g2) / det;
            double dB = -(-h21 * g1 + h11 * g2) / det;
            double gd = g1 * dA + g2 * dB;
            for (stepsize = 1.0; stepsize >= min_step; stepsize /= 2.0) {
                double newA = A + stepsize * dA;
                double newB = B + stepsize * dB;
                double newf = 0.0;
                for (i = 0; i < l; ++i) {
                    fApB = dec_values[i] * newA + newB;
                    if (fApB >= 0.0) {
                        newf += t[i] * fApB + Math.log(1.0 + Math.exp(-fApB));
                        continue;
                    }
                    newf += (t[i] - 1.0) * fApB + Math.log(1.0 + Math.exp(fApB));
                }
                if (!(newf < fval + 1.0E-4 * stepsize * gd)) continue;
                A = newA;
                B = newB;
                fval = newf;
                break;
            }
            if (stepsize < min_step) break;
        }
        probAB[0] = A;
        probAB[1] = B;
    }

    private static double sigmoid_predict(double decision_value, double A, double B) {
        double fApB = decision_value * A + B;
        if (fApB >= 0.0) {
            return Math.exp(-fApB) / (1.0 + Math.exp(-fApB));
        }
        return 1.0 / (1.0 + Math.exp(fApB));
    }

    public static enum WeightMode {
        UNIT,
        DOWNRATE_DUPLICATES,
        SIZE_DEPENDENT,
        DOWNRATE_DUPLICATES_SIZE_DEPENDENT;

    }
}

