/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import de.unijena.bioinf.ChemistryBase.chem.Element;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.chem.PeriodicTable;
import de.unijena.bioinf.ChemistryBase.fp.PredictionPerformance;
import de.unijena.bioinf.fingerid.OptimizationStrategy;
import de.unijena.bioinf.fingerid.Predictor;
import gnu.trove.list.array.TShortArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_print_interface;
import libsvm.svm_problem;

public class TrainCompoundClasses
implements Closeable {
    private static final boolean DEBUG = true;
    private static final String[] ELEMENTS = new String[]{"C", "H", "N", "O", "P", "S", "Cl", "Br", "I", "F"};
    private static final double[] ELEM_WEIGHTS = new double[]{60.0, 80.0, 12.0, 20.0, 3.0, 3.0, 3.0, 2.0, 1.0, 5.0};
    private static final Element[] ELEMENT_ARY = new Element[ELEMENTS.length];
    private static final int ADDITIONAL_FINGERPRINTS = ELEMENTS.length + 1;
    private int numberOfCs = 5;
    private int minDegree = 1;
    private int maxDegree = 2;
    private int minCoef = 0;
    private int maxCoef = 1;
    static final svm_node FINAL_NODE = new svm_node();
    private static final int FOLDS = 5;
    private ExecutorService service;
    private int[] usedIndizes;
    private PredictionPerformance[] fingerprintPerformance;
    private svm_node[] NODE_POOL;
    private List<Compound> seed;
    private List<Compound> pool;
    private List<Compound> trainingSet;
    private List<Compound> evaluationSet;
    private final double[] WEIGHT = new double[2];
    private final int[] WEIGHT_LABEL = new int[]{1, -1};
    private double[] weighting;
    private File outputDir = new File(".");
    private final Element[] elements = new Element[ELEMENTS.length];
    private final int FEATURES;

    private double[] getAdditionalFingerprintsFor(Compound c) {
        return TrainCompoundClasses.getAdditionalFingerprintsFor(c.formula);
    }

    public static double[] getAdditionalFingerprintsFor(MolecularFormula f) {
        int i;
        double[] FP = new double[ADDITIONAL_FINGERPRINTS];
        if (ELEMENT_ARY[0] == null) {
            PeriodicTable pt = PeriodicTable.getInstance();
            for (i = 0; i < ELEMENT_ARY.length; ++i) {
                TrainCompoundClasses.ELEMENT_ARY[i] = pt.getByName(ELEMENTS[i]);
            }
        }
        int k = 0;
        for (i = 0; i < ELEMENT_ARY.length; ++i) {
            FP[k++] = (double)f.numberOf(ELEMENT_ARY[i]) / ELEM_WEIGHTS[i];
        }
        FP[k++] = f.getMass() / 1000.0;
        return FP;
    }

    @Override
    public void close() throws IOException {
        this.service.shutdown();
    }

    public int getNumberOfCs() {
        return this.numberOfCs;
    }

    public void setNumberOfCs(int numberOfCs) {
        this.numberOfCs = numberOfCs;
    }

    public int getMinDegree() {
        return this.minDegree;
    }

    public void setMinDegree(int minDegree) {
        this.minDegree = minDegree;
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public void setMaxDegree(int maxDegree) {
        this.maxDegree = maxDegree;
    }

    public int getMinCoef() {
        return this.minCoef;
    }

    public void setMinCoef(int minCoef) {
        this.minCoef = minCoef;
    }

    public int getMaxCoef() {
        return this.maxCoef;
    }

    public void setMaxCoef(int maxCoef) {
        this.maxCoef = maxCoef;
    }

    public void removeDuplicateEntries() {
        TrainCompoundClasses.removeDuplicates(Arrays.asList(this.seed, this.pool));
    }

    public static void removeDuplicates(List<List<Compound>> compounds) {
        HashSet<CFingerprint> map = new HashSet<CFingerprint>();
        int count = 0;
        for (List<Compound> alist : compounds) {
            ListIterator<Compound> citer = alist.listIterator();
            while (citer.hasNext()) {
                Compound c = citer.next();
                CFingerprint fc = new CFingerprint(c);
                if (map.contains(fc)) {
                    citer.remove();
                    ++count;
                    continue;
                }
                map.add(fc);
            }
        }
        System.out.println("Remove " + count + " duplicate entries");
    }

    public void setWeighting(double[] weights) {
        this.weighting = weights;
        int i = 0;
        for (int k : this.usedIndizes) {
            this.NODE_POOL[k].value = weights == null ? 1.0 : this.weighting[i++];
        }
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public static short[][] transformFingerprintsToIntegerArray(int[] usedIndizes, boolean[][] fingerprints) {
        short[][] matrix = new short[fingerprints.length][];
        TShortArrayList buffer = new TShortArrayList(524);
        for (int k = 0; k < fingerprints.length; ++k) {
            boolean[] fingerprint = fingerprints[k];
            for (int i = 0; i < usedIndizes.length; ++i) {
                if (!fingerprint[usedIndizes[i]]) continue;
                buffer.add((short)usedIndizes[i]);
            }
            matrix[k] = buffer.toArray();
            buffer.resetQuick();
        }
        return matrix;
    }

    public static short[] transformFingerprintToIntegerArray(int[] usedIndizes, boolean[] fingerprint) {
        TShortArrayList buffer = new TShortArrayList(128);
        for (int i = 0; i < usedIndizes.length; ++i) {
            if (!fingerprint[usedIndizes[i]]) continue;
            buffer.add((short)usedIndizes[i]);
        }
        return buffer.toArray();
    }

    public TrainCompoundClasses(int[] usedIndizes) {
        this(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()), usedIndizes);
    }

    public TrainCompoundClasses(ExecutorService service, int[] usedIndizes) {
        PeriodicTable pt = PeriodicTable.getInstance();
        for (int k = 0; k < ELEMENTS.length; ++k) {
            this.elements[k] = pt.getByName(ELEMENTS[k]);
        }
        this.usedIndizes = usedIndizes;
        this.service = service;
        Arrays.sort(usedIndizes);
        this.NODE_POOL = new svm_node[usedIndizes[usedIndizes.length - 1] + 1];
        for (int i : usedIndizes) {
            this.NODE_POOL[i] = new svm_node();
            this.NODE_POOL[i].index = i + 1;
            this.NODE_POOL[i].value = 1.0;
        }
        this.FEATURES = this.NODE_POOL.length;
        this.seed = new ArrayList<Compound>();
        this.pool = new ArrayList<Compound>();
        svm.svm_set_print_string_function((svm_print_interface)new svm_print_interface(){

            public void print(String s) {
            }
        });
    }

    public PredictionPerformance evaluateOnRealFingerprints(svm_model predictor, MolecularFormula[] formulasPositive, MolecularFormula[] formulasNegatives, double[][] plattScoresOfPositives, double[][] plattScoresOfNegatives) throws IOException {
        PredictionPerformance performance = this.evaluateOnRealFingerprints(predictor, formulasPositive, plattScoresOfPositives, 1);
        performance.merge(this.evaluateOnRealFingerprints(predictor, formulasNegatives, plattScoresOfNegatives, -1));
        return performance;
    }

    public PredictionPerformance evaluateOnRealFingerprints(svm_model predictor, MolecularFormula[] formulas, double[][] platts, int expectedClass) throws IOException {
        int tp = 0;
        int fp = 0;
        int tn = 0;
        int fn = 0;
        int fpFeatures = platts[0].length;
        svm_node[] nodes = new svm_node[fpFeatures + ADDITIONAL_FINGERPRINTS];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new svm_node();
        }
        for (int k = 0; k < platts.length; ++k) {
            for (int i = 0; i < fpFeatures; ++i) {
                nodes[i].index = this.usedIndizes[i] + 1;
                nodes[i].value = platts[k][i];
                if (this.weighting == null) continue;
                nodes[i].value *= this.weighting[i];
            }
            double[] additionalF = TrainCompoundClasses.getAdditionalFingerprintsFor(formulas[k]);
            for (int i = 0; i < ADDITIONAL_FINGERPRINTS; ++i) {
                nodes[fpFeatures + i].index = this.FEATURES + i;
                nodes[fpFeatures + i].value = additionalF[i];
            }
            double classification = svm.svm_predict((svm_model)predictor, (svm_node[])nodes);
            if (classification > 0.0) {
                if (expectedClass > 0) {
                    ++tp;
                    continue;
                }
                ++fp;
                continue;
            }
            if (expectedClass > 0) {
                ++fn;
                continue;
            }
            ++tn;
        }
        return new PredictionPerformance((double)tp, (double)fp, (double)tn, (double)fn);
    }

    private Compound newCompound(String inchikey, MolecularFormula formula, int classification, boolean[] fingerprint) {
        Compound c = new Compound(inchikey, formula, (byte)classification, TrainCompoundClasses.transformFingerprintToIntegerArray(this.usedIndizes, fingerprint));
        int fpFeatures = c.fingerprint.length;
        Compound.access$302(c, new svm_node[fpFeatures + ADDITIONAL_FINGERPRINTS]);
        for (int i = 0; i < c.fingerprint.length; ++i) {
            ((Compound)c).nodes[i] = this.NODE_POOL[c.fingerprint[i]];
            if (c.nodes[i] != null) continue;
            throw new RuntimeException("node is null: " + inchikey + " at " + i);
        }
        double[] additionalFingerprints = this.getAdditionalFingerprintsFor(c);
        for (int i = 0; i < additionalFingerprints.length; ++i) {
            ((Compound)c).nodes[fpFeatures + i] = new svm_node();
            ((Compound)c).nodes[fpFeatures + i].index = i + this.FEATURES;
            ((Compound)c).nodes[fpFeatures + i].value = additionalFingerprints[i];
        }
        return c;
    }

    public void addSeed(String id, MolecularFormula formula, int classification, boolean[] fingerprint) {
        this.seed.add(this.newCompound(id, formula, classification, fingerprint));
    }

    public void addPool(String id, MolecularFormula formula, int classification, boolean[] fingerprint) {
        this.pool.add(this.newCompound(id, formula, classification, fingerprint));
    }

    public void updateWeightLabels(List<Compound> compounds) {
        this.WEIGHT[1] = 1.0;
        this.WEIGHT[0] = 1.0;
    }

    public MPredictor train(int degree, boolean useCoefficient, double C) {
        Model bestModel = new Model(new PredictionPerformance(), C, degree, useCoefficient ? 1.0 : 0.0);
        this.trainingSet = new ArrayList<Compound>();
        this.evaluationSet = new ArrayList<Compound>();
        this.pickupTrainAndEval(this.seed, this.trainingSet, this.evaluationSet);
        this.updateWeightLabels(this.trainingSet);
        MPredictor lastPredictor = null;
        int counter = 0;
        for (int f = 0; f < 5; ++f) {
            MPredictor predictor;
            System.out.println("Round " + f);
            lastPredictor = predictor = this.trainAndEvaluate(bestModel, this.defineProblem(this.trainingSet), this.evaluationSet);
            List<Compound> fails = this.evaluateAndRememberFalseNegatives(predictor.svmModel, this.pool);
            try {
                System.out.println("Write report with " + fails.size() + " failed instances and " + predictor.getPerformance().toString());
                this.writeReport(predictor, fails.size(), f, ++counter, this.trainingSet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (fails.size() == 0) break;
            int trBefore = this.trainingSet.size();
            Collections.shuffle(fails);
            HashSet<String> addedKeys = new HashSet<String>();
            for (int i = 0; i < Math.min(5000, fails.size()); ++i) {
                this.trainingSet.add(fails.get(i));
                addedKeys.add(fails.get(i).inchiKey);
            }
            System.out.println("Added " + Math.min(5000, fails.size()) + " new negative samples");
            Iterator<Compound> deleteFromPool = this.pool.iterator();
            while (deleteFromPool.hasNext()) {
                if (!addedKeys.contains(deleteFromPool.next().inchiKey)) continue;
                deleteFromPool.remove();
            }
        }
        return lastPredictor;
    }

    public MPredictor train() throws InterruptedException {
        Object predictor;
        System.out.println("Train version: 0.4");
        this.trainingSet = new ArrayList<Compound>();
        this.evaluationSet = new ArrayList<Compound>();
        this.pickupTrainAndEval(this.seed, this.trainingSet, this.evaluationSet);
        Object lastPredictor = null;
        int counter = 0;
        System.out.println("New outer fold: 1");
        this.updateWeightLabels(this.trainingSet);
        System.out.println("Start training parameters");
        Model bestModel = this.trainParameters(this.trainingSet);
        System.out.println("finally best found parameters: " + bestModel.toString() + " with " + bestModel.performance.toString());
        for (int f = 0; f < 5; ++f) {
            System.out.println("Round " + f);
            predictor = this.trainAndEvaluate(bestModel, this.defineProblem(this.trainingSet), this.evaluationSet);
            ArrayList<Compound> whatToRemove = this.findFarFromMargin(((MPredictor)predictor).svmModel, this.trainingSet, 2);
            System.out.println(whatToRemove.size() + " vectors are far away from margin");
            lastPredictor = predictor;
            List<Compound> fails = this.evaluateAndRememberFalseNegatives(((MPredictor)predictor).svmModel, this.pool);
            try {
                System.out.println("Write report with " + fails.size() + " failed instances and " + ((Predictor)predictor).getPerformance().toString());
                this.writeReport((MPredictor)predictor, fails.size(), 1, ++counter, this.trainingSet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (fails.size() == 0) break;
            int trBefore = this.trainingSet.size();
            if (fails.size() + this.trainingSet.size() > 30000) {
                this.trainingSet.removeAll(whatToRemove);
                this.pool.addAll(whatToRemove);
            }
            Collections.shuffle(fails);
            HashSet<String> addedKeys = new HashSet<String>();
            int addToTrainingSet = fails.size() + this.trainingSet.size() > 30000 ? fails.size() : 3000;
            for (int i = 0; i < Math.min(addToTrainingSet, fails.size()); ++i) {
                this.trainingSet.add(fails.get(i));
                addedKeys.add(fails.get(i).inchiKey);
            }
            System.out.println("Added " + Math.min(addToTrainingSet, fails.size()) + " new negative samples");
            Iterator<Compound> deleteFromPool = this.pool.iterator();
            while (deleteFromPool.hasNext()) {
                if (!addedKeys.contains(deleteFromPool.next().inchiKey)) continue;
                deleteFromPool.remove();
            }
            this.uniqueList(this.evaluationSet);
            this.uniqueList(this.pool);
            this.uniqueList(this.trainingSet);
        }
        Model newBestModel = this.trainParameters(this.trainingSet);
        System.out.println("FINAL MODEL: " + newBestModel.toString());
        for (Compound c : this.evaluationSet) {
            if (c.classification <= 0) continue;
            this.trainingSet.add(c);
        }
        predictor = this.trainAndEvaluate(bestModel, this.defineProblem(this.trainingSet), this.evaluationSet);
        try {
            ((MPredictor)predictor).writeModel(new File(new File(this.outputDir.getParent(), "models"), this.outputDir.getName() + ".model"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return predictor;
    }

    private void uniqueList(List<Compound> evaluationSet) {
        HashSet<String> keys = new HashSet<String>();
        ListIterator<Compound> citer = evaluationSet.listIterator();
        while (citer.hasNext()) {
            Compound c = citer.next();
            if (keys.contains(c.inchiKey)) {
                citer.remove();
                continue;
            }
            keys.add(c.inchiKey);
        }
    }

    private void removeNonSupportVectorsFromTrainingSet(List<Compound> trainingSet, List<Compound> evaluationSet, MPredictor predictor) {
        ArrayList<Compound> newTrainingSet = new ArrayList<Compound>();
        TIntHashSet indizes = new TIntHashSet();
        for (int sv : predictor.supportVectors) {
            Compound c = trainingSet.get(sv - 1);
            if (c.classification >= 0) continue;
            newTrainingSet.add(c);
            indizes.add(sv - 1);
        }
        for (int k = 0; k < trainingSet.size(); ++k) {
            Compound c = trainingSet.get(k);
            if (c.classification > 0) {
                newTrainingSet.add(c);
                continue;
            }
            if (indizes.contains(k)) continue;
            evaluationSet.add(c);
        }
        trainingSet.clear();
        trainingSet.addAll(newTrainingSet);
    }

    private void writeReport(MPredictor predictor, int failed, int round, int counter, List<Compound> trainingSet) throws IOException {
        File mfile = new File(this.outputDir, String.valueOf(round + 1) + "_" + String.valueOf(counter) + ".model");
        File rfile = new File(this.outputDir, String.valueOf(round + 1) + "_" + String.valueOf(counter) + ".txt");
        predictor.writeModel(mfile);
        try (BufferedWriter rbw = Files.newBufferedWriter(rfile.toPath(), Charset.defaultCharset(), new OpenOption[0]);){
            rbw.write(predictor.getPerformance().toString());
            rbw.newLine();
            rbw.write(String.valueOf(failed));
            rbw.write("\t");
            rbw.write("failed instances in pool\n");
            rbw.write(predictor.model.toString());
            rbw.newLine();
            rbw.write("trained on " + trainingSet.size() + " compounds\n---\n");
            for (Compound c : trainingSet) {
                rbw.write(c.inchiKey);
                rbw.newLine();
            }
        }
    }

    private Model trainParameters(List<Compound> compounds) throws InterruptedException {
        List[] train = new List[5];
        final List[] eval = new List[5];
        this.pickupTrainAndEval(compounds, train, eval);
        this.updateWeightLabels(compounds);
        final svm_problem[] problems = new svm_problem[5];
        for (int fold = 0; fold < 5; ++fold) {
            problems[fold] = this.defineProblem(train[fold]);
        }
        ArrayList<Future<Model>> fmodels = new ArrayList<Future<Model>>();
        for (int degree = this.minDegree; degree <= this.maxDegree; ++degree) {
            for (int coef0 = this.minCoef; coef0 <= this.maxCoef; ++coef0) {
                final int n = degree;
                final int COEF0 = coef0;
                for (final int sign : new int[]{-1, 1}) {
                    fmodels.add(this.service.submit(new Callable<Model>(){

                        @Override
                        public Model call() throws Exception {
                            int c;
                            Model m = null;
                            int noinc = 0;
                            int n2 = c = sign < 0 ? 0 : 1;
                            while (c <= TrainCompoundClasses.this.numberOfCs) {
                                svm_parameter param = TrainCompoundClasses.this.defaultParameters();
                                param.C = Math.pow(2.0, c * sign);
                                param.cache_size = 1024.0;
                                param.weight = TrainCompoundClasses.this.WEIGHT;
                                param.coef0 = COEF0;
                                param.degree = n;
                                param.gamma = 1.0;
                                param.weight_label = TrainCompoundClasses.this.WEIGHT_LABEL;
                                Model m2 = TrainCompoundClasses.this.trainAndEvaluateCrossFolds(problems, param, eval);
                                if (m == null || m2.compareTo(m) > 0) {
                                    m = m2;
                                } else if (++noinc > 1) break;
                                ++c;
                            }
                            System.out.println("Best model for " + (sign > 0 ? "large" : "small") + " c values: " + m.toString() + " with " + m.performance.toString());
                            return m;
                        }
                    }));
                }
            }
        }
        ArrayList models = new ArrayList();
        for (Future future : fmodels) {
            try {
                models.add(future.get());
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return (Model)Collections.max(models);
    }

    private MPredictor trainAndEvaluate(Model model, svm_problem problem, List<Compound> evals) {
        svm_parameter param = this.defaultParameters();
        param.C = model.c;
        param.cache_size = 1024.0;
        param.weight = this.WEIGHT;
        param.coef0 = model.coef0;
        param.degree = model.degree;
        param.gamma = 1.0;
        param.weight_label = this.WEIGHT_LABEL;
        svm_model amodel = svm.svm_train((svm_problem)problem, (svm_parameter)param);
        PredictionPerformance performance = this.evaluate(amodel, evals);
        MPredictor p = new MPredictor(model, amodel);
        p.setStatistics(performance);
        return p;
    }

    private Model trainAndEvaluateCrossFolds(svm_problem[] problems, svm_parameter param, List<Compound>[] evals) {
        StringBuilder buf = new StringBuilder();
        PredictionPerformance performance = new PredictionPerformance();
        buf.append("#SV = ");
        for (int fold = 0; fold < problems.length; ++fold) {
            svm_model model = svm.svm_train((svm_problem)problems[fold], (svm_parameter)param);
            buf.append("\t").append(model.nSV[0]).append(" ").append(model.nSV.length > 1 ? Integer.valueOf(model.nSV[1]) : "0");
            PredictionPerformance performance2 = this.evaluate(model, evals[fold]);
            performance.merge(performance2);
        }
        performance.calc();
        Model m = new Model(performance, param.C, param.degree, param.coef0);
        System.out.println("found " + m.toString() + ", " + buf);
        return m;
    }

    private void pickupTrainAndEval(List<Compound> compounds, List<Compound> trains, List<Compound> eval) {
        int N = 5;
        ArrayList<Compound> positives = new ArrayList<Compound>();
        ArrayList<Compound> negatives = new ArrayList<Compound>();
        for (Compound c : compounds) {
            if (c.classification > 0) {
                positives.add(c);
                continue;
            }
            negatives.add(c);
        }
        int np = positives.size() / 5;
        int nn = negatives.size() / 5;
        Collections.shuffle(positives);
        Collections.shuffle(negatives);
        eval.addAll(positives.subList(0, np));
        trains.addAll(positives.subList(np, positives.size()));
        eval.addAll(negatives.subList(0, nn));
        trains.addAll(negatives.subList(nn, negatives.size()));
    }

    private void pickupTrainAndEval(List<Compound> compounds, List<Compound>[] trains, List<Compound>[] eval) {
        int i;
        int k;
        int N = trains.length;
        ArrayList<Compound> positives = new ArrayList<Compound>();
        ArrayList<Compound> negatives = new ArrayList<Compound>();
        for (Compound c : compounds) {
            if (c.classification > 0) {
                positives.add(c);
                continue;
            }
            negatives.add(c);
        }
        Collections.shuffle(positives);
        Collections.shuffle(negatives);
        for (k = 0; k < N; ++k) {
            trains[k] = new ArrayList<Compound>();
            eval[k] = new ArrayList<Compound>();
        }
        for (k = 0; k < positives.size(); ++k) {
            int fold = k % N;
            eval[fold].add((Compound)positives.get(k));
            for (i = 0; i < N; ++i) {
                if (i == fold) continue;
                trains[i].add((Compound)positives.get(k));
            }
        }
        for (k = 0; k < negatives.size(); ++k) {
            int fold = k % N;
            eval[fold].add((Compound)negatives.get(k));
            for (i = 0; i < N; ++i) {
                if (i == fold) continue;
                trains[i].add((Compound)negatives.get(k));
            }
        }
    }

    private List<Compound> evaluateAndRememberFalseNegatives(svm_model model, List<Compound> negatives) {
        ArrayList<Compound> failed = new ArrayList<Compound>();
        for (int k = 0; k < negatives.size(); ++k) {
            boolean isPositive;
            boolean bl = isPositive = negatives.get(k).classification > 0;
            if (this.svmPredict(model, negatives.get(k)) == isPositive) continue;
            failed.add(negatives.get(k));
        }
        return failed;
    }

    private PredictionPerformance evaluate(svm_model model, List<Compound> compounds) {
        int tp = 0;
        int fp = 0;
        int tn = 0;
        int fn = 0;
        for (int k = 0; k < compounds.size(); ++k) {
            Compound c = compounds.get(k);
            boolean prediction = this.svmPredict(model, c);
            if (c.classification > 0) {
                if (prediction) {
                    ++tp;
                    continue;
                }
                ++fp;
                continue;
            }
            if (prediction) {
                ++fn;
                continue;
            }
            ++tn;
        }
        return new PredictionPerformance((double)tp, (double)fp, (double)tn, (double)fn);
    }

    private ArrayList<Compound> findFarFromMargin(svm_model model, List<Compound> trainCompounds, int dist) {
        ArrayList<Compound> farFromMargin = new ArrayList<Compound>();
        for (Compound c : trainCompounds) {
            boolean rclass;
            boolean pclass;
            double value = this.svmPredictValue(model, c);
            boolean pp = this.svmPredict(model, c);
            boolean bl = pclass = value > 0.0;
            if (pclass != pp) {
                throw new RuntimeException("WTF??");
            }
            boolean bl2 = rclass = c.classification > 0;
            if (!(Math.abs(value) > (double)dist)) continue;
            farFromMargin.add(c);
        }
        return farFromMargin;
    }

    private boolean svmPredict(svm_model model, Compound c) {
        return svm.svm_predict((svm_model)model, (svm_node[])c.nodes) > 0.0;
    }

    private double svmPredictValue(svm_model model, Compound c) {
        svm_node[] nodes = c.nodes;
        double sum = 0.0;
        if (model.label[0] < 0) {
            throw new RuntimeException("WTF?");
        }
        for (int i = 0; i < model.l; ++i) {
            sum += model.sv_coef[0][i] * TrainCompoundClasses.k_function(nodes, model.SV[i], model.param);
        }
        return sum - model.rho[0];
    }

    private svm_parameter defaultParameters() {
        svm_parameter param = new svm_parameter();
        param.svm_type = 0;
        param.kernel_type = 1;
        param.degree = 2;
        param.gamma = 1.0;
        param.coef0 = 1.0;
        param.nu = 0.5;
        param.cache_size = 5000.0;
        param.C = 1.0;
        param.eps = 0.001;
        param.p = 0.1;
        param.shrinking = 1;
        param.probability = 0;
        param.weight_label = new int[]{1, -1};
        param.weight = new double[]{1.0, 1.0};
        param.nr_weight = param.weight.length;
        return param;
    }

    private svm_problem defineProblem(List<Compound> compounds) {
        svm_problem problem = new svm_problem();
        problem.l = compounds.size();
        problem.x = new svm_node[problem.l][];
        problem.y = new double[problem.l];
        for (int k = 0; k < compounds.size(); ++k) {
            Compound c = compounds.get(k);
            problem.x[k] = c.nodes;
            problem.y[k] = c.classification;
        }
        return problem;
    }

    private static double dot(svm_node[] x, svm_node[] y) {
        double sum = 0.0;
        int xlen = x.length;
        int ylen = y.length;
        int i = 0;
        int j = 0;
        while (i < xlen && j < ylen) {
            if (x[i].index == y[j].index) {
                sum += x[i++].value * y[j++].value;
                continue;
            }
            if (x[i].index > y[j].index) {
                ++j;
                continue;
            }
            ++i;
        }
        return sum;
    }

    private static double k_function(svm_node[] x, svm_node[] y, svm_parameter param) {
        switch (param.kernel_type) {
            case 0: {
                return TrainCompoundClasses.dot(x, y);
            }
            case 1: {
                return TrainCompoundClasses.powi(param.gamma * TrainCompoundClasses.dot(x, y) + param.coef0, param.degree);
            }
            case 2: {
                double sum = 0.0;
                int xlen = x.length;
                int ylen = y.length;
                int i = 0;
                int j = 0;
                while (i < xlen && j < ylen) {
                    if (x[i].index == y[j].index) {
                        double d = x[i++].value - y[j++].value;
                        sum += d * d;
                        continue;
                    }
                    if (x[i].index > y[j].index) {
                        sum += y[j].value * y[j].value;
                        ++j;
                        continue;
                    }
                    sum += x[i].value * x[i].value;
                    ++i;
                }
                while (i < xlen) {
                    sum += x[i].value * x[i].value;
                    ++i;
                }
                while (j < ylen) {
                    sum += y[j].value * y[j].value;
                    ++j;
                }
                return Math.exp(-param.gamma * sum);
            }
            case 3: {
                return Math.tanh(param.gamma * TrainCompoundClasses.dot(x, y) + param.coef0);
            }
            case 4: {
                return x[(int)y[0].value].value;
            }
        }
        return 0.0;
    }

    private static double powi(double base, int times) {
        double tmp = base;
        double ret = 1.0;
        for (int t = times; t > 0; t /= 2) {
            if (t % 2 == 1) {
                ret *= tmp;
            }
            tmp *= tmp;
        }
        return ret;
    }

    static {
        TrainCompoundClasses.FINAL_NODE.index = -1;
    }

    public static class Model
    implements Comparable<Model> {
        private static Comparator<PredictionPerformance> comp = new OptimizationStrategy.ByFScore().getComparator();
        private final PredictionPerformance performance;
        private final double c;
        private final int degree;
        public double coef0;

        public Model(PredictionPerformance performance, double c, int degree, double coef0) {
            this.performance = performance;
            this.c = c;
            this.degree = degree;
            this.coef0 = coef0;
        }

        @Override
        public int compareTo(Model o) {
            return comp.compare(this.performance, o.performance);
        }

        public String toString() {
            return "polynomial svm, degree = " + this.degree + ", coefficient = " + this.coef0 + ", c = " + this.c + ", f = " + this.performance.getF();
        }
    }

    public static class MPredictor
    extends Predictor {
        private final Model model;
        private transient svm_model svmModel;

        public MPredictor(Model model, svm_model svm2) {
            super(0, svm2.rho[0], 0.0, 0.0, svm2.sv_coef[0], svm2.sv_indices);
            this.model = model;
            this.svmModel = svm2;
        }

        public void writeModel(File f) throws IOException {
            svm.svm_save_model((String)f.getAbsolutePath(), (svm_model)this.svmModel);
        }
    }

    private static class CFingerprint {
        private Compound c;
        private int hashCode;

        private CFingerprint(Compound c) {
            this.c = c;
            this.hashCode = Arrays.hashCode(c.fingerprint);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CFingerprint that = (CFingerprint)o;
            return Arrays.equals(this.c.fingerprint, that.c.fingerprint);
        }
    }

    public static class Compound {
        private final String inchiKey;
        private final byte classification;
        private final short[] fingerprint;
        private final MolecularFormula formula;
        private svm_node[] nodes;
        private byte fold;

        public Compound(String inchiKey, MolecularFormula formula, byte classification, short[] fingerprint) {
            this.formula = formula;
            this.inchiKey = inchiKey;
            this.classification = classification;
            this.fingerprint = fingerprint;
            this.fold = 0;
        }

        static /* synthetic */ svm_node[] access$302(Compound x0, svm_node[] x1) {
            x0.nodes = x1;
            return x1;
        }
    }
}

