/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import de.unijena.bioinf.fingerid.ParameterC;
import de.unijena.bioinf.fingerid.Predictor;
import java.util.ArrayList;
import java.util.List;

public class TrainResult {
    public final Predictor[] predictors;
    public final ParameterC[] parameterCs;
    double[][] decisionValues;

    public TrainResult(Predictor[] predictors, ParameterC[] parameterCs) {
        this.predictors = predictors;
        this.parameterCs = parameterCs;
    }

    public void setDecisionValues(double[][] values) {
        this.decisionValues = values;
    }

    public static final class Builder {
        List<Predictor> predictionList = new ArrayList<Predictor>();
        List<ParameterC> parameterCList = new ArrayList<ParameterC>();

        public void addResult(Predictor predictor, ParameterC parameterC) {
            this.predictionList.add(predictor);
            this.parameterCList.add(parameterC);
        }

        public void addResult(TrainResult result) {
            for (Predictor predictor : result.predictors) {
                this.predictionList.add(predictor);
            }
            for (ParameterC parameterC : result.parameterCs) {
                this.parameterCList.add(parameterC);
            }
        }

        public TrainResult done() {
            return new TrainResult(this.predictionList.toArray(new Predictor[0]), this.parameterCList.toArray(new ParameterC[0]));
        }
    }
}

