/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.svm;

import de.unijena.bioinf.fingerid.svm.Sample;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Crossvalidation<T extends Sample> {
    private int nfolds;
    private boolean random;
    private boolean useGrouping;
    private int[] grouping;
    private final int[] sizes;
    private List<T> samples;

    public Crossvalidation(List<T> samples, int nfolds, boolean random, boolean useGrouping) {
        if (nfolds >= 30) {
            throw new IllegalArgumentException("Too large fold: " + nfolds);
        }
        this.nfolds = nfolds;
        this.random = random;
        this.samples = samples;
        this.sizes = new int[nfolds];
        this.startTagging();
    }

    private void startTagging() {
        if (this.random) {
            this.startRandomTagging(this.samples);
        } else {
            this.startSequentialTaggingSamples(this.samples);
        }
    }

    public Sample[] getFoldsArrayWithout(int ... folds) {
        int set = (1 << this.nfolds) - 1;
        int size = this.samples.size();
        for (int k : folds) {
            set &= ~(1 << k);
            size -= this.sizes[k];
        }
        Sample[] foldList = new Sample[size];
        int k = 0;
        for (Sample s : this.samples) {
            if ((1 << s.getBatchNum() & set) == 0) continue;
            foldList[k++] = s;
        }
        if (k < foldList.length) {
            System.err.println("List should have size " + size + " but real size is " + k + " for folds: " + Arrays.toString(folds));
            return Arrays.copyOf(foldList, k);
        }
        return foldList;
    }

    public Sample[] getFoldsArray(int ... folds) {
        int set = 0;
        int size = 0;
        for (int k : folds) {
            set |= 1 << k;
            size += this.sizes[k];
        }
        Sample[] foldList = new Sample[size];
        int k = 0;
        for (Sample s : this.samples) {
            if ((1 << s.getBatchNum() & set) == 0) continue;
            foldList[k++] = s;
        }
        if (k < foldList.length) {
            System.err.println("List should have size " + size + " but real size is " + k + " for folds: " + Arrays.toString(folds));
            return Arrays.copyOf(foldList, k);
        }
        return foldList;
    }

    public List<T> getFoldsWithout(int ... folds) {
        int set = (1 << this.nfolds) - 1;
        int size = this.samples.size();
        for (int k : folds) {
            set &= ~(1 << k);
            size -= this.sizes[k];
        }
        ArrayList<Sample> foldList = new ArrayList<Sample>(size);
        for (Sample s : this.samples) {
            if ((1 << s.getBatchNum() & set) == 0) continue;
            foldList.add(s);
        }
        return foldList;
    }

    public List<T> getFolds(int ... folds) {
        int set = 0;
        int size = 0;
        for (int k : folds) {
            set |= 1 << k;
            size += this.sizes[k];
        }
        ArrayList<Sample> foldList = new ArrayList<Sample>(size);
        for (Sample s : this.samples) {
            if ((1 << s.getBatchNum() & set) == 0) continue;
            foldList.add(s);
        }
        return foldList;
    }

    private void startSequentialTaggingSamples(List<T> samples) {
        if (!this.useGrouping) {
            for (int k = 0; k < samples.size(); ++k) {
                int fold = k % this.nfolds;
                ((Sample)samples.get(k)).setBatchNum(fold);
                int n = fold;
                this.sizes[n] = this.sizes[n] + 1;
            }
        }
    }

    private void startRandomTagging(List<T> samples) {
        ArrayList<T> newList = new ArrayList<T>(samples);
        Collections.shuffle(newList);
        this.startSequentialTaggingSamples(newList);
    }
}

