/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.svm;

import de.unijena.bioinf.ChemistryBase.fp.PredictionPerformance;
import de.unijena.bioinf.fingerid.svm.Sample;
import de.unijena.bioinf.fingerid.svm.SvmInstance;
import de.unijena.bioinf.fingerid.svm.kernel.KernelSvmInstance;
import de.unijena.bioinf.fingerid.svm.linear.LinearSvmInstance;

public class Svm {
    public static final String SVM_TYPE = "svm_type";
    public static final String KERNEL_TYPE = "kernel_type";
    public static final String DEGREE = "degree";
    public static final String GAMMA = "gamma";
    public static final String COEF0 = "coef0";
    public static final String CACHE_SIZE = "cache_size";
    public static final String EPS = "epsilon";
    public static final String C = "c";
    public static final String PROBABILITY = "probability";
    public static final String SHRINKING = "shrinking";
    public static final String P = "p";
    public static final String SOLVER = "Solver";
    public static final String BIAS = "bias";
    public static final String NU = "nu";
    public static final int POLYNOMIAL = 1;
    public static final int LINEAR = 0;
    public static final int RBF = 2;
    public static final int PRECOMPUTED = 4;

    public static PredictionPerformance evaluateClassificationPerformance(Sample[] samples, double[] predictions) {
        int tp = 0;
        int fp = 0;
        int tn = 0;
        int fn = 0;
        for (int k = 0; k < samples.length; ++k) {
            if (samples[k].getLabel() > 0.0) {
                if (predictions[k] > 0.0) {
                    ++tp;
                    continue;
                }
                ++fn;
                continue;
            }
            if (predictions[k] > 0.0) {
                ++fp;
                continue;
            }
            ++tn;
        }
        return new PredictionPerformance((double)tp, (double)fp, (double)tn, (double)fn);
    }

    public static SvmInstance getLinearSvm() {
        return new LinearSvmInstance();
    }

    public static SvmInstance getKernelSvm() {
        return new KernelSvmInstance();
    }
}

