/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.svm.kernel;

import de.unijena.bioinf.fingerid.svm.FeatureList;
import java.util.Arrays;
import libsvm.svm_node;

class KernelFeatureList
implements FeatureList {
    protected svm_node[] nodes;
    protected int k;

    public KernelFeatureList(int size) {
        this.nodes = new svm_node[size];
        this.k = 0;
    }

    public svm_node[] getNodes() {
        if (this.k < this.nodes.length) {
            this.nodes = Arrays.copyOf(this.nodes, this.k);
        }
        return this.nodes;
    }

    @Override
    public void add(int featureId, double value) {
        svm_node node = new svm_node();
        node.value = value;
        node.index = this.k + 1;
        this.nodes[this.k++] = node;
    }

    @Override
    public void addFeatureFrom(FeatureList featureList, int featureIndex) {
        KernelFeatureList kf = (KernelFeatureList)featureList;
        this.nodes[this.k++] = kf.nodes[featureIndex];
    }

    @Override
    public int size() {
        return this.k;
    }
}

