/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.svm.kernel;

import de.unijena.bioinf.fingerid.svm.FeatureList;
import de.unijena.bioinf.fingerid.svm.kernel.KernelFeatureList;

public class KernelMatrix2FeatureList {
    private KernelFeatureList[] featureList;
    private KernelFeatureList testList;

    public KernelMatrix2FeatureList(int nsize) {
        this.featureList = new KernelFeatureList[nsize];
        this.testList = KernelMatrix2FeatureList.createFeatureList(0, nsize);
        for (int k = 0; k < nsize; ++k) {
            this.featureList[k] = KernelMatrix2FeatureList.createFeatureList(k, nsize);
        }
    }

    public void set(double[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                this.featureList[i].nodes[j + 1].value = matrix[i][j];
            }
        }
    }

    public FeatureList getTestvector(double[] kernel) {
        KernelFeatureList copy = new KernelFeatureList(this.testList.size());
        copy.add(0, 0.0);
        for (int k = 0; k < kernel.length; ++k) {
            copy.add(k + 1, kernel[k]);
        }
        copy.add(-1, -1.0);
        return copy;
    }

    public FeatureList getSharedTestvector(double[] kernel) {
        for (int k = 0; k < kernel.length; ++k) {
            this.testList.nodes[k + 1].value = kernel[k];
        }
        return this.testList;
    }

    public FeatureList[] get() {
        return this.featureList;
    }

    private static KernelFeatureList createFeatureList(int k, int nsize) {
        KernelFeatureList kf = new KernelFeatureList(nsize + 2);
        kf.add(0, k + 1);
        for (int j = 0; j < nsize; ++j) {
            kf.add(j + 1, 0.0);
        }
        kf.add(-1, -1.0);
        return kf;
    }
}

