/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.svm.kernel;

import de.unijena.bioinf.fingerid.svm.Sample;
import de.unijena.bioinf.fingerid.svm.SvmModel;
import de.unijena.bioinf.fingerid.svm.kernel.KernelFeatureList;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;

class KernelModel
implements SvmModel {
    protected final svm_model model;

    KernelModel(svm_model model) {
        this.model = model;
    }

    @Override
    public double[] getFeatureWeights() {
        return this.model.sv_coef[0];
    }

    @Override
    public int[] getSupportVectors() {
        return this.model.sv_indices;
    }

    @Override
    public double getBias() {
        return this.model.rho[0];
    }

    @Override
    public double[] predict(Sample[] samples) {
        double[] matrix = new double[samples.length];
        for (int l = 0; l < samples.length; ++l) {
            matrix[l] = this.predict(samples[l]);
        }
        return matrix;
    }

    @Override
    public double predict(Sample sample) {
        return svm.svm_predict((svm_model)this.model, (svm_node[])((KernelFeatureList)sample.getFeatureList()).getNodes());
    }

    @Override
    public double computeDecisionValue(Sample sample) {
        svm_node[] nodes = ((KernelFeatureList)sample.getFeatureList()).getNodes();
        double sum = 0.0;
        for (int i = 0; i < this.model.l; ++i) {
            sum += this.model.sv_coef[0][i] * KernelModel.k_function(nodes, this.model.SV[i], this.model.param);
        }
        return sum - this.model.rho[0];
    }

    @Override
    public double[] computeDecisionValues(Sample[] samples) {
        double[] matrix = new double[samples.length];
        for (int l = 0; l < samples.length; ++l) {
            matrix[l] = this.computeDecisionValue(samples[l]);
        }
        return matrix;
    }

    @Override
    public double predictProbability(Sample sample) {
        double[] probabilities = new double[2];
        svm.svm_predict_probability((svm_model)this.model, (svm_node[])((KernelFeatureList)sample.getFeatureList()).getNodes(), (double[])probabilities);
        return probabilities[0];
    }

    @Override
    public double[] predictProbabilities(Sample[] samples) {
        double[] matrix = new double[samples.length];
        for (int l = 0; l < samples.length; ++l) {
            matrix[l] = this.predictProbability(samples[l]);
        }
        return matrix;
    }

    private static double dot(svm_node[] x, svm_node[] y) {
        double sum = 0.0;
        int xlen = x.length;
        int ylen = y.length;
        int i = 0;
        int j = 0;
        while (i < xlen && j < ylen) {
            if (x[i].index == y[j].index) {
                sum += x[i++].value * y[j++].value;
                continue;
            }
            if (x[i].index > y[j].index) {
                ++j;
                continue;
            }
            ++i;
        }
        return sum;
    }

    private static double k_function(svm_node[] x, svm_node[] y, svm_parameter param) {
        switch (param.kernel_type) {
            case 0: {
                return KernelModel.dot(x, y);
            }
            case 1: {
                return KernelModel.powi(param.gamma * KernelModel.dot(x, y) + param.coef0, param.degree);
            }
            case 2: {
                double sum = 0.0;
                int xlen = x.length;
                int ylen = y.length;
                int i = 0;
                int j = 0;
                while (i < xlen && j < ylen) {
                    if (x[i].index == y[j].index) {
                        double d = x[i++].value - y[j++].value;
                        sum += d * d;
                        continue;
                    }
                    if (x[i].index > y[j].index) {
                        sum += y[j].value * y[j].value;
                        ++j;
                        continue;
                    }
                    sum += x[i].value * x[i].value;
                    ++i;
                }
                while (i < xlen) {
                    sum += x[i].value * x[i].value;
                    ++i;
                }
                while (j < ylen) {
                    sum += y[j].value * y[j].value;
                    ++j;
                }
                return Math.exp(-param.gamma * sum);
            }
            case 3: {
                return Math.tanh(param.gamma * KernelModel.dot(x, y) + param.coef0);
            }
            case 4: {
                return x[(int)y[0].value].value;
            }
        }
        return 0.0;
    }

    private static double powi(double base, int times) {
        double tmp = base;
        double ret = 1.0;
        for (int t = times; t > 0; t /= 2) {
            if (t % 2 == 1) {
                ret *= tmp;
            }
            tmp *= tmp;
        }
        return ret;
    }
}

