/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.svm.kernel;

import de.unijena.bioinf.fingerid.svm.FeatureList;
import de.unijena.bioinf.fingerid.svm.Sample;
import de.unijena.bioinf.fingerid.svm.SvmInstance;
import de.unijena.bioinf.fingerid.svm.SvmModel;
import de.unijena.bioinf.fingerid.svm.kernel.KernelFeatureList;
import de.unijena.bioinf.fingerid.svm.kernel.KernelModel;
import java.io.File;
import java.io.IOException;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_print_interface;
import libsvm.svm_problem;

public class KernelSvmInstance
implements SvmInstance {
    private svm_problem svm_instance = new svm_problem();
    private svm_parameter svm_params = KernelSvmInstance.defaultParameters();
    private Sample[] samples;

    private static void _enableDebugMode() {
        svm.svm_set_print_string_function((svm_print_interface)new svm_print_interface(){

            public void print(String s) {
                System.err.println(s);
            }
        });
    }

    private static void _disableDebugMode() {
        svm.svm_set_print_string_function((svm_print_interface)new svm_print_interface(){

            public void print(String s) {
            }
        });
    }

    @Override
    public void enableDebugMode() {
        KernelSvmInstance._enableDebugMode();
    }

    @Override
    public void disableDebugMode() {
        KernelSvmInstance._disableDebugMode();
    }

    @Override
    public void setSamples(Sample[] samples) {
        this.samples = samples;
        this.svm_instance.l = samples.length;
        this.svm_instance.x = new svm_node[samples.length][];
        this.svm_instance.y = new double[samples.length];
        for (int l = 0; l < this.svm_instance.l; ++l) {
            FeatureList featureList = samples[l].getFeatureList();
            this.svm_instance.x[l] = ((KernelFeatureList)featureList).getNodes();
            this.svm_instance.y[l] = samples[l].getLabel();
        }
    }

    @Override
    public void setWeights(int[] labels, double[] weights) {
        this.svm_params.weight = (double[])weights.clone();
        this.svm_params.weight_label = (int[])labels.clone();
        this.svm_params.nr_weight = weights.length;
    }

    @Override
    public void setParameter(String name, double value) {
        switch (name) {
            case "c": {
                this.svm_params.C = value;
                break;
            }
            case "cache_size": {
                this.svm_params.cache_size = value;
                break;
            }
            case "coef0": {
                this.svm_params.coef0 = value;
                break;
            }
            case "degree": {
                this.svm_params.degree = (int)value;
                break;
            }
            case "epsilon": {
                this.svm_params.eps = value;
                break;
            }
            case "gamma": {
                this.svm_params.gamma = value;
                break;
            }
            case "kernel_type": {
                this.svm_params.kernel_type = (int)value;
                break;
            }
            case "shrinking": {
                this.svm_params.shrinking = (int)value;
                break;
            }
            case "svm_type": {
                this.svm_params.svm_type = (int)value;
                break;
            }
            case "nu": {
                this.svm_params.nu = value;
                break;
            }
            case "p": {
                this.svm_params.p = value;
            }
        }
    }

    @Override
    public SvmModel train() {
        svm_model model = svm.svm_train((svm_problem)this.svm_instance, (svm_parameter)this.svm_params);
        return new KernelModel(model);
    }

    @Override
    public FeatureList newFeatureList(int size) {
        return new KernelFeatureList(size);
    }

    @Override
    public SvmInstance getCopy() {
        KernelSvmInstance kv = new KernelSvmInstance();
        kv.svm_instance = new svm_problem();
        kv.svm_instance.x = this.svm_instance.x;
        kv.svm_instance.y = this.svm_instance.y;
        kv.svm_instance.l = this.svm_instance.l;
        kv.svm_params = (svm_parameter)this.svm_params.clone();
        kv.samples = this.samples;
        return kv;
    }

    @Override
    public void setParametersFrom(SvmInstance other) {
        this.svm_params = ((KernelSvmInstance)other).svm_params;
    }

    @Override
    public void writeModel(File file, SvmModel model) throws IOException {
        KernelModel m = (KernelModel)model;
        svm.svm_save_model((String)file.getAbsolutePath(), (svm_model)m.model);
    }

    @Override
    public SvmModel readModel(File file) throws IOException {
        svm_model model = svm.svm_load_model((String)file.getAbsolutePath());
        return new KernelModel(model);
    }

    private static svm_parameter defaultParameters() {
        svm_parameter param = new svm_parameter();
        param.svm_type = 0;
        param.kernel_type = 1;
        param.degree = 2;
        param.gamma = 1.0;
        param.coef0 = 1.0;
        param.nu = 0.5;
        param.cache_size = 5000.0;
        param.C = 1.0;
        param.eps = 0.001;
        param.p = 0.1;
        param.shrinking = 1;
        param.probability = 0;
        param.weight_label = new int[]{1, -1};
        param.weight = new double[]{1.0, 1.0};
        param.nr_weight = param.weight.length;
        return param;
    }
}

