/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.svm.linear;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.FeatureNode;
import de.unijena.bioinf.fingerid.svm.FeatureList;
import java.util.Arrays;

class LinearFeatureList
implements FeatureList {
    private Feature[] features;
    private int k;

    LinearFeatureList(int size) {
        this.features = new Feature[size];
    }

    public Feature[] getNodes() {
        if (this.k < this.features.length) {
            this.features = Arrays.copyOf(this.features, this.k);
        }
        return this.features;
    }

    @Override
    public void add(int featureId, double value) {
        this.features[this.k++] = new FeatureNode(featureId + 1, value);
    }

    @Override
    public void addFeatureFrom(FeatureList featureList, int featureId) {
        this.features[this.k++] = ((LinearFeatureList)featureList).features[featureId];
    }

    @Override
    public int size() {
        return this.k;
    }
}

