/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.svm.linear;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Model;
import de.unijena.bioinf.fingerid.svm.Sample;
import de.unijena.bioinf.fingerid.svm.SvmModel;
import de.unijena.bioinf.fingerid.svm.linear.LinearFeatureList;

class LinearModel
implements SvmModel {
    protected Model model;

    LinearModel(Model model) {
        this.model = model;
    }

    @Override
    public double[] getFeatureWeights() {
        return this.model.getFeatureWeights();
    }

    @Override
    public int[] getSupportVectors() {
        return this.model.getLabels();
    }

    @Override
    public double getBias() {
        return this.model.getBias();
    }

    @Override
    public double[] predict(Sample[] samples) {
        double[] vector = new double[samples.length];
        for (int i = 0; i < samples.length; ++i) {
            vector[i] = this.predict(samples[i]);
        }
        return vector;
    }

    @Override
    public double predict(Sample sample) {
        double[] dv = new double[2];
        return Linear.predictValues((Model)this.model, (Feature[])((LinearFeatureList)sample.getFeatureList()).getNodes(), (double[])dv);
    }

    @Override
    public double computeDecisionValue(Sample sample) {
        double[] dv = new double[2];
        Linear.predictValues((Model)this.model, (Feature[])((LinearFeatureList)sample.getFeatureList()).getNodes(), (double[])dv);
        return dv[0];
    }

    @Override
    public double[] computeDecisionValues(Sample[] samples) {
        double[] vector = new double[samples.length];
        for (int i = 0; i < samples.length; ++i) {
            vector[i] = this.computeDecisionValue(samples[i]);
        }
        return vector;
    }

    @Override
    public double predictProbability(Sample sample) {
        double[] prob = new double[2];
        Linear.predictProbability((Model)this.model, (Feature[])((LinearFeatureList)sample.getFeatureList()).getNodes(), (double[])prob);
        return prob[0];
    }

    @Override
    public double[] predictProbabilities(Sample[] samples) {
        double[] vector = new double[samples.length];
        for (int i = 0; i < samples.length; ++i) {
            vector[i] = this.predictProbability(samples[i]);
        }
        return vector;
    }
}

