/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.svm.linear;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Model;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SolverType;
import de.bwaldvogel.liblinear.WeightBugfix;
import de.unijena.bioinf.fingerid.svm.FeatureList;
import de.unijena.bioinf.fingerid.svm.Sample;
import de.unijena.bioinf.fingerid.svm.SvmInstance;
import de.unijena.bioinf.fingerid.svm.SvmModel;
import de.unijena.bioinf.fingerid.svm.linear.LinearFeatureList;
import de.unijena.bioinf.fingerid.svm.linear.LinearModel;
import java.io.File;
import java.io.IOException;

public class LinearSvmInstance
implements SvmInstance {
    protected Sample[] samples;
    protected Problem problem;
    protected Parameter param = new Parameter(SolverType.L2R_L2LOSS_SVC, 1.0, 0.001);
    protected int maxFeatureSize;

    public LinearSvmInstance() {
        this.problem = new Problem();
        this.problem.bias = 5.0;
    }

    @Override
    public void enableDebugMode() {
        Linear.enableDebugOutput();
    }

    @Override
    public void disableDebugMode() {
        Linear.disableDebugOutput();
    }

    @Override
    public void setSamples(Sample[] samples) {
        this.samples = samples;
        this.problem.l = samples.length;
        this.maxFeatureSize = -1;
        this.problem.y = new double[samples.length];
        this.problem.x = new Feature[samples.length][];
        for (int i = 0; i < samples.length; ++i) {
            Sample s = samples[i];
            LinearFeatureList lf = (LinearFeatureList)s.getFeatureList();
            Feature[] features = lf.getNodes();
            this.maxFeatureSize = Math.max(this.maxFeatureSize, features[features.length - 1].getIndex());
            this.problem.x[i] = features;
            this.problem.y[i] = s.getLabel();
        }
    }

    @Override
    public void setWeights(int[] labels, double[] weights) {
        this.param.setWeights(weights, labels);
    }

    @Override
    public void setParameter(String name, double value) {
        switch (name) {
            case "c": {
                this.param.setC(value);
                break;
            }
            case "epsilon": {
                this.param.setEps(value);
                break;
            }
            case "p": {
                this.param.setP(value);
                break;
            }
            case "Solver": {
                this.param.setSolverType(SolverType.getById((int)((int)value)));
                break;
            }
            case "bias": {
                this.problem.bias = value;
            }
        }
    }

    @Override
    public SvmModel train() {
        this.problem.n = this.problem.bias > 0.0 ? this.maxFeatureSize + 1 : this.maxFeatureSize;
        Model m = Linear.train((Problem)this.problem, (Parameter)this.param);
        return new LinearModel(m);
    }

    @Override
    public FeatureList newFeatureList(int size) {
        return new LinearFeatureList(size);
    }

    @Override
    public SvmInstance getCopy() {
        Problem p = new Problem();
        p.n = this.problem.n;
        p.bias = this.problem.bias;
        p.x = this.problem.x;
        p.y = this.problem.y;
        p.l = this.problem.l;
        LinearSvmInstance i = new LinearSvmInstance();
        i.problem = p;
        i.samples = this.samples;
        i.maxFeatureSize = this.maxFeatureSize;
        i.setParametersFrom(this);
        return i;
    }

    @Override
    public void setParametersFrom(SvmInstance other) {
        LinearSvmInstance li = (LinearSvmInstance)other;
        Parameter a = new Parameter(li.param.getSolverType(), li.param.getC(), li.param.getEps());
        a.setP(li.param.getP());
        if (!WeightBugfix.weightsAreNull(li.param)) {
            a.setWeights(li.param.getWeights(), li.param.getWeightLabels());
        }
        this.param = a;
    }

    @Override
    public void writeModel(File file, SvmModel model) throws IOException {
        Linear.saveModel((File)file, (Model)((LinearModel)model).model);
    }

    @Override
    public SvmModel readModel(File file) throws IOException {
        return new LinearModel(Linear.loadModel((File)file));
    }
}

