/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.svm.linear;

import com.google.common.base.Function;
import de.bwaldvogel.liblinear.Linear2;
import de.bwaldvogel.liblinear.Model;
import de.unijena.bioinf.fingerid.svm.Sample;
import de.unijena.bioinf.fingerid.svm.SvmModel;
import de.unijena.bioinf.fingerid.svm.linear.LinearModel;
import de.unijena.bioinf.fingerid.svm.linear.LinearSvmInstance;

public class LinearSvmWithWeights
extends LinearSvmInstance {
    private Function<Sample, Double> weightFunction;

    public void setWeightFunction(Function<Sample, Double> fun) {
        this.weightFunction = fun;
    }

    @Override
    public SvmModel train() {
        if (this.weightFunction == null) {
            return super.train();
        }
        this.problem.n = this.problem.bias > 0.0 ? this.maxFeatureSize + 1 : this.maxFeatureSize;
        double[] weights = new double[this.problem.l];
        for (int k = 0; k < weights.length; ++k) {
            Double v = (Double)this.weightFunction.apply((Object)this.samples[k]);
            weights[k] = v == null ? 1.0 : v;
        }
        Model m = Linear2.train(this.problem, this.param, weights);
        return new LinearModel(m);
    }
}

