/*
 * Decompiled with CFR 0.152.
 */
package org.libsvm;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import java.util.StringTokenizer;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_print_interface;
import libsvm.svm_problem;
import org.libsvm.Kernel;
import org.libsvm.SVC_Q;
import org.libsvm.Solver;

public class SVM {
    public static final int LIBSVM_VERSION = 321;
    public static final Random rand = new Random();
    private static svm_print_interface svm_print_stdout;
    private static svm_print_interface svm_print_string;
    static final String[] svm_type_table;
    static final String[] kernel_type_table;

    static void info(String s) {
        svm_print_string.print(s);
    }

    private static void solve_c_svc(svm_problem prob, svm_parameter param, double[] alpha, Solver.SolutionInfo si, double Cp, double Cn, double[] sample_weigts) {
        int i;
        int l = prob.l;
        double[] minus_ones = new double[l];
        byte[] y = new byte[l];
        for (i = 0; i < l; ++i) {
            alpha[i] = 0.0;
            minus_ones[i] = -1.0;
            y[i] = prob.y[i] > 0.0 ? 1 : -1;
        }
        Solver s = new Solver();
        s.Solve(l, new SVC_Q(prob, param, y), minus_ones, y, alpha, Cp, Cn, param.eps, si, param.shrinking, sample_weigts);
        double sum_alpha = 0.0;
        for (i = 0; i < l; ++i) {
            sum_alpha += alpha[i];
        }
        if (Cp == Cn) {
            SVM.info("nu = " + sum_alpha / (Cp * (double)prob.l) + "\n");
        }
        for (i = 0; i < l; ++i) {
            int n = i;
            alpha[n] = alpha[n] * (double)y[i];
        }
    }

    static decision_function svm_train_one(svm_problem prob, svm_parameter param, double Cp, double Cn, double[] sample_weights) {
        double[] alpha = new double[prob.l];
        Solver.SolutionInfo si = new Solver.SolutionInfo();
        switch (param.svm_type) {
            case 0: {
                SVM.solve_c_svc(prob, param, alpha, si, Cp, Cn, sample_weights);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        SVM.info("obj = " + si.obj + ", rho = " + si.rho + "\n");
        int nSV = 0;
        int nBSV = 0;
        for (int i = 0; i < prob.l; ++i) {
            if (!(Math.abs(alpha[i]) > 0.0)) continue;
            ++nSV;
            if (prob.y[i] > 0.0) {
                if (!(Math.abs(alpha[i]) >= si.upper_bound_p)) continue;
                ++nBSV;
                continue;
            }
            if (!(Math.abs(alpha[i]) >= si.upper_bound_n)) continue;
            ++nBSV;
        }
        SVM.info("nSV = " + nSV + ", nBSV = " + nBSV + "\n");
        decision_function f = new decision_function();
        f.alpha = alpha;
        f.rho = si.rho;
        return f;
    }

    private static void sigmoid_train(int l, double[] dec_values, double[] labels, double[] probAB) {
        int iter;
        double fApB;
        int i;
        double prior1 = 0.0;
        double prior0 = 0.0;
        for (i = 0; i < l; ++i) {
            if (labels[i] > 0.0) {
                prior1 += 1.0;
                continue;
            }
            prior0 += 1.0;
        }
        int max_iter = 100;
        double min_step = 1.0E-10;
        double sigma = 1.0E-12;
        double eps = 1.0E-5;
        double hiTarget = (prior1 + 1.0) / (prior1 + 2.0);
        double loTarget = 1.0 / (prior0 + 2.0);
        double[] t = new double[l];
        double A = 0.0;
        double B = Math.log((prior0 + 1.0) / (prior1 + 1.0));
        double fval = 0.0;
        for (i = 0; i < l; ++i) {
            t[i] = labels[i] > 0.0 ? hiTarget : loTarget;
            fApB = dec_values[i] * A + B;
            if (fApB >= 0.0) {
                fval += t[i] * fApB + Math.log(1.0 + Math.exp(-fApB));
                continue;
            }
            fval += (t[i] - 1.0) * fApB + Math.log(1.0 + Math.exp(fApB));
        }
        for (iter = 0; iter < max_iter; ++iter) {
            double stepsize;
            double h11 = sigma;
            double h22 = sigma;
            double h21 = 0.0;
            double g1 = 0.0;
            double g2 = 0.0;
            for (i = 0; i < l; ++i) {
                double q;
                double p;
                fApB = dec_values[i] * A + B;
                if (fApB >= 0.0) {
                    p = Math.exp(-fApB) / (1.0 + Math.exp(-fApB));
                    q = 1.0 / (1.0 + Math.exp(-fApB));
                } else {
                    p = 1.0 / (1.0 + Math.exp(fApB));
                    q = Math.exp(fApB) / (1.0 + Math.exp(fApB));
                }
                double d2 = p * q;
                h11 += dec_values[i] * dec_values[i] * d2;
                h22 += d2;
                h21 += dec_values[i] * d2;
                double d1 = t[i] - p;
                g1 += dec_values[i] * d1;
                g2 += d1;
            }
            if (Math.abs(g1) < eps && Math.abs(g2) < eps) break;
            double det = h11 * h22 - h21 * h21;
            double dA = -(h22 * g1 - h21 * g2) / det;
            double dB = -(-h21 * g1 + h11 * g2) / det;
            double gd = g1 * dA + g2 * dB;
            for (stepsize = 1.0; stepsize >= min_step; stepsize /= 2.0) {
                double newA = A + stepsize * dA;
                double newB = B + stepsize * dB;
                double newf = 0.0;
                for (i = 0; i < l; ++i) {
                    fApB = dec_values[i] * newA + newB;
                    if (fApB >= 0.0) {
                        newf += t[i] * fApB + Math.log(1.0 + Math.exp(-fApB));
                        continue;
                    }
                    newf += (t[i] - 1.0) * fApB + Math.log(1.0 + Math.exp(fApB));
                }
                if (!(newf < fval + 1.0E-4 * stepsize * gd)) continue;
                A = newA;
                B = newB;
                fval = newf;
                break;
            }
            if (!(stepsize < min_step)) continue;
            SVM.info("Line search fails in two-class probability estimates\n");
            break;
        }
        if (iter >= max_iter) {
            SVM.info("Reaching maximal iterations in two-class probability estimates\n");
        }
        probAB[0] = A;
        probAB[1] = B;
    }

    private static double sigmoid_predict(double decision_value, double A, double B) {
        double fApB = decision_value * A + B;
        if (fApB >= 0.0) {
            return Math.exp(-fApB) / (1.0 + Math.exp(-fApB));
        }
        return 1.0 / (1.0 + Math.exp(fApB));
    }

    private static void multiclass_probability(int k, double[][] r, double[] p) {
        int j;
        int t;
        int iter = 0;
        int max_iter = Math.max(100, k);
        double[][] Q = new double[k][k];
        double[] Qp = new double[k];
        double eps = 0.005 / (double)k;
        for (t = 0; t < k; ++t) {
            p[t] = 1.0 / (double)k;
            Q[t][t] = 0.0;
            for (j = 0; j < t; ++j) {
                double[] dArray = Q[t];
                int n = t;
                dArray[n] = dArray[n] + r[j][t] * r[j][t];
                Q[t][j] = Q[j][t];
            }
            for (j = t + 1; j < k; ++j) {
                double[] dArray = Q[t];
                int n = t;
                dArray[n] = dArray[n] + r[j][t] * r[j][t];
                Q[t][j] = -r[j][t] * r[t][j];
            }
        }
        for (iter = 0; iter < max_iter; ++iter) {
            double pQp = 0.0;
            for (t = 0; t < k; ++t) {
                Qp[t] = 0.0;
                for (j = 0; j < k; ++j) {
                    int n = t;
                    Qp[n] = Qp[n] + Q[t][j] * p[j];
                }
                pQp += p[t] * Qp[t];
            }
            double max_error = 0.0;
            for (t = 0; t < k; ++t) {
                double error = Math.abs(Qp[t] - pQp);
                if (!(error > max_error)) continue;
                max_error = error;
            }
            if (max_error < eps) break;
            for (t = 0; t < k; ++t) {
                double diff = (-Qp[t] + pQp) / Q[t][t];
                int n = t;
                p[n] = p[n] + diff;
                pQp = (pQp + diff * (diff * Q[t][t] + 2.0 * Qp[t])) / (1.0 + diff) / (1.0 + diff);
                j = 0;
                while (j < k) {
                    Qp[j] = (Qp[j] + diff * Q[t][j]) / (1.0 + diff);
                    int n2 = j++;
                    p[n2] = p[n2] / (1.0 + diff);
                }
            }
        }
        if (iter >= max_iter) {
            SVM.info("Exceeds max_iter in multiclass_prob\n");
        }
    }

    private static void svm_binary_svc_probability(svm_problem prob, svm_parameter param, double Cp, double Cn, double[] probAB, double[] sample_weights) {
        int i;
        int nr_fold = 5;
        int[] perm = new int[prob.l];
        double[] dec_values = new double[prob.l];
        for (i = 0; i < prob.l; ++i) {
            perm[i] = i;
        }
        for (i = 0; i < prob.l; ++i) {
            int j = i + rand.nextInt(prob.l - i);
            int _ = perm[i];
            perm[i] = perm[j];
            perm[j] = _;
        }
        for (i = 0; i < nr_fold; ++i) {
            int j;
            int begin = i * prob.l / nr_fold;
            int end = (i + 1) * prob.l / nr_fold;
            svm_problem subprob = new svm_problem();
            subprob.l = prob.l - (end - begin);
            subprob.x = new svm_node[subprob.l][];
            subprob.y = new double[subprob.l];
            int k = 0;
            for (j = 0; j < begin; ++j) {
                subprob.x[k] = prob.x[perm[j]];
                subprob.y[k] = prob.y[perm[j]];
                ++k;
            }
            for (j = end; j < prob.l; ++j) {
                subprob.x[k] = prob.x[perm[j]];
                subprob.y[k] = prob.y[perm[j]];
                ++k;
            }
            int p_count = 0;
            int n_count = 0;
            for (j = 0; j < k; ++j) {
                if (subprob.y[j] > 0.0) {
                    ++p_count;
                    continue;
                }
                ++n_count;
            }
            if (p_count == 0 && n_count == 0) {
                for (j = begin; j < end; ++j) {
                    dec_values[perm[j]] = 0.0;
                }
                continue;
            }
            if (p_count > 0 && n_count == 0) {
                for (j = begin; j < end; ++j) {
                    dec_values[perm[j]] = 1.0;
                }
                continue;
            }
            if (p_count == 0 && n_count > 0) {
                for (j = begin; j < end; ++j) {
                    dec_values[perm[j]] = -1.0;
                }
                continue;
            }
            svm_parameter subparam = (svm_parameter)param.clone();
            subparam.probability = 0;
            subparam.C = 1.0;
            subparam.nr_weight = 2;
            subparam.weight_label = new int[2];
            subparam.weight = new double[2];
            subparam.weight_label[0] = 1;
            subparam.weight_label[1] = -1;
            subparam.weight[0] = Cp;
            subparam.weight[1] = Cn;
            svm_model submodel = SVM.svm_train(subprob, subparam, sample_weights);
            for (j = begin; j < end; ++j) {
                double[] dec_value = new double[1];
                SVM.svm_predict_values(submodel, prob.x[perm[j]], dec_value);
                dec_values[perm[j]] = dec_value[0];
                int n = perm[j];
                dec_values[n] = dec_values[n] * (double)submodel.label[0];
            }
        }
        SVM.sigmoid_train(prob.l, dec_values, prob.y, probAB);
    }

    private static void svm_group_classes(svm_problem prob, int[] nr_class_ret, int[][] label_ret, int[][] start_ret, int[][] count_ret, int[] perm) {
        int i;
        int l = prob.l;
        int max_nr_class = 16;
        int nr_class = 0;
        int[] label = new int[max_nr_class];
        int[] count = new int[max_nr_class];
        int[] data_label = new int[l];
        for (i = 0; i < l; ++i) {
            int j;
            int this_label = (int)prob.y[i];
            for (j = 0; j < nr_class; ++j) {
                if (this_label != label[j]) continue;
                int n = j;
                count[n] = count[n] + 1;
                break;
            }
            data_label[i] = j;
            if (j != nr_class) continue;
            if (nr_class == max_nr_class) {
                int[] new_data = new int[max_nr_class *= 2];
                System.arraycopy(label, 0, new_data, 0, label.length);
                label = new_data;
                new_data = new int[max_nr_class];
                System.arraycopy(count, 0, new_data, 0, count.length);
                count = new_data;
            }
            label[nr_class] = this_label;
            count[nr_class] = 1;
            ++nr_class;
        }
        if (nr_class == 2 && label[0] == -1 && label[1] == 1) {
            int _ = label[0];
            label[0] = label[1];
            label[1] = _;
            _ = count[0];
            count[0] = count[1];
            count[1] = _;
            for (i = 0; i < l; ++i) {
                data_label[i] = data_label[i] == 0 ? 1 : 0;
            }
        }
        int[] start = new int[nr_class];
        start[0] = 0;
        for (i = 1; i < nr_class; ++i) {
            start[i] = start[i - 1] + count[i - 1];
        }
        for (i = 0; i < l; ++i) {
            perm[start[data_label[i]]] = i;
            int n = data_label[i];
            start[n] = start[n] + 1;
        }
        start[0] = 0;
        for (i = 1; i < nr_class; ++i) {
            start[i] = start[i - 1] + count[i - 1];
        }
        nr_class_ret[0] = nr_class;
        label_ret[0] = label;
        start_ret[0] = start;
        count_ret[0] = count;
    }

    public static svm_model svm_train(svm_problem prob, svm_parameter param, double[] sample_weights) {
        if (sample_weights != null) {
            // empty if block
        }
        return svm.svm_train((svm_problem)prob, (svm_parameter)param);
    }

    public static int svm_get_svm_type(svm_model model) {
        return model.param.svm_type;
    }

    public static int svm_get_nr_class(svm_model model) {
        return model.nr_class;
    }

    public static void svm_get_labels(svm_model model, int[] label) {
        if (model.label != null) {
            for (int i = 0; i < model.nr_class; ++i) {
                label[i] = model.label[i];
            }
        }
    }

    public static void svm_get_sv_indices(svm_model model, int[] indices) {
        if (model.sv_indices != null) {
            for (int i = 0; i < model.l; ++i) {
                indices[i] = model.sv_indices[i];
            }
        }
    }

    public static int svm_get_nr_sv(svm_model model) {
        return model.l;
    }

    public static double svm_get_svr_probability(svm_model model) {
        if ((model.param.svm_type == 3 || model.param.svm_type == 4) && model.probA != null) {
            return model.probA[0];
        }
        System.err.print("Model doesn't contain information for SVR probability inference\n");
        return 0.0;
    }

    public static double svm_predict_values(svm_model model, svm_node[] x, double[] dec_values) {
        int i;
        if (model.param.svm_type == 2 || model.param.svm_type == 3 || model.param.svm_type == 4) {
            double[] sv_coef = model.sv_coef[0];
            double sum = 0.0;
            for (int i2 = 0; i2 < model.l; ++i2) {
                sum += sv_coef[i2] * Kernel.k_function(x, model.SV[i2], model.param);
            }
            dec_values[0] = sum -= model.rho[0];
            if (model.param.svm_type == 2) {
                return sum > 0.0 ? 1.0 : -1.0;
            }
            return sum;
        }
        int nr_class = model.nr_class;
        int l = model.l;
        double[] kvalue = new double[l];
        for (i = 0; i < l; ++i) {
            kvalue[i] = Kernel.k_function(x, model.SV[i], model.param);
        }
        int[] start = new int[nr_class];
        start[0] = 0;
        for (i = 1; i < nr_class; ++i) {
            start[i] = start[i - 1] + model.nSV[i - 1];
        }
        int[] vote = new int[nr_class];
        for (i = 0; i < nr_class; ++i) {
            vote[i] = 0;
        }
        int p = 0;
        for (i = 0; i < nr_class; ++i) {
            for (int j = i + 1; j < nr_class; ++j) {
                int k;
                double sum = 0.0;
                int si = start[i];
                int sj = start[j];
                int ci = model.nSV[i];
                int cj = model.nSV[j];
                double[] coef1 = model.sv_coef[j - 1];
                double[] coef2 = model.sv_coef[i];
                for (k = 0; k < ci; ++k) {
                    sum += coef1[si + k] * kvalue[si + k];
                }
                for (k = 0; k < cj; ++k) {
                    sum += coef2[sj + k] * kvalue[sj + k];
                }
                dec_values[p] = sum -= model.rho[p];
                if (dec_values[p] > 0.0) {
                    int n = i;
                    vote[n] = vote[n] + 1;
                } else {
                    int n = j;
                    vote[n] = vote[n] + 1;
                }
                ++p;
            }
        }
        int vote_max_idx = 0;
        for (i = 1; i < nr_class; ++i) {
            if (vote[i] <= vote[vote_max_idx]) continue;
            vote_max_idx = i;
        }
        return model.label[vote_max_idx];
    }

    public static double svm_predict(svm_model model, svm_node[] x) {
        int nr_class = model.nr_class;
        double[] dec_values = model.param.svm_type == 2 || model.param.svm_type == 3 || model.param.svm_type == 4 ? new double[1] : new double[nr_class * (nr_class - 1) / 2];
        double pred_result = SVM.svm_predict_values(model, x, dec_values);
        return pred_result;
    }

    public static double svm_predict_probability(svm_model model, svm_node[] x, double[] prob_estimates) {
        if ((model.param.svm_type == 0 || model.param.svm_type == 1) && model.probA != null && model.probB != null) {
            int i;
            int nr_class = model.nr_class;
            double[] dec_values = new double[nr_class * (nr_class - 1) / 2];
            SVM.svm_predict_values(model, x, dec_values);
            double min_prob = 1.0E-7;
            double[][] pairwise_prob = new double[nr_class][nr_class];
            int k = 0;
            for (i = 0; i < nr_class; ++i) {
                for (int j = i + 1; j < nr_class; ++j) {
                    pairwise_prob[i][j] = Math.min(Math.max(SVM.sigmoid_predict(dec_values[k], model.probA[k], model.probB[k]), min_prob), 1.0 - min_prob);
                    pairwise_prob[j][i] = 1.0 - pairwise_prob[i][j];
                    ++k;
                }
            }
            SVM.multiclass_probability(nr_class, pairwise_prob, prob_estimates);
            int prob_max_idx = 0;
            for (i = 1; i < nr_class; ++i) {
                if (!(prob_estimates[i] > prob_estimates[prob_max_idx])) continue;
                prob_max_idx = i;
            }
            return model.label[prob_max_idx];
        }
        return SVM.svm_predict(model, x);
    }

    public static void svm_save_model(String model_file_name, svm_model model) throws IOException {
        int i;
        DataOutputStream fp = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(model_file_name)));
        svm_parameter param = model.param;
        fp.writeBytes("svm_type " + svm_type_table[param.svm_type] + "\n");
        fp.writeBytes("kernel_type " + kernel_type_table[param.kernel_type] + "\n");
        if (param.kernel_type == 1) {
            fp.writeBytes("degree " + param.degree + "\n");
        }
        if (param.kernel_type == 1 || param.kernel_type == 2 || param.kernel_type == 3) {
            fp.writeBytes("gamma " + param.gamma + "\n");
        }
        if (param.kernel_type == 1 || param.kernel_type == 3) {
            fp.writeBytes("coef0 " + param.coef0 + "\n");
        }
        int nr_class = model.nr_class;
        int l = model.l;
        fp.writeBytes("nr_class " + nr_class + "\n");
        fp.writeBytes("total_sv " + l + "\n");
        fp.writeBytes("rho");
        for (i = 0; i < nr_class * (nr_class - 1) / 2; ++i) {
            fp.writeBytes(" " + model.rho[i]);
        }
        fp.writeBytes("\n");
        if (model.label != null) {
            fp.writeBytes("label");
            for (i = 0; i < nr_class; ++i) {
                fp.writeBytes(" " + model.label[i]);
            }
            fp.writeBytes("\n");
        }
        if (model.probA != null) {
            fp.writeBytes("probA");
            for (i = 0; i < nr_class * (nr_class - 1) / 2; ++i) {
                fp.writeBytes(" " + model.probA[i]);
            }
            fp.writeBytes("\n");
        }
        if (model.probB != null) {
            fp.writeBytes("probB");
            for (i = 0; i < nr_class * (nr_class - 1) / 2; ++i) {
                fp.writeBytes(" " + model.probB[i]);
            }
            fp.writeBytes("\n");
        }
        if (model.nSV != null) {
            fp.writeBytes("nr_sv");
            for (i = 0; i < nr_class; ++i) {
                fp.writeBytes(" " + model.nSV[i]);
            }
            fp.writeBytes("\n");
        }
        fp.writeBytes("SV\n");
        double[][] sv_coef = model.sv_coef;
        svm_node[][] SV = model.SV;
        for (int i2 = 0; i2 < l; ++i2) {
            for (int j = 0; j < nr_class - 1; ++j) {
                fp.writeBytes(sv_coef[j][i2] + " ");
            }
            svm_node[] p = SV[i2];
            if (param.kernel_type == 4) {
                fp.writeBytes("0:" + (int)p[0].value);
            } else {
                for (int j = 0; j < p.length; ++j) {
                    fp.writeBytes(p[j].index + ":" + p[j].value + " ");
                }
            }
            fp.writeBytes("\n");
        }
        fp.close();
    }

    private static double atof(String s) {
        return Double.valueOf(s);
    }

    private static int atoi(String s) {
        return Integer.parseInt(s);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean read_model_header(BufferedReader fp, svm_model model) {
        svm_parameter param;
        model.param = param = new svm_parameter();
        try {
            block2: while (true) {
                int i;
                String arg;
                block25: {
                    String cmd = fp.readLine();
                    arg = cmd.substring(cmd.indexOf(32) + 1);
                    if (cmd.startsWith("svm_type")) {
                    } else if (cmd.startsWith("kernel_type")) {
                        break block25;
                    } else {
                        int i2;
                        StringTokenizer st;
                        int n;
                        if (cmd.startsWith("degree")) {
                            param.degree = SVM.atoi(arg);
                            continue;
                        }
                        if (cmd.startsWith("gamma")) {
                            param.gamma = SVM.atof(arg);
                            continue;
                        }
                        if (cmd.startsWith("coef0")) {
                            param.coef0 = SVM.atof(arg);
                            continue;
                        }
                        if (cmd.startsWith("nr_class")) {
                            model.nr_class = SVM.atoi(arg);
                            continue;
                        }
                        if (cmd.startsWith("total_sv")) {
                            model.l = SVM.atoi(arg);
                            continue;
                        }
                        if (cmd.startsWith("rho")) {
                            n = model.nr_class * (model.nr_class - 1) / 2;
                            model.rho = new double[n];
                            st = new StringTokenizer(arg);
                            i2 = 0;
                            while (true) {
                                if (i2 >= n) continue block2;
                                model.rho[i2] = SVM.atof(st.nextToken());
                                ++i2;
                            }
                        }
                        if (cmd.startsWith("label")) {
                            n = model.nr_class;
                            model.label = new int[n];
                            st = new StringTokenizer(arg);
                            i2 = 0;
                            while (true) {
                                if (i2 >= n) continue block2;
                                model.label[i2] = SVM.atoi(st.nextToken());
                                ++i2;
                            }
                        }
                        if (cmd.startsWith("probA")) {
                            n = model.nr_class * (model.nr_class - 1) / 2;
                            model.probA = new double[n];
                            st = new StringTokenizer(arg);
                            i2 = 0;
                            while (true) {
                                if (i2 >= n) continue block2;
                                model.probA[i2] = SVM.atof(st.nextToken());
                                ++i2;
                            }
                        }
                        if (cmd.startsWith("probB")) {
                            n = model.nr_class * (model.nr_class - 1) / 2;
                            model.probB = new double[n];
                            st = new StringTokenizer(arg);
                            i2 = 0;
                            while (true) {
                                if (i2 >= n) continue block2;
                                model.probB[i2] = SVM.atof(st.nextToken());
                                ++i2;
                            }
                        }
                        if (cmd.startsWith("nr_sv")) {
                            n = model.nr_class;
                            model.nSV = new int[n];
                            st = new StringTokenizer(arg);
                            i2 = 0;
                            while (true) {
                                if (i2 >= n) continue block2;
                                model.nSV[i2] = SVM.atoi(st.nextToken());
                                ++i2;
                            }
                        }
                        if (cmd.startsWith("SV")) {
                            return true;
                        }
                        System.err.print("unknown text in model file: [" + cmd + "]\n");
                        return false;
                    }
                    for (i = 0; i < svm_type_table.length; ++i) {
                        if (arg.indexOf(svm_type_table[i]) == -1) continue;
                        param.svm_type = i;
                        break;
                    }
                    if (i != svm_type_table.length) continue;
                    System.err.print("unknown SVM type.\n");
                    return false;
                }
                for (i = 0; i < kernel_type_table.length; ++i) {
                    if (arg.indexOf(kernel_type_table[i]) == -1) continue;
                    param.kernel_type = i;
                    break;
                }
                if (i == kernel_type_table.length) break;
            }
            System.err.print("unknown kernel function.\n");
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static svm_model svm_load_model(String model_file_name) throws IOException {
        return SVM.svm_load_model(new BufferedReader(new FileReader(model_file_name)));
    }

    public static svm_model svm_load_model(BufferedReader fp) throws IOException {
        svm_model model = new svm_model();
        model.rho = null;
        model.probA = null;
        model.probB = null;
        model.label = null;
        model.nSV = null;
        if (!SVM.read_model_header(fp, model)) {
            System.err.print("ERROR: failed to read model\n");
            return null;
        }
        int m = model.nr_class - 1;
        int l = model.l;
        model.sv_coef = new double[m][l];
        model.SV = new svm_node[l][];
        for (int i = 0; i < l; ++i) {
            String line = fp.readLine();
            StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
            for (int k = 0; k < m; ++k) {
                model.sv_coef[k][i] = SVM.atof(st.nextToken());
            }
            int n = st.countTokens() / 2;
            model.SV[i] = new svm_node[n];
            for (int j = 0; j < n; ++j) {
                model.SV[i][j] = new svm_node();
                model.SV[i][j].index = SVM.atoi(st.nextToken());
                model.SV[i][j].value = SVM.atof(st.nextToken());
            }
        }
        fp.close();
        return model;
    }

    public static String svm_check_parameter(svm_problem prob, svm_parameter param) {
        int svm_type = param.svm_type;
        if (svm_type != 0 && svm_type != 1 && svm_type != 2 && svm_type != 3 && svm_type != 4) {
            return "unknown SVM type";
        }
        int kernel_type = param.kernel_type;
        if (kernel_type != 0 && kernel_type != 1 && kernel_type != 2 && kernel_type != 3 && kernel_type != 4) {
            return "unknown kernel type";
        }
        if (param.gamma < 0.0) {
            return "gamma < 0";
        }
        if (param.degree < 0) {
            return "degree of polynomial kernel < 0";
        }
        if (param.cache_size <= 0.0) {
            return "cache_size <= 0";
        }
        if (param.eps <= 0.0) {
            return "eps <= 0";
        }
        if ((svm_type == 0 || svm_type == 3 || svm_type == 4) && param.C <= 0.0) {
            return "C <= 0";
        }
        if ((svm_type == 1 || svm_type == 2 || svm_type == 4) && (param.nu <= 0.0 || param.nu > 1.0)) {
            return "nu <= 0 or nu > 1";
        }
        if (svm_type == 3 && param.p < 0.0) {
            return "p < 0";
        }
        if (param.shrinking != 0 && param.shrinking != 1) {
            return "shrinking != 0 and shrinking != 1";
        }
        if (param.probability != 0 && param.probability != 1) {
            return "probability != 0 and probability != 1";
        }
        if (param.probability == 1 && svm_type == 2) {
            return "one-class SVM probability output not supported yet";
        }
        if (svm_type == 1) {
            int j;
            int i;
            int l = prob.l;
            int max_nr_class = 16;
            int nr_class = 0;
            int[] label = new int[max_nr_class];
            int[] count = new int[max_nr_class];
            for (i = 0; i < l; ++i) {
                int this_label = (int)prob.y[i];
                for (j = 0; j < nr_class; ++j) {
                    if (this_label != label[j]) continue;
                    int n = j;
                    count[n] = count[n] + 1;
                    break;
                }
                if (j != nr_class) continue;
                if (nr_class == max_nr_class) {
                    int[] new_data = new int[max_nr_class *= 2];
                    System.arraycopy(label, 0, new_data, 0, label.length);
                    label = new_data;
                    new_data = new int[max_nr_class];
                    System.arraycopy(count, 0, new_data, 0, count.length);
                    count = new_data;
                }
                label[nr_class] = this_label;
                count[nr_class] = 1;
                ++nr_class;
            }
            for (i = 0; i < nr_class; ++i) {
                int n1 = count[i];
                for (j = i + 1; j < nr_class; ++j) {
                    int n2 = count[j];
                    if (!(param.nu * (double)(n1 + n2) / 2.0 > (double)Math.min(n1, n2))) continue;
                    return "specified nu is infeasible";
                }
            }
        }
        return null;
    }

    public static int svm_check_probability_model(svm_model model) {
        if ((model.param.svm_type == 0 || model.param.svm_type == 1) && model.probA != null && model.probB != null || (model.param.svm_type == 3 || model.param.svm_type == 4) && model.probA != null) {
            return 1;
        }
        return 0;
    }

    public static void svm_set_print_string_function(svm_print_interface print_func) {
        svm_print_string = print_func == null ? svm_print_stdout : print_func;
    }

    static {
        svm_print_string = svm_print_stdout = new svm_print_interface(){

            public void print(String s) {
                System.out.print(s);
                System.out.flush();
            }
        };
        svm_type_table = new String[]{"c_svc", "nu_svc", "one_class", "epsilon_svr", "nu_svr"};
        kernel_type_table = new String[]{"linear", "polynomial", "rbf", "sigmoid", "precomputed"};
    }

    static class decision_function {
        double[] alpha;
        double rho;

        decision_function() {
        }
    }
}

