/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingeriddb;

import de.unijena.bioinf.ChemistryBase.properties.PropertyManager;
import de.unijena.bioinf.fingerid.utils.FingerIDProperties;
import de.unijena.bioinf.fingeriddb.Authorization;
import de.unijena.bioinf.fingeriddb.DBCandidate;
import de.unijena.bioinf.fingeriddb.FingerCandidate;
import de.unijena.bioinf.fingeriddb.FingerIdInstance;
import de.unijena.bioinf.fingeriddb.FingerTreeResult;
import de.unijena.bioinf.fingeriddb.FingerblastResult;
import de.unijena.bioinf.fingeriddb.InstanceState;
import de.unijena.bioinf.fingeriddb.JsonSerializer;
import de.unijena.bioinf.fingeriddb.MolecularFeatureStats;
import de.unijena.bioinf.fingeriddb.News;
import de.unijena.bioinf.fingeriddb.Status;
import de.unijena.bioinf.fingeriddb.job.FingerIdJob;
import de.unijena.bioinf.fingeriddb.job.JobState;
import de.unijena.bioinf.fingeriddb.job.JobType;
import de.unijena.bioinf.fingeriddb.job.PredictorType;
import de.unijena.bioinf.fingeriddb.job.SiriusPredictionJob;
import de.unijena.bioinf.fingeriddb.job.TreeJob;
import de.unijena.bioinf.fingeriddb.stats.UsageStats;
import de.unijena.bioinf.fingeriddb.stats.UserStats;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.json.Json;
import javax.json.stream.JsonParser;
import joptsimple.internal.Strings;
import net.efabrika.util.DBTablePrinter;
import org.slf4j.LoggerFactory;

public class FingerIdDB
implements Closeable {
    protected String host;
    protected String username;
    protected String password;
    protected Connection connection;
    protected static final String localhostName;
    private final ExecutorService timeoutExecutor = Executors.newCachedThreadPool();
    private List<PreparedStatement> _sqlDeleteOldJobs;
    private PreparedStatement _sqlCountWorker;
    private PreparedStatement _sqlCountWorkerOnHost;
    private PreparedStatement _sqlUpdateWorkerAlive;
    private PreparedStatement _sqlAddWorker;
    private PreparedStatement _sqlWorkerState;
    private PreparedStatement _sqlWorkerStatesByVersion;
    private PreparedStatement _sqlWorkerStatesByPrefixVersion;
    private PreparedStatement _sqlWorkerStatesByPrefix;
    private PreparedStatement _sqlWorkerStatesWithBackup;
    private PreparedStatement _sqlWorkerStates;
    private PreparedStatement _sqlShutdownWorkersByTime;
    private PreparedStatement _sqlRemoveShutdownedWorkersByTime;
    private PreparedStatement _sqlRemoveWorker;
    private PreparedStatement _sqlRemoveWorkers;
    private PreparedStatement _sqlGetWorkerState;
    private PreparedStatement _sqlCountNumberOfJobs;
    private PreparedStatement _sqlSubmitBySirius;
    private PreparedStatement _sqlFindFingerblastResult;
    private PreparedStatement _sqlFindFingerblastResultsBio;
    private PreparedStatement _sqlFindTreeJob;
    private PreparedStatement _sqlFindFingerIdJob;
    private PreparedStatement _sqlTreeResults;
    private PreparedStatement _sqlTree;
    private PreparedStatement _sqlFingerIdJobUpdateFinished;
    private PreparedStatement _sqlTreeJobUpdateFinished;
    private PreparedStatement _sqlTreeJobUpdateProgress;
    private PreparedStatement _sqlUserStats;
    private PreparedStatement _sqlUsageStats;
    private PreparedStatement _sqlLastUsageStats;
    private PreparedStatement _sqlFingerIdJobStatementForUpdate;
    private PreparedStatement _sqlSiriusPredictionJobStatementForUpdate;
    private PreparedStatement _sqlSiriusPredictionJobStatementStatus;
    private PreparedStatement _sqlSiriusPredictionJobStatement;
    private PreparedStatement _sqlTreeJobStatementForUpdate;
    private PreparedStatement _sqlFindInstance;
    private PreparedStatement _sqlCountCompoundCandidates;
    private PreparedStatement _sqlSetCountCompoundCandidates;
    private PreparedStatement _sqlCountTrees;
    private PreparedStatement _sqlFindAllFingerprintJobs;
    private PreparedStatement _sqlVerifyInstance;
    private PreparedStatement _sqlIsWebAPIVersionInTable;
    private PreparedStatement _sqlRegisterWebAPI;
    private PreparedStatement _sqlIsWebAPIExpired;
    private PreparedStatement _sqlGetAcceptJobDate;
    private PreparedStatement _sqlGetFinishJobDate;
    private PreparedStatement _sqlGetMessages;
    private PreparedStatement _sqlGetLatestStatsTime;

    public FingerIdDB() throws SQLException {
        this.setup();
        this.connect();
    }

    private void setup() {
        this.host = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.fingerid.fingerid_db.host");
        this.username = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.fingerid.fingerid_db.username");
        this.password = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.fingerid.fingerid_db.password");
    }

    public FingerIdDB(String host, String username, String password) throws SQLException {
        this.host = host;
        this.username = username;
        this.password = password;
        this.connect();
    }

    public boolean containsWebserviceEntry(String version) throws SQLException {
        PreparedStatement statement = this.sqlIsWebAPIVersionInTable();
        statement.setString(1, version);
        statement.execute();
        Throwable throwable = null;
        try (ResultSet s = statement.getResultSet();){
            if (s.next()) {
                boolean bl = s.getInt(1) > 0;
                return bl;
            }
            try {
                throw new SQLDataException("Empty Return Set!");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void registerWebservice() throws SQLException {
        PreparedStatement statement = this.sqlRegisterWebAPI();
        statement.setString(1, FingerIDProperties.fingeridVersion());
        statement.executeUpdate();
    }

    public boolean isWebserviceExpired(String version) throws SQLException {
        PreparedStatement statement = this.sqlIsWebAPIExpired();
        statement.setString(1, version);
        statement.execute();
        Throwable throwable = null;
        try (ResultSet s = statement.getResultSet();){
            if (s.next()) {
                boolean bl = s.getBoolean(1);
                return bl;
            }
            try {
                throw new SQLDataException("Empty Return Set!");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public boolean isWebserviceAcceptJobs(String version) throws SQLException {
        return this.isLaterThanNow(this.sqlGetAcceptJobDate(), version);
    }

    public boolean isWebserviceFinishJobs(String version) throws SQLException {
        return this.isLaterThanNow(this.sqlGetFinishJobDate(), version);
    }

    public boolean isWebserviceShutdown(String version) throws SQLException {
        return !this.isLaterThanNow(this.sqlGetFinishJobDate(), version);
    }

    private boolean isLaterThanNow(PreparedStatement statement, String version) throws SQLException {
        return this.getExpiryDate(statement, version).getTime() >= System.currentTimeMillis();
    }

    private Timestamp getExpiryDate(PreparedStatement statement, String version) throws SQLException {
        statement.setString(1, version);
        statement.execute();
        Throwable throwable = null;
        try (ResultSet s = statement.getResultSet();){
            if (s.next()) {
                Timestamp timestamp = s.getTimestamp(1);
                return timestamp;
            }
            try {
                throw new SQLDataException("Empty Return Set!");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Timestamp getWebserviceAcceptJobsDate(String version) throws SQLException {
        return this.getExpiryDate(this.sqlGetAcceptJobDate(), version);
    }

    public Timestamp getWebserviceFinishJobsDate(String version) throws SQLException {
        return this.getExpiryDate(this.sqlGetFinishJobDate(), version);
    }

    public List<News> getNews(String sirius_guiVersion) throws SQLException {
        if (sirius_guiVersion == null || sirius_guiVersion.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<News> news = new ArrayList<News>();
        PreparedStatement statement = this.sqlGetMessages();
        statement.setString(1, sirius_guiVersion);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        statement.setTimestamp(2, now);
        statement.setTimestamp(3, now);
        try (ResultSet s = statement.executeQuery();){
            while (s.next()) {
                news.add(new News(s.getInt(1), s.getTimestamp(2), s.getTimestamp(3), s.getString(4)));
            }
        }
        catch (SQLException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error occured while parsing message list to News object", (Throwable)e);
        }
        return news;
    }

    /*
     * Exception decompiling
     */
    public Authorization submitBySirius(String workerprefix, String securityToken, String ip, String jsonTree, String ms, String uid, long predictorBits) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void submitStatistics(String prefix, long predictorType, MolecularFeatureStats[] stats, String version, String classifierVersion) throws SQLException {
        this.submitStatistics(prefix, predictorType, stats, version, classifierVersion, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitStatistics(String prefix, long predictorType, MolecularFeatureStats[] stats, String version, String classifierVersion, String confidencePredictorsBio, String confidencePredictorsPubchem, String covarianceTree) throws SQLException {
        StringBuilder buf = new StringBuilder();
        for (MolecularFeatureStats s : stats) {
            buf.append(String.valueOf(s.getRealIndex())).append('\t');
            buf.append(String.valueOf(s.getTp())).append('\t');
            buf.append(String.valueOf(s.getFp())).append('\t');
            buf.append(String.valueOf(s.getTn())).append('\t');
            buf.append(String.valueOf(s.getFn())).append('\n');
        }
        this.connection.setAutoCommit(false);
        try {
            try (PreparedStatement s = this.connection.prepareStatement("REPLACE INTO SIRIUS_FINGERID_STATISTICS (workerPrefix, statistics, version, confidenceBio, confidencePubchem, covarianceTree, classifierVersion, predictors) VALUE (?, ?, ?, ?, ?, ?, ?, ?)");){
                s.setString(1, prefix);
                s.setString(2, buf.toString());
                s.setString(3, version);
                if (confidencePredictorsBio == null) {
                    s.setNull(4, -1);
                } else {
                    s.setString(4, confidencePredictorsBio);
                }
                if (confidencePredictorsPubchem == null) {
                    s.setNull(5, -1);
                } else {
                    s.setString(5, confidencePredictorsPubchem);
                }
                if (covarianceTree == null) {
                    s.setNull(6, -1);
                } else {
                    s.setString(6, covarianceTree);
                }
                s.setString(7, classifierVersion);
                s.setLong(8, predictorType);
                s.execute();
                this.connection.commit();
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.connection.rollback();
            }
        }
        finally {
            this.connection.setAutoCommit(true);
        }
    }

    /*
     * Exception decompiling
     */
    public String getStatisticsCsv(String prefix, long predictorType) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String getCovarianceTreeCsv(String prefix) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String getQueryPredictorJSON(String prefix, boolean bioDb) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public MolecularFeatureStats[] getStatistics(String prefix) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void pushUsageStats(Map<java.util.Date, UsageStats> newUsageStats) throws SQLException {
        Map<java.util.Date, UsageStats> oldUsageStats = this.getUsageStats(newUsageStats.keySet());
        try (PreparedStatement q = this.connection.prepareStatement("INSERT INTO USAGE_STATS (numberOfSiriusJobs, numberOfFingerIdJobs, numberOfBatchJobs, numberOfErrors, statsDay) VALUES (?,?,?,?,?) ON DUPLICATE KEY UPDATE numberOfSiriusJobs=?, numberOfFingerIdJobs=?, numberOfBatchJobs=?, numberOfErrors=?");){
            for (UsageStats stats : newUsageStats.values()) {
                UsageStats oldStat = oldUsageStats.get(stats.day());
                if (oldStat != null) {
                    stats.merge(oldStat);
                }
                q.setInt(1, stats.numberOfSiriusJobs);
                q.setInt(2, stats.numberOfFingerIdJobs);
                q.setInt(3, stats.numberOfBatchJobs);
                q.setInt(4, stats.numberOfErrors);
                q.setDate(5, stats.sqlDate());
                q.setInt(6, stats.numberOfSiriusJobs);
                q.setInt(7, stats.numberOfFingerIdJobs);
                q.setInt(8, stats.numberOfBatchJobs);
                q.setInt(9, stats.numberOfErrors);
                q.addBatch();
            }
            q.executeBatch();
        }
    }

    protected Map<String, UserStats> getUserStats() throws SQLException {
        try (ResultSet r = this.sqlUserStats().executeQuery();){
            HashMap<String, UserStats> userStats = new HashMap<String, UserStats>();
            while (r.next()) {
                UserStats current = new UserStats(r.getString("uid"), r.getString("continent"), r.getString("country"), r.getString("city"), r.getInt("numberOfSiriusJobs"), r.getInt("numberOfFingerIdJobs"), r.getInt("numberOfBatchJobs"), r.getInt("numberOfErrors"), r.getTimestamp("lastJobSubmission"));
                UserStats source = (UserStats)userStats.get(current.getKey());
                if (source == null) {
                    userStats.put(current.getKey(), current);
                    continue;
                }
                source.merge(current);
            }
            HashMap<String, UserStats> hashMap = userStats;
            return hashMap;
        }
    }

    protected final boolean cleanJobLists(java.util.Date latest) throws SQLException {
        if (this._sqlDeleteOldJobs == null) {
            this._sqlDeleteOldJobs = new ArrayList<PreparedStatement>(JobType.values().length);
            for (JobType jobType : JobType.values()) {
                this._sqlDeleteOldJobs.add(this.connection.prepareStatement("DELETE FROM " + jobType.name() + " WHERE submissionTime <= ? AND state > 2"));
            }
        }
        Timestamp stamp = new Timestamp(latest.getTime());
        for (PreparedStatement statement : this._sqlDeleteOldJobs) {
            statement.setTimestamp(1, stamp);
            statement.execute();
        }
        return true;
    }

    public void updateUsageStats() throws SQLException {
        Timestamp time = this.getLatestStatsTime();
        List<Map<?, ?>> l = this.collectUserStats(time);
        Map<String, UserStats> newUserStats = l.get(0);
        Map<java.util.Date, UsageStats> newUsageStats = l.get(1);
        if (newUserStats != null && !newUserStats.isEmpty() && newUsageStats != null && !newUsageStats.isEmpty()) {
            Timestamp latest = new Timestamp(0L);
            for (UserStats userStats : newUserStats.values()) {
                latest.setTime(Math.max(latest.getTime(), userStats.stats.getTime()));
            }
            this.pushUsageStats(newUsageStats);
            this.pushUserStats(newUserStats);
            this.cleanJobLists(latest);
        }
    }

    public Timestamp getLatestStatsTime() throws SQLException {
        try (ResultSet r = this.sqlGetLatestStatsTime().executeQuery();){
            if (r.next()) {
                Timestamp timestamp = r.getTimestamp(1);
                return timestamp;
            }
        }
        return new Timestamp(0L);
    }

    private void pushUserStats(Map<String, UserStats> newStats) throws SQLException {
        Map<String, UserStats> oldStats = this.getUserStats();
        if (oldStats != null) {
            for (String key : newStats.keySet()) {
                UserStats old = oldStats.get(key);
                if (old == null) continue;
                newStats.get(key).merge(old);
            }
            try (PreparedStatement q = this.connection.prepareStatement("INSERT INTO USER_STATS (uid, continent, country, city, numberOfSiriusJobs, numberOfFingerIdJobs, numberOfBatchJobs, numberOfErrors, lastJobSubmission) VALUES (?,?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE numberOfSiriusJobs=?, numberOfFingerIdJobs=?, numberOfBatchJobs=?, numberOfErrors=?, lastJobSubmission=?");){
                for (UserStats userStats : newStats.values()) {
                    if (userStats.isValid()) {
                        UsageStats stats = userStats.stats;
                        q.setString(1, userStats.uid);
                        q.setString(2, userStats.continent);
                        q.setString(3, userStats.country);
                        q.setString(4, userStats.city);
                        q.setInt(5, stats.numberOfSiriusJobs);
                        q.setInt(6, stats.numberOfFingerIdJobs);
                        q.setInt(7, stats.numberOfBatchJobs);
                        q.setInt(8, stats.numberOfErrors);
                        q.setTimestamp(9, stats.timestamp());
                        q.setInt(10, stats.numberOfSiriusJobs);
                        q.setInt(11, stats.numberOfFingerIdJobs);
                        q.setInt(12, stats.numberOfBatchJobs);
                        q.setInt(13, stats.numberOfErrors);
                        q.setTimestamp(14, stats.timestamp());
                        q.addBatch();
                        continue;
                    }
                    LoggerFactory.getLogger(this.getClass()).warn("non Valid User stats data set -> skipping this entry");
                }
                q.executeBatch();
            }
        }
    }

    protected List<? extends Map<?, ?>> collectUserStats(java.util.Date after) throws SQLException {
        HashMap<String, UserStats> userStats = new HashMap<String, UserStats>();
        HashMap<java.util.Date, UsageStats> usageStats = new HashMap<java.util.Date, UsageStats>();
        for (JobType tableName : JobType.values()) {
            try (PreparedStatement s = this.connection.prepareStatement("SELECT * FROM " + tableName.name() + " WHERE submissionTime > ?");){
                s.setDate(1, new Date(after.getTime()));
                try (ResultSet r = s.executeQuery();){
                    while (r.next()) {
                        UserStats current = new UserStats(tableName.equals((Object)JobType.SIRIUS_FINGERID_JOB) ? r.getString("uid") : "Website", tableName.equals((Object)JobType.SIRIUS_FINGERID_JOB) ? r.getString("ip") : "141.35.12.31", tableName, r.getInt("state") == 4, (java.util.Date)r.getTimestamp("submissionTime"));
                        UserStats userSource = (UserStats)userStats.get(current.getKey());
                        if (userSource == null) {
                            userStats.put(current.getKey(), current);
                        } else {
                            userSource.merge(current);
                        }
                        UsageStats usageSource = (UsageStats)usageStats.get(current.stats.day());
                        if (usageSource == null) {
                            UsageStats c = current.stats.clone();
                            usageStats.put(c.day(), c);
                            continue;
                        }
                        usageSource.merge(current.stats);
                    }
                }
            }
        }
        return Arrays.asList(userStats, usageStats);
    }

    protected UsageStats collectUsageStats(java.util.Date before) throws SQLException {
        Throwable throwable;
        ResultSet r;
        UsageStats stats = new UsageStats(new java.util.Date());
        try (PreparedStatement s = this.connection.prepareStatement("SELECT COUNT(*) FROM SIRIUS_FINGERID_JOB WHERE submissionTime > ?");){
            s.setDate(1, new Date(before.getTime()));
            r = s.executeQuery();
            throwable = null;
            try {
                if (r.next()) {
                    stats.numberOfBatchJobs = r.getInt(1);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (r != null) {
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        r.close();
                    }
                }
            }
        }
        s = this.connection.prepareStatement("SELECT COUNT(*) FROM FINGERPRINT_JOB WHERE submissionTime > ?");
        var4_4 = null;
        try {
            s.setDate(1, new Date(before.getTime()));
            r = s.executeQuery();
            throwable = null;
            try {
                if (r.next()) {
                    stats.numberOfFingerIdJobs = r.getInt(1);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (r != null) {
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        r.close();
                    }
                }
            }
        }
        catch (Throwable r2) {
            var4_4 = r2;
            throw r2;
        }
        finally {
            if (s != null) {
                if (var4_4 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable r2) {
                        var4_4.addSuppressed(r2);
                    }
                } else {
                    s.close();
                }
            }
        }
        s = this.connection.prepareStatement("SELECT COUNT(*) FROM TREE_JOB WHERE submissionTime > ?");
        var4_4 = null;
        try {
            s.setDate(1, new Date(before.getTime()));
            r = s.executeQuery();
            throwable = null;
            try {
                if (r.next()) {
                    stats.numberOfSiriusJobs = r.getInt(1);
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (r != null) {
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        r.close();
                    }
                }
            }
        }
        catch (Throwable r3) {
            var4_4 = r3;
            throw r3;
        }
        finally {
            if (s != null) {
                if (var4_4 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable r3) {
                        var4_4.addSuppressed(r3);
                    }
                } else {
                    s.close();
                }
            }
        }
        stats.numberOfErrors = 0;
        s = this.connection.prepareStatement("SELECT COUNT(*) FROM SIRIUS_FINGERID_JOB WHERE state = 4 AND submissionTime > ?");
        var4_4 = null;
        try {
            s.setDate(1, new Date(before.getTime()));
            r = s.executeQuery();
            throwable = null;
            try {
                if (r.next()) {
                    stats.numberOfErrors += r.getInt(1);
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (r != null) {
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        r.close();
                    }
                }
            }
        }
        catch (Throwable r4) {
            var4_4 = r4;
            throw r4;
        }
        finally {
            if (s != null) {
                if (var4_4 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable r4) {
                        var4_4.addSuppressed(r4);
                    }
                } else {
                    s.close();
                }
            }
        }
        s = this.connection.prepareStatement("SELECT COUNT(*) FROM FINGERPRINT_JOB WHERE state = 4 AND submissionTime > ?");
        var4_4 = null;
        try {
            s.setDate(1, new Date(before.getTime()));
            r = s.executeQuery();
            throwable = null;
            try {
                if (r.next()) {
                    stats.numberOfErrors = r.getInt(1);
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (r != null) {
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                    } else {
                        r.close();
                    }
                }
            }
        }
        catch (Throwable r5) {
            var4_4 = r5;
            throw r5;
        }
        finally {
            if (s != null) {
                if (var4_4 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable r5) {
                        var4_4.addSuppressed(r5);
                    }
                } else {
                    s.close();
                }
            }
        }
        s = this.connection.prepareStatement("SELECT COUNT(*) FROM TREE_JOB WHERE state = 4 AND submissionTime > ?");
        var4_4 = null;
        try {
            s.setDate(1, new Date(before.getTime()));
            r = s.executeQuery();
            throwable = null;
            try {
                if (r.next()) {
                    stats.numberOfErrors = r.getInt(1);
                }
            }
            catch (Throwable throwable12) {
                throwable = throwable12;
                throw throwable12;
            }
            finally {
                if (r != null) {
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable13) {
                            throwable.addSuppressed(throwable13);
                        }
                    } else {
                        r.close();
                    }
                }
            }
        }
        catch (Throwable throwable14) {
            var4_4 = throwable14;
            throw throwable14;
        }
        finally {
            if (s != null) {
                if (var4_4 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable15) {
                        var4_4.addSuppressed(throwable15);
                    }
                } else {
                    s.close();
                }
            }
        }
        return stats;
    }

    public boolean updateSiriusPredictionJobFinished(long jobId, JobState state, String errors, double[] platts, double[] iokrVector) throws SQLException {
        if (platts == null || state != JobState.DONE) {
            return this.sqlSiriusPredictionJobStatementFinished(jobId, state.id, errors, null, null);
        }
        return this.sqlSiriusPredictionJobStatementFinished(jobId, state.id, errors, this.convertTobinary(platts), iokrVector == null ? null : this.convertTobinary(iokrVector));
    }

    protected byte[] convertTobinary(double[] data) {
        ByteBuffer buffer = ByteBuffer.allocate(data.length * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (double val : data) {
            buffer.putDouble(val);
        }
        buffer.rewind();
        return buffer.array();
    }

    public int countNumberOfActiveLocalWorkers(String prefix, String version, String workerType) throws SQLException {
        return this.countNumberOfRegisteredWorkers(prefix, version, workerType, (Boolean)false);
    }

    public int countNumberOfActiveBackupWorkers(String prefix, String version, String workerType) throws SQLException {
        return this.countNumberOfRegisteredWorkers(prefix, version, workerType, (Boolean)true);
    }

    public int countNumberOfRegisteredWorkers(String prefix, String version, Set<String> workerType, Boolean isBackup) throws SQLException {
        int all = 0;
        for (String type : workerType) {
            all += this.countNumberOfRegisteredWorkers(prefix, version, type, isBackup);
        }
        return all;
    }

    public int countNumberOfRegisteredWorkers(String prefix, String version, String workerType, Boolean isBackup) throws SQLException {
        PreparedStatement statement = this.sqlCountWorker();
        statement.setString(1, prefix);
        statement.setString(2, version);
        statement.setString(3, workerType);
        statement.setBoolean(4, isBackup);
        Throwable throwable = null;
        try (ResultSet s = statement.executeQuery();){
            if (s.next()) {
                int n = s.getInt(1);
                return n;
            }
            try {
                throw new SQLDataException("Empty Return Set!");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public int countNumberOfRegisteredWorkersOnHost(String prefix, String version, String workerType) throws SQLException {
        PreparedStatement statement = this.sqlCountWorkerOnHost();
        statement.setString(1, prefix);
        statement.setString(2, version);
        statement.setString(3, workerType);
        statement.setString(4, localhostName);
        Throwable throwable = null;
        try (ResultSet s = statement.executeQuery();){
            if (s.next()) {
                int n = s.getInt(1);
                return n;
            }
            try {
                throw new SQLDataException("Empty Return Set!");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private <V> String toSQLArray(List<V> elements) {
        List<V> toConcat;
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        if (elements.get(0) instanceof String) {
            toConcat = new ArrayList<V>(elements.size());
            for (V s : elements) {
                toConcat.add(s.toString());
            }
        } else {
            toConcat = elements;
        }
        String conccay = "('" + Strings.join(toConcat, (String)"','") + "')";
        System.out.println(conccay);
        return conccay;
    }

    public ResultSet getRegisteredWorkers(List<String> prefixe, String version, List<String> workerTypes, Boolean isBackup) throws SQLException {
        PreparedStatement statement = this.sqlGetRegisteredWorkers(this.toSQLArray(prefixe), version, this.toSQLArray(workerTypes), isBackup);
        return statement.executeQuery();
    }

    public boolean isShutdown(int id) throws SQLException {
        return this.getWorkerState(id) == WorkerState.STOPPING;
    }

    public boolean isStarting(int id) throws SQLException {
        return this.getWorkerState(id) == WorkerState.STARTING;
    }

    public boolean isRunning(int id) throws SQLException {
        return this.getWorkerState(id) == WorkerState.RUNNING;
    }

    public WorkerState getWorkerState(int id) throws SQLException {
        PreparedStatement statement = this.sqlGetWorkerState();
        statement.setInt(1, id);
        statement.execute();
        Throwable throwable = null;
        try (ResultSet s = statement.getResultSet();){
            if (s.next()) {
                WorkerState workerState = WorkerState.values()[s.getInt("state")];
                return workerState;
            }
            try {
                throw new SQLDataException("Empty Return Set!");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void setStarting(int id) throws SQLException {
        this.setWorkerState(id, WorkerState.STARTING);
    }

    public void setRunning(int id) throws SQLException {
        this.setWorkerState(id, WorkerState.RUNNING);
    }

    public void shutdownWorker(int id) throws SQLException {
        this.setWorkerState(id, WorkerState.STOPPING);
    }

    public void setWorkerState(int id, WorkerState state) throws SQLException {
        PreparedStatement statement = this.sqlWorkerState();
        statement.setInt(1, state.ordinal());
        statement.setTimestamp(2, FingerIdDB.getCurrentDateTime());
        statement.setInt(3, id);
        statement.execute();
    }

    private static Timestamp getCurrentDateTime() {
        Timestamp date = new Timestamp(System.currentTimeMillis());
        return date;
    }

    public int updateWorkerAliveState(int id) throws SQLException {
        PreparedStatement statement = this.sqlUpdateWorkerAlive();
        statement.setTimestamp(1, FingerIdDB.getCurrentDateTime());
        statement.setInt(2, id);
        int row = statement.executeUpdate();
        return row;
    }

    public int addWorker(String prefix, String version, String workerType, String supportedPredictors, Boolean isBackup) throws SQLException {
        PreparedStatement statement = this.sqlAddWorker();
        statement.setString(1, prefix);
        statement.setString(2, version);
        statement.setString(3, workerType);
        statement.setString(4, supportedPredictors);
        statement.setBoolean(5, isBackup);
        statement.setString(6, localhostName);
        statement.setTimestamp(7, FingerIdDB.getCurrentDateTime());
        System.out.println(statement.toString());
        statement.execute();
        Throwable throwable = null;
        try (ResultSet s = statement.getGeneratedKeys();){
            if (s.next()) {
                int n = s.getInt(1);
                return n;
            }
            try {
                throw new SQLDataException("Empty Return Set!");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void removeWorker(int id) throws SQLException {
        PreparedStatement statement = this.sqlRemoveWorker();
        statement.setInt(1, id);
        statement.execute();
    }

    public void removeWorkers(String prefix, String version, String workerType, Boolean isBackup) throws SQLException {
        PreparedStatement statement = this.sqlRemoveWorkers();
        statement.setString(1, prefix);
        statement.setString(2, version);
        statement.setString(3, workerType);
        statement.setBoolean(4, isBackup);
        statement.execute();
    }

    public void shutdownWorkersByVersion(String version) throws SQLException {
        PreparedStatement statement = this.sqlWorkerStatesByVersion();
        statement.setInt(1, WorkerState.STOPPING.ordinal());
        statement.setTimestamp(2, FingerIdDB.getCurrentDateTime());
        statement.setString(3, version);
        statement.execute();
    }

    public void removeWorkersByPrefix(String prefix) throws SQLException {
        PreparedStatement statement = this.sqlWorkerStatesByPrefix();
        statement.setInt(1, WorkerState.STOPPING.ordinal());
        statement.setTimestamp(2, FingerIdDB.getCurrentDateTime());
        statement.setString(3, prefix);
        statement.execute();
    }

    public void shutdownWorkers(String prefix, String version) throws SQLException {
        PreparedStatement statement = this.sqlWorkerStatesByPrefixVersion();
        statement.setInt(1, WorkerState.STOPPING.ordinal());
        statement.setTimestamp(2, FingerIdDB.getCurrentDateTime());
        statement.setString(3, prefix);
        statement.setString(4, version);
        statement.execute();
    }

    public void shutdownWorkers(String prefix, String version, String workerType) throws SQLException {
        PreparedStatement statement = this.sqlWorkerStates();
        statement.setInt(1, WorkerState.STOPPING.ordinal());
        statement.setString(2, prefix);
        statement.setString(3, version);
        statement.setString(4, workerType);
        int row = statement.executeUpdate();
    }

    public void shutdownWorkers(String prefix, String version, String workerType, Boolean isBackup) throws SQLException {
        PreparedStatement statement = this.sqlWorkerStatesWithBackup();
        statement.setInt(1, WorkerState.STOPPING.ordinal());
        statement.setString(2, prefix);
        statement.setString(3, version);
        statement.setString(4, workerType);
        statement.setBoolean(5, isBackup);
        int row = statement.executeUpdate();
    }

    public ResultSet shutdownUnreachableWorkers(long oldestAlive) throws SQLException {
        PreparedStatement statement = this.sqlShutdownRunningWorkersByTime();
        Timestamp time = new Timestamp(oldestAlive);
        statement.setTimestamp(1, time);
        statement.setTimestamp(2, time);
        statement.executeUpdate();
        try (ResultSet s = statement.getResultSet();){
            ResultSet resultSet = s;
            return resultSet;
        }
    }

    public ResultSet removeShutdownedWorkersByTime(long oldestAlive) throws SQLException {
        PreparedStatement statement = this.sqlRemoveShutdownedWorkersByTime();
        statement.setTimestamp(1, new Timestamp(oldestAlive));
        int row = statement.executeUpdate();
        try (ResultSet s = statement.getResultSet();){
            ResultSet resultSet = s;
            return resultSet;
        }
    }

    public int countNumberOfActiveJobs(String jobTable) throws SQLException {
        String SQL = "SELECT COUNT(state) FROM " + jobTable + " WHERE state <= 2";
        Throwable throwable = null;
        try (PreparedStatement state = this.connection.prepareStatement(SQL);){
            Throwable throwable2;
            ResultSet s;
            block25: {
                int n;
                block26: {
                    block27: {
                        s = state.executeQuery();
                        throwable2 = null;
                        if (!s.next()) break block25;
                        n = s.getInt(1);
                        if (s == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            s.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    s.close();
                }
                return n;
            }
            try {
                try {
                    try {
                        throw new SQLDataException("Empty Return Set!");
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (s != null) {
                        if (throwable2 != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            s.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    public int countNumberOfActiveJobs(String[] jobTables) throws SQLException {
        int jobcount = 0;
        for (String jobTable : jobTables) {
            jobcount += this.countNumberOfActiveJobs(jobTable);
        }
        return jobcount;
    }

    public int countNumberOfActiveFingerIdJobs() throws SQLException {
        return this.countNumberOfActiveJobs(FingerIdJob.getTableName());
    }

    public int countNumberOfActiveTreeJobs() throws SQLException {
        return this.countNumberOfActiveJobs(TreeJob.getTableName());
    }

    public int countNumberOfActiveSiriusJobs() throws SQLException {
        return this.countNumberOfActiveJobs(SiriusPredictionJob.getTableName());
    }

    public Map<java.util.Date, UsageStats> getUsageStats(Collection<java.util.Date> date) throws SQLException {
        HashMap<java.util.Date, UsageStats> result = new HashMap<java.util.Date, UsageStats>(date.size());
        try (ResultSet r = this.sqlGetUsageStats(date).executeQuery();){
            while (r.next()) {
                UsageStats s = new UsageStats(r.getDate("statsDay"));
                s.numberOfSiriusJobs = r.getInt("numberOfSiriusJobs");
                s.numberOfFingerIdJobs = r.getInt("numberOfFingerIdJobs");
                s.numberOfBatchJobs = r.getInt("numberOfBatchJobs");
                s.numberOfErrors = r.getInt("numberOfErrors");
                result.put(s.day(), s);
            }
        }
        return result;
    }

    public SiriusPredictionJob fetchLastSiriusPredictionJob(String workerPrefix) throws SQLException {
        return this.fetchLastSiriusPredictionJob(workerPrefix, PredictorType.allBitsSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SiriusPredictionJob fetchLastSiriusPredictionJob(String workerPrefix, long predictorBits) throws SQLException {
        this.connection.setAutoCommit(false);
        try {
            Throwable throwable;
            ResultSet set;
            block19: {
                PreparedStatement statement = this.sqlSiriusPredictionJobStatementForUpdate(workerPrefix, predictorBits);
                try {
                    SiriusPredictionJob siriusPredictionJob;
                    block20: {
                        set = statement.executeQuery();
                        throwable = null;
                        try {
                            if (!set.next()) break block19;
                            set.updateLong(4, (long)JobState.FETCHED.id);
                            set.updateRow();
                            this.connection.commit();
                            SiriusPredictionJob job = new SiriusPredictionJob();
                            job.setJobId(set.getLong(1));
                            job.setState(JobState.FETCHED);
                            job.setPrefix(workerPrefix);
                            job.setJsonTree(set.getString(2));
                            job.setMs(set.getString(3));
                            job.setPredictors(set.getInt(5));
                            siriusPredictionJob = job;
                            if (set == null) return siriusPredictionJob;
                            if (throwable == null) break block20;
                        }
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (set == null) throw throwable5;
                                if (throwable != null) {
                                    try {
                                        set.close();
                                        throw throwable5;
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                        throw throwable5;
                                    }
                                }
                                set.close();
                                throw throwable5;
                            }
                        }
                        try {
                            set.close();
                            return siriusPredictionJob;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return siriusPredictionJob;
                        }
                    }
                    set.close();
                    return siriusPredictionJob;
                }
                catch (Throwable t) {
                    this.connection.rollback();
                    LoggerFactory.getLogger(this.getClass()).error("Error fetching fingerid job", t);
                    throw t;
                }
            }
            if (set == null) return null;
            if (throwable == null) {
                set.close();
                return null;
            }
            try {
                set.close();
                return null;
            }
            catch (Throwable throwable3) {
                throwable.addSuppressed(throwable3);
                return null;
            }
        }
        finally {
            this.connection.setAutoCommit(true);
        }
    }

    public SiriusPredictionJob getSiriusPredictionJobStatus(Authorization auth) throws SQLException {
        try (ResultSet set = this.sqlSiriusPredictionJobStatementStatus(auth.getId(), auth.getSecurityToken()).executeQuery();){
            if (set.next()) {
                Blob iokrBlob;
                SiriusPredictionJob job = new SiriusPredictionJob();
                job.setJobId(auth.getId());
                job.setErrorMessage(set.getString(1));
                job.setState(JobState.withId(set.getInt(2)));
                Blob b = set.getBlob(3);
                if (b != null) {
                    job.setFingerprints(b.getBytes(1L, (int)b.length()));
                }
                if ((iokrBlob = set.getBlob("iokrVector")) != null) {
                    job.setIokrVector(iokrBlob.getBytes(1L, (int)iokrBlob.length()));
                }
                SiriusPredictionJob siriusPredictionJob = job;
                return siriusPredictionJob;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public boolean submit(FingerIdInstance instance, String prefix) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitFingerIdResults(FingerIdJob job, List<DBCandidate> candidates) throws SQLException {
        try {
            this.connection.setAutoCommit(false);
            try (PreparedStatement statement = this.connection.prepareStatement("INSERT INTO FINGERBLAST_RESULTS (instanceId, candidateId, inchi_key_1, inchi, score, pos, name, flags, smiles, matchScore) VALUES (?,?,?,?,?,?,?,?,?,?)");){
                for (DBCandidate fc : candidates) {
                    statement.setLong(1, job.getInstanceId());
                    statement.setInt(2, job.getCandidateId());
                    statement.setString(3, fc.getInchKey2D());
                    statement.setString(4, fc.getInchi());
                    statement.setDouble(5, fc.getScore());
                    statement.setInt(6, fc.getRank());
                    statement.setString(7, fc.getName());
                    statement.setLong(8, fc.getFlags());
                    statement.setString(9, fc.getSmiles());
                    statement.setDouble(10, fc.getMatchScore());
                    statement.execute();
                }
                job.setState(JobState.DONE);
                this.updateFingerIdJobFinished(job);
                this.connection.commit();
            }
            catch (Throwable t) {
                this.connection.rollback();
                throw t;
            }
        }
        finally {
            this.connection.setAutoCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTreeResults(TreeJob job, FingerTreeResult result) throws SQLException {
        try {
            this.connection.setAutoCommit(false);
            try (PreparedStatement statement = this.connection.prepareStatement("INSERT INTO TREE_RESULTS (instanceId, rank, formula, score, treeScore, isoScore, tree, optimal, flags) VALUES (?,?,?,?,?,?,?,TRUE,?)");){
                for (FingerCandidate fc : result.candidates) {
                    statement.setLong(1, job.getInstanceId());
                    statement.setInt(2, fc.getRank());
                    statement.setString(3, fc.formula);
                    statement.setDouble(4, fc.getScore());
                    statement.setDouble(5, fc.getTreeScore());
                    statement.setDouble(6, fc.getIsoScore());
                    statement.setString(7, fc.getJsonTree());
                    statement.setLong(8, fc.getFlags());
                    statement.execute();
                }
                job.setState(JobState.DONE);
                this.updateTreeJobFinished(job);
                this.connection.commit();
            }
            catch (Throwable t) {
                this.connection.rollback();
                throw t;
            }
        }
        finally {
            this.connection.setAutoCommit(true);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean startFingerprintJob(Authorization auth, int candidateId, String prefix) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean verify(Authorization auth) throws SQLException {
        return this.sqlVerifyInstance(auth.getId(), auth.getSecurityToken());
    }

    public FingerTreeResult getTreeResult(long instanceId) throws SQLException {
        List<FingerCandidate> trees = this.sqlTreeResults(instanceId);
        FingerTreeResult result = new FingerTreeResult();
        result.candidates = trees;
        result.optimal = true;
        return result;
    }

    public String getTree(long instanceId, int rank) throws SQLException {
        return this.sqlTree(instanceId, rank);
    }

    public int getNumberOfCompoundCandidates(long instanceId, int candidateId) throws SQLException {
        return this.sqlCountCompoundCandidates(instanceId, candidateId);
    }

    public boolean setNumberOfCompoundCandidates(long instanceId, int candidateId, int numberOfCandidates) throws SQLException {
        return this.sqlSetCountCompoundCandidates(instanceId, candidateId, numberOfCandidates);
    }

    public Status getStatus(Authorization auth) throws SQLException {
        Status status = new Status();
        TreeJob treeJob = this.getTreeJob(auth.getId());
        status.treeJob = treeJob == null ? JobState.INITIAL : treeJob.getState();
        status.numberOfComputedTrees = this.sqlCountTrees(auth.getId());
        this.findAllFingerprintJobs(auth.getId(), status);
        return status;
    }

    public TreeJob getTreeJob(long id) throws SQLException {
        return this.sqlFindTreeJob(id);
    }

    public FingerIdJob getFingerIdJob(long id, int candidateId) throws SQLException {
        return this.sqlFingerIdJob(id, candidateId);
    }

    public boolean updateTreeJobProgress(TreeJob job) throws SQLException {
        return this.sqlTreeJobUpdateProgress(job.getInstanceId(), job.getNumberOfProcessedCandidates());
    }

    public boolean updateTreeJobFinished(TreeJob job) throws SQLException {
        return this.sqlTreeJobUpdateFinished(job.getInstanceId(), job.getState().id, job.getErrorMessage(), job.getNumberOfProcessedCandidates());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized TreeJob fetchLastTreeJob(String prefix) throws SQLException {
        this.connection.setAutoCommit(false);
        try {
            block26: {
                Throwable throwable;
                ResultSet set;
                block23: {
                    TreeJob treeJob;
                    block24: {
                        block25: {
                            PreparedStatement statement = this.sqlTreeJobStatementForUpdate(prefix);
                            set = statement.executeQuery();
                            throwable = null;
                            if (!set.next()) break block23;
                            set.updateLong(5, (long)JobState.FETCHED.id);
                            set.updateRow();
                            this.connection.commit();
                            TreeJob job = new TreeJob();
                            job.setInstanceId(set.getLong(1));
                            job.setState(JobState.FETCHED);
                            job.setErrorMessage(set.getString(2));
                            job.setNumberOfProcessedCandidates(set.getInt(3));
                            job.setNumberOfCandidates(set.getInt(4));
                            job.setPrefix(prefix);
                            treeJob = job;
                            if (set == null) break block24;
                            if (throwable == null) break block25;
                            try {
                                set.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block24;
                        }
                        set.close();
                    }
                    return treeJob;
                }
                try {
                    if (set != null) {
                        if (throwable != null) {
                            try {
                                set.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            set.close();
                        }
                    }
                    break block26;
                    {
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (set != null) {
                                    if (throwable != null) {
                                        try {
                                            set.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                    } else {
                                        set.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    this.connection.rollback();
                    LoggerFactory.getLogger(this.getClass()).error("Error fetching tree job", (Throwable)e);
                }
            }
            TreeJob treeJob = null;
            return treeJob;
        }
        finally {
            this.connection.setAutoCommit(true);
        }
    }

    public boolean updateFingerIdJobFinished(FingerIdJob job) throws SQLException {
        return this.sqlFingerIdJobUpdateFinished(job.getInstanceId(), job.getCandidateId(), job.getState().id, job.getErrorMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FingerIdJob fetchLastFingerIdJob(String prefix) throws SQLException {
        this.connection.setAutoCommit(false);
        try {
            Throwable throwable;
            ResultSet set;
            block19: {
                PreparedStatement statement = this.sqlFingerIdJobStatementForUpdate(prefix);
                try {
                    FingerIdJob fingerIdJob;
                    block20: {
                        set = statement.executeQuery();
                        throwable = null;
                        try {
                            if (!set.next()) break block19;
                            set.updateLong("state", (long)JobState.FETCHED.id);
                            set.updateRow();
                            this.connection.commit();
                            FingerIdJob job = new FingerIdJob();
                            job.setInstanceId(set.getLong(1));
                            job.setState(JobState.FETCHED);
                            job.setCandidateId(set.getInt(2));
                            job.setErrorMessage(set.getString(3));
                            job.setPrefix(prefix);
                            fingerIdJob = job;
                            if (set == null) return fingerIdJob;
                            if (throwable == null) break block20;
                        }
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (set == null) throw throwable5;
                                if (throwable != null) {
                                    try {
                                        set.close();
                                        throw throwable5;
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                        throw throwable5;
                                    }
                                }
                                set.close();
                                throw throwable5;
                            }
                        }
                        try {
                            set.close();
                            return fingerIdJob;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return fingerIdJob;
                        }
                    }
                    set.close();
                    return fingerIdJob;
                }
                catch (SQLException e) {
                    this.connection.rollback();
                    LoggerFactory.getLogger(this.getClass()).error("Error fetching fingerid job", (Throwable)e);
                    return null;
                }
            }
            if (set == null) return null;
            if (throwable == null) {
                set.close();
                return null;
            }
            try {
                set.close();
                return null;
            }
            catch (Throwable throwable3) {
                throwable.addSuppressed(throwable3);
                return null;
            }
        }
        finally {
            this.connection.setAutoCommit(true);
        }
    }

    public FingerIdInstance getInstance(long id, String securityToken) throws SQLException {
        FingerIdInstance instance = this.getInstanceNoSecurityCheck(id);
        if (!instance.securityToken.equals(securityToken)) {
            return null;
        }
        return instance;
    }

    public FingerIdInstance getInstanceNoSecurityCheck(long id) throws SQLException {
        return this.sqlFindInstance(id);
    }

    public List<FingerblastResult> getFingerblastResults(Authorization auth, int rank, int offset, boolean bio) throws SQLException {
        PreparedStatement statement = bio ? this.sqlFindFingerblastResultsBio() : this.sqlFindFingerblastResult();
        statement.setLong(1, auth.getId());
        statement.setInt(2, rank);
        statement.setInt(3, offset);
        ArrayList<FingerblastResult> results = new ArrayList<FingerblastResult>(20);
        try (ResultSet set = statement.executeQuery();){
            while (set.next()) {
                FingerblastResult result = new FingerblastResult();
                result.inchi_key_1 = set.getString(1);
                result.inchi = set.getString(2);
                result.smiles = set.getString(3);
                result.flags = set.getLong(4);
                result.score = set.getDouble(5);
                result.ranking = set.getInt(6);
                result.name = set.getString(7);
                result.matchScore = set.getDouble(8);
                results.add(result);
            }
        }
        return results;
    }

    private PreparedStatement sqlGetRegisteredWorkers(String prefix, String version, String workerType, Boolean isBackup) throws SQLException {
        StringBuilder statementString = new StringBuilder("SELECT * FROM WORKER_ACTIVE WHERE");
        boolean first = true;
        if (prefix != null) {
            if (!first) {
                statementString.append(" AND");
            } else {
                first = false;
            }
            statementString.append(" prefix IN ").append(prefix);
        }
        if (version != null) {
            if (!first) {
                statementString.append(" AND");
            } else {
                first = false;
            }
            statementString.append(" version='").append(version).append('\'');
        }
        if (workerType != null) {
            if (!first) {
                statementString.append(" AND");
            } else {
                first = false;
            }
            statementString.append(" type IN ").append(workerType);
        }
        if (isBackup != null) {
            if (!first) {
                statementString.append(" AND");
            } else {
                first = false;
            }
            statementString.append(" isBackup=").append(isBackup);
        }
        return this.connection.prepareStatement(statementString.toString());
    }

    private PreparedStatement sqlCountWorker() throws SQLException {
        if (this._sqlCountWorker == null) {
            this._sqlCountWorker = this.connection.prepareStatement("SELECT COUNT(*) FROM WORKER_ACTIVE WHERE prefix=? AND version=? AND type=? AND isBackup=? AND state!=2");
        }
        return this._sqlCountWorker;
    }

    private PreparedStatement sqlCountWorkerOnHost() throws SQLException {
        if (this._sqlCountWorkerOnHost == null) {
            this._sqlCountWorkerOnHost = this.connection.prepareStatement("SELECT COUNT(*) FROM WORKER_ACTIVE WHERE prefix=? AND version=? AND type=? AND host=? AND state!=2");
        }
        return this._sqlCountWorkerOnHost;
    }

    private PreparedStatement sqlUpdateWorkerAlive() throws SQLException {
        if (this._sqlUpdateWorkerAlive == null) {
            this._sqlUpdateWorkerAlive = this.connection.prepareStatement("UPDATE WORKER_ACTIVE SET alive = ? WHERE id=?");
        }
        return this._sqlUpdateWorkerAlive;
    }

    private PreparedStatement sqlAddWorker() throws SQLException {
        if (this._sqlAddWorker == null) {
            this._sqlAddWorker = this.connection.prepareStatement("INSERT INTO WORKER_ACTIVE (prefix, version, type, supportedPredictors, isBackup, host, alive) VALUE (?, ?, ?, ?, ?, ?, ?)", 1);
        }
        return this._sqlAddWorker;
    }

    private PreparedStatement sqlWorkerState() throws SQLException {
        if (this._sqlWorkerState == null) {
            this._sqlWorkerState = this.connection.prepareStatement("UPDATE WORKER_ACTIVE SET state = ?, alive = ? WHERE id = ?");
        }
        return this._sqlWorkerState;
    }

    private PreparedStatement sqlWorkerStatesByVersion() throws SQLException {
        if (this._sqlWorkerStatesByVersion == null) {
            this._sqlWorkerStatesByVersion = this.connection.prepareStatement("UPDATE WORKER_ACTIVE SET state = ?, alive = ? WHERE version = ?");
        }
        return this._sqlWorkerStatesByVersion;
    }

    private PreparedStatement sqlWorkerStatesByPrefixVersion() throws SQLException {
        if (this._sqlWorkerStatesByPrefixVersion == null) {
            this._sqlWorkerStatesByPrefixVersion = this.connection.prepareStatement("UPDATE WORKER_ACTIVE SET state = ?, alive = ? WHERE prefix = ? AND version = ?");
        }
        return this._sqlWorkerStatesByPrefixVersion;
    }

    private PreparedStatement sqlWorkerStatesByPrefix() throws SQLException {
        if (this._sqlWorkerStatesByPrefix == null) {
            this._sqlWorkerStatesByPrefix = this.connection.prepareStatement("UPDATE WORKER_ACTIVE SET state = ?, alive = ? WHERE prefix = ?");
        }
        return this._sqlWorkerStatesByPrefix;
    }

    private PreparedStatement sqlWorkerStatesWithBackup() throws SQLException {
        if (this._sqlWorkerStatesWithBackup == null) {
            this._sqlWorkerStatesWithBackup = this.connection.prepareStatement("UPDATE WORKER_ACTIVE SET state = ? WHERE prefix = ? AND version = ? AND type = ? AND isBackup = ?");
        }
        return this._sqlWorkerStatesWithBackup;
    }

    private PreparedStatement sqlWorkerStates() throws SQLException {
        if (this._sqlWorkerStates == null) {
            this._sqlWorkerStates = this.connection.prepareStatement("UPDATE WORKER_ACTIVE SET state = ? WHERE prefix = ? AND version = ? AND type = ?");
        }
        return this._sqlWorkerStates;
    }

    private PreparedStatement sqlShutdownRunningWorkersByTime() throws SQLException {
        if (this._sqlShutdownWorkersByTime == null) {
            this._sqlShutdownWorkersByTime = this.connection.prepareStatement("UPDATE WORKER_ACTIVE SET  state = 2, alive = ?  WHERE alive < ? AND state = 1");
        }
        return this._sqlShutdownWorkersByTime;
    }

    private PreparedStatement sqlRemoveShutdownedWorkersByTime() throws SQLException {
        if (this._sqlRemoveShutdownedWorkersByTime == null) {
            this._sqlRemoveShutdownedWorkersByTime = this.connection.prepareStatement("DELETE FROM WORKER_ACTIVE WHERE state = 2 AND alive < ?");
        }
        return this._sqlRemoveShutdownedWorkersByTime;
    }

    private PreparedStatement sqlRemoveWorker() throws SQLException {
        if (this._sqlRemoveWorker == null) {
            this._sqlRemoveWorker = this.connection.prepareStatement("DELETE FROM WORKER_ACTIVE WHERE id = ?");
        }
        return this._sqlRemoveWorker;
    }

    private PreparedStatement sqlRemoveWorkers() throws SQLException {
        if (this._sqlRemoveWorkers == null) {
            this._sqlRemoveWorkers = this.connection.prepareStatement("DELETE FROM WORKER_ACTIVE WHERE prefix = ? AND version = ? AND type = ? and isBackup = ?");
        }
        return this._sqlRemoveWorkers;
    }

    private PreparedStatement sqlGetWorkerState() throws SQLException {
        if (this._sqlGetWorkerState == null) {
            this._sqlGetWorkerState = this.connection.prepareStatement("SELECT state FROM WORKER_ACTIVE WHERE id = ?");
        }
        return this._sqlGetWorkerState;
    }

    private PreparedStatement sqlCountNumberOfJobs() throws SQLException {
        if (this._sqlCountNumberOfJobs == null) {
            this._sqlCountNumberOfJobs = this.connection.prepareStatement("SELECT COUNT(state) FROM ? WHERE state <= 2");
        }
        return this._sqlCountNumberOfJobs;
    }

    private PreparedStatement sqlSubmitBySirius() throws SQLException {
        if (this._sqlSubmitBySirius == null) {
            this._sqlSubmitBySirius = this.connection.prepareStatement("INSERT INTO SIRIUS_FINGERID_JOB (workerPrefix, version, securityToken, state, submissionTime, tree, ms, ip, uid, predictors) VALUE (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
        }
        return this._sqlSubmitBySirius;
    }

    private PreparedStatement sqlFindFingerblastResult() throws SQLException {
        if (this._sqlFindFingerblastResult == null) {
            this._sqlFindFingerblastResult = this.connection.prepareStatement("SELECT inchi_key_1, inchi, smiles, flags, score, pos, name, matchScore FROM FINGERBLAST_RESULTS WHERE instanceId = ? AND candidateId = ? ORDER BY pos ASC LIMIT 20 OFFSET ?");
        }
        return this._sqlFindFingerblastResult;
    }

    private PreparedStatement sqlFindFingerblastResultsBio() throws SQLException {
        if (this._sqlFindFingerblastResultsBio == null) {
            this._sqlFindFingerblastResultsBio = this.connection.prepareStatement("SELECT inchi_key_1, inchi, smiles, flags, score, pos, name, matchScore FROM FINGERBLAST_RESULTS WHERE instanceId = ? AND candidateId = ? AND flags > 2 ORDER BY pos ASC LIMIT 20 OFFSET ?");
        }
        return this._sqlFindFingerblastResultsBio;
    }

    private TreeJob sqlFindTreeJob(long id) throws SQLException {
        if (this._sqlFindTreeJob == null) {
            this._sqlFindTreeJob = this.connection.prepareStatement("SELECT workerPrefix, state, submissionTime, errorMessage, numberOfCandidates, alreadyProcessedCandidates FROM TREE_JOB WHERE instanceId = ?");
        }
        this._sqlFindTreeJob.setLong(1, id);
        try (ResultSet set = this._sqlFindTreeJob.executeQuery();){
            if (!set.next()) {
                TreeJob treeJob = null;
                return treeJob;
            }
            TreeJob job = new TreeJob();
            job.setPrefix(set.getString(1));
            job.setState(JobState.withId(set.getInt(2)));
            job.setTimestamp(set.getTimestamp(3).getTime());
            job.setErrorMessage(set.getString(4));
            job.setNumberOfCandidates(set.getInt(5));
            job.setNumberOfProcessedCandidates(set.getInt(6));
            job.setInstanceId(id);
            TreeJob treeJob = job;
            return treeJob;
        }
    }

    private FingerIdJob sqlFingerIdJob(long id, int candidateId) throws SQLException {
        if (this._sqlFindFingerIdJob == null) {
            this._sqlFindFingerIdJob = this.connection.prepareStatement("SELECT workerPrefix, state, submissionTime, errorMessage FROM FINGERPRINT_JOB WHERE instanceId = ? AND candidateId = ?");
        }
        this._sqlFindFingerIdJob.setLong(1, id);
        this._sqlFindFingerIdJob.setInt(2, candidateId);
        try (ResultSet set = this._sqlFindFingerIdJob.executeQuery();){
            if (!set.next()) {
                FingerIdJob fingerIdJob = null;
                return fingerIdJob;
            }
            FingerIdJob job = new FingerIdJob();
            job.setPrefix(set.getString(1));
            job.setState(JobState.withId(set.getInt(2)));
            job.setTimestamp(set.getTimestamp(3).getTime());
            job.setErrorMessage(set.getString(4));
            job.setInstanceId(id);
            job.setCandidateId(candidateId);
            FingerIdJob fingerIdJob = job;
            return fingerIdJob;
        }
    }

    private List<FingerCandidate> sqlTreeResults(long instanceId) throws SQLException {
        if (this._sqlTreeResults == null) {
            this._sqlTreeResults = this.connection.prepareStatement("SELECT rank, formula, score, treeScore, isoScore, tree, flags FROM TREE_RESULTS WHERE instanceId = ? ORDER BY rank ASC ");
        }
        this._sqlTreeResults.setLong(1, instanceId);
        ArrayList<FingerCandidate> trees = new ArrayList<FingerCandidate>();
        try (ResultSet set = this._sqlTreeResults.executeQuery();){
            while (set.next()) {
                FingerCandidate tree = new FingerCandidate(set.getString(6), set.getString(2), set.getDouble(3), set.getDouble(4), set.getDouble(5), set.getInt(1), set.getLong(7));
                trees.add(tree);
            }
        }
        return trees;
    }

    private String sqlTree(long instanceId, int candidateId) throws SQLException {
        if (this._sqlTree == null) {
            this._sqlTree = this.connection.prepareStatement("SELECT tree FROM TREE_RESULTS WHERE instanceId = ? AND rank = ?");
        }
        this._sqlTree.setLong(1, instanceId);
        this._sqlTree.setInt(2, candidateId);
        try (ResultSet set = this._sqlTree.executeQuery();){
            if (set.next()) {
                String string = set.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    private boolean sqlFingerIdJobUpdateFinished(long instanceId, int candidateId, int stateId, String errorMessage) throws SQLException {
        if (this._sqlFingerIdJobUpdateFinished == null) {
            this._sqlFingerIdJobUpdateFinished = this.connection.prepareStatement("UPDATE FINGERPRINT_JOB SET state = ?, errorMessage = ? WHERE instanceId = ? AND candidateId = ?");
        }
        this._sqlFingerIdJobUpdateFinished.setInt(1, stateId);
        this._sqlFingerIdJobUpdateFinished.setString(2, errorMessage);
        this._sqlFingerIdJobUpdateFinished.setLong(3, instanceId);
        this._sqlFingerIdJobUpdateFinished.setInt(4, candidateId);
        this._sqlFingerIdJobUpdateFinished.execute();
        return true;
    }

    private boolean sqlTreeJobUpdateFinished(long instanceId, int stateId, String errorMessage, int candidateNumber) throws SQLException {
        if (this._sqlTreeJobUpdateFinished == null) {
            this._sqlTreeJobUpdateFinished = this.connection.prepareStatement("UPDATE TREE_JOB SET state = ?, errorMessage = ?, alreadyProcessedCandidates = ? WHERE instanceId = ?");
        }
        this._sqlTreeJobUpdateFinished.setInt(1, stateId);
        this._sqlTreeJobUpdateFinished.setString(2, errorMessage);
        this._sqlTreeJobUpdateFinished.setInt(3, candidateNumber);
        this._sqlTreeJobUpdateFinished.setLong(4, instanceId);
        this._sqlTreeJobUpdateFinished.execute();
        return true;
    }

    private boolean sqlTreeJobUpdateProgress(long instanceId, int newProgress) throws SQLException {
        if (this._sqlTreeJobUpdateProgress == null) {
            this._sqlTreeJobUpdateProgress = this.connection.prepareStatement("UPDATE TREE_JOB SET alreadyProcessedCandidates = ? WHERE instanceId = ?");
        }
        this._sqlTreeJobUpdateProgress.setInt(1, newProgress);
        this._sqlTreeJobUpdateProgress.setLong(2, instanceId);
        this._sqlTreeJobUpdateProgress.execute();
        return true;
    }

    protected PreparedStatement sqlUserStats() throws SQLException {
        if (this._sqlUserStats == null) {
            this._sqlUserStats = this.connection.prepareStatement("SELECT * FROM USER_STATS");
        }
        return this._sqlUserStats;
    }

    protected PreparedStatement sqlGetUsageStats(Collection<java.util.Date> days) throws SQLException {
        boolean first = true;
        StringBuilder q = new StringBuilder("SELECT * FROM USAGE_STATS WHERE statsDay IN (");
        for (java.util.Date day : days) {
            if (first) {
                first = false;
            } else {
                q.append(',');
            }
            q.append('\'').append(new Date(day.getTime()).toString()).append('\'');
        }
        q.append(')');
        PreparedStatement _sqlUsageStats = this.connection.prepareStatement(q.toString());
        return _sqlUsageStats;
    }

    protected PreparedStatement sqlGetLastUsageStats() throws SQLException {
        if (this._sqlLastUsageStats == null) {
            this._sqlLastUsageStats = this.connection.prepareStatement("SELECT numberOfSiriusJobs, numberOfFingerIdJobs, numberOfBatchJobs, numberOfErrors, numberOfDifferentIps, statsDay FROM USAGE_STATS ORDER BY statsDay DESC LIMIT 1");
        }
        return this._sqlLastUsageStats;
    }

    protected PreparedStatement sqlFingerIdJobStatementForUpdate(String prefix) throws SQLException {
        if (this._sqlFingerIdJobStatementForUpdate == null) {
            this._sqlFingerIdJobStatementForUpdate = this.connection.prepareStatement("SELECT instanceId, candidateId, errorMessage, state FROM FINGERPRINT_JOB WHERE state=1 AND workerPrefix = ? AND version = ? ORDER BY submissionTime LIMIT 1 FOR UPDATE", 1003, 1008);
        }
        this._sqlFingerIdJobStatementForUpdate.setString(1, prefix);
        this._sqlFingerIdJobStatementForUpdate.setString(2, FingerIDProperties.fingeridVersion());
        return this._sqlFingerIdJobStatementForUpdate;
    }

    protected PreparedStatement sqlSiriusPredictionJobStatementForUpdate(String prefix, long predictorBits) throws SQLException {
        if (this._sqlSiriusPredictionJobStatementForUpdate == null) {
            this._sqlSiriusPredictionJobStatementForUpdate = this.connection.prepareStatement("SELECT jobId, tree, ms, state, predictors FROM SIRIUS_FINGERID_JOB WHERE state=1 AND workerPrefix = ? AND ? = ( ? | predictors)  AND version = ? ORDER BY submissionTime LIMIT 1 FOR UPDATE", 1003, 1008);
        }
        this._sqlSiriusPredictionJobStatementForUpdate.setString(1, prefix);
        this._sqlSiriusPredictionJobStatementForUpdate.setLong(2, predictorBits);
        this._sqlSiriusPredictionJobStatementForUpdate.setLong(3, predictorBits);
        this._sqlSiriusPredictionJobStatementForUpdate.setString(4, FingerIDProperties.fingeridVersion());
        return this._sqlSiriusPredictionJobStatementForUpdate;
    }

    protected PreparedStatement sqlSiriusPredictionJobStatementStatus(long jobId, String securityToken) throws SQLException {
        if (this._sqlSiriusPredictionJobStatementStatus == null) {
            this._sqlSiriusPredictionJobStatementStatus = this.connection.prepareStatement("SELECT errorMessage, state, fingerprint, iokrVector FROM SIRIUS_FINGERID_JOB WHERE jobId = ? AND securityToken = ?");
        }
        this._sqlSiriusPredictionJobStatementStatus.setLong(1, jobId);
        this._sqlSiriusPredictionJobStatementStatus.setString(2, securityToken);
        return this._sqlSiriusPredictionJobStatementStatus;
    }

    private boolean sqlSiriusPredictionJobStatementFinished(long jobId, int stateId, String errorMessage, byte[] plattBytes, byte[] iokrBytes) throws SQLException {
        if (this._sqlSiriusPredictionJobStatement == null) {
            this._sqlSiriusPredictionJobStatement = this.connection.prepareStatement("UPDATE SIRIUS_FINGERID_JOB SET state = ?, errorMessage = ?, fingerprint = ?, iokrVector = ? WHERE jobId = ?");
        }
        this._sqlSiriusPredictionJobStatement.setInt(1, stateId);
        this._sqlSiriusPredictionJobStatement.setString(2, errorMessage);
        if (plattBytes == null) {
            this._sqlSiriusPredictionJobStatement.setNull(3, 2004);
        } else {
            this._sqlSiriusPredictionJobStatement.setBlob(3, new ByteArrayInputStream(plattBytes), plattBytes.length);
        }
        if (iokrBytes == null) {
            this._sqlSiriusPredictionJobStatement.setNull(4, 2004);
        } else {
            this._sqlSiriusPredictionJobStatement.setBlob(4, new ByteArrayInputStream(iokrBytes), iokrBytes.length);
        }
        this._sqlSiriusPredictionJobStatement.setLong(5, jobId);
        this._sqlSiriusPredictionJobStatement.execute();
        return true;
    }

    protected PreparedStatement sqlTreeJobStatementForUpdate(String prefix) throws SQLException {
        if (this._sqlTreeJobStatementForUpdate == null) {
            this._sqlTreeJobStatementForUpdate = this.connection.prepareStatement("SELECT instanceId, errorMessage, alreadyProcessedCandidates, numberOfCandidates, state FROM TREE_JOB WHERE state=1 AND workerPrefix=?  AND version = ? ORDER BY submissionTime LIMIT 1 FOR UPDATE", 1003, 1008);
        }
        this._sqlTreeJobStatementForUpdate.setString(1, prefix);
        this._sqlTreeJobStatementForUpdate.setString(2, FingerIDProperties.fingeridVersion());
        return this._sqlTreeJobStatementForUpdate;
    }

    protected final FingerIdInstance sqlFindInstance(long id) throws SQLException {
        block27: {
            if (this._sqlFindInstance == null) {
                this._sqlFindInstance = this.connection.prepareStatement("SELECT input, ip, state, submissionTime,securityToken FROM FINGERID_INSTANCES WHERE id = ?");
            }
            this._sqlFindInstance.setLong(1, id);
            try (ResultSet set = this._sqlFindInstance.executeQuery();){
                if (!set.next()) break block27;
                FingerIdInstance instance = new FingerIdInstance();
                instance.id = id;
                instance.ip = set.getString(2);
                instance.state = InstanceState.withId(set.getInt(3));
                instance.submissionTime = new java.util.Date(set.getTimestamp(4).getTime());
                instance.securityToken = set.getString(5);
                try (JsonParser parser = Json.createParser((Reader)set.getCharacterStream(1));){
                    instance.input = JsonSerializer.readMsInput(parser);
                }
                FingerIdInstance fingerIdInstance = instance;
                return fingerIdInstance;
            }
        }
        return null;
    }

    private int sqlCountCompoundCandidates(long id, int candidateId) throws SQLException {
        if (this._sqlCountCompoundCandidates == null) {
            this._sqlCountCompoundCandidates = this.connection.prepareStatement("SELECT numberOfCandidates FROM TREE_RESULTS WHERE instanceId = ? AND rank = ?");
        }
        this._sqlCountCompoundCandidates.setLong(1, id);
        this._sqlCountCompoundCandidates.setInt(2, candidateId);
        try (ResultSet set = this._sqlCountCompoundCandidates.executeQuery();){
            if (!set.next()) {
                int n = 0;
                return n;
            }
            int n = set.getInt(1);
            return n;
        }
    }

    private boolean sqlSetCountCompoundCandidates(long id, int candidateId, int count) throws SQLException {
        if (this._sqlSetCountCompoundCandidates == null) {
            this._sqlSetCountCompoundCandidates = this.connection.prepareStatement("UPDATE TREE_RESULTS SET numberOfCandidates = ? WHERE instanceId = ? AND rank = ?");
        }
        this._sqlSetCountCompoundCandidates.setInt(1, count);
        this._sqlSetCountCompoundCandidates.setLong(2, id);
        this._sqlSetCountCompoundCandidates.setInt(3, candidateId);
        this._sqlSetCountCompoundCandidates.execute();
        return true;
    }

    private int sqlCountTrees(long id) throws SQLException {
        if (this._sqlCountTrees == null) {
            this._sqlCountTrees = this.connection.prepareStatement("SELECT COUNT(rank) FROM TREE_RESULTS WHERE instanceId = ?");
        }
        this._sqlCountTrees.setLong(1, id);
        try (ResultSet set = this._sqlCountTrees.executeQuery();){
            if (!set.next()) {
                int n = 0;
                return n;
            }
            int n = set.getInt(1);
            return n;
        }
    }

    private void findAllFingerprintJobs(long id, Status st) throws SQLException {
        if (this._sqlFindAllFingerprintJobs == null) {
            this._sqlFindAllFingerprintJobs = this.connection.prepareStatement("SELECT candidateId, state FROM FINGERPRINT_JOB WHERE instanceId = ? ORDER BY candidateId ASC");
        }
        this._sqlFindAllFingerprintJobs.setLong(1, id);
        ArrayList<JobState> states = new ArrayList<JobState>();
        ArrayList<Integer> candidateIds = new ArrayList<Integer>();
        try (ResultSet set = this._sqlFindAllFingerprintJobs.executeQuery();){
            while (set.next()) {
                candidateIds.add(set.getInt(1));
                states.add(JobState.withId(set.getInt(2)));
            }
        }
        st.fingerprintJobs = new JobState[states.size()];
        st.submittedFingerprintJobs = new int[candidateIds.size()];
        for (int k = 0; k < candidateIds.size(); ++k) {
            st.fingerprintJobs[k] = (JobState)((Object)states.get(k));
            st.submittedFingerprintJobs[k] = (Integer)candidateIds.get(k);
        }
    }

    protected final boolean sqlVerifyInstance(long id, String securityToken) throws SQLException {
        if (this._sqlVerifyInstance == null) {
            this._sqlVerifyInstance = this.connection.prepareStatement("SELECT ip FROM FINGERID_INSTANCES WHERE id = ? AND securityToken = ?");
        }
        this._sqlVerifyInstance.setLong(1, id);
        this._sqlVerifyInstance.setString(2, securityToken);
        try (ResultSet set = this._sqlVerifyInstance.executeQuery();){
            if (set.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private PreparedStatement sqlIsWebAPIVersionInTable() throws SQLException {
        if (this._sqlIsWebAPIVersionInTable == null) {
            this._sqlIsWebAPIVersionInTable = this.connection.prepareStatement("SELECT COUNT(*) FROM CSI_WEB_API_VERSIONS  WHERE version = ? LIMIT 1");
        }
        return this._sqlIsWebAPIVersionInTable;
    }

    private PreparedStatement sqlRegisterWebAPI() throws SQLException {
        if (this._sqlRegisterWebAPI == null) {
            this._sqlRegisterWebAPI = this.connection.prepareStatement("INSERT INTO CSI_WEB_API_VERSIONS (version) VALUES(?)");
        }
        return this._sqlRegisterWebAPI;
    }

    private PreparedStatement sqlIsWebAPIExpired() throws SQLException {
        if (this._sqlIsWebAPIExpired == null) {
            this._sqlIsWebAPIExpired = this.connection.prepareStatement("SELECT expired FROM CSI_WEB_API_VERSIONS  WHERE version = ? LIMIT 1");
        }
        return this._sqlIsWebAPIExpired;
    }

    private PreparedStatement sqlGetAcceptJobDate() throws SQLException {
        if (this._sqlGetAcceptJobDate == null) {
            this._sqlGetAcceptJobDate = this.connection.prepareStatement("SELECT accept_jobs FROM CSI_WEB_API_VERSIONS WHERE version = ?");
        }
        return this._sqlGetAcceptJobDate;
    }

    private PreparedStatement sqlGetFinishJobDate() throws SQLException {
        if (this._sqlGetFinishJobDate == null) {
            this._sqlGetFinishJobDate = this.connection.prepareStatement("SELECT finish_jobs FROM CSI_WEB_API_VERSIONS WHERE version = ?");
        }
        return this._sqlGetFinishJobDate;
    }

    private PreparedStatement sqlGetMessages() throws SQLException {
        if (this._sqlGetMessages == null) {
            this._sqlGetMessages = this.connection.prepareStatement("SELECT id, begin_date, end_date, message FROM MESSAGES WHERE sirius_version = ? AND publish = 1 AND begin_date <= ? AND end_date >= ?");
        }
        return this._sqlGetMessages;
    }

    private PreparedStatement sqlGetLatestStatsTime() throws SQLException {
        if (this._sqlGetLatestStatsTime == null) {
            this._sqlGetLatestStatsTime = this.connection.prepareStatement("SELECT MAX(lastJobSubmission) AS TIMESTAMP FROM USER_STATS");
        }
        return this._sqlGetLatestStatsTime;
    }

    protected final void clearPreparedStatements() {
        try {
            if (this._sqlCountWorker != null) {
                this._sqlCountWorker.close();
            }
            if (this._sqlCountWorkerOnHost != null) {
                this._sqlCountWorkerOnHost.close();
            }
            if (this._sqlUpdateWorkerAlive != null) {
                this._sqlUpdateWorkerAlive.close();
            }
            if (this._sqlAddWorker != null) {
                this._sqlAddWorker.close();
            }
            if (this._sqlWorkerState != null) {
                this._sqlWorkerState.close();
            }
            if (this._sqlWorkerStatesByVersion != null) {
                this._sqlWorkerStatesByVersion.close();
            }
            if (this._sqlWorkerStatesByPrefixVersion != null) {
                this._sqlWorkerStatesByPrefixVersion.close();
            }
            if (this._sqlWorkerStatesByPrefix != null) {
                this._sqlWorkerStatesByPrefix.close();
            }
            if (this._sqlWorkerStatesWithBackup != null) {
                this._sqlWorkerStatesWithBackup.close();
            }
            if (this._sqlWorkerStates != null) {
                this._sqlWorkerStates.close();
            }
            if (this._sqlShutdownWorkersByTime != null) {
                this._sqlShutdownWorkersByTime.close();
            }
            if (this._sqlRemoveShutdownedWorkersByTime != null) {
                this._sqlRemoveShutdownedWorkersByTime.close();
            }
            if (this._sqlRemoveWorker != null) {
                this._sqlRemoveWorker.close();
            }
            if (this._sqlRemoveWorkers != null) {
                this._sqlRemoveWorkers.close();
            }
            if (this._sqlGetWorkerState != null) {
                this._sqlGetWorkerState.close();
            }
            if (this._sqlCountNumberOfJobs != null) {
                this._sqlCountNumberOfJobs.close();
            }
            if (this._sqlSubmitBySirius != null) {
                this._sqlSubmitBySirius.close();
            }
            if (this._sqlFindFingerblastResult != null) {
                this._sqlFindFingerblastResult.close();
            }
            if (this._sqlFindFingerblastResultsBio != null) {
                this._sqlFindFingerblastResultsBio.close();
            }
            if (this._sqlFindTreeJob != null) {
                this._sqlFindTreeJob.close();
            }
            if (this._sqlFindFingerIdJob != null) {
                this._sqlFindFingerIdJob.close();
            }
            if (this._sqlTreeResults != null) {
                this._sqlTreeResults.close();
            }
            if (this._sqlTree != null) {
                this._sqlTree.close();
            }
            if (this._sqlFingerIdJobUpdateFinished != null) {
                this._sqlFingerIdJobUpdateFinished.close();
            }
            if (this._sqlTreeJobUpdateFinished != null) {
                this._sqlTreeJobUpdateFinished.close();
            }
            if (this._sqlTreeJobUpdateProgress != null) {
                this._sqlTreeJobUpdateProgress.close();
            }
            if (this._sqlUsageStats != null) {
                this._sqlUsageStats.close();
            }
            if (this._sqlLastUsageStats != null) {
                this._sqlLastUsageStats.close();
            }
            if (this._sqlFingerIdJobStatementForUpdate != null) {
                this._sqlFingerIdJobStatementForUpdate.close();
            }
            if (this._sqlSiriusPredictionJobStatementForUpdate != null) {
                this._sqlSiriusPredictionJobStatementForUpdate.close();
            }
            if (this._sqlSiriusPredictionJobStatementStatus != null) {
                this._sqlSiriusPredictionJobStatementStatus.close();
            }
            if (this._sqlSiriusPredictionJobStatement != null) {
                this._sqlSiriusPredictionJobStatement.close();
            }
            if (this._sqlTreeJobStatementForUpdate != null) {
                this._sqlTreeJobStatementForUpdate.close();
            }
            if (this._sqlFindInstance != null) {
                this._sqlFindInstance.close();
            }
            if (this._sqlCountCompoundCandidates != null) {
                this._sqlCountCompoundCandidates.close();
            }
            if (this._sqlSetCountCompoundCandidates != null) {
                this._sqlSetCountCompoundCandidates.close();
            }
            if (this._sqlCountTrees != null) {
                this._sqlCountTrees.close();
            }
            if (this._sqlFindAllFingerprintJobs != null) {
                this._sqlFindAllFingerprintJobs.close();
            }
            if (this._sqlVerifyInstance != null) {
                this._sqlVerifyInstance.close();
            }
            if (this._sqlIsWebAPIVersionInTable != null) {
                this._sqlIsWebAPIVersionInTable.close();
            }
            if (this._sqlRegisterWebAPI != null) {
                this._sqlRegisterWebAPI.close();
            }
            if (this._sqlIsWebAPIExpired != null) {
                this._sqlIsWebAPIExpired.close();
            }
            if (this._sqlGetAcceptJobDate != null) {
                this._sqlGetAcceptJobDate.close();
            }
            if (this._sqlGetFinishJobDate != null) {
                this._sqlGetFinishJobDate.close();
            }
            if (this._sqlGetMessages != null) {
                this._sqlGetMessages.close();
            }
            if (this._sqlUserStats != null) {
                this._sqlUserStats.close();
            }
            if (this._sqlGetLatestStatsTime != null) {
                this._sqlGetLatestStatsTime.close();
            }
            if (this._sqlDeleteOldJobs != null) {
                for (PreparedStatement statement : this._sqlDeleteOldJobs) {
                    statement.close();
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this._sqlCountWorker = null;
            this._sqlCountWorkerOnHost = null;
            this._sqlUpdateWorkerAlive = null;
            this._sqlAddWorker = null;
            this._sqlWorkerState = null;
            this._sqlWorkerStatesByVersion = null;
            this._sqlWorkerStatesByPrefixVersion = null;
            this._sqlWorkerStatesByPrefix = null;
            this._sqlWorkerStatesWithBackup = null;
            this._sqlWorkerStates = null;
            this._sqlShutdownWorkersByTime = null;
            this._sqlRemoveShutdownedWorkersByTime = null;
            this._sqlRemoveWorker = null;
            this._sqlRemoveWorkers = null;
            this._sqlGetWorkerState = null;
            this._sqlCountNumberOfJobs = null;
            this._sqlSubmitBySirius = null;
            this._sqlFindFingerblastResult = null;
            this._sqlFindFingerblastResultsBio = null;
            this._sqlFindTreeJob = null;
            this._sqlFindFingerIdJob = null;
            this._sqlTreeResults = null;
            this._sqlTree = null;
            this._sqlFingerIdJobUpdateFinished = null;
            this._sqlTreeJobUpdateFinished = null;
            this._sqlTreeJobUpdateProgress = null;
            this._sqlUsageStats = null;
            this._sqlLastUsageStats = null;
            this._sqlFingerIdJobStatementForUpdate = null;
            this._sqlSiriusPredictionJobStatementForUpdate = null;
            this._sqlSiriusPredictionJobStatementStatus = null;
            this._sqlSiriusPredictionJobStatement = null;
            this._sqlTreeJobStatementForUpdate = null;
            this._sqlFindInstance = null;
            this._sqlCountCompoundCandidates = null;
            this._sqlSetCountCompoundCandidates = null;
            this._sqlCountTrees = null;
            this._sqlFindAllFingerprintJobs = null;
            this._sqlVerifyInstance = null;
            this._sqlIsWebAPIVersionInTable = null;
            this._sqlRegisterWebAPI = null;
            this._sqlIsWebAPIExpired = null;
            this._sqlGetAcceptJobDate = null;
            this._sqlGetFinishJobDate = null;
            this._sqlGetMessages = null;
            this._sqlUserStats = null;
            this._sqlGetLatestStatsTime = null;
            this._sqlDeleteOldJobs = null;
        }
    }

    protected final boolean connect() throws SQLException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + "/csi_fingerid", this.username, this.password);
        this.connection.setNetworkTimeout(this.timeoutExecutor, 30000);
        this.connection.setAutoCommit(true);
        return true;
    }

    public final synchronized boolean refresh() throws SQLException {
        if (this.connection != null && !this.connection.isClosed() && this.connection.isValid(3)) {
            LoggerFactory.getLogger(this.getClass()).info("Try FingerID_DB refresh but connection is fine!");
            return true;
        }
        try {
            this.clearPreparedStatements();
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error durding FingerID_DB Refresh", (Throwable)e);
        }
        boolean c = this.connect();
        LoggerFactory.getLogger(this.getClass()).info("Refresh of FingerID_DB done! Return Value: " + c);
        return c;
    }

    @Override
    public void close() {
        try {
            this.clearPreparedStatements();
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Could not close connection", (Throwable)e);
            }
            this.connection = null;
        }
        finally {
            this.timeoutExecutor.shutdown();
        }
    }

    public static void main(String[] args) throws SQLException {
        System.out.println(PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.version"));
        System.out.println(PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.fingerid.db.date"));
        FingerIdDB db = new FingerIdDB();
        int i = db.addWorker("fleisch", "1.1.0", "SIRIUS", "NONE", false);
        System.out.println("added ID " + i);
        i = db.addWorker("fleisch", "1.1.0", "FINGER_ID", "CSI_FINGERID_POSITIVE", false);
        System.out.println("added ID " + i);
        DBTablePrinter.printTable(db.connection, "WORKER_ACTIVE");
        i = db.countNumberOfActiveBackupWorkers("fleisch-1.1.0", "1.1.0", "SIRIUS");
        System.out.println(i);
        i = db.countNumberOfActiveBackupWorkers("fleisch-1.1.0", "1.1.0", "FINGER_ID");
        System.out.println(i);
        i = db.countNumberOfActiveLocalWorkers("fleisch-1.1.0", "1.1.0", "SIRIUS");
        System.out.println(i);
        i = db.countNumberOfActiveLocalWorkers("fleisch-1.1.0", "1.1.0", "FINGER_ID");
        System.out.println(i);
        i = db.countNumberOfRegisteredWorkers("fleisch-1.1.0", "1.1.0", "*", (Boolean)false);
        System.out.println(i);
    }

    static {
        FingerIDProperties.fingeridVersion();
        String l = null;
        try {
            l = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        finally {
            localhostName = l;
        }
    }

    public static enum WorkerState {
        STARTING,
        RUNNING,
        STOPPING;

    }
}

