/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingeriddb;

import java.util.Arrays;

public class FingerSpectrum {
    private static final double[] EMPTY_ARRAY = new double[0];
    boolean ms1;
    double[] mz = EMPTY_ARRAY;
    double[] intens = EMPTY_ARRAY;

    public double[] getMz() {
        return this.mz;
    }

    public void setMz(double[] mz) {
        this.mz = mz;
    }

    public double[] getIntens() {
        return this.intens;
    }

    public void setIntens(double[] intens) {
        this.intens = intens;
    }

    public boolean isMs1() {
        return this.ms1;
    }

    public void setMs1(boolean ms1) {
        this.ms1 = ms1;
    }

    public void readFromText(String text) {
        if (text.length() > 0x100000) {
            throw new IllegalArgumentException("spectrum is too large");
        }
        String[] lines = text.split("\n");
        if (lines.length > 50000) {
            throw new IllegalArgumentException("spectrum is too large");
        }
        this.mz = new double[lines.length];
        this.intens = new double[lines.length];
        int k = 0;
        for (String line : lines) {
            if ((line = line.trim()).isEmpty()) continue;
            String[] pair = line.split("[ \t;,]", 2);
            this.mz[k] = Double.parseDouble(pair[0]);
            this.intens[k] = Double.parseDouble(pair[1]);
            ++k;
        }
        if (k < this.mz.length) {
            this.mz = Arrays.copyOf(this.mz, k);
            this.intens = Arrays.copyOf(this.intens, k);
        }
    }
}

