/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingeriddb;

import de.unijena.bioinf.fingeriddb.ElementRestriction;
import de.unijena.bioinf.fingeriddb.FingerCandidate;
import de.unijena.bioinf.fingeriddb.FingerIdInstance;
import de.unijena.bioinf.fingeriddb.FingerSpectrum;
import de.unijena.bioinf.fingeriddb.InstanceState;
import de.unijena.bioinf.fingeriddb.MsInput;
import de.unijena.bioinf.fingeriddb.Status;
import java.util.Arrays;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;

public class JsonSerializer {
    private static final String PUBCHEM = "PubChem";

    public static void writeSpectrum(JsonGenerator generator, FingerSpectrum spectrum) {
        generator.write("ms1", spectrum.ms1);
        generator.writeStartArray("mz");
        double[] mzs = spectrum.getMz();
        for (int i = 0; i < mzs.length; ++i) {
            generator.write(mzs[i]);
        }
        generator.writeEnd();
        generator.writeStartArray("int");
        double[] ints = spectrum.getIntens();
        for (int i = 0; i < mzs.length; ++i) {
            generator.write(ints[i]);
        }
        generator.writeEnd();
    }

    public static FingerSpectrum readSpectrum(JsonParser parser) {
        FingerSpectrum spec = new FingerSpectrum();
        block4: while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case KEY_NAME: {
                    if (parser.getString().equals("ms1")) {
                        JsonParser.Event valueEvent = parser.next();
                        spec.ms1 = valueEvent == JsonParser.Event.VALUE_TRUE;
                        continue block4;
                    }
                    if (parser.getString().equals("mz")) {
                        spec.mz = JsonSerializer.parseDoubleArray(parser, spec.intens.length > 0 ? spec.intens.length : 20);
                        continue block4;
                    }
                    if (!parser.getString().equals("int")) continue block4;
                    spec.intens = JsonSerializer.parseDoubleArray(parser, spec.mz.length > 0 ? spec.mz.length : 20);
                    continue block4;
                }
                case END_OBJECT: {
                    return spec;
                }
            }
            JsonSerializer.expect(parser, event, JsonParser.Event.KEY_NAME);
        }
        JsonSerializer.expect(parser, null, JsonParser.Event.END_OBJECT);
        return null;
    }

    public static void writeMsInput(JsonGenerator generator, MsInput input) {
        generator.write("parentMz", input.parentMass);
        generator.write("allowedElements", input.allowedElements.getId());
        generator.writeStartArray("ionization");
        for (String s : input.ionizations) {
            generator.write(s);
        }
        generator.writeEnd();
        generator.write("ppm", input.maxPPM);
        if (input.molecularFormula != null) {
            generator.write("molecularFormula", input.molecularFormula);
        }
        if (input.spectra != null) {
            generator.writeStartArray("spectra");
            for (FingerSpectrum spec : input.spectra) {
                generator.writeStartObject();
                JsonSerializer.writeSpectrum(generator, spec);
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    public static MsInput readMsInput(JsonParser parser) {
        return JsonSerializer.readMsInput(parser, true);
    }

    public static MsInput readMsInput(JsonParser parser, boolean expectStartObject) {
        MsInput input = new MsInput();
        block4: while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            if (expectStartObject) {
                JsonSerializer.expect(parser, event, JsonParser.Event.START_OBJECT);
                expectStartObject = false;
                continue;
            }
            block0 : switch (event) {
                case KEY_NAME: {
                    JsonParser.Event valueEvent;
                    if (parser.getString().equals("parentMz")) {
                        valueEvent = parser.next();
                        input.parentMass = Double.parseDouble(parser.getString());
                        break;
                    }
                    if (parser.getString().equals("ppm")) {
                        valueEvent = parser.next();
                        input.maxPPM = Double.parseDouble(parser.getString());
                        break;
                    }
                    if (parser.getString().equals("allowedElements")) {
                        valueEvent = parser.next();
                        input.allowedElements = ElementRestriction.getById(parser.getInt());
                        break;
                    }
                    if (parser.getString().equals("ionization")) {
                        input.ionizations = JsonSerializer.parseStringArray(parser, 3);
                        break;
                    }
                    if (parser.getString().equals("molecularFormula")) {
                        parser.next();
                        input.molecularFormula = parser.getString();
                        break;
                    }
                    if (!parser.getString().equals("spectra")) continue block4;
                    JsonSerializer.expect(parser, parser.next(), JsonParser.Event.START_ARRAY);
                    while (parser.hasNext()) {
                        JsonParser.Event elemEvent = parser.next();
                        if (elemEvent == JsonParser.Event.END_ARRAY) break block0;
                        JsonSerializer.expect(parser, elemEvent, JsonParser.Event.START_OBJECT);
                        input.spectra.add(JsonSerializer.readSpectrum(parser));
                    }
                    continue block4;
                }
                case END_OBJECT: {
                    return input;
                }
                default: {
                    JsonSerializer.expect(parser, event, JsonParser.Event.KEY_NAME);
                }
            }
        }
        throw new IllegalStateException("Unexpected end of JSON stream");
    }

    public static void writeInstance(JsonGenerator generator, FingerIdInstance instance, boolean forUser) {
        generator.write("jobId", instance.id);
        generator.write("securityToken", instance.securityToken);
        if (!forUser) {
            generator.write("ip", instance.id);
        }
        generator.write("state", instance.state.id);
        if (instance.input != null) {
            generator.writeStartObject("input");
            JsonSerializer.writeMsInput(generator, instance.input);
            generator.writeEnd();
        }
    }

    public static FingerIdInstance readInstance(JsonParser parser) {
        FingerIdInstance instance = new FingerIdInstance();
        block4: while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case KEY_NAME: {
                    JsonParser.Event valueEvent;
                    if (parser.getString().equals("jobId")) {
                        valueEvent = parser.next();
                        instance.id = parser.getLong();
                        continue block4;
                    }
                    if (parser.getString().equals("securityToken")) {
                        valueEvent = parser.next();
                        instance.securityToken = parser.getString();
                        continue block4;
                    }
                    if (parser.getString().equals("state")) {
                        parser.next();
                        instance.state = InstanceState.valueOf(parser.getString());
                        continue block4;
                    }
                    if (!parser.getString().equals("input")) continue block4;
                    JsonSerializer.expect(parser, parser.next(), JsonParser.Event.START_OBJECT);
                    instance.input = JsonSerializer.readMsInput(parser, false);
                    continue block4;
                }
                case END_OBJECT: {
                    return instance;
                }
            }
            JsonSerializer.expect(parser, event, JsonParser.Event.KEY_NAME);
        }
        throw new IllegalStateException("Unexpected end of JSON stream");
    }

    private static void expect(JsonParser parser, JsonParser.Event given, JsonParser.Event expected) {
        if (given != expected) {
            JsonLocation loc = parser.getLocation();
            throw new IllegalStateException("Expected " + given.toString() + " in line " + loc.getLineNumber() + " and column " + loc.getColumnNumber());
        }
    }

    private static String[] parseStringArray(JsonParser parser, int expectedSize) {
        JsonParser.Event valueEvent;
        JsonSerializer.expect(parser, parser.next(), JsonParser.Event.START_ARRAY);
        String[] xs = new String[Math.max(5, expectedSize)];
        int k = 0;
        while (parser.hasNext() && (valueEvent = parser.next()) != JsonParser.Event.END_ARRAY) {
            if (k >= xs.length) {
                xs = Arrays.copyOf(xs, xs.length * 2);
            }
            xs[k++] = parser.getString();
        }
        if (k != xs.length) {
            return Arrays.copyOf(xs, k);
        }
        return xs;
    }

    private static double[] parseDoubleArray(JsonParser parser, int expectedSize) {
        JsonParser.Event valueEvent;
        JsonSerializer.expect(parser, parser.next(), JsonParser.Event.START_ARRAY);
        double[] xs = new double[Math.max(5, expectedSize)];
        int k = 0;
        while (parser.hasNext() && (valueEvent = parser.next()) != JsonParser.Event.END_ARRAY) {
            if (k >= xs.length) {
                xs = Arrays.copyOf(xs, xs.length * 2);
            }
            double val = Double.parseDouble(parser.getString());
            xs[k++] = val;
        }
        if (k != xs.length) {
            return Arrays.copyOf(xs, k);
        }
        return xs;
    }

    public static void writeTreeCandidate(JsonGenerator generator, FingerCandidate c) {
        generator.write("molecularFormula", c.formula);
        generator.write("rank", c.rank);
        generator.write("isoScore", c.isoScore);
        generator.write("treeScore", c.treeScore);
        generator.write("score", c.score);
        generator.writeStartArray("databases");
        Object[] databases = c.getDatabases() == null ? new String[]{} : c.getDatabases().toArray(new String[c.getDatabases().size()]);
        Arrays.sort(databases);
        if (c.getDatabases().contains(PUBCHEM)) {
            generator.write(PUBCHEM);
        }
        for (Object db : databases) {
            if (((String)db).equals(PUBCHEM)) continue;
            generator.write((String)db);
        }
        generator.writeEnd();
        generator.write("tree", c.getJsonTree());
    }

    public static void writeStatus(JsonGenerator generator, Status status) {
        generator.write("numberOfComputedTrees", status.numberOfComputedTrees);
        generator.write("treeJob", status.treeJob.toString());
        generator.writeStartArray("fingerprintJobs");
        for (int k = 0; k < status.fingerprintJobs.length; ++k) {
            generator.writeStartObject();
            generator.write("rank", status.submittedFingerprintJobs[k]);
            generator.write("status", status.fingerprintJobs[k].toString());
            generator.writeEnd();
        }
        generator.writeEnd();
    }
}

