/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingeriddb;

import de.unijena.bioinf.fingeriddb.FingerIdDB;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.LoggerFactory;

public class News {
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final FingerIdDB newsDB;
    public final int id;
    public final Date begin;
    public final Date end;
    public final String message;

    public News(int id, Date begin, Date end, String message) {
        this.id = id;
        this.begin = begin;
        this.end = end;
        this.message = News.embedInHTML(message);
    }

    public int getId() {
        return this.id;
    }

    public Date getBegin() {
        return this.begin;
    }

    public String getBeginString() {
        return formatter.format(this.begin);
    }

    public Date getEnd() {
        return this.end;
    }

    public String getEndString() {
        return formatter.format(this.end);
    }

    public String getMessage() {
        return this.message;
    }

    public static List<News> getNews(String sirius_guiVersion) {
        try {
            return newsDB.getNews(sirius_guiVersion);
        }
        catch (SQLException e) {
            LoggerFactory.getLogger(News.class).error("Could not load news list from db", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static String embedInHTML(String string) {
        if (string.contains("<html>")) {
            return string;
        }
        return "<html>" + string + "</html>";
    }

    static {
        FingerIdDB db = null;
        try {
            db = new FingerIdDB();
            db.connect();
        }
        catch (SQLException e) {
            LoggerFactory.getLogger(News.class).error("Could not get db connection to init news Service", (Throwable)e);
        }
        newsDB = db;
    }
}

