/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingeriddb.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public enum PredictorType {
    CSI_FINGERID_POSITIVE,
    IOKR_POSITIVE,
    CSI_FINGERID_NEGATIVE,
    IOKR_NEGATIVE;


    public String toBitsAsString() {
        return String.valueOf(this.toBits());
    }

    public long toBits() {
        return 1L << this.ordinal();
    }

    public boolean isBitSet(long bits) {
        return (bits & 1L << this.ordinal()) != 0L;
    }

    public static String getBitsAsString(Iterable<PredictorType> types) {
        return String.valueOf(PredictorType.getBits(types));
    }

    public static long getBits(Iterable<PredictorType> types) {
        long bits = 0L;
        for (PredictorType type : types) {
            bits = PredictorType.setBit(bits, type.ordinal());
        }
        return bits;
    }

    public static String getBitsAsString(PredictorType ... types) {
        return String.valueOf(PredictorType.getBits(types));
    }

    public static long getBits(PredictorType ... types) {
        long bits = 0L;
        for (PredictorType type : types) {
            bits = PredictorType.setBit(bits, type.ordinal());
        }
        return bits;
    }

    private static long setBit(long source, long posToAdd) {
        return source | 1L << (int)posToAdd;
    }

    public static boolean contains(long bits, PredictorType predictor) {
        return predictor.isBitSet(bits);
    }

    public static long allBitsSet() {
        return -1L;
    }

    public static long noBitsSet() {
        return 0L;
    }

    public static EnumSet<PredictorType> defaultPredictorSet() {
        return EnumSet.of(CSI_FINGERID_POSITIVE);
    }

    public static EnumSet<PredictorType> makeValid(EnumSet<PredictorType> predictors) {
        if (predictors.contains((Object)CSI_FINGERID_POSITIVE) && predictors.contains((Object)CSI_FINGERID_NEGATIVE)) {
            predictors.remove((Object)CSI_FINGERID_NEGATIVE);
        }
        return predictors;
    }

    public static String bitsToNames(long bits) {
        ArrayList<PredictorType> predictors = new ArrayList<PredictorType>();
        PredictorType[] val = PredictorType.values();
        for (int i = (int)Long.highestOneBit(bits); i >= 0; --i) {
            if ((bits >> i & 1L) != 1L) continue;
            predictors.add(val[i]);
        }
        return ((Object)predictors).toString();
    }

    public static void main(String[] args) {
        List<PredictorType> types = Arrays.asList(new PredictorType[0]);
        long bitSet = PredictorType.getBits(types);
        System.out.println(Long.toBinaryString(bitSet));
        System.out.println(PredictorType.bitsToNames(bitSet));
    }
}

