/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingeriddb.job;

import de.unijena.bioinf.fingeriddb.job.Job;
import de.unijena.bioinf.fingeriddb.job.JobType;
import de.unijena.bioinf.fingeriddb.job.PredictorType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SiriusPredictionJob
extends Job {
    protected long predictors;
    protected long jobId;
    protected String ms;
    protected String jsonTree;
    protected byte[] fingerprints;
    protected byte[] iokrVector;

    public double[] plattProbabilities() {
        int size = this.fingerprints.length / 8;
        double[] platts = new double[size];
        ByteBuffer buf = ByteBuffer.wrap(this.fingerprints);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < platts.length; ++i) {
            platts[i] = buf.getDouble();
        }
        return platts;
    }

    public byte[] getFingerprints() {
        return this.fingerprints;
    }

    public byte[] getIokrVector() {
        return this.iokrVector;
    }

    public void setIokrVector(byte[] iokrVector) {
        this.iokrVector = iokrVector;
    }

    public void setFingerprints(byte[] fingerprints) {
        this.fingerprints = fingerprints;
    }

    public String getMs() {
        return this.ms;
    }

    public void setMs(String ms) {
        this.ms = ms;
    }

    public String getJsonTree() {
        return this.jsonTree;
    }

    public void setJsonTree(String jsonTree) {
        this.jsonTree = jsonTree;
    }

    public long getJobId() {
        return this.jobId;
    }

    public void setJobId(long jobId) {
        this.jobId = jobId;
    }

    public boolean containsPredictor(PredictorType predictor) {
        return predictor.isBitSet(this.predictors);
    }

    public long getPredictorsBits() {
        return this.predictors;
    }

    public void setPredictors(long bits) {
        this.predictors = bits;
    }

    public static String getTableName() {
        return SiriusPredictionJob.getJobType().name();
    }

    public static JobType getJobType() {
        return JobType.SIRIUS_FINGERID_JOB;
    }
}

