/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingeriddb.job;

import de.unijena.bioinf.ChemistryBase.chem.Ionization;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.fingeriddb.job.PredictorType;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public enum UserDefineablePredictorType {
    CSI_FINGERID(PredictorType.CSI_FINGERID_POSITIVE, PredictorType.CSI_FINGERID_NEGATIVE),
    IOKR(PredictorType.IOKR_POSITIVE, PredictorType.IOKR_NEGATIVE);

    private final PredictorType positive;
    private final PredictorType negative;

    private UserDefineablePredictorType(PredictorType positive, PredictorType negative) {
        this.positive = positive;
        this.negative = negative;
    }

    public PredictorType toPredictorType(@NotNull PrecursorIonType ion) {
        return this.toPredictorType(ion.getIonization());
    }

    public PredictorType toPredictorType(@NotNull Ionization ion) {
        if (ion.getCharge() < 0) {
            return this.negative;
        }
        return this.positive;
    }

    public static EnumSet<PredictorType> toPredictorTypes(@NotNull PrecursorIonType ion, UserDefineablePredictorType ... types) {
        return UserDefineablePredictorType.toPredictorTypes(ion.getIonization(), types);
    }

    public static EnumSet<PredictorType> toPredictorTypes(@NotNull Ionization ion, UserDefineablePredictorType ... types) {
        return EnumSet.copyOf(Arrays.stream(types).map(it -> it.toPredictorType(ion)).collect(Collectors.toSet()));
    }

    public static EnumSet<PredictorType> toPredictorTypes(@NotNull PrecursorIonType ion, @NotNull Collection<UserDefineablePredictorType> types) {
        return UserDefineablePredictorType.toPredictorTypes(ion.getIonization(), types);
    }

    public static EnumSet<PredictorType> toPredictorTypes(@NotNull Ionization ion, @NotNull Collection<UserDefineablePredictorType> types) {
        return EnumSet.copyOf(types.stream().map(it -> it.toPredictorType(ion)).collect(Collectors.toSet()));
    }
}

