/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingeriddb.stats;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import de.unijena.bioinf.ChemistryBase.properties.PropertyManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.LoggerFactory;

public class Localizer {
    private static DatabaseReader instance = null;
    private static final String[] internalIPs = new String[]{"/10.35"};
    private static final String DB_FILE_NAME = "GeoLite2-City.mmdb";

    public static DatabaseReader getDBInstance() {
        if (instance == null) {
            Localizer.initDB();
        }
        return instance;
    }

    public static void closeDB() {
        if (instance != null) {
            try {
                instance.close();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(Localizer.class).error("Could not close db File", (Throwable)e);
            }
        }
        instance = null;
    }

    public static void initDB() {
        Path dbFile = Localizer.getDBPath().resolve(DB_FILE_NAME);
        InputStream dbStream = null;
        if (Files.notExists(dbFile, new LinkOption[0])) {
            Localizer.updateDBFile(dbFile.getParent());
        }
        if (Files.exists(dbFile, new LinkOption[0])) {
            try {
                dbStream = Files.newInputStream(dbFile, StandardOpenOption.READ);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(Localizer.class).error("Error during GeoLite2 database import", (Throwable)e);
            }
        }
        if (dbStream == null) {
            LoggerFactory.getLogger(Localizer.class).info("Using Fallback GeoLite2 DB");
            dbStream = Localizer.class.getResourceAsStream("/GeoLite2-City.mmdb");
        }
        try {
            instance = new DatabaseReader.Builder(dbStream).build();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Localizer.class).error("Could not load db File", (Throwable)e);
        }
    }

    public static CityResponse getLocation(String ip) throws UnknownHostException {
        InetAddress ipAddress = InetAddress.getByName(ip);
        return Localizer.getLocation(ipAddress);
    }

    public static CityResponse getLocation(InetAddress ip) {
        try {
            return Localizer.getDBInstance().city(ip);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Localizer.class).error("Could not access db File", (Throwable)e);
        }
        catch (GeoIp2Exception e) {
            for (String internalIP : internalIPs) {
                if (!ip.toString().startsWith(internalIP)) continue;
                try {
                    return Localizer.getLocation("141.35.12.31");
                }
                catch (UnknownHostException e1) {
                    LoggerFactory.getLogger(Localizer.class).error("Error while resolving Uni Jena IP", (Throwable)e);
                }
            }
            LoggerFactory.getLogger(Localizer.class).error("Error while querying GeoIp2 DB", (Throwable)e);
        }
        return null;
    }

    private static Path getDBPath() {
        String dbPath = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.fingerid.fingerid_db.localizer_db", System.getProperty("user.home"));
        return Paths.get(dbPath, new String[0]);
    }

    public static int updateDBFile() {
        return Localizer.updateDBFile(Localizer.getDBPath());
    }

    public static int updateDBFile(Path dbPath) {
        Localizer.closeDB();
        int r = -1;
        try {
            if (Files.notExists(dbPath, new LinkOption[0])) {
                Files.createDirectories(dbPath, new FileAttribute[0]);
            }
            String[] arguments = new String[]{"geoipupdate", "-d", dbPath.toAbsolutePath().toString()};
            Process proc = new ProcessBuilder(arguments).start();
            r = proc.waitFor();
            LoggerFactory.getLogger(Localizer.class).info("DB Update Finished with EXIT value:" + r);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Localizer.class).error("Error While updating db file", (Throwable)e);
            r = 99;
        }
        catch (InterruptedException e) {
            LoggerFactory.getLogger(Localizer.class).error("Unexpected Interruption while updating db file", (Throwable)e);
            r = 100;
        }
        return r;
    }

    public static void main(String[] args) throws UnknownHostException {
        CityResponse resp = Localizer.getLocation("200.46.27.89");
        System.out.println(resp.getContinent().getName());
        System.out.println(resp.getCountry().getName());
        System.out.println(resp.getCity().getName());
        System.out.println();
    }
}

