/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingeriddb.stats;

import de.unijena.bioinf.fingeriddb.job.JobType;
import de.unijena.bioinf.fingeriddb.stats.UserStats;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;

public class UsageStats
implements Cloneable {
    private long time;
    public int numberOfSiriusJobs;
    public int numberOfFingerIdJobs;
    public int numberOfBatchJobs;
    public int numberOfErrors = 0;

    public UsageStats(Date date) {
        this.time = date.getTime();
    }

    public UsageStats(JobType table, boolean error, Date date) {
        this.time = date.getTime();
        this.increaseJobCount(table, error);
    }

    public UsageStats(Date date, int numberOfSiriusJobs, int numberOfFingerIdJobs, int numberOfBatchJobs, int numberOfErrors) {
        this.time = date.getTime();
        this.numberOfSiriusJobs = numberOfSiriusJobs;
        this.numberOfFingerIdJobs = numberOfFingerIdJobs;
        this.numberOfBatchJobs = numberOfBatchJobs;
        this.numberOfErrors = numberOfErrors;
    }

    private UsageStats(UsageStats other) {
        this.time = other.time;
        this.numberOfSiriusJobs = other.numberOfSiriusJobs;
        this.numberOfFingerIdJobs = other.numberOfFingerIdJobs;
        this.numberOfBatchJobs = other.numberOfBatchJobs;
        this.numberOfErrors = other.numberOfErrors;
    }

    public UsageStats(Collection<UserStats> userStats, Date date) {
        this(date);
        for (UserStats userStat : userStats) {
            this.merge(userStat.stats);
        }
    }

    public void merge(UsageStats s) {
        if (s == null) {
            return;
        }
        this.numberOfBatchJobs += s.numberOfBatchJobs;
        this.numberOfErrors += s.numberOfErrors;
        this.numberOfFingerIdJobs += s.numberOfFingerIdJobs;
        this.numberOfSiriusJobs += s.numberOfSiriusJobs;
    }

    public void increaseJobCount(JobType table, boolean error) {
        if (error) {
            ++this.numberOfErrors;
        }
        if (table == null) {
            return;
        }
        switch (table) {
            case TREE_JOB: {
                ++this.numberOfSiriusJobs;
                break;
            }
            case FINGERPRINT_JOB: {
                ++this.numberOfFingerIdJobs;
                break;
            }
            case SIRIUS_FINGERID_JOB: {
                ++this.numberOfBatchJobs;
                break;
            }
        }
    }

    public Date day() {
        return UsageStats.dateToFullDay(this.time);
    }

    public Date date() {
        return new Date(this.time);
    }

    public Timestamp timestamp() {
        return new Timestamp(this.time);
    }

    public java.sql.Date sqlDate() {
        return new java.sql.Date(this.time);
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public static Date dateToFullDay(Date time) {
        return UsageStats.dateToFullDay(time.getTime());
    }

    public static Date dateToFullDay(long timeInMillis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeInMillis);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.set(11, 0);
        return c.getTime();
    }

    public UsageStats clone() {
        return new UsageStats(this);
    }
}

