/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingeriddb.stats;

import com.maxmind.geoip2.model.CityResponse;
import de.unijena.bioinf.fingeriddb.job.JobType;
import de.unijena.bioinf.fingeriddb.stats.Localizer;
import de.unijena.bioinf.fingeriddb.stats.UsageStats;
import java.net.UnknownHostException;
import java.util.Date;
import org.slf4j.LoggerFactory;

public class UserStats {
    public final UsageStats stats;
    public final String uid;
    public final String continent;
    public final String country;
    public final String city;
    private final String key;

    private String createKey(String uid, String continent, String country, String city) {
        return uid + continent + country + city;
    }

    public UserStats(String uid, String continent, String country, String city, Date date) {
        this(uid, continent, country, city, new UsageStats(date));
    }

    public UserStats(String uid, String continent, String country, String city, UsageStats stats) {
        this.uid = uid;
        this.country = country;
        this.continent = country;
        this.city = city;
        this.stats = stats;
        this.key = this.createKey(uid, continent, country, city);
    }

    public UserStats(String uid, String continent, String country, String city, int numberOfSiriusJobs, int numberOfFingerIdJobs, int numberOfBatchJobs, int numberOfErrors, Date date) {
        this(uid, continent, country, city, new UsageStats(date, numberOfSiriusJobs, numberOfFingerIdJobs, numberOfBatchJobs, numberOfErrors));
    }

    public UserStats(String uid, String ip, JobType table, boolean error, Date date) {
        this(uid, ip, new UsageStats(table, error, date));
    }

    public UserStats(String uid, String ip, UsageStats stats) {
        CityResponse r = null;
        if (ip != null) {
            try {
                r = Localizer.getLocation(ip);
            }
            catch (UnknownHostException e) {
                LoggerFactory.getLogger(Localizer.class).warn("Could not get Location for IP: " + ip, (Throwable)e);
            }
        }
        this.uid = uid;
        this.continent = r != null ? r.getContinent().getName() : "unknown";
        this.country = r != null ? r.getCountry().getName() : "unknown";
        this.city = r != null ? r.getCity().getName() : "unknown";
        this.key = this.createKey(uid, this.continent, this.country, this.city);
        this.stats = stats;
    }

    public UserStats(String uid, String ip, int numberOfSiriusJobs, int numberOfFingerIdJobs, int numberOfBatchJobs, int numberOfErrors, Date date) {
        this(uid, ip, new UsageStats(date, numberOfSiriusJobs, numberOfFingerIdJobs, numberOfBatchJobs, numberOfErrors));
    }

    public boolean merge(UserStats userStats) {
        if (!userStats.equals(this)) {
            return false;
        }
        this.stats.merge(userStats.stats);
        this.stats.setTime(Math.max(this.stats.getTime(), userStats.stats.getTime()));
        return true;
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserStats)) {
            return false;
        }
        UserStats userStats = (UserStats)o;
        return this.key.equals(userStats.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean isValid() {
        return this.stats != null && this.city != null && this.continent != null && this.country != null;
    }
}

