/*
 * Decompiled with CFR 0.152.
 */
package net.efabrika.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import joptsimple.internal.Strings;

public class DBTablePrinter {
    private static final int DEFAULT_MAX_ROWS = 10;
    private static final int DEFAULT_MAX_TEXT_COL_WIDTH = 150;
    public static final int CATEGORY_STRING = 1;
    public static final int CATEGORY_INTEGER = 2;
    public static final int CATEGORY_DOUBLE = 3;
    public static final int CATEGORY_DATETIME = 4;
    public static final int CATEGORY_BOOLEAN = 5;
    public static final int CATEGORY_OTHER = 0;

    public static void printTable(Connection conn, String tableName) {
        DBTablePrinter.printTable(conn, tableName, 10, 150);
    }

    public static void printTable(Connection conn, String tableName, int maxRows) {
        DBTablePrinter.printTable(conn, tableName, maxRows, 150);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTable(Connection conn, String tableName, int maxRows, int maxStringColWidth) {
        if (conn == null) {
            System.err.println("DBTablePrinter Error: No connection to database (Connection is null)!");
            return;
        }
        if (tableName == null) {
            System.err.println("DBTablePrinter Error: No table name (tableName is null)!");
            return;
        }
        if (tableName.length() == 0) {
            System.err.println("DBTablePrinter Error: Empty table name!");
            return;
        }
        if (maxRows < 1) {
            System.err.println("DBTablePrinter Info: Invalid max. rows number. Using default!");
            maxRows = 10;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            if (conn.isClosed()) {
                System.err.println("DBTablePrinter Error: Connection is closed!");
                return;
            }
            String sqlSelectAll = "SELECT * FROM " + tableName + " LIMIT " + maxRows;
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sqlSelectAll);
            DBTablePrinter.printResultSet(rs, maxStringColWidth);
        }
        catch (SQLException e) {
            System.err.println("SQL exception in DBTablePrinter. Message:");
            System.err.println(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public static void printResultSet(ResultSet rs) {
        DBTablePrinter.printResultSet(rs, 150);
    }

    public static void printResultSet(ResultSet rs, int maxStringColWidth) {
        try {
            if (rs == null) {
                System.err.println("DBTablePrinter Error: Result set is null!");
                return;
            }
            if (rs.isClosed()) {
                System.err.println("DBTablePrinter Error: Result Set is closed!");
                return;
            }
            if (maxStringColWidth < 1) {
                System.err.println("DBTablePrinter Info: Invalid max. varchar column width. Using default!");
                maxStringColWidth = 150;
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            ArrayList<Column> columns = new ArrayList<Column>(columnCount);
            ArrayList<String> tableNames = new ArrayList<String>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                Column c = new Column(rsmd.getColumnLabel(i), rsmd.getColumnType(i), rsmd.getColumnTypeName(i));
                c.setWidth(c.getLabel().length());
                c.setTypeCategory(DBTablePrinter.whichCategory(c.getType()));
                columns.add(c);
                if (tableNames.contains(rsmd.getTableName(i))) continue;
                tableNames.add(rsmd.getTableName(i));
            }
            int rowCount = 0;
            while (rs.next()) {
                for (int i = 0; i < columnCount; ++i) {
                    Column c = (Column)columns.get(i);
                    int category = c.getTypeCategory();
                    Object value = category == 0 ? "(" + c.getTypeName() + ")" : (rs.getString(i + 1) == null ? "NULL" : rs.getString(i + 1));
                    switch (category) {
                        case 3: {
                            if (((String)value).equals("NULL")) break;
                            Double dValue = rs.getDouble(i + 1);
                            value = String.format("%.3f", dValue);
                            break;
                        }
                        case 1: {
                            c.justifyLeft();
                            if (((String)value).length() <= maxStringColWidth) break;
                            value = ((String)value).substring(0, maxStringColWidth - 3) + "...";
                        }
                    }
                    c.setWidth(((String)value).length() > c.getWidth() ? ((String)value).length() : c.getWidth());
                    c.addValue((String)value);
                }
                ++rowCount;
            }
            StringBuilder strToPrint = new StringBuilder();
            StringBuilder rowSeparator = new StringBuilder();
            for (Column c : columns) {
                String name;
                int width = c.getWidth();
                int diff = width - (name = c.getLabel()).length();
                if (diff % 2 == 1) {
                    ++diff;
                    c.setWidth(++width);
                }
                int paddingSize = diff / 2;
                String padding = new String(new char[paddingSize]).replace("\u0000", " ");
                String toPrint = "| " + padding + name + padding + " ";
                strToPrint.append(toPrint);
                rowSeparator.append("+");
                rowSeparator.append(new String(new char[width + 2]).replace("\u0000", "-"));
            }
            String lineSeparator = System.getProperty("line.separator");
            rowSeparator.append("+").append(lineSeparator);
            strToPrint.append("|").append(lineSeparator);
            strToPrint.insert(0, rowSeparator);
            strToPrint.append((CharSequence)rowSeparator);
            String info = "Printing " + rowCount;
            info = info + (rowCount > 1 ? " rows from " : " row from ");
            info = info + (tableNames.size() > 1 ? "tables " : "table ");
            info = info + Strings.join((String[])tableNames.toArray(new String[tableNames.size()]), (String)", ");
            System.out.println(info);
            System.out.print(strToPrint.toString());
            for (int i = 0; i < rowCount; ++i) {
                for (Column c : columns) {
                    String format = String.format("| %%%s%ds ", c.getJustifyFlag(), c.getWidth());
                    System.out.print(String.format(format, c.getValue(i)));
                }
                System.out.println("|");
                System.out.print(rowSeparator);
            }
            System.out.println();
        }
        catch (SQLException e) {
            System.err.println("SQL exception in DBTablePrinter. Message:");
            System.err.println(e.getMessage());
        }
    }

    private static int whichCategory(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return 2;
            }
            case 3: 
            case 7: 
            case 8: {
                return 3;
            }
            case 91: 
            case 92: 
            case 93: {
                return 4;
            }
            case 16: {
                return 5;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return 1;
            }
        }
        return 0;
    }

    private static class Column {
        private String label;
        private int type;
        private String typeName;
        private int width = 0;
        private List<String> values = new ArrayList<String>();
        private String justifyFlag = "";
        private int typeCategory = 0;

        public Column(String label, int type, String typeName) {
            this.label = label;
            this.type = type;
            this.typeName = typeName;
        }

        public String getLabel() {
            return this.label;
        }

        public int getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void addValue(String value) {
            this.values.add(value);
        }

        public String getValue(int i) {
            return this.values.get(i);
        }

        public String getJustifyFlag() {
            return this.justifyFlag;
        }

        public void justifyLeft() {
            this.justifyFlag = "-";
        }

        public int getTypeCategory() {
            return this.typeCategory;
        }

        public void setTypeCategory(int typeCategory) {
            this.typeCategory = typeCategory;
        }
    }
}

