/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.pvalues;

import de.unijena.bioinf.fingerid.pvalues.FPVariable;
import de.unijena.bioinf.fingerid.pvalues.FingerprintTree;
import de.unijena.bioinf.fingerid.pvalues.Main;
import de.unijena.bioinf.graphUtils.tree.Tree;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class ConditionalProbabilitiesEstimator {
    private static final double PSEUDO_COUNTS = 0.5;
    private FingerprintTree tree;

    public ConditionalProbabilitiesEstimator(FingerprintTree tree) {
        this.tree = tree;
    }

    public void estimateFromFile(File f) throws IOException {
        this.estimate(Main.readFingerprints(f));
    }

    public void fitByCorrelation(Iterator<boolean[]> fingerprints) {
        List<Tree<FPVariable>> variables = this.tree.nodes.subList(0, this.tree.nodes.size() - 1);
        for (Tree<FPVariable> node : this.tree.nodes) {
            FPVariable v = (FPVariable)node.getLabel();
            v.frequency = 0.5;
        }
        FPVariable root = (FPVariable)this.tree.root.getLabel();
        int intcounter = 0;
        while (fingerprints.hasNext()) {
            ++intcounter;
            boolean[] fp = fingerprints.next();
            if (fp[root.to]) {
                root.frequency += 1.0;
            }
            for (Tree<FPVariable> node : variables) {
                FPVariable uv = (FPVariable)node.getLabel();
                if (fp[uv.from]) {
                    if (!fp[uv.to]) continue;
                    uv.frequency += 1.0;
                    continue;
                }
                if (!fp[uv.to]) continue;
                uv.frequency += 1.0;
            }
        }
        double counter = (double)intcounter + 2.0;
        for (Tree<FPVariable> node : this.tree.nodes) {
            ((FPVariable)node.getLabel()).frequency /= counter;
        }
        for (Tree<FPVariable> node : variables) {
            FPVariable uv = (FPVariable)node.getLabel();
            FPVariable parent = (FPVariable)this.tree.varMap.get(uv.from);
            double expX = uv.frequency;
            double expY = parent.frequency;
            double II = uv.correlation * (expX - expX * expX) * (expY - expY * expY) + expX * expY;
            double Io = uv.frequency - II;
            double oI = parent.frequency - II;
            double oo = 1.0 - (II + Io + oI);
            uv.II = II;
            uv.Io = Io;
            uv.oI = oI;
            uv.oo = oo;
            uv.calculateProbabilities();
        }
    }

    public void estimate(Iterator<boolean[]> fingerprints) {
        for (Tree<FPVariable> node : this.tree.nodes) {
            FPVariable variable = (FPVariable)node.getLabel();
            variable.frequency = 0.5;
            variable.II = 0.5;
            variable.Io = 0.5;
            variable.oI = 0.5;
            variable.oo = 0.5;
        }
        List<Tree<FPVariable>> variables = this.tree.nodes.subList(0, this.tree.nodes.size() - 1);
        FPVariable root = (FPVariable)this.tree.root.getLabel();
        int intcounter = 0;
        while (fingerprints.hasNext()) {
            ++intcounter;
            boolean[] fp = fingerprints.next();
            if (fp[root.to]) {
                root.frequency += 1.0;
            }
            for (Tree<FPVariable> node : variables) {
                FPVariable uv = (FPVariable)node.getLabel();
                if (fp[uv.from]) {
                    if (fp[uv.to]) {
                        uv.frequency += 1.0;
                        uv.II += 1.0;
                        continue;
                    }
                    uv.oI += 1.0;
                    continue;
                }
                if (fp[uv.to]) {
                    uv.frequency += 1.0;
                    uv.Io += 1.0;
                    continue;
                }
                uv.oo += 1.0;
            }
        }
        double counter = (double)intcounter + 2.0;
        for (Tree<FPVariable> node : variables) {
            FPVariable uv = (FPVariable)node.getLabel();
            FPVariable parent = (FPVariable)this.tree.varMap.get(uv.from);
            assert ((int)(uv.oo + uv.Io + uv.II + uv.oI) == (int)counter);
            double expX = uv.frequency / counter;
            double expY = parent.frequency / counter;
            double expXY = uv.II / counter;
            uv.correlation = (expXY - expX * expY) / (Math.sqrt(expX - expX * expX) * Math.sqrt(expY - expY * expY));
            uv.oo /= counter;
            uv.Io /= counter;
            uv.oI /= counter;
            uv.II /= counter;
            uv.frequency /= counter;
            uv.calculateProbabilities();
        }
    }
}

