/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.pvalues;

import de.unijena.bioinf.fingerid.pvalues.FPVariable;
import de.unijena.bioinf.fingerid.pvalues.FingerprintTree;
import de.unijena.bioinf.graphUtils.tree.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DotParser {
    private static final Pattern pattern = Pattern.compile("^\\s*(\\d+)\\s*->\\s*(\\d+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FingerprintTree parseFromFile(File f) throws IOException {
        try (FileReader fileReader = new FileReader(f);){
            FingerprintTree fingerprintTree = this.parse(fileReader);
            return fingerprintTree;
        }
    }

    public FingerprintTree parse(Reader reader) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(reader);
        HashMap<Integer, Integer> edges = new HashMap<Integer, Integer>();
        HashSet<Integer> nodes = new HashSet<Integer>();
        while ((line = r.readLine()) != null) {
            Object m;
            if (!line.contains("->") || !((Matcher)(m = pattern.matcher(line))).find()) continue;
            Integer n = Integer.parseInt(((Matcher)m).group(1));
            Integer v = Integer.parseInt(((Matcher)m).group(2));
            nodes.add(n);
            nodes.remove(v);
            if (edges.containsKey(v)) {
                throw new RuntimeException("Cycle detected! Graph is not a tree!");
            }
            edges.put(v, n);
        }
        for (Map.Entry entry : edges.entrySet()) {
            nodes.remove(entry.getKey());
        }
        if (nodes.size() > 1) {
            System.err.println("Warning: Tree has more than one root. Add artificial edges to connect the forest.");
            Iterator nodeIter = nodes.iterator();
            Integer n = (Integer)nodeIter.next();
            while (nodeIter.hasNext()) {
                edges.put((Integer)nodeIter.next(), n);
                nodeIter.remove();
            }
        } else if (nodes.size() == 0) {
            throw new RuntimeException("Cycle detected! Graph is not a tree!");
        }
        Integer rootVertex = (Integer)nodes.iterator().next();
        return this.buildTree(rootVertex, edges);
    }

    private FingerprintTree buildTree(Integer rootVertex, HashMap<Integer, Integer> edges) {
        HashMap<Integer, Tree> nodeMap = new HashMap<Integer, Tree>();
        nodeMap.put(rootVertex, new Tree((Object)new FPVariable(-1, rootVertex)));
        for (Map.Entry<Integer, Integer> entry : edges.entrySet()) {
            nodeMap.put(entry.getKey(), new Tree((Object)new FPVariable(entry.getValue(), entry.getKey())));
        }
        for (Map.Entry<Integer, Integer> entry : edges.entrySet()) {
            ((Tree)nodeMap.get(entry.getValue())).addChild((Tree)nodeMap.get(entry.getKey()));
        }
        return new FingerprintTree((Tree<FPVariable>)((Tree)nodeMap.get(rootVertex)));
    }
}

