/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.pvalues;

import de.unijena.bioinf.fingerid.pvalues.Probability;

public final class FPVariable
implements Cloneable {
    protected final int from;
    protected final int to;
    protected double oo;
    protected double oI;
    protected double Io;
    protected double II;
    protected double frequency;
    protected double correlation;
    protected Probability Poo;
    protected Probability PoI;
    protected Probability PIo;
    protected Probability PII;
    protected Probability o;
    protected Probability I;

    public FPVariable(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public void calculateProbabilities() {
        assert (Math.abs(this.oo + this.Io + this.oI + this.II - 1.0) < 1.0E-5);
        double Mo = this.oo + this.Io;
        double MI = this.oI + this.II;
        this.Poo = new Probability(this.oo / Mo);
        this.PoI = new Probability(this.oI / MI);
        this.PIo = new Probability(this.Io / Mo);
        this.PII = new Probability(this.II / MI);
        this.o = new Probability(1.0 - this.frequency);
        this.I = new Probability(this.frequency);
    }

    public FPVariable clone() {
        try {
            return (FPVariable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

